<?php


/**
 * Base class that represents a row from the 'projects_project' table.
 *
 * Project
 *
 * @package    propel.generator.projects.classes.om
 */
abstract class BaseProject extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'ProjectPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        ProjectPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the objectiveid field.
     * @var        int
     */
    protected $objectiveid;

    /**
     * The value for the code field.
     * @var        string
     */
    protected $code;

    /**
     * The value for the codeaux field.
     * @var        string
     */
    protected $codeaux;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the description field.
     * @var        string
     */
    protected $description;

    /**
     * The value for the impact field.
     * @var        string
     */
    protected $impact;

    /**
     * The value for the uniquegoal field.
     * @var        string
     */
    protected $uniquegoal;

    /**
     * The value for the goalexpirationdate field.
     * @var        string
     */
    protected $goalexpirationdate;

    /**
     * The value for the date field.
     * @var        string
     */
    protected $date;

    /**
     * The value for the budget field.
     * @var        double
     */
    protected $budget;

    /**
     * The value for the exchangerate field.
     * @var        double
     */
    protected $exchangerate;

    /**
     * The value for the visibility field.
     * @var        int
     */
    protected $visibility;

    /**
     * The value for the coordinateneed field.
     * @var        string
     */
    protected $coordinateneed;

    /**
     * The value for the frequency field.
     * @var        string
     */
    protected $frequency;

    /**
     * The value for the finished field.
     * @var        boolean
     */
    protected $finished;

    /**
     * The value for the notes field.
     * @var        string
     */
    protected $notes;

    /**
     * The value for the postalcode field.
     * @var        string
     */
    protected $postalcode;

    /**
     * The value for the uniquegoalnumeric field.
     * @var        int
     */
    protected $uniquegoalnumeric;

    /**
     * The value for the goalprogress field.
     * @var        int
     */
    protected $goalprogress;

    /**
     * The value for the latitude field.
     * @var        double
     */
    protected $latitude;

    /**
     * The value for the longitude field.
     * @var        double
     */
    protected $longitude;

    /**
     * The value for the oldid field.
     * @var        int
     */
    protected $oldid;

    /**
     * The value for the regionid field.
     * @var        int
     */
    protected $regionid;

    /**
     * The value for the oldregionid field.
     * @var        int
     */
    protected $oldregionid;

    /**
     * The value for the lastmodification field.
     * @var        string
     */
    protected $lastmodification;

    /**
     * The value for the address field.
     * @var        string
     */
    protected $address;

    /**
     * The value for the street field.
     * @var        string
     */
    protected $street;

    /**
     * The value for the number field.
     * @var        int
     */
    protected $number;

    /**
     * The value for the priority field.
     * @var        int
     */
    protected $priority;

    /**
     * The value for the modifications field.
     * @var        int
     */
    protected $modifications;

    /**
     * The value for the plannedstart field.
     * @var        string
     */
    protected $plannedstart;

    /**
     * The value for the plannedend field.
     * @var        string
     */
    protected $plannedend;

    /**
     * The value for the realstart field.
     * @var        string
     */
    protected $realstart;

    /**
     * The value for the realend field.
     * @var        string
     */
    protected $realend;

    /**
     * The value for the cancelled field.
     * @var        boolean
     */
    protected $cancelled;

    /**
     * The value for the isconstruction field.
     * @var        boolean
     */
    protected $isconstruction;

    /**
     * The value for the relevance field.
     * @var        string
     */
    protected $relevance;

    /**
     * The value for the userid field.
     * @var        int
     */
    protected $userid;

    /**
     * The value for the order field.
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $order;

    /**
     * The value for the weight field.
     * Note: this column has a database default value of: '0'
     * @var        string
     */
    protected $weight;

    /**
     * The value for the updated field.
     * @var        string
     */
    protected $updated;

    /**
     * The value for the responsiblecode field.
     * @var        int
     */
    protected $responsiblecode;

    /**
     * The value for the indicatorid field.
     * @var        int
     */
    protected $indicatorid;

    /**
     * The value for the primarysource field.
     * @var        string
     */
    protected $primarysource;

    /**
     * The value for the additionalsource field.
     * @var        string
     */
    protected $additionalsource;

    /**
     * The value for the startingyear field.
     * @var        int
     */
    protected $startingyear;

    /**
     * The value for the endingyear field.
     * @var        int
     */
    protected $endingyear;

    /**
     * The value for the subproject field.
     * @var        string
     */
    protected $subproject;

    /**
     * The value for the ongoing field.
     * @var        string
     */
    protected $ongoing;

    /**
     * The value for the relatedareas field.
     * @var        string
     */
    protected $relatedareas;

    /**
     * The value for the goal field.
     * @var        string
     */
    protected $goal;

    /**
     * The value for the legal field.
     * @var        string
     */
    protected $legal;

    /**
     * The value for the execresp field.
     * @var        string
     */
    protected $execresp;

    /**
     * The value for the exectenure field.
     * @var        string
     */
    protected $exectenure;

    /**
     * The value for the execdependency field.
     * @var        string
     */
    protected $execdependency;

    /**
     * The value for the execcontact field.
     * @var        string
     */
    protected $execcontact;

    /**
     * The value for the subsecretary field.
     * @var        string
     */
    protected $subsecretary;

    /**
     * The value for the budgetrequested field.
     * @var        double
     */
    protected $budgetrequested;

    /**
     * The value for the budgetsanctioned field.
     * @var        double
     */
    protected $budgetsanctioned;

    /**
     * The value for the belgrano field.
     * @var        boolean
     */
    protected $belgrano;

    /**
     * The value for the clasification field.
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $clasification;

    /**
     * The value for the press field.
     * @var        boolean
     */
    protected $press;

    /**
     * The value for the priorityarea field.
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $priorityarea;

    /**
     * The value for the beneficiario field.
     * @var        string
     */
    protected $beneficiario;

    /**
     * The value for the requirecontractor field.
     * @var        boolean
     */
    protected $requirecontractor;

    /**
     * The value for the purchasetype field.
     * @var        int
     */
    protected $purchasetype;

    /**
     * The value for the constructiontype field.
     * @var        int
     */
    protected $constructiontype;

    /**
     * The value for the requireexraresources field.
     * @var        boolean
     */
    protected $requireexraresources;

    /**
     * The value for the implementationpartner field.
     * @var        string
     */
    protected $implementationpartner;

    /**
     * The value for the riskfactors field.
     * @var        string
     */
    protected $riskfactors;

    /**
     * The value for the ownfinance field.
     * @var        int
     */
    protected $ownfinance;

    /**
     * The value for the provincefinance field.
     * @var        int
     */
    protected $provincefinance;

    /**
     * The value for the nationfinance field.
     * @var        int
     */
    protected $nationfinance;

    /**
     * The value for the otherfinance field.
     * @var        int
     */
    protected $otherfinance;

    /**
     * The value for the financedetail field.
     * @var        string
     */
    protected $financedetail;

    /**
     * The value for the financeprogram field.
     * @var        string
     */
    protected $financeprogram;

    /**
     * The value for the created_at field.
     * @var        string
     */
    protected $created_at;

    /**
     * The value for the updated_at field.
     * @var        string
     */
    protected $updated_at;

    /**
     * The value for the deleted_at field.
     * @var        string
     */
    protected $deleted_at;

    /**
     * @var        Objective
     */
    protected $aObjective;

    /**
     * @var        Position
     */
    protected $aPosition;

    /**
     * @var        Indicator
     */
    protected $aIndicator;

    /**
     * @var        User
     */
    protected $aUser;

    /**
     * @var        PropelObjectCollection|Construction[] Collection to store aggregation of Construction objects.
     */
    protected $collConstructions;
    protected $collConstructionsPartial;

    /**
     * @var        PropelObjectCollection|Guarantee[] Collection to store aggregation of Guarantee objects.
     */
    protected $collGuarantees;
    protected $collGuaranteesPartial;

    /**
     * @var        PropelObjectCollection|AdministrativeAct[] Collection to store aggregation of AdministrativeAct objects.
     */
    protected $collAdministrativeActs;
    protected $collAdministrativeActsPartial;

    /**
     * @var        PropelObjectCollection|ProjectRegion[] Collection to store aggregation of ProjectRegion objects.
     */
    protected $collProjectRegions;
    protected $collProjectRegionsPartial;

    /**
     * @var        PropelObjectCollection|ProjectMilestone[] Collection to store aggregation of ProjectMilestone objects.
     */
    protected $collProjectMilestones;
    protected $collProjectMilestonesPartial;

    /**
     * @var        PropelObjectCollection|ProjectIndicator[] Collection to store aggregation of ProjectIndicator objects.
     */
    protected $collProjectIndicators;
    protected $collProjectIndicatorsPartial;

    /**
     * @var        PropelObjectCollection|ProjectActivity[] Collection to store aggregation of ProjectActivity objects.
     */
    protected $collProjectActivitys;
    protected $collProjectActivitysPartial;

    /**
     * @var        PropelObjectCollection|ProjectDocument[] Collection to store aggregation of ProjectDocument objects.
     */
    protected $collProjectDocuments;
    protected $collProjectDocumentsPartial;

    /**
     * @var        PropelObjectCollection|ProjectContractor[] Collection to store aggregation of ProjectContractor objects.
     */
    protected $collProjectContractors;
    protected $collProjectContractorsPartial;

    /**
     * @var        PropelObjectCollection|ProjectLog[] Collection to store aggregation of ProjectLog objects.
     */
    protected $collProjectLogs;
    protected $collProjectLogsPartial;

    /**
     * @var        PropelObjectCollection|ProjectMilestoneLog[] Collection to store aggregation of ProjectMilestoneLog objects.
     */
    protected $collProjectMilestoneLogs;
    protected $collProjectMilestoneLogsPartial;

    /**
     * @var        PropelObjectCollection|ProjectActivityLog[] Collection to store aggregation of ProjectActivityLog objects.
     */
    protected $collProjectActivityLogs;
    protected $collProjectActivityLogsPartial;

    /**
     * @var        PropelObjectCollection|Region[] Collection to store aggregation of Region objects.
     */
    protected $collRegions;

    /**
     * @var        PropelObjectCollection|Document[] Collection to store aggregation of Document objects.
     */
    protected $collDocuments;

    /**
     * @var        PropelObjectCollection|Contractor[] Collection to store aggregation of Contractor objects.
     */
    protected $collContractors;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $regionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $documentsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $contractorsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $constructionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $guaranteesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $administrativeActsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectRegionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectMilestonesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectIndicatorsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectActivitysScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectDocumentsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectContractorsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectLogsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectMilestoneLogsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectActivityLogsScheduledForDeletion = null;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see        __construct()
     */
    public function applyDefaultValues()
    {
        $this->order = 0;
        $this->weight = '0';
        $this->clasification = 0;
        $this->priorityarea = 0;
    }

    /**
     * Initializes internal state of BaseProject object.
     * @see        applyDefaults()
     */
    public function __construct()
    {
        parent::__construct();
        $this->applyDefaultValues();
    }

    /**
     * Get the [id] column value.
     * Project Id
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [objectiveid] column value.
     * Objective Id
     * @return int
     */
    public function getObjectiveid()
    {
        return $this->objectiveid;
    }

    /**
     * Get the [code] column value.
     * Project Code
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Get the [codeaux] column value.
     * Project Code Auxiliary code
     * @return string
     */
    public function getCodeaux()
    {
        return $this->codeaux;
    }

    /**
     * Get the [name] column value.
     * Project Name
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [description] column value.
     * Project Description
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Get the [impact] column value.
     * Project Impact
     * @return string
     */
    public function getImpact()
    {
        return $this->impact;
    }

    /**
     * Get the [uniquegoal] column value.
     * Project Unique Goal
     * @return string
     */
    public function getUniquegoal()
    {
        return $this->uniquegoal;
    }

    /**
     * Get the [optionally formatted] temporal [goalexpirationdate] column value.
     * Project Goal Expiration Date
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getGoalexpirationdate($format = '%Y/%m/%d')
    {
        if ($this->goalexpirationdate === null) {
            return null;
        }

        if ($this->goalexpirationdate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->goalexpirationdate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->goalexpirationdate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [date] column value.
     * Project Creation Date
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDate($format = 'Y-m-d H:i:s')
    {
        if ($this->date === null) {
            return null;
        }

        if ($this->date === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->date);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->date, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [budget] column value.
     * Project Budget (Presupuesto)
     * @return double
     */
    public function getBudget()
    {
        return $this->budget;
    }

    /**
     * Get the [exchangerate] column value.
     * Exchange Rate
     * @return double
     */
    public function getExchangerate()
    {
        return $this->exchangerate;
    }

    /**
     * Get the [visibility] column value.
     * Visibility
     * @return int
     */
    public function getVisibility()
    {
        return $this->visibility;
    }

    /**
     * Get the [coordinateneed] column value.
     * Project Coordinate Need
     * @return string
     */
    public function getCoordinateneed()
    {
        return $this->coordinateneed;
    }

    /**
     * Get the [frequency] column value.
     * Project Frequency
     * @return string
     */
    public function getFrequency()
    {
        return $this->frequency;
    }

    /**
     * Get the [finished] column value.
     * is Project Finished?
     * @return boolean
     */
    public function getFinished()
    {
        return $this->finished;
    }

    /**
     * Get the [notes] column value.
     * Project Notes
     * @return string
     */
    public function getNotes()
    {
        return $this->notes;
    }

    /**
     * Get the [postalcode] column value.
     * Project Postal Code
     * @return string
     */
    public function getPostalcode()
    {
        return $this->postalcode;
    }

    /**
     * Get the [uniquegoalnumeric] column value.
     * Project Unique Goal Numeric
     * @return int
     */
    public function getUniquegoalnumeric()
    {
        return $this->uniquegoalnumeric;
    }

    /**
     * Get the [goalprogress] column value.
     * Project Goal Progress
     * @return int
     */
    public function getGoalprogress()
    {
        return $this->goalprogress;
    }

    /**
     * Get the [latitude] column value.
     * latitud del proyecto
     * @return double
     */
    public function getLatitude()
    {
        return $this->latitude;
    }

    /**
     * Get the [longitude] column value.
     * longitud del proyecto
     * @return double
     */
    public function getLongitude()
    {
        return $this->longitude;
    }

    /**
     * Get the [oldid] column value.
     * Old Id
     * @return int
     */
    public function getOldid()
    {
        return $this->oldid;
    }

    /**
     * Get the [regionid] column value.
     * Region Id
     * @return int
     */
    public function getRegionid()
    {
        return $this->regionid;
    }

    /**
     * Get the [oldregionid] column value.
     * Old Region Id
     * @return int
     */
    public function getOldregionid()
    {
        return $this->oldregionid;
    }

    /**
     * Get the [optionally formatted] temporal [lastmodification] column value.
     * Ultima modificacion Date
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getLastmodification($format = 'Y-m-d H:i:s')
    {
        if ($this->lastmodification === null) {
            return null;
        }

        if ($this->lastmodification === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->lastmodification);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->lastmodification, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [address] column value.
     * Direccion del proyecto
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }

    /**
     * Get the [street] column value.
     * Nombre de la calle
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }

    /**
     * Get the [number] column value.
     * Numero de la calle
     * @return int
     */
    public function getNumber()
    {
        return $this->number;
    }

    /**
     * Get the [priority] column value.
     * Prioridad Id
     * @return int
     */
    public function getPriority()
    {
        return $this->priority;
    }

    /**
     * Get the [modifications] column value.
     * Cantidad de modificaciones
     * @return int
     */
    public function getModifications()
    {
        return $this->modifications;
    }

    /**
     * Get the [optionally formatted] temporal [plannedstart] column value.
     * Project planned start
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getPlannedstart($format = '%Y/%m/%d')
    {
        if ($this->plannedstart === null) {
            return null;
        }

        if ($this->plannedstart === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->plannedstart);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->plannedstart, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [plannedend] column value.
     * Project planned End
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getPlannedend($format = '%Y/%m/%d')
    {
        if ($this->plannedend === null) {
            return null;
        }

        if ($this->plannedend === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->plannedend);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->plannedend, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [realstart] column value.
     * Project real start
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getRealstart($format = '%Y/%m/%d')
    {
        if ($this->realstart === null) {
            return null;
        }

        if ($this->realstart === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->realstart);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->realstart, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [realend] column value.
     * Project real end
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getRealend($format = '%Y/%m/%d')
    {
        if ($this->realend === null) {
            return null;
        }

        if ($this->realend === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->realend);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->realend, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [cancelled] column value.
     * is project cancelled?
     * @return boolean
     */
    public function getCancelled()
    {
        return $this->cancelled;
    }

    /**
     * Get the [isconstruction] column value.
     * is a construction?
     * @return boolean
     */
    public function getIsconstruction()
    {
        return $this->isconstruction;
    }

    /**
     * Get the [relevance] column value.
     * Importancia
     * @return string
     */
    public function getRelevance()
    {
        return $this->relevance;
    }

    /**
     * Get the [userid] column value.
     * User Id
     * @return int
     */
    public function getUserid()
    {
        return $this->userid;
    }

    /**
     * Get the [order] column value.
     * Orden
     * @return int
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * Get the [weight] column value.
     * Peso
     * @return string
     */
    public function getWeight()
    {
        return $this->weight;
    }

    /**
     * Get the [optionally formatted] temporal [updated] column value.
     * Updated
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getUpdated($format = 'Y-m-d H:i:s')
    {
        if ($this->updated === null) {
            return null;
        }

        if ($this->updated === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->updated);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->updated, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [responsiblecode] column value.
     * Codigo del responsable
     * @return int
     */
    public function getResponsiblecode()
    {
        return $this->responsiblecode;
    }

    /**
     * Get the [indicatorid] column value.
     * Id del indicador del grafico de desembolsos
     * @return int
     */
    public function getIndicatorid()
    {
        return $this->indicatorid;
    }

    /**
     * Get the [primarysource] column value.
     * Fuente principal de financiamiento
     * @return string
     */
    public function getPrimarysource()
    {
        return $this->primarysource;
    }

    /**
     * Get the [additionalsource] column value.
     * Fuente adicional de financiamiento
     * @return string
     */
    public function getAdditionalsource()
    {
        return $this->additionalsource;
    }

    /**
     * Get the [startingyear] column value.
     * Starting year
     * @return int
     */
    public function getStartingyear()
    {
        return $this->startingyear;
    }

    /**
     * Get the [endingyear] column value.
     * Ending year
     * @return int
     */
    public function getEndingyear()
    {
        return $this->endingyear;
    }

    /**
     * Get the [subproject] column value.
     * is subproject?
     * @return string
     */
    public function getSubproject()
    {
        return $this->subproject;
    }

    /**
     * Get the [ongoing] column value.
     * Nombre del programa en desarrollo
     * @return string
     */
    public function getOngoing()
    {
        return $this->ongoing;
    }

    /**
     * Get the [relatedareas] column value.
     * Areas relacionadas
     * @return string
     */
    public function getRelatedareas()
    {
        return $this->relatedareas;
    }

    /**
     * Get the [goal] column value.
     * Meta producto
     * @return string
     */
    public function getGoal()
    {
        return $this->goal;
    }

    /**
     * Get the [legal] column value.
     * Marco legal
     * @return string
     */
    public function getLegal()
    {
        return $this->legal;
    }

    /**
     * Get the [execresp] column value.
     * Responsable
     * @return string
     */
    public function getExecresp()
    {
        return $this->execresp;
    }

    /**
     * Get the [exectenure] column value.
     * Cargo
     * @return string
     */
    public function getExectenure()
    {
        return $this->exectenure;
    }

    /**
     * Get the [execdependency] column value.
     * Dependencia
     * @return string
     */
    public function getExecdependency()
    {
        return $this->execdependency;
    }

    /**
     * Get the [execcontact] column value.
     * Contacto
     * @return string
     */
    public function getExeccontact()
    {
        return $this->execcontact;
    }

    /**
     * Get the [subsecretary] column value.
     * Subsecretaria
     * @return string
     */
    public function getSubsecretary()
    {
        return $this->subsecretary;
    }

    /**
     * Get the [budgetrequested] column value.
     * Presupuesto solicitado
     * @return double
     */
    public function getBudgetrequested()
    {
        return $this->budgetrequested;
    }

    /**
     * Get the [budgetsanctioned] column value.
     * Presupuesto sancionado
     * @return double
     */
    public function getBudgetsanctioned()
    {
        return $this->budgetsanctioned;
    }

    /**
     * Get the [belgrano] column value.
     * si es Plan Belgrano?
     * @return boolean
     */
    public function getBelgrano()
    {
        return $this->belgrano;
    }

    /**
     * Get the [clasification] column value.
     * Clasification
     * @return int
     */
    public function getClasification()
    {
        return $this->clasification;
    }

    /**
     * Get the [press] column value.
     * Interes prensa?
     * @return boolean
     */
    public function getPress()
    {
        return $this->press;
    }

    /**
     * Get the [priorityarea] column value.
     * prioridad del area
     * @return int
     */
    public function getPriorityarea()
    {
        return $this->priorityarea;
    }

    /**
     * Get the [beneficiario] column value.
     * Grupo / Sector se va a beneficiar con este proyecto
     * @return string
     */
    public function getBeneficiario()
    {
        return $this->beneficiario;
    }

    /**
     * Get the [requirecontractor] column value.
     * Requiere Contratacion?
     * @return boolean
     */
    public function getRequirecontractor()
    {
        return $this->requirecontractor;
    }

    /**
     * Get the [purchasetype] column value.
     * Tipo de compra
     * @return int
     */
    public function getPurchasetype()
    {
        return $this->purchasetype;
    }

    /**
     * Get the [constructiontype] column value.
     * Tipo de Obra
     * @return int
     */
    public function getConstructiontype()
    {
        return $this->constructiontype;
    }

    /**
     * Get the [requireexraresources] column value.
     * Requiere personal extra?
     * @return boolean
     */
    public function getRequireexraresources()
    {
        return $this->requireexraresources;
    }

    /**
     * Get the [implementationpartner] column value.
     * Socios en la implementación
     * @return string
     */
    public function getImplementationpartner()
    {
        return $this->implementationpartner;
    }

    /**
     * Get the [riskfactors] column value.
     * Factores de riesgo
     * @return string
     */
    public function getRiskfactors()
    {
        return $this->riskfactors;
    }

    /**
     * Get the [ownfinance] column value.
     * Financiamiento propio?
     * @return int
     */
    public function getOwnfinance()
    {
        return $this->ownfinance;
    }

    /**
     * Get the [provincefinance] column value.
     * Financiamiento Provincial?
     * @return int
     */
    public function getProvincefinance()
    {
        return $this->provincefinance;
    }

    /**
     * Get the [nationfinance] column value.
     * Financiamiento Nacional?
     * @return int
     */
    public function getNationfinance()
    {
        return $this->nationfinance;
    }

    /**
     * Get the [otherfinance] column value.
     * Otro Financiamiento?
     * @return int
     */
    public function getOtherfinance()
    {
        return $this->otherfinance;
    }

    /**
     * Get the [financedetail] column value.
     * Detalle de financiamiento
     * @return string
     */
    public function getFinancedetail()
    {
        return $this->financedetail;
    }

    /**
     * Get the [financeprogram] column value.
     * Programa destino financiamiento
     * @return string
     */
    public function getFinanceprogram()
    {
        return $this->financeprogram;
    }

    /**
     * Get the [optionally formatted] temporal [created_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getCreatedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->created_at === null) {
            return null;
        }

        if ($this->created_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->created_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->created_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [updated_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getUpdatedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->updated_at === null) {
            return null;
        }

        if ($this->updated_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->updated_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->updated_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [deleted_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDeletedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->deleted_at === null) {
            return null;
        }

        if ($this->deleted_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->deleted_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->deleted_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Set the value of [id] column.
     * Project Id
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = ProjectPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [objectiveid] column.
     * Objective Id
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setObjectiveid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->objectiveid !== $v) {
            $this->objectiveid = $v;
            $this->modifiedColumns[] = ProjectPeer::OBJECTIVEID;
        }

        if ($this->aObjective !== null && $this->aObjective->getId() !== $v) {
            $this->aObjective = null;
        }


        return $this;
    } // setObjectiveid()

    /**
     * Set the value of [code] column.
     * Project Code
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setCode($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->code !== $v) {
            $this->code = $v;
            $this->modifiedColumns[] = ProjectPeer::CODE;
        }


        return $this;
    } // setCode()

    /**
     * Set the value of [codeaux] column.
     * Project Code Auxiliary code
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setCodeaux($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->codeaux !== $v) {
            $this->codeaux = $v;
            $this->modifiedColumns[] = ProjectPeer::CODEAUX;
        }


        return $this;
    } // setCodeaux()

    /**
     * Set the value of [name] column.
     * Project Name
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = ProjectPeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [description] column.
     * Project Description
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setDescription($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->description !== $v) {
            $this->description = $v;
            $this->modifiedColumns[] = ProjectPeer::DESCRIPTION;
        }


        return $this;
    } // setDescription()

    /**
     * Set the value of [impact] column.
     * Project Impact
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setImpact($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->impact !== $v) {
            $this->impact = $v;
            $this->modifiedColumns[] = ProjectPeer::IMPACT;
        }


        return $this;
    } // setImpact()

    /**
     * Set the value of [uniquegoal] column.
     * Project Unique Goal
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setUniquegoal($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->uniquegoal !== $v) {
            $this->uniquegoal = $v;
            $this->modifiedColumns[] = ProjectPeer::UNIQUEGOAL;
        }


        return $this;
    } // setUniquegoal()

    /**
     * Sets the value of [goalexpirationdate] column to a normalized version of the date/time value specified.
     * Project Goal Expiration Date
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Project The current object (for fluent API support)
     */
    public function setGoalexpirationdate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->goalexpirationdate !== null || $dt !== null) {
            $currentDateAsString = ($this->goalexpirationdate !== null && $tmpDt = new DateTime($this->goalexpirationdate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->goalexpirationdate = $newDateAsString;
                $this->modifiedColumns[] = ProjectPeer::GOALEXPIRATIONDATE;
            }
        } // if either are not null


        return $this;
    } // setGoalexpirationdate()

    /**
     * Sets the value of [date] column to a normalized version of the date/time value specified.
     * Project Creation Date
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Project The current object (for fluent API support)
     */
    public function setDate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->date !== null || $dt !== null) {
            $currentDateAsString = ($this->date !== null && $tmpDt = new DateTime($this->date)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->date = $newDateAsString;
                $this->modifiedColumns[] = ProjectPeer::DATE;
            }
        } // if either are not null


        return $this;
    } // setDate()

    /**
     * Set the value of [budget] column.
     * Project Budget (Presupuesto)
     * @param double $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setBudget($v)
    {
        if ($v !== null) {
            $v = (double) $v;
        }

        if ($this->budget !== $v) {
            $this->budget = $v;
            $this->modifiedColumns[] = ProjectPeer::BUDGET;
        }


        return $this;
    } // setBudget()

    /**
     * Set the value of [exchangerate] column.
     * Exchange Rate
     * @param double $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setExchangerate($v)
    {
        if ($v !== null) {
            $v = (double) $v;
        }

        if ($this->exchangerate !== $v) {
            $this->exchangerate = $v;
            $this->modifiedColumns[] = ProjectPeer::EXCHANGERATE;
        }


        return $this;
    } // setExchangerate()

    /**
     * Set the value of [visibility] column.
     * Visibility
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setVisibility($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->visibility !== $v) {
            $this->visibility = $v;
            $this->modifiedColumns[] = ProjectPeer::VISIBILITY;
        }


        return $this;
    } // setVisibility()

    /**
     * Set the value of [coordinateneed] column.
     * Project Coordinate Need
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setCoordinateneed($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->coordinateneed !== $v) {
            $this->coordinateneed = $v;
            $this->modifiedColumns[] = ProjectPeer::COORDINATENEED;
        }


        return $this;
    } // setCoordinateneed()

    /**
     * Set the value of [frequency] column.
     * Project Frequency
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setFrequency($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->frequency !== $v) {
            $this->frequency = $v;
            $this->modifiedColumns[] = ProjectPeer::FREQUENCY;
        }


        return $this;
    } // setFrequency()

    /**
     * Sets the value of the [finished] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * is Project Finished?
     * @param boolean|integer|string $v The new value
     * @return Project The current object (for fluent API support)
     */
    public function setFinished($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->finished !== $v) {
            $this->finished = $v;
            $this->modifiedColumns[] = ProjectPeer::FINISHED;
        }


        return $this;
    } // setFinished()

    /**
     * Set the value of [notes] column.
     * Project Notes
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setNotes($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->notes !== $v) {
            $this->notes = $v;
            $this->modifiedColumns[] = ProjectPeer::NOTES;
        }


        return $this;
    } // setNotes()

    /**
     * Set the value of [postalcode] column.
     * Project Postal Code
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setPostalcode($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->postalcode !== $v) {
            $this->postalcode = $v;
            $this->modifiedColumns[] = ProjectPeer::POSTALCODE;
        }


        return $this;
    } // setPostalcode()

    /**
     * Set the value of [uniquegoalnumeric] column.
     * Project Unique Goal Numeric
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setUniquegoalnumeric($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->uniquegoalnumeric !== $v) {
            $this->uniquegoalnumeric = $v;
            $this->modifiedColumns[] = ProjectPeer::UNIQUEGOALNUMERIC;
        }


        return $this;
    } // setUniquegoalnumeric()

    /**
     * Set the value of [goalprogress] column.
     * Project Goal Progress
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setGoalprogress($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->goalprogress !== $v) {
            $this->goalprogress = $v;
            $this->modifiedColumns[] = ProjectPeer::GOALPROGRESS;
        }


        return $this;
    } // setGoalprogress()

    /**
     * Set the value of [latitude] column.
     * latitud del proyecto
     * @param double $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setLatitude($v)
    {
        if ($v !== null) {
            $v = (double) $v;
        }

        if ($this->latitude !== $v) {
            $this->latitude = $v;
            $this->modifiedColumns[] = ProjectPeer::LATITUDE;
        }


        return $this;
    } // setLatitude()

    /**
     * Set the value of [longitude] column.
     * longitud del proyecto
     * @param double $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setLongitude($v)
    {
        if ($v !== null) {
            $v = (double) $v;
        }

        if ($this->longitude !== $v) {
            $this->longitude = $v;
            $this->modifiedColumns[] = ProjectPeer::LONGITUDE;
        }


        return $this;
    } // setLongitude()

    /**
     * Set the value of [oldid] column.
     * Old Id
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setOldid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->oldid !== $v) {
            $this->oldid = $v;
            $this->modifiedColumns[] = ProjectPeer::OLDID;
        }


        return $this;
    } // setOldid()

    /**
     * Set the value of [regionid] column.
     * Region Id
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setRegionid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->regionid !== $v) {
            $this->regionid = $v;
            $this->modifiedColumns[] = ProjectPeer::REGIONID;
        }


        return $this;
    } // setRegionid()

    /**
     * Set the value of [oldregionid] column.
     * Old Region Id
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setOldregionid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->oldregionid !== $v) {
            $this->oldregionid = $v;
            $this->modifiedColumns[] = ProjectPeer::OLDREGIONID;
        }


        return $this;
    } // setOldregionid()

    /**
     * Sets the value of [lastmodification] column to a normalized version of the date/time value specified.
     * Ultima modificacion Date
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Project The current object (for fluent API support)
     */
    public function setLastmodification($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->lastmodification !== null || $dt !== null) {
            $currentDateAsString = ($this->lastmodification !== null && $tmpDt = new DateTime($this->lastmodification)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->lastmodification = $newDateAsString;
                $this->modifiedColumns[] = ProjectPeer::LASTMODIFICATION;
            }
        } // if either are not null


        return $this;
    } // setLastmodification()

    /**
     * Set the value of [address] column.
     * Direccion del proyecto
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setAddress($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->address !== $v) {
            $this->address = $v;
            $this->modifiedColumns[] = ProjectPeer::ADDRESS;
        }


        return $this;
    } // setAddress()

    /**
     * Set the value of [street] column.
     * Nombre de la calle
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setStreet($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->street !== $v) {
            $this->street = $v;
            $this->modifiedColumns[] = ProjectPeer::STREET;
        }


        return $this;
    } // setStreet()

    /**
     * Set the value of [number] column.
     * Numero de la calle
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setNumber($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->number !== $v) {
            $this->number = $v;
            $this->modifiedColumns[] = ProjectPeer::NUMBER;
        }


        return $this;
    } // setNumber()

    /**
     * Set the value of [priority] column.
     * Prioridad Id
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setPriority($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->priority !== $v) {
            $this->priority = $v;
            $this->modifiedColumns[] = ProjectPeer::PRIORITY;
        }


        return $this;
    } // setPriority()

    /**
     * Set the value of [modifications] column.
     * Cantidad de modificaciones
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setModifications($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->modifications !== $v) {
            $this->modifications = $v;
            $this->modifiedColumns[] = ProjectPeer::MODIFICATIONS;
        }


        return $this;
    } // setModifications()

    /**
     * Sets the value of [plannedstart] column to a normalized version of the date/time value specified.
     * Project planned start
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Project The current object (for fluent API support)
     */
    public function setPlannedstart($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->plannedstart !== null || $dt !== null) {
            $currentDateAsString = ($this->plannedstart !== null && $tmpDt = new DateTime($this->plannedstart)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->plannedstart = $newDateAsString;
                $this->modifiedColumns[] = ProjectPeer::PLANNEDSTART;
            }
        } // if either are not null


        return $this;
    } // setPlannedstart()

    /**
     * Sets the value of [plannedend] column to a normalized version of the date/time value specified.
     * Project planned End
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Project The current object (for fluent API support)
     */
    public function setPlannedend($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->plannedend !== null || $dt !== null) {
            $currentDateAsString = ($this->plannedend !== null && $tmpDt = new DateTime($this->plannedend)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->plannedend = $newDateAsString;
                $this->modifiedColumns[] = ProjectPeer::PLANNEDEND;
            }
        } // if either are not null


        return $this;
    } // setPlannedend()

    /**
     * Sets the value of [realstart] column to a normalized version of the date/time value specified.
     * Project real start
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Project The current object (for fluent API support)
     */
    public function setRealstart($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->realstart !== null || $dt !== null) {
            $currentDateAsString = ($this->realstart !== null && $tmpDt = new DateTime($this->realstart)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->realstart = $newDateAsString;
                $this->modifiedColumns[] = ProjectPeer::REALSTART;
            }
        } // if either are not null


        return $this;
    } // setRealstart()

    /**
     * Sets the value of [realend] column to a normalized version of the date/time value specified.
     * Project real end
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Project The current object (for fluent API support)
     */
    public function setRealend($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->realend !== null || $dt !== null) {
            $currentDateAsString = ($this->realend !== null && $tmpDt = new DateTime($this->realend)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->realend = $newDateAsString;
                $this->modifiedColumns[] = ProjectPeer::REALEND;
            }
        } // if either are not null


        return $this;
    } // setRealend()

    /**
     * Sets the value of the [cancelled] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * is project cancelled?
     * @param boolean|integer|string $v The new value
     * @return Project The current object (for fluent API support)
     */
    public function setCancelled($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->cancelled !== $v) {
            $this->cancelled = $v;
            $this->modifiedColumns[] = ProjectPeer::CANCELLED;
        }


        return $this;
    } // setCancelled()

    /**
     * Sets the value of the [isconstruction] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * is a construction?
     * @param boolean|integer|string $v The new value
     * @return Project The current object (for fluent API support)
     */
    public function setIsconstruction($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->isconstruction !== $v) {
            $this->isconstruction = $v;
            $this->modifiedColumns[] = ProjectPeer::ISCONSTRUCTION;
        }


        return $this;
    } // setIsconstruction()

    /**
     * Set the value of [relevance] column.
     * Importancia
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setRelevance($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->relevance !== $v) {
            $this->relevance = $v;
            $this->modifiedColumns[] = ProjectPeer::RELEVANCE;
        }


        return $this;
    } // setRelevance()

    /**
     * Set the value of [userid] column.
     * User Id
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setUserid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->userid !== $v) {
            $this->userid = $v;
            $this->modifiedColumns[] = ProjectPeer::USERID;
        }

        if ($this->aUser !== null && $this->aUser->getId() !== $v) {
            $this->aUser = null;
        }


        return $this;
    } // setUserid()

    /**
     * Set the value of [order] column.
     * Orden
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setOrder($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->order !== $v) {
            $this->order = $v;
            $this->modifiedColumns[] = ProjectPeer::ORDER;
        }


        return $this;
    } // setOrder()

    /**
     * Set the value of [weight] column.
     * Peso
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setWeight($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->weight !== $v) {
            $this->weight = $v;
            $this->modifiedColumns[] = ProjectPeer::WEIGHT;
        }


        return $this;
    } // setWeight()

    /**
     * Sets the value of [updated] column to a normalized version of the date/time value specified.
     * Updated
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Project The current object (for fluent API support)
     */
    public function setUpdated($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->updated !== null || $dt !== null) {
            $currentDateAsString = ($this->updated !== null && $tmpDt = new DateTime($this->updated)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->updated = $newDateAsString;
                $this->modifiedColumns[] = ProjectPeer::UPDATED;
            }
        } // if either are not null


        return $this;
    } // setUpdated()

    /**
     * Set the value of [responsiblecode] column.
     * Codigo del responsable
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setResponsiblecode($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->responsiblecode !== $v) {
            $this->responsiblecode = $v;
            $this->modifiedColumns[] = ProjectPeer::RESPONSIBLECODE;
        }

        if ($this->aPosition !== null && $this->aPosition->getCode() !== $v) {
            $this->aPosition = null;
        }


        return $this;
    } // setResponsiblecode()

    /**
     * Set the value of [indicatorid] column.
     * Id del indicador del grafico de desembolsos
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setIndicatorid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->indicatorid !== $v) {
            $this->indicatorid = $v;
            $this->modifiedColumns[] = ProjectPeer::INDICATORID;
        }

        if ($this->aIndicator !== null && $this->aIndicator->getId() !== $v) {
            $this->aIndicator = null;
        }


        return $this;
    } // setIndicatorid()

    /**
     * Set the value of [primarysource] column.
     * Fuente principal de financiamiento
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setPrimarysource($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->primarysource !== $v) {
            $this->primarysource = $v;
            $this->modifiedColumns[] = ProjectPeer::PRIMARYSOURCE;
        }


        return $this;
    } // setPrimarysource()

    /**
     * Set the value of [additionalsource] column.
     * Fuente adicional de financiamiento
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setAdditionalsource($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->additionalsource !== $v) {
            $this->additionalsource = $v;
            $this->modifiedColumns[] = ProjectPeer::ADDITIONALSOURCE;
        }


        return $this;
    } // setAdditionalsource()

    /**
     * Set the value of [startingyear] column.
     * Starting year
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setStartingyear($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->startingyear !== $v) {
            $this->startingyear = $v;
            $this->modifiedColumns[] = ProjectPeer::STARTINGYEAR;
        }


        return $this;
    } // setStartingyear()

    /**
     * Set the value of [endingyear] column.
     * Ending year
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setEndingyear($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->endingyear !== $v) {
            $this->endingyear = $v;
            $this->modifiedColumns[] = ProjectPeer::ENDINGYEAR;
        }


        return $this;
    } // setEndingyear()

    /**
     * Set the value of [subproject] column.
     * is subproject?
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setSubproject($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->subproject !== $v) {
            $this->subproject = $v;
            $this->modifiedColumns[] = ProjectPeer::SUBPROJECT;
        }


        return $this;
    } // setSubproject()

    /**
     * Set the value of [ongoing] column.
     * Nombre del programa en desarrollo
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setOngoing($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->ongoing !== $v) {
            $this->ongoing = $v;
            $this->modifiedColumns[] = ProjectPeer::ONGOING;
        }


        return $this;
    } // setOngoing()

    /**
     * Set the value of [relatedareas] column.
     * Areas relacionadas
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setRelatedareas($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->relatedareas !== $v) {
            $this->relatedareas = $v;
            $this->modifiedColumns[] = ProjectPeer::RELATEDAREAS;
        }


        return $this;
    } // setRelatedareas()

    /**
     * Set the value of [goal] column.
     * Meta producto
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setGoal($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->goal !== $v) {
            $this->goal = $v;
            $this->modifiedColumns[] = ProjectPeer::GOAL;
        }


        return $this;
    } // setGoal()

    /**
     * Set the value of [legal] column.
     * Marco legal
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setLegal($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->legal !== $v) {
            $this->legal = $v;
            $this->modifiedColumns[] = ProjectPeer::LEGAL;
        }


        return $this;
    } // setLegal()

    /**
     * Set the value of [execresp] column.
     * Responsable
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setExecresp($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->execresp !== $v) {
            $this->execresp = $v;
            $this->modifiedColumns[] = ProjectPeer::EXECRESP;
        }


        return $this;
    } // setExecresp()

    /**
     * Set the value of [exectenure] column.
     * Cargo
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setExectenure($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->exectenure !== $v) {
            $this->exectenure = $v;
            $this->modifiedColumns[] = ProjectPeer::EXECTENURE;
        }


        return $this;
    } // setExectenure()

    /**
     * Set the value of [execdependency] column.
     * Dependencia
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setExecdependency($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->execdependency !== $v) {
            $this->execdependency = $v;
            $this->modifiedColumns[] = ProjectPeer::EXECDEPENDENCY;
        }


        return $this;
    } // setExecdependency()

    /**
     * Set the value of [execcontact] column.
     * Contacto
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setExeccontact($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->execcontact !== $v) {
            $this->execcontact = $v;
            $this->modifiedColumns[] = ProjectPeer::EXECCONTACT;
        }


        return $this;
    } // setExeccontact()

    /**
     * Set the value of [subsecretary] column.
     * Subsecretaria
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setSubsecretary($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->subsecretary !== $v) {
            $this->subsecretary = $v;
            $this->modifiedColumns[] = ProjectPeer::SUBSECRETARY;
        }


        return $this;
    } // setSubsecretary()

    /**
     * Set the value of [budgetrequested] column.
     * Presupuesto solicitado
     * @param double $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setBudgetrequested($v)
    {
        if ($v !== null) {
            $v = (double) $v;
        }

        if ($this->budgetrequested !== $v) {
            $this->budgetrequested = $v;
            $this->modifiedColumns[] = ProjectPeer::BUDGETREQUESTED;
        }


        return $this;
    } // setBudgetrequested()

    /**
     * Set the value of [budgetsanctioned] column.
     * Presupuesto sancionado
     * @param double $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setBudgetsanctioned($v)
    {
        if ($v !== null) {
            $v = (double) $v;
        }

        if ($this->budgetsanctioned !== $v) {
            $this->budgetsanctioned = $v;
            $this->modifiedColumns[] = ProjectPeer::BUDGETSANCTIONED;
        }


        return $this;
    } // setBudgetsanctioned()

    /**
     * Sets the value of the [belgrano] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * si es Plan Belgrano?
     * @param boolean|integer|string $v The new value
     * @return Project The current object (for fluent API support)
     */
    public function setBelgrano($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->belgrano !== $v) {
            $this->belgrano = $v;
            $this->modifiedColumns[] = ProjectPeer::BELGRANO;
        }


        return $this;
    } // setBelgrano()

    /**
     * Set the value of [clasification] column.
     * Clasification
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setClasification($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->clasification !== $v) {
            $this->clasification = $v;
            $this->modifiedColumns[] = ProjectPeer::CLASIFICATION;
        }


        return $this;
    } // setClasification()

    /**
     * Sets the value of the [press] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Interes prensa?
     * @param boolean|integer|string $v The new value
     * @return Project The current object (for fluent API support)
     */
    public function setPress($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->press !== $v) {
            $this->press = $v;
            $this->modifiedColumns[] = ProjectPeer::PRESS;
        }


        return $this;
    } // setPress()

    /**
     * Set the value of [priorityarea] column.
     * prioridad del area
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setPriorityarea($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->priorityarea !== $v) {
            $this->priorityarea = $v;
            $this->modifiedColumns[] = ProjectPeer::PRIORITYAREA;
        }


        return $this;
    } // setPriorityarea()

    /**
     * Set the value of [beneficiario] column.
     * Grupo / Sector se va a beneficiar con este proyecto
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setBeneficiario($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->beneficiario !== $v) {
            $this->beneficiario = $v;
            $this->modifiedColumns[] = ProjectPeer::BENEFICIARIO;
        }


        return $this;
    } // setBeneficiario()

    /**
     * Sets the value of the [requirecontractor] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Requiere Contratacion?
     * @param boolean|integer|string $v The new value
     * @return Project The current object (for fluent API support)
     */
    public function setRequirecontractor($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->requirecontractor !== $v) {
            $this->requirecontractor = $v;
            $this->modifiedColumns[] = ProjectPeer::REQUIRECONTRACTOR;
        }


        return $this;
    } // setRequirecontractor()

    /**
     * Set the value of [purchasetype] column.
     * Tipo de compra
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setPurchasetype($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->purchasetype !== $v) {
            $this->purchasetype = $v;
            $this->modifiedColumns[] = ProjectPeer::PURCHASETYPE;
        }


        return $this;
    } // setPurchasetype()

    /**
     * Set the value of [constructiontype] column.
     * Tipo de Obra
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setConstructiontype($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->constructiontype !== $v) {
            $this->constructiontype = $v;
            $this->modifiedColumns[] = ProjectPeer::CONSTRUCTIONTYPE;
        }


        return $this;
    } // setConstructiontype()

    /**
     * Sets the value of the [requireexraresources] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Requiere personal extra?
     * @param boolean|integer|string $v The new value
     * @return Project The current object (for fluent API support)
     */
    public function setRequireexraresources($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->requireexraresources !== $v) {
            $this->requireexraresources = $v;
            $this->modifiedColumns[] = ProjectPeer::REQUIREEXRARESOURCES;
        }


        return $this;
    } // setRequireexraresources()

    /**
     * Set the value of [implementationpartner] column.
     * Socios en la implementación
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setImplementationpartner($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->implementationpartner !== $v) {
            $this->implementationpartner = $v;
            $this->modifiedColumns[] = ProjectPeer::IMPLEMENTATIONPARTNER;
        }


        return $this;
    } // setImplementationpartner()

    /**
     * Set the value of [riskfactors] column.
     * Factores de riesgo
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setRiskfactors($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->riskfactors !== $v) {
            $this->riskfactors = $v;
            $this->modifiedColumns[] = ProjectPeer::RISKFACTORS;
        }


        return $this;
    } // setRiskfactors()

    /**
     * Set the value of [ownfinance] column.
     * Financiamiento propio?
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setOwnfinance($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->ownfinance !== $v) {
            $this->ownfinance = $v;
            $this->modifiedColumns[] = ProjectPeer::OWNFINANCE;
        }


        return $this;
    } // setOwnfinance()

    /**
     * Set the value of [provincefinance] column.
     * Financiamiento Provincial?
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setProvincefinance($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->provincefinance !== $v) {
            $this->provincefinance = $v;
            $this->modifiedColumns[] = ProjectPeer::PROVINCEFINANCE;
        }


        return $this;
    } // setProvincefinance()

    /**
     * Set the value of [nationfinance] column.
     * Financiamiento Nacional?
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setNationfinance($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->nationfinance !== $v) {
            $this->nationfinance = $v;
            $this->modifiedColumns[] = ProjectPeer::NATIONFINANCE;
        }


        return $this;
    } // setNationfinance()

    /**
     * Set the value of [otherfinance] column.
     * Otro Financiamiento?
     * @param int $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setOtherfinance($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->otherfinance !== $v) {
            $this->otherfinance = $v;
            $this->modifiedColumns[] = ProjectPeer::OTHERFINANCE;
        }


        return $this;
    } // setOtherfinance()

    /**
     * Set the value of [financedetail] column.
     * Detalle de financiamiento
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setFinancedetail($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->financedetail !== $v) {
            $this->financedetail = $v;
            $this->modifiedColumns[] = ProjectPeer::FINANCEDETAIL;
        }


        return $this;
    } // setFinancedetail()

    /**
     * Set the value of [financeprogram] column.
     * Programa destino financiamiento
     * @param string $v new value
     * @return Project The current object (for fluent API support)
     */
    public function setFinanceprogram($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->financeprogram !== $v) {
            $this->financeprogram = $v;
            $this->modifiedColumns[] = ProjectPeer::FINANCEPROGRAM;
        }


        return $this;
    } // setFinanceprogram()

    /**
     * Sets the value of [created_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Project The current object (for fluent API support)
     */
    public function setCreatedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->created_at !== null || $dt !== null) {
            $currentDateAsString = ($this->created_at !== null && $tmpDt = new DateTime($this->created_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->created_at = $newDateAsString;
                $this->modifiedColumns[] = ProjectPeer::CREATED_AT;
            }
        } // if either are not null


        return $this;
    } // setCreatedAt()

    /**
     * Sets the value of [updated_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Project The current object (for fluent API support)
     */
    public function setUpdatedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->updated_at !== null || $dt !== null) {
            $currentDateAsString = ($this->updated_at !== null && $tmpDt = new DateTime($this->updated_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->updated_at = $newDateAsString;
                $this->modifiedColumns[] = ProjectPeer::UPDATED_AT;
            }
        } // if either are not null


        return $this;
    } // setUpdatedAt()

    /**
     * Sets the value of [deleted_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Project The current object (for fluent API support)
     */
    public function setDeletedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->deleted_at !== null || $dt !== null) {
            $currentDateAsString = ($this->deleted_at !== null && $tmpDt = new DateTime($this->deleted_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->deleted_at = $newDateAsString;
                $this->modifiedColumns[] = ProjectPeer::DELETED_AT;
            }
        } // if either are not null


        return $this;
    } // setDeletedAt()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
            if ($this->order !== 0) {
                return false;
            }

            if ($this->weight !== '0') {
                return false;
            }

            if ($this->clasification !== 0) {
                return false;
            }

            if ($this->priorityarea !== 0) {
                return false;
            }

        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->objectiveid = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
            $this->code = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
            $this->codeaux = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->name = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->description = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->impact = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->uniquegoal = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
            $this->goalexpirationdate = ($row[$startcol + 8] !== null) ? (string) $row[$startcol + 8] : null;
            $this->date = ($row[$startcol + 9] !== null) ? (string) $row[$startcol + 9] : null;
            $this->budget = ($row[$startcol + 10] !== null) ? (double) $row[$startcol + 10] : null;
            $this->exchangerate = ($row[$startcol + 11] !== null) ? (double) $row[$startcol + 11] : null;
            $this->visibility = ($row[$startcol + 12] !== null) ? (int) $row[$startcol + 12] : null;
            $this->coordinateneed = ($row[$startcol + 13] !== null) ? (string) $row[$startcol + 13] : null;
            $this->frequency = ($row[$startcol + 14] !== null) ? (string) $row[$startcol + 14] : null;
            $this->finished = ($row[$startcol + 15] !== null) ? (boolean) $row[$startcol + 15] : null;
            $this->notes = ($row[$startcol + 16] !== null) ? (string) $row[$startcol + 16] : null;
            $this->postalcode = ($row[$startcol + 17] !== null) ? (string) $row[$startcol + 17] : null;
            $this->uniquegoalnumeric = ($row[$startcol + 18] !== null) ? (int) $row[$startcol + 18] : null;
            $this->goalprogress = ($row[$startcol + 19] !== null) ? (int) $row[$startcol + 19] : null;
            $this->latitude = ($row[$startcol + 20] !== null) ? (double) $row[$startcol + 20] : null;
            $this->longitude = ($row[$startcol + 21] !== null) ? (double) $row[$startcol + 21] : null;
            $this->oldid = ($row[$startcol + 22] !== null) ? (int) $row[$startcol + 22] : null;
            $this->regionid = ($row[$startcol + 23] !== null) ? (int) $row[$startcol + 23] : null;
            $this->oldregionid = ($row[$startcol + 24] !== null) ? (int) $row[$startcol + 24] : null;
            $this->lastmodification = ($row[$startcol + 25] !== null) ? (string) $row[$startcol + 25] : null;
            $this->address = ($row[$startcol + 26] !== null) ? (string) $row[$startcol + 26] : null;
            $this->street = ($row[$startcol + 27] !== null) ? (string) $row[$startcol + 27] : null;
            $this->number = ($row[$startcol + 28] !== null) ? (int) $row[$startcol + 28] : null;
            $this->priority = ($row[$startcol + 29] !== null) ? (int) $row[$startcol + 29] : null;
            $this->modifications = ($row[$startcol + 30] !== null) ? (int) $row[$startcol + 30] : null;
            $this->plannedstart = ($row[$startcol + 31] !== null) ? (string) $row[$startcol + 31] : null;
            $this->plannedend = ($row[$startcol + 32] !== null) ? (string) $row[$startcol + 32] : null;
            $this->realstart = ($row[$startcol + 33] !== null) ? (string) $row[$startcol + 33] : null;
            $this->realend = ($row[$startcol + 34] !== null) ? (string) $row[$startcol + 34] : null;
            $this->cancelled = ($row[$startcol + 35] !== null) ? (boolean) $row[$startcol + 35] : null;
            $this->isconstruction = ($row[$startcol + 36] !== null) ? (boolean) $row[$startcol + 36] : null;
            $this->relevance = ($row[$startcol + 37] !== null) ? (string) $row[$startcol + 37] : null;
            $this->userid = ($row[$startcol + 38] !== null) ? (int) $row[$startcol + 38] : null;
            $this->order = ($row[$startcol + 39] !== null) ? (int) $row[$startcol + 39] : null;
            $this->weight = ($row[$startcol + 40] !== null) ? (string) $row[$startcol + 40] : null;
            $this->updated = ($row[$startcol + 41] !== null) ? (string) $row[$startcol + 41] : null;
            $this->responsiblecode = ($row[$startcol + 42] !== null) ? (int) $row[$startcol + 42] : null;
            $this->indicatorid = ($row[$startcol + 43] !== null) ? (int) $row[$startcol + 43] : null;
            $this->primarysource = ($row[$startcol + 44] !== null) ? (string) $row[$startcol + 44] : null;
            $this->additionalsource = ($row[$startcol + 45] !== null) ? (string) $row[$startcol + 45] : null;
            $this->startingyear = ($row[$startcol + 46] !== null) ? (int) $row[$startcol + 46] : null;
            $this->endingyear = ($row[$startcol + 47] !== null) ? (int) $row[$startcol + 47] : null;
            $this->subproject = ($row[$startcol + 48] !== null) ? (string) $row[$startcol + 48] : null;
            $this->ongoing = ($row[$startcol + 49] !== null) ? (string) $row[$startcol + 49] : null;
            $this->relatedareas = ($row[$startcol + 50] !== null) ? (string) $row[$startcol + 50] : null;
            $this->goal = ($row[$startcol + 51] !== null) ? (string) $row[$startcol + 51] : null;
            $this->legal = ($row[$startcol + 52] !== null) ? (string) $row[$startcol + 52] : null;
            $this->execresp = ($row[$startcol + 53] !== null) ? (string) $row[$startcol + 53] : null;
            $this->exectenure = ($row[$startcol + 54] !== null) ? (string) $row[$startcol + 54] : null;
            $this->execdependency = ($row[$startcol + 55] !== null) ? (string) $row[$startcol + 55] : null;
            $this->execcontact = ($row[$startcol + 56] !== null) ? (string) $row[$startcol + 56] : null;
            $this->subsecretary = ($row[$startcol + 57] !== null) ? (string) $row[$startcol + 57] : null;
            $this->budgetrequested = ($row[$startcol + 58] !== null) ? (double) $row[$startcol + 58] : null;
            $this->budgetsanctioned = ($row[$startcol + 59] !== null) ? (double) $row[$startcol + 59] : null;
            $this->belgrano = ($row[$startcol + 60] !== null) ? (boolean) $row[$startcol + 60] : null;
            $this->clasification = ($row[$startcol + 61] !== null) ? (int) $row[$startcol + 61] : null;
            $this->press = ($row[$startcol + 62] !== null) ? (boolean) $row[$startcol + 62] : null;
            $this->priorityarea = ($row[$startcol + 63] !== null) ? (int) $row[$startcol + 63] : null;
            $this->beneficiario = ($row[$startcol + 64] !== null) ? (string) $row[$startcol + 64] : null;
            $this->requirecontractor = ($row[$startcol + 65] !== null) ? (boolean) $row[$startcol + 65] : null;
            $this->purchasetype = ($row[$startcol + 66] !== null) ? (int) $row[$startcol + 66] : null;
            $this->constructiontype = ($row[$startcol + 67] !== null) ? (int) $row[$startcol + 67] : null;
            $this->requireexraresources = ($row[$startcol + 68] !== null) ? (boolean) $row[$startcol + 68] : null;
            $this->implementationpartner = ($row[$startcol + 69] !== null) ? (string) $row[$startcol + 69] : null;
            $this->riskfactors = ($row[$startcol + 70] !== null) ? (string) $row[$startcol + 70] : null;
            $this->ownfinance = ($row[$startcol + 71] !== null) ? (int) $row[$startcol + 71] : null;
            $this->provincefinance = ($row[$startcol + 72] !== null) ? (int) $row[$startcol + 72] : null;
            $this->nationfinance = ($row[$startcol + 73] !== null) ? (int) $row[$startcol + 73] : null;
            $this->otherfinance = ($row[$startcol + 74] !== null) ? (int) $row[$startcol + 74] : null;
            $this->financedetail = ($row[$startcol + 75] !== null) ? (string) $row[$startcol + 75] : null;
            $this->financeprogram = ($row[$startcol + 76] !== null) ? (string) $row[$startcol + 76] : null;
            $this->created_at = ($row[$startcol + 77] !== null) ? (string) $row[$startcol + 77] : null;
            $this->updated_at = ($row[$startcol + 78] !== null) ? (string) $row[$startcol + 78] : null;
            $this->deleted_at = ($row[$startcol + 79] !== null) ? (string) $row[$startcol + 79] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 80; // 80 = ProjectPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating Project object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aObjective !== null && $this->objectiveid !== $this->aObjective->getId()) {
            $this->aObjective = null;
        }
        if ($this->aUser !== null && $this->userid !== $this->aUser->getId()) {
            $this->aUser = null;
        }
        if ($this->aPosition !== null && $this->responsiblecode !== $this->aPosition->getCode()) {
            $this->aPosition = null;
        }
        if ($this->aIndicator !== null && $this->indicatorid !== $this->aIndicator->getId()) {
            $this->aIndicator = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ProjectPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = ProjectPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aObjective = null;
            $this->aPosition = null;
            $this->aIndicator = null;
            $this->aUser = null;
            $this->collConstructions = null;

            $this->collGuarantees = null;

            $this->collAdministrativeActs = null;

            $this->collProjectRegions = null;

            $this->collProjectMilestones = null;

            $this->collProjectIndicators = null;

            $this->collProjectActivitys = null;

            $this->collProjectDocuments = null;

            $this->collProjectContractors = null;

            $this->collProjectLogs = null;

            $this->collProjectMilestoneLogs = null;

            $this->collProjectActivityLogs = null;

            $this->collRegions = null;
            $this->collDocuments = null;
            $this->collContractors = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ProjectPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = ProjectQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            // soft_delete behavior
            if (!empty($ret) && ProjectQuery::isSoftDeleteEnabled()) {
                $this->keepUpdateDateUnchanged();
                $this->setDeletedAt(time());
                $this->save($con);
                $this->postDelete($con);
                $con->commit();
                ProjectPeer::removeInstanceFromPool($this);

                return;
            }

            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ProjectPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
                // timestampable behavior
                if (!$this->isColumnModified(ProjectPeer::CREATED_AT)) {
                    $this->setCreatedAt(time());
                }
                if (!$this->isColumnModified(ProjectPeer::UPDATED_AT)) {
                    $this->setUpdatedAt(time());
                }
            } else {
                $ret = $ret && $this->preUpdate($con);
                // timestampable behavior
                if ($this->isModified() && !$this->isColumnModified(ProjectPeer::UPDATED_AT)) {
                    $this->setUpdatedAt(time());
                }
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                ProjectPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aObjective !== null) {
                if ($this->aObjective->isModified() || $this->aObjective->isNew()) {
                    $affectedRows += $this->aObjective->save($con);
                }
                $this->setObjective($this->aObjective);
            }

            if ($this->aPosition !== null) {
                if ($this->aPosition->isModified() || $this->aPosition->isNew()) {
                    $affectedRows += $this->aPosition->save($con);
                }
                $this->setPosition($this->aPosition);
            }

            if ($this->aIndicator !== null) {
                if ($this->aIndicator->isModified() || $this->aIndicator->isNew()) {
                    $affectedRows += $this->aIndicator->save($con);
                }
                $this->setIndicator($this->aIndicator);
            }

            if ($this->aUser !== null) {
                if ($this->aUser->isModified() || $this->aUser->isNew()) {
                    $affectedRows += $this->aUser->save($con);
                }
                $this->setUser($this->aUser);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->regionsScheduledForDeletion !== null) {
                if (!$this->regionsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->regionsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    ProjectRegionQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->regionsScheduledForDeletion = null;
                }

                foreach ($this->getRegions() as $region) {
                    if ($region->isModified()) {
                        $region->save($con);
                    }
                }
            }

            if ($this->documentsScheduledForDeletion !== null) {
                if (!$this->documentsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->documentsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    ProjectDocumentQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->documentsScheduledForDeletion = null;
                }

                foreach ($this->getDocuments() as $document) {
                    if ($document->isModified()) {
                        $document->save($con);
                    }
                }
            }

            if ($this->contractorsScheduledForDeletion !== null) {
                if (!$this->contractorsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->contractorsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    ProjectContractorQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->contractorsScheduledForDeletion = null;
                }

                foreach ($this->getContractors() as $contractor) {
                    if ($contractor->isModified()) {
                        $contractor->save($con);
                    }
                }
            }

            if ($this->constructionsScheduledForDeletion !== null) {
                if (!$this->constructionsScheduledForDeletion->isEmpty()) {
                    foreach ($this->constructionsScheduledForDeletion as $construction) {
                        // need to save related object because we set the relation to null
                        $construction->save($con);
                    }
                    $this->constructionsScheduledForDeletion = null;
                }
            }

            if ($this->collConstructions !== null) {
                foreach ($this->collConstructions as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->guaranteesScheduledForDeletion !== null) {
                if (!$this->guaranteesScheduledForDeletion->isEmpty()) {
                    foreach ($this->guaranteesScheduledForDeletion as $guarantee) {
                        // need to save related object because we set the relation to null
                        $guarantee->save($con);
                    }
                    $this->guaranteesScheduledForDeletion = null;
                }
            }

            if ($this->collGuarantees !== null) {
                foreach ($this->collGuarantees as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->administrativeActsScheduledForDeletion !== null) {
                if (!$this->administrativeActsScheduledForDeletion->isEmpty()) {
                    foreach ($this->administrativeActsScheduledForDeletion as $administrativeAct) {
                        // need to save related object because we set the relation to null
                        $administrativeAct->save($con);
                    }
                    $this->administrativeActsScheduledForDeletion = null;
                }
            }

            if ($this->collAdministrativeActs !== null) {
                foreach ($this->collAdministrativeActs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectRegionsScheduledForDeletion !== null) {
                if (!$this->projectRegionsScheduledForDeletion->isEmpty()) {
                    ProjectRegionQuery::create()
                        ->filterByPrimaryKeys($this->projectRegionsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->projectRegionsScheduledForDeletion = null;
                }
            }

            if ($this->collProjectRegions !== null) {
                foreach ($this->collProjectRegions as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectMilestonesScheduledForDeletion !== null) {
                if (!$this->projectMilestonesScheduledForDeletion->isEmpty()) {
                    ProjectMilestoneQuery::create()
                        ->filterByPrimaryKeys($this->projectMilestonesScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->projectMilestonesScheduledForDeletion = null;
                }
            }

            if ($this->collProjectMilestones !== null) {
                foreach ($this->collProjectMilestones as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectIndicatorsScheduledForDeletion !== null) {
                if (!$this->projectIndicatorsScheduledForDeletion->isEmpty()) {
                    ProjectIndicatorQuery::create()
                        ->filterByPrimaryKeys($this->projectIndicatorsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->projectIndicatorsScheduledForDeletion = null;
                }
            }

            if ($this->collProjectIndicators !== null) {
                foreach ($this->collProjectIndicators as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectActivitysScheduledForDeletion !== null) {
                if (!$this->projectActivitysScheduledForDeletion->isEmpty()) {
                    ProjectActivityQuery::create()
                        ->filterByPrimaryKeys($this->projectActivitysScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->projectActivitysScheduledForDeletion = null;
                }
            }

            if ($this->collProjectActivitys !== null) {
                foreach ($this->collProjectActivitys as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectDocumentsScheduledForDeletion !== null) {
                if (!$this->projectDocumentsScheduledForDeletion->isEmpty()) {
                    ProjectDocumentQuery::create()
                        ->filterByPrimaryKeys($this->projectDocumentsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->projectDocumentsScheduledForDeletion = null;
                }
            }

            if ($this->collProjectDocuments !== null) {
                foreach ($this->collProjectDocuments as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectContractorsScheduledForDeletion !== null) {
                if (!$this->projectContractorsScheduledForDeletion->isEmpty()) {
                    foreach ($this->projectContractorsScheduledForDeletion as $projectContractor) {
                        // need to save related object because we set the relation to null
                        $projectContractor->save($con);
                    }
                    $this->projectContractorsScheduledForDeletion = null;
                }
            }

            if ($this->collProjectContractors !== null) {
                foreach ($this->collProjectContractors as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectLogsScheduledForDeletion !== null) {
                if (!$this->projectLogsScheduledForDeletion->isEmpty()) {
                    ProjectLogQuery::create()
                        ->filterByPrimaryKeys($this->projectLogsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->projectLogsScheduledForDeletion = null;
                }
            }

            if ($this->collProjectLogs !== null) {
                foreach ($this->collProjectLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectMilestoneLogsScheduledForDeletion !== null) {
                if (!$this->projectMilestoneLogsScheduledForDeletion->isEmpty()) {
                    ProjectMilestoneLogQuery::create()
                        ->filterByPrimaryKeys($this->projectMilestoneLogsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->projectMilestoneLogsScheduledForDeletion = null;
                }
            }

            if ($this->collProjectMilestoneLogs !== null) {
                foreach ($this->collProjectMilestoneLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectActivityLogsScheduledForDeletion !== null) {
                if (!$this->projectActivityLogsScheduledForDeletion->isEmpty()) {
                    ProjectActivityLogQuery::create()
                        ->filterByPrimaryKeys($this->projectActivityLogsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->projectActivityLogsScheduledForDeletion = null;
                }
            }

            if ($this->collProjectActivityLogs !== null) {
                foreach ($this->collProjectActivityLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = ProjectPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . ProjectPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(ProjectPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(ProjectPeer::OBJECTIVEID)) {
            $modifiedColumns[':p' . $index++]  = '`OBJECTIVEID`';
        }
        if ($this->isColumnModified(ProjectPeer::CODE)) {
            $modifiedColumns[':p' . $index++]  = '`CODE`';
        }
        if ($this->isColumnModified(ProjectPeer::CODEAUX)) {
            $modifiedColumns[':p' . $index++]  = '`CODEAUX`';
        }
        if ($this->isColumnModified(ProjectPeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(ProjectPeer::DESCRIPTION)) {
            $modifiedColumns[':p' . $index++]  = '`DESCRIPTION`';
        }
        if ($this->isColumnModified(ProjectPeer::IMPACT)) {
            $modifiedColumns[':p' . $index++]  = '`IMPACT`';
        }
        if ($this->isColumnModified(ProjectPeer::UNIQUEGOAL)) {
            $modifiedColumns[':p' . $index++]  = '`UNIQUEGOAL`';
        }
        if ($this->isColumnModified(ProjectPeer::GOALEXPIRATIONDATE)) {
            $modifiedColumns[':p' . $index++]  = '`GOALEXPIRATIONDATE`';
        }
        if ($this->isColumnModified(ProjectPeer::DATE)) {
            $modifiedColumns[':p' . $index++]  = '`DATE`';
        }
        if ($this->isColumnModified(ProjectPeer::BUDGET)) {
            $modifiedColumns[':p' . $index++]  = '`BUDGET`';
        }
        if ($this->isColumnModified(ProjectPeer::EXCHANGERATE)) {
            $modifiedColumns[':p' . $index++]  = '`EXCHANGERATE`';
        }
        if ($this->isColumnModified(ProjectPeer::VISIBILITY)) {
            $modifiedColumns[':p' . $index++]  = '`VISIBILITY`';
        }
        if ($this->isColumnModified(ProjectPeer::COORDINATENEED)) {
            $modifiedColumns[':p' . $index++]  = '`COORDINATENEED`';
        }
        if ($this->isColumnModified(ProjectPeer::FREQUENCY)) {
            $modifiedColumns[':p' . $index++]  = '`FREQUENCY`';
        }
        if ($this->isColumnModified(ProjectPeer::FINISHED)) {
            $modifiedColumns[':p' . $index++]  = '`FINISHED`';
        }
        if ($this->isColumnModified(ProjectPeer::NOTES)) {
            $modifiedColumns[':p' . $index++]  = '`NOTES`';
        }
        if ($this->isColumnModified(ProjectPeer::POSTALCODE)) {
            $modifiedColumns[':p' . $index++]  = '`POSTALCODE`';
        }
        if ($this->isColumnModified(ProjectPeer::UNIQUEGOALNUMERIC)) {
            $modifiedColumns[':p' . $index++]  = '`UNIQUEGOALNUMERIC`';
        }
        if ($this->isColumnModified(ProjectPeer::GOALPROGRESS)) {
            $modifiedColumns[':p' . $index++]  = '`GOALPROGRESS`';
        }
        if ($this->isColumnModified(ProjectPeer::LATITUDE)) {
            $modifiedColumns[':p' . $index++]  = '`LATITUDE`';
        }
        if ($this->isColumnModified(ProjectPeer::LONGITUDE)) {
            $modifiedColumns[':p' . $index++]  = '`LONGITUDE`';
        }
        if ($this->isColumnModified(ProjectPeer::OLDID)) {
            $modifiedColumns[':p' . $index++]  = '`OLDID`';
        }
        if ($this->isColumnModified(ProjectPeer::REGIONID)) {
            $modifiedColumns[':p' . $index++]  = '`REGIONID`';
        }
        if ($this->isColumnModified(ProjectPeer::OLDREGIONID)) {
            $modifiedColumns[':p' . $index++]  = '`OLDREGIONID`';
        }
        if ($this->isColumnModified(ProjectPeer::LASTMODIFICATION)) {
            $modifiedColumns[':p' . $index++]  = '`LASTMODIFICATION`';
        }
        if ($this->isColumnModified(ProjectPeer::ADDRESS)) {
            $modifiedColumns[':p' . $index++]  = '`ADDRESS`';
        }
        if ($this->isColumnModified(ProjectPeer::STREET)) {
            $modifiedColumns[':p' . $index++]  = '`STREET`';
        }
        if ($this->isColumnModified(ProjectPeer::NUMBER)) {
            $modifiedColumns[':p' . $index++]  = '`NUMBER`';
        }
        if ($this->isColumnModified(ProjectPeer::PRIORITY)) {
            $modifiedColumns[':p' . $index++]  = '`PRIORITY`';
        }
        if ($this->isColumnModified(ProjectPeer::MODIFICATIONS)) {
            $modifiedColumns[':p' . $index++]  = '`MODIFICATIONS`';
        }
        if ($this->isColumnModified(ProjectPeer::PLANNEDSTART)) {
            $modifiedColumns[':p' . $index++]  = '`PLANNEDSTART`';
        }
        if ($this->isColumnModified(ProjectPeer::PLANNEDEND)) {
            $modifiedColumns[':p' . $index++]  = '`PLANNEDEND`';
        }
        if ($this->isColumnModified(ProjectPeer::REALSTART)) {
            $modifiedColumns[':p' . $index++]  = '`REALSTART`';
        }
        if ($this->isColumnModified(ProjectPeer::REALEND)) {
            $modifiedColumns[':p' . $index++]  = '`REALEND`';
        }
        if ($this->isColumnModified(ProjectPeer::CANCELLED)) {
            $modifiedColumns[':p' . $index++]  = '`CANCELLED`';
        }
        if ($this->isColumnModified(ProjectPeer::ISCONSTRUCTION)) {
            $modifiedColumns[':p' . $index++]  = '`ISCONSTRUCTION`';
        }
        if ($this->isColumnModified(ProjectPeer::RELEVANCE)) {
            $modifiedColumns[':p' . $index++]  = '`RELEVANCE`';
        }
        if ($this->isColumnModified(ProjectPeer::USERID)) {
            $modifiedColumns[':p' . $index++]  = '`USERID`';
        }
        if ($this->isColumnModified(ProjectPeer::ORDER)) {
            $modifiedColumns[':p' . $index++]  = '`ORDER`';
        }
        if ($this->isColumnModified(ProjectPeer::WEIGHT)) {
            $modifiedColumns[':p' . $index++]  = '`WEIGHT`';
        }
        if ($this->isColumnModified(ProjectPeer::UPDATED)) {
            $modifiedColumns[':p' . $index++]  = '`UPDATED`';
        }
        if ($this->isColumnModified(ProjectPeer::RESPONSIBLECODE)) {
            $modifiedColumns[':p' . $index++]  = '`RESPONSIBLECODE`';
        }
        if ($this->isColumnModified(ProjectPeer::INDICATORID)) {
            $modifiedColumns[':p' . $index++]  = '`INDICATORID`';
        }
        if ($this->isColumnModified(ProjectPeer::PRIMARYSOURCE)) {
            $modifiedColumns[':p' . $index++]  = '`PRIMARYSOURCE`';
        }
        if ($this->isColumnModified(ProjectPeer::ADDITIONALSOURCE)) {
            $modifiedColumns[':p' . $index++]  = '`ADDITIONALSOURCE`';
        }
        if ($this->isColumnModified(ProjectPeer::STARTINGYEAR)) {
            $modifiedColumns[':p' . $index++]  = '`STARTINGYEAR`';
        }
        if ($this->isColumnModified(ProjectPeer::ENDINGYEAR)) {
            $modifiedColumns[':p' . $index++]  = '`ENDINGYEAR`';
        }
        if ($this->isColumnModified(ProjectPeer::SUBPROJECT)) {
            $modifiedColumns[':p' . $index++]  = '`SUBPROJECT`';
        }
        if ($this->isColumnModified(ProjectPeer::ONGOING)) {
            $modifiedColumns[':p' . $index++]  = '`ONGOING`';
        }
        if ($this->isColumnModified(ProjectPeer::RELATEDAREAS)) {
            $modifiedColumns[':p' . $index++]  = '`RELATEDAREAS`';
        }
        if ($this->isColumnModified(ProjectPeer::GOAL)) {
            $modifiedColumns[':p' . $index++]  = '`GOAL`';
        }
        if ($this->isColumnModified(ProjectPeer::LEGAL)) {
            $modifiedColumns[':p' . $index++]  = '`LEGAL`';
        }
        if ($this->isColumnModified(ProjectPeer::EXECRESP)) {
            $modifiedColumns[':p' . $index++]  = '`EXECRESP`';
        }
        if ($this->isColumnModified(ProjectPeer::EXECTENURE)) {
            $modifiedColumns[':p' . $index++]  = '`EXECTENURE`';
        }
        if ($this->isColumnModified(ProjectPeer::EXECDEPENDENCY)) {
            $modifiedColumns[':p' . $index++]  = '`EXECDEPENDENCY`';
        }
        if ($this->isColumnModified(ProjectPeer::EXECCONTACT)) {
            $modifiedColumns[':p' . $index++]  = '`EXECCONTACT`';
        }
        if ($this->isColumnModified(ProjectPeer::SUBSECRETARY)) {
            $modifiedColumns[':p' . $index++]  = '`SUBSECRETARY`';
        }
        if ($this->isColumnModified(ProjectPeer::BUDGETREQUESTED)) {
            $modifiedColumns[':p' . $index++]  = '`BUDGETREQUESTED`';
        }
        if ($this->isColumnModified(ProjectPeer::BUDGETSANCTIONED)) {
            $modifiedColumns[':p' . $index++]  = '`BUDGETSANCTIONED`';
        }
        if ($this->isColumnModified(ProjectPeer::BELGRANO)) {
            $modifiedColumns[':p' . $index++]  = '`BELGRANO`';
        }
        if ($this->isColumnModified(ProjectPeer::CLASIFICATION)) {
            $modifiedColumns[':p' . $index++]  = '`CLASIFICATION`';
        }
        if ($this->isColumnModified(ProjectPeer::PRESS)) {
            $modifiedColumns[':p' . $index++]  = '`PRESS`';
        }
        if ($this->isColumnModified(ProjectPeer::PRIORITYAREA)) {
            $modifiedColumns[':p' . $index++]  = '`PRIORITYAREA`';
        }
        if ($this->isColumnModified(ProjectPeer::BENEFICIARIO)) {
            $modifiedColumns[':p' . $index++]  = '`BENEFICIARIO`';
        }
        if ($this->isColumnModified(ProjectPeer::REQUIRECONTRACTOR)) {
            $modifiedColumns[':p' . $index++]  = '`REQUIRECONTRACTOR`';
        }
        if ($this->isColumnModified(ProjectPeer::PURCHASETYPE)) {
            $modifiedColumns[':p' . $index++]  = '`PURCHASETYPE`';
        }
        if ($this->isColumnModified(ProjectPeer::CONSTRUCTIONTYPE)) {
            $modifiedColumns[':p' . $index++]  = '`CONSTRUCTIONTYPE`';
        }
        if ($this->isColumnModified(ProjectPeer::REQUIREEXRARESOURCES)) {
            $modifiedColumns[':p' . $index++]  = '`REQUIREEXRARESOURCES`';
        }
        if ($this->isColumnModified(ProjectPeer::IMPLEMENTATIONPARTNER)) {
            $modifiedColumns[':p' . $index++]  = '`IMPLEMENTATIONPARTNER`';
        }
        if ($this->isColumnModified(ProjectPeer::RISKFACTORS)) {
            $modifiedColumns[':p' . $index++]  = '`RISKFACTORS`';
        }
        if ($this->isColumnModified(ProjectPeer::OWNFINANCE)) {
            $modifiedColumns[':p' . $index++]  = '`OWNFINANCE`';
        }
        if ($this->isColumnModified(ProjectPeer::PROVINCEFINANCE)) {
            $modifiedColumns[':p' . $index++]  = '`PROVINCEFINANCE`';
        }
        if ($this->isColumnModified(ProjectPeer::NATIONFINANCE)) {
            $modifiedColumns[':p' . $index++]  = '`NATIONFINANCE`';
        }
        if ($this->isColumnModified(ProjectPeer::OTHERFINANCE)) {
            $modifiedColumns[':p' . $index++]  = '`OTHERFINANCE`';
        }
        if ($this->isColumnModified(ProjectPeer::FINANCEDETAIL)) {
            $modifiedColumns[':p' . $index++]  = '`FINANCEDETAIL`';
        }
        if ($this->isColumnModified(ProjectPeer::FINANCEPROGRAM)) {
            $modifiedColumns[':p' . $index++]  = '`FINANCEPROGRAM`';
        }
        if ($this->isColumnModified(ProjectPeer::CREATED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`CREATED_AT`';
        }
        if ($this->isColumnModified(ProjectPeer::UPDATED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`UPDATED_AT`';
        }
        if ($this->isColumnModified(ProjectPeer::DELETED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`DELETED_AT`';
        }

        $sql = sprintf(
            'INSERT INTO `projects_project` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`OBJECTIVEID`':
                        $stmt->bindValue($identifier, $this->objectiveid, PDO::PARAM_INT);
                        break;
                    case '`CODE`':
                        $stmt->bindValue($identifier, $this->code, PDO::PARAM_STR);
                        break;
                    case '`CODEAUX`':
                        $stmt->bindValue($identifier, $this->codeaux, PDO::PARAM_STR);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`DESCRIPTION`':
                        $stmt->bindValue($identifier, $this->description, PDO::PARAM_STR);
                        break;
                    case '`IMPACT`':
                        $stmt->bindValue($identifier, $this->impact, PDO::PARAM_STR);
                        break;
                    case '`UNIQUEGOAL`':
                        $stmt->bindValue($identifier, $this->uniquegoal, PDO::PARAM_STR);
                        break;
                    case '`GOALEXPIRATIONDATE`':
                        $stmt->bindValue($identifier, $this->goalexpirationdate, PDO::PARAM_STR);
                        break;
                    case '`DATE`':
                        $stmt->bindValue($identifier, $this->date, PDO::PARAM_STR);
                        break;
                    case '`BUDGET`':
                        $stmt->bindValue($identifier, $this->budget, PDO::PARAM_STR);
                        break;
                    case '`EXCHANGERATE`':
                        $stmt->bindValue($identifier, $this->exchangerate, PDO::PARAM_STR);
                        break;
                    case '`VISIBILITY`':
                        $stmt->bindValue($identifier, $this->visibility, PDO::PARAM_INT);
                        break;
                    case '`COORDINATENEED`':
                        $stmt->bindValue($identifier, $this->coordinateneed, PDO::PARAM_STR);
                        break;
                    case '`FREQUENCY`':
                        $stmt->bindValue($identifier, $this->frequency, PDO::PARAM_STR);
                        break;
                    case '`FINISHED`':
                        $stmt->bindValue($identifier, (int) $this->finished, PDO::PARAM_INT);
                        break;
                    case '`NOTES`':
                        $stmt->bindValue($identifier, $this->notes, PDO::PARAM_STR);
                        break;
                    case '`POSTALCODE`':
                        $stmt->bindValue($identifier, $this->postalcode, PDO::PARAM_STR);
                        break;
                    case '`UNIQUEGOALNUMERIC`':
                        $stmt->bindValue($identifier, $this->uniquegoalnumeric, PDO::PARAM_INT);
                        break;
                    case '`GOALPROGRESS`':
                        $stmt->bindValue($identifier, $this->goalprogress, PDO::PARAM_INT);
                        break;
                    case '`LATITUDE`':
                        $stmt->bindValue($identifier, $this->latitude, PDO::PARAM_STR);
                        break;
                    case '`LONGITUDE`':
                        $stmt->bindValue($identifier, $this->longitude, PDO::PARAM_STR);
                        break;
                    case '`OLDID`':
                        $stmt->bindValue($identifier, $this->oldid, PDO::PARAM_INT);
                        break;
                    case '`REGIONID`':
                        $stmt->bindValue($identifier, $this->regionid, PDO::PARAM_INT);
                        break;
                    case '`OLDREGIONID`':
                        $stmt->bindValue($identifier, $this->oldregionid, PDO::PARAM_INT);
                        break;
                    case '`LASTMODIFICATION`':
                        $stmt->bindValue($identifier, $this->lastmodification, PDO::PARAM_STR);
                        break;
                    case '`ADDRESS`':
                        $stmt->bindValue($identifier, $this->address, PDO::PARAM_STR);
                        break;
                    case '`STREET`':
                        $stmt->bindValue($identifier, $this->street, PDO::PARAM_STR);
                        break;
                    case '`NUMBER`':
                        $stmt->bindValue($identifier, $this->number, PDO::PARAM_INT);
                        break;
                    case '`PRIORITY`':
                        $stmt->bindValue($identifier, $this->priority, PDO::PARAM_INT);
                        break;
                    case '`MODIFICATIONS`':
                        $stmt->bindValue($identifier, $this->modifications, PDO::PARAM_INT);
                        break;
                    case '`PLANNEDSTART`':
                        $stmt->bindValue($identifier, $this->plannedstart, PDO::PARAM_STR);
                        break;
                    case '`PLANNEDEND`':
                        $stmt->bindValue($identifier, $this->plannedend, PDO::PARAM_STR);
                        break;
                    case '`REALSTART`':
                        $stmt->bindValue($identifier, $this->realstart, PDO::PARAM_STR);
                        break;
                    case '`REALEND`':
                        $stmt->bindValue($identifier, $this->realend, PDO::PARAM_STR);
                        break;
                    case '`CANCELLED`':
                        $stmt->bindValue($identifier, (int) $this->cancelled, PDO::PARAM_INT);
                        break;
                    case '`ISCONSTRUCTION`':
                        $stmt->bindValue($identifier, (int) $this->isconstruction, PDO::PARAM_INT);
                        break;
                    case '`RELEVANCE`':
                        $stmt->bindValue($identifier, $this->relevance, PDO::PARAM_STR);
                        break;
                    case '`USERID`':
                        $stmt->bindValue($identifier, $this->userid, PDO::PARAM_INT);
                        break;
                    case '`ORDER`':
                        $stmt->bindValue($identifier, $this->order, PDO::PARAM_INT);
                        break;
                    case '`WEIGHT`':
                        $stmt->bindValue($identifier, $this->weight, PDO::PARAM_STR);
                        break;
                    case '`UPDATED`':
                        $stmt->bindValue($identifier, $this->updated, PDO::PARAM_STR);
                        break;
                    case '`RESPONSIBLECODE`':
                        $stmt->bindValue($identifier, $this->responsiblecode, PDO::PARAM_INT);
                        break;
                    case '`INDICATORID`':
                        $stmt->bindValue($identifier, $this->indicatorid, PDO::PARAM_INT);
                        break;
                    case '`PRIMARYSOURCE`':
                        $stmt->bindValue($identifier, $this->primarysource, PDO::PARAM_STR);
                        break;
                    case '`ADDITIONALSOURCE`':
                        $stmt->bindValue($identifier, $this->additionalsource, PDO::PARAM_STR);
                        break;
                    case '`STARTINGYEAR`':
                        $stmt->bindValue($identifier, $this->startingyear, PDO::PARAM_INT);
                        break;
                    case '`ENDINGYEAR`':
                        $stmt->bindValue($identifier, $this->endingyear, PDO::PARAM_INT);
                        break;
                    case '`SUBPROJECT`':
                        $stmt->bindValue($identifier, $this->subproject, PDO::PARAM_STR);
                        break;
                    case '`ONGOING`':
                        $stmt->bindValue($identifier, $this->ongoing, PDO::PARAM_STR);
                        break;
                    case '`RELATEDAREAS`':
                        $stmt->bindValue($identifier, $this->relatedareas, PDO::PARAM_STR);
                        break;
                    case '`GOAL`':
                        $stmt->bindValue($identifier, $this->goal, PDO::PARAM_STR);
                        break;
                    case '`LEGAL`':
                        $stmt->bindValue($identifier, $this->legal, PDO::PARAM_STR);
                        break;
                    case '`EXECRESP`':
                        $stmt->bindValue($identifier, $this->execresp, PDO::PARAM_STR);
                        break;
                    case '`EXECTENURE`':
                        $stmt->bindValue($identifier, $this->exectenure, PDO::PARAM_STR);
                        break;
                    case '`EXECDEPENDENCY`':
                        $stmt->bindValue($identifier, $this->execdependency, PDO::PARAM_STR);
                        break;
                    case '`EXECCONTACT`':
                        $stmt->bindValue($identifier, $this->execcontact, PDO::PARAM_STR);
                        break;
                    case '`SUBSECRETARY`':
                        $stmt->bindValue($identifier, $this->subsecretary, PDO::PARAM_STR);
                        break;
                    case '`BUDGETREQUESTED`':
                        $stmt->bindValue($identifier, $this->budgetrequested, PDO::PARAM_STR);
                        break;
                    case '`BUDGETSANCTIONED`':
                        $stmt->bindValue($identifier, $this->budgetsanctioned, PDO::PARAM_STR);
                        break;
                    case '`BELGRANO`':
                        $stmt->bindValue($identifier, (int) $this->belgrano, PDO::PARAM_INT);
                        break;
                    case '`CLASIFICATION`':
                        $stmt->bindValue($identifier, $this->clasification, PDO::PARAM_INT);
                        break;
                    case '`PRESS`':
                        $stmt->bindValue($identifier, (int) $this->press, PDO::PARAM_INT);
                        break;
                    case '`PRIORITYAREA`':
                        $stmt->bindValue($identifier, $this->priorityarea, PDO::PARAM_INT);
                        break;
                    case '`BENEFICIARIO`':
                        $stmt->bindValue($identifier, $this->beneficiario, PDO::PARAM_STR);
                        break;
                    case '`REQUIRECONTRACTOR`':
                        $stmt->bindValue($identifier, (int) $this->requirecontractor, PDO::PARAM_INT);
                        break;
                    case '`PURCHASETYPE`':
                        $stmt->bindValue($identifier, $this->purchasetype, PDO::PARAM_INT);
                        break;
                    case '`CONSTRUCTIONTYPE`':
                        $stmt->bindValue($identifier, $this->constructiontype, PDO::PARAM_INT);
                        break;
                    case '`REQUIREEXRARESOURCES`':
                        $stmt->bindValue($identifier, (int) $this->requireexraresources, PDO::PARAM_INT);
                        break;
                    case '`IMPLEMENTATIONPARTNER`':
                        $stmt->bindValue($identifier, $this->implementationpartner, PDO::PARAM_STR);
                        break;
                    case '`RISKFACTORS`':
                        $stmt->bindValue($identifier, $this->riskfactors, PDO::PARAM_STR);
                        break;
                    case '`OWNFINANCE`':
                        $stmt->bindValue($identifier, $this->ownfinance, PDO::PARAM_INT);
                        break;
                    case '`PROVINCEFINANCE`':
                        $stmt->bindValue($identifier, $this->provincefinance, PDO::PARAM_INT);
                        break;
                    case '`NATIONFINANCE`':
                        $stmt->bindValue($identifier, $this->nationfinance, PDO::PARAM_INT);
                        break;
                    case '`OTHERFINANCE`':
                        $stmt->bindValue($identifier, $this->otherfinance, PDO::PARAM_INT);
                        break;
                    case '`FINANCEDETAIL`':
                        $stmt->bindValue($identifier, $this->financedetail, PDO::PARAM_STR);
                        break;
                    case '`FINANCEPROGRAM`':
                        $stmt->bindValue($identifier, $this->financeprogram, PDO::PARAM_STR);
                        break;
                    case '`CREATED_AT`':
                        $stmt->bindValue($identifier, $this->created_at, PDO::PARAM_STR);
                        break;
                    case '`UPDATED_AT`':
                        $stmt->bindValue($identifier, $this->updated_at, PDO::PARAM_STR);
                        break;
                    case '`DELETED_AT`':
                        $stmt->bindValue($identifier, $this->deleted_at, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aObjective !== null) {
                if (!$this->aObjective->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aObjective->getValidationFailures());
                }
            }

            if ($this->aPosition !== null) {
                if (!$this->aPosition->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aPosition->getValidationFailures());
                }
            }

            if ($this->aIndicator !== null) {
                if (!$this->aIndicator->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aIndicator->getValidationFailures());
                }
            }

            if ($this->aUser !== null) {
                if (!$this->aUser->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aUser->getValidationFailures());
                }
            }


            if (($retval = ProjectPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collConstructions !== null) {
                    foreach ($this->collConstructions as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collGuarantees !== null) {
                    foreach ($this->collGuarantees as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collAdministrativeActs !== null) {
                    foreach ($this->collAdministrativeActs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectRegions !== null) {
                    foreach ($this->collProjectRegions as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectMilestones !== null) {
                    foreach ($this->collProjectMilestones as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectIndicators !== null) {
                    foreach ($this->collProjectIndicators as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectActivitys !== null) {
                    foreach ($this->collProjectActivitys as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectDocuments !== null) {
                    foreach ($this->collProjectDocuments as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectContractors !== null) {
                    foreach ($this->collProjectContractors as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectLogs !== null) {
                    foreach ($this->collProjectLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectMilestoneLogs !== null) {
                    foreach ($this->collProjectMilestoneLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectActivityLogs !== null) {
                    foreach ($this->collProjectActivityLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ProjectPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getObjectiveid();
                break;
            case 2:
                return $this->getCode();
                break;
            case 3:
                return $this->getCodeaux();
                break;
            case 4:
                return $this->getName();
                break;
            case 5:
                return $this->getDescription();
                break;
            case 6:
                return $this->getImpact();
                break;
            case 7:
                return $this->getUniquegoal();
                break;
            case 8:
                return $this->getGoalexpirationdate();
                break;
            case 9:
                return $this->getDate();
                break;
            case 10:
                return $this->getBudget();
                break;
            case 11:
                return $this->getExchangerate();
                break;
            case 12:
                return $this->getVisibility();
                break;
            case 13:
                return $this->getCoordinateneed();
                break;
            case 14:
                return $this->getFrequency();
                break;
            case 15:
                return $this->getFinished();
                break;
            case 16:
                return $this->getNotes();
                break;
            case 17:
                return $this->getPostalcode();
                break;
            case 18:
                return $this->getUniquegoalnumeric();
                break;
            case 19:
                return $this->getGoalprogress();
                break;
            case 20:
                return $this->getLatitude();
                break;
            case 21:
                return $this->getLongitude();
                break;
            case 22:
                return $this->getOldid();
                break;
            case 23:
                return $this->getRegionid();
                break;
            case 24:
                return $this->getOldregionid();
                break;
            case 25:
                return $this->getLastmodification();
                break;
            case 26:
                return $this->getAddress();
                break;
            case 27:
                return $this->getStreet();
                break;
            case 28:
                return $this->getNumber();
                break;
            case 29:
                return $this->getPriority();
                break;
            case 30:
                return $this->getModifications();
                break;
            case 31:
                return $this->getPlannedstart();
                break;
            case 32:
                return $this->getPlannedend();
                break;
            case 33:
                return $this->getRealstart();
                break;
            case 34:
                return $this->getRealend();
                break;
            case 35:
                return $this->getCancelled();
                break;
            case 36:
                return $this->getIsconstruction();
                break;
            case 37:
                return $this->getRelevance();
                break;
            case 38:
                return $this->getUserid();
                break;
            case 39:
                return $this->getOrder();
                break;
            case 40:
                return $this->getWeight();
                break;
            case 41:
                return $this->getUpdated();
                break;
            case 42:
                return $this->getResponsiblecode();
                break;
            case 43:
                return $this->getIndicatorid();
                break;
            case 44:
                return $this->getPrimarysource();
                break;
            case 45:
                return $this->getAdditionalsource();
                break;
            case 46:
                return $this->getStartingyear();
                break;
            case 47:
                return $this->getEndingyear();
                break;
            case 48:
                return $this->getSubproject();
                break;
            case 49:
                return $this->getOngoing();
                break;
            case 50:
                return $this->getRelatedareas();
                break;
            case 51:
                return $this->getGoal();
                break;
            case 52:
                return $this->getLegal();
                break;
            case 53:
                return $this->getExecresp();
                break;
            case 54:
                return $this->getExectenure();
                break;
            case 55:
                return $this->getExecdependency();
                break;
            case 56:
                return $this->getExeccontact();
                break;
            case 57:
                return $this->getSubsecretary();
                break;
            case 58:
                return $this->getBudgetrequested();
                break;
            case 59:
                return $this->getBudgetsanctioned();
                break;
            case 60:
                return $this->getBelgrano();
                break;
            case 61:
                return $this->getClasification();
                break;
            case 62:
                return $this->getPress();
                break;
            case 63:
                return $this->getPriorityarea();
                break;
            case 64:
                return $this->getBeneficiario();
                break;
            case 65:
                return $this->getRequirecontractor();
                break;
            case 66:
                return $this->getPurchasetype();
                break;
            case 67:
                return $this->getConstructiontype();
                break;
            case 68:
                return $this->getRequireexraresources();
                break;
            case 69:
                return $this->getImplementationpartner();
                break;
            case 70:
                return $this->getRiskfactors();
                break;
            case 71:
                return $this->getOwnfinance();
                break;
            case 72:
                return $this->getProvincefinance();
                break;
            case 73:
                return $this->getNationfinance();
                break;
            case 74:
                return $this->getOtherfinance();
                break;
            case 75:
                return $this->getFinancedetail();
                break;
            case 76:
                return $this->getFinanceprogram();
                break;
            case 77:
                return $this->getCreatedAt();
                break;
            case 78:
                return $this->getUpdatedAt();
                break;
            case 79:
                return $this->getDeletedAt();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['Project'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Project'][$this->getPrimaryKey()] = true;
        $keys = ProjectPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getObjectiveid(),
            $keys[2] => $this->getCode(),
            $keys[3] => $this->getCodeaux(),
            $keys[4] => $this->getName(),
            $keys[5] => $this->getDescription(),
            $keys[6] => $this->getImpact(),
            $keys[7] => $this->getUniquegoal(),
            $keys[8] => $this->getGoalexpirationdate(),
            $keys[9] => $this->getDate(),
            $keys[10] => $this->getBudget(),
            $keys[11] => $this->getExchangerate(),
            $keys[12] => $this->getVisibility(),
            $keys[13] => $this->getCoordinateneed(),
            $keys[14] => $this->getFrequency(),
            $keys[15] => $this->getFinished(),
            $keys[16] => $this->getNotes(),
            $keys[17] => $this->getPostalcode(),
            $keys[18] => $this->getUniquegoalnumeric(),
            $keys[19] => $this->getGoalprogress(),
            $keys[20] => $this->getLatitude(),
            $keys[21] => $this->getLongitude(),
            $keys[22] => $this->getOldid(),
            $keys[23] => $this->getRegionid(),
            $keys[24] => $this->getOldregionid(),
            $keys[25] => $this->getLastmodification(),
            $keys[26] => $this->getAddress(),
            $keys[27] => $this->getStreet(),
            $keys[28] => $this->getNumber(),
            $keys[29] => $this->getPriority(),
            $keys[30] => $this->getModifications(),
            $keys[31] => $this->getPlannedstart(),
            $keys[32] => $this->getPlannedend(),
            $keys[33] => $this->getRealstart(),
            $keys[34] => $this->getRealend(),
            $keys[35] => $this->getCancelled(),
            $keys[36] => $this->getIsconstruction(),
            $keys[37] => $this->getRelevance(),
            $keys[38] => $this->getUserid(),
            $keys[39] => $this->getOrder(),
            $keys[40] => $this->getWeight(),
            $keys[41] => $this->getUpdated(),
            $keys[42] => $this->getResponsiblecode(),
            $keys[43] => $this->getIndicatorid(),
            $keys[44] => $this->getPrimarysource(),
            $keys[45] => $this->getAdditionalsource(),
            $keys[46] => $this->getStartingyear(),
            $keys[47] => $this->getEndingyear(),
            $keys[48] => $this->getSubproject(),
            $keys[49] => $this->getOngoing(),
            $keys[50] => $this->getRelatedareas(),
            $keys[51] => $this->getGoal(),
            $keys[52] => $this->getLegal(),
            $keys[53] => $this->getExecresp(),
            $keys[54] => $this->getExectenure(),
            $keys[55] => $this->getExecdependency(),
            $keys[56] => $this->getExeccontact(),
            $keys[57] => $this->getSubsecretary(),
            $keys[58] => $this->getBudgetrequested(),
            $keys[59] => $this->getBudgetsanctioned(),
            $keys[60] => $this->getBelgrano(),
            $keys[61] => $this->getClasification(),
            $keys[62] => $this->getPress(),
            $keys[63] => $this->getPriorityarea(),
            $keys[64] => $this->getBeneficiario(),
            $keys[65] => $this->getRequirecontractor(),
            $keys[66] => $this->getPurchasetype(),
            $keys[67] => $this->getConstructiontype(),
            $keys[68] => $this->getRequireexraresources(),
            $keys[69] => $this->getImplementationpartner(),
            $keys[70] => $this->getRiskfactors(),
            $keys[71] => $this->getOwnfinance(),
            $keys[72] => $this->getProvincefinance(),
            $keys[73] => $this->getNationfinance(),
            $keys[74] => $this->getOtherfinance(),
            $keys[75] => $this->getFinancedetail(),
            $keys[76] => $this->getFinanceprogram(),
            $keys[77] => $this->getCreatedAt(),
            $keys[78] => $this->getUpdatedAt(),
            $keys[79] => $this->getDeletedAt(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aObjective) {
                $result['Objective'] = $this->aObjective->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aPosition) {
                $result['Position'] = $this->aPosition->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aIndicator) {
                $result['Indicator'] = $this->aIndicator->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aUser) {
                $result['User'] = $this->aUser->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collConstructions) {
                $result['Constructions'] = $this->collConstructions->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collGuarantees) {
                $result['Guarantees'] = $this->collGuarantees->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collAdministrativeActs) {
                $result['AdministrativeActs'] = $this->collAdministrativeActs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectRegions) {
                $result['ProjectRegions'] = $this->collProjectRegions->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectMilestones) {
                $result['ProjectMilestones'] = $this->collProjectMilestones->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectIndicators) {
                $result['ProjectIndicators'] = $this->collProjectIndicators->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectActivitys) {
                $result['ProjectActivitys'] = $this->collProjectActivitys->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectDocuments) {
                $result['ProjectDocuments'] = $this->collProjectDocuments->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectContractors) {
                $result['ProjectContractors'] = $this->collProjectContractors->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectLogs) {
                $result['ProjectLogs'] = $this->collProjectLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectMilestoneLogs) {
                $result['ProjectMilestoneLogs'] = $this->collProjectMilestoneLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectActivityLogs) {
                $result['ProjectActivityLogs'] = $this->collProjectActivityLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ProjectPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setObjectiveid($value);
                break;
            case 2:
                $this->setCode($value);
                break;
            case 3:
                $this->setCodeaux($value);
                break;
            case 4:
                $this->setName($value);
                break;
            case 5:
                $this->setDescription($value);
                break;
            case 6:
                $this->setImpact($value);
                break;
            case 7:
                $this->setUniquegoal($value);
                break;
            case 8:
                $this->setGoalexpirationdate($value);
                break;
            case 9:
                $this->setDate($value);
                break;
            case 10:
                $this->setBudget($value);
                break;
            case 11:
                $this->setExchangerate($value);
                break;
            case 12:
                $this->setVisibility($value);
                break;
            case 13:
                $this->setCoordinateneed($value);
                break;
            case 14:
                $this->setFrequency($value);
                break;
            case 15:
                $this->setFinished($value);
                break;
            case 16:
                $this->setNotes($value);
                break;
            case 17:
                $this->setPostalcode($value);
                break;
            case 18:
                $this->setUniquegoalnumeric($value);
                break;
            case 19:
                $this->setGoalprogress($value);
                break;
            case 20:
                $this->setLatitude($value);
                break;
            case 21:
                $this->setLongitude($value);
                break;
            case 22:
                $this->setOldid($value);
                break;
            case 23:
                $this->setRegionid($value);
                break;
            case 24:
                $this->setOldregionid($value);
                break;
            case 25:
                $this->setLastmodification($value);
                break;
            case 26:
                $this->setAddress($value);
                break;
            case 27:
                $this->setStreet($value);
                break;
            case 28:
                $this->setNumber($value);
                break;
            case 29:
                $this->setPriority($value);
                break;
            case 30:
                $this->setModifications($value);
                break;
            case 31:
                $this->setPlannedstart($value);
                break;
            case 32:
                $this->setPlannedend($value);
                break;
            case 33:
                $this->setRealstart($value);
                break;
            case 34:
                $this->setRealend($value);
                break;
            case 35:
                $this->setCancelled($value);
                break;
            case 36:
                $this->setIsconstruction($value);
                break;
            case 37:
                $this->setRelevance($value);
                break;
            case 38:
                $this->setUserid($value);
                break;
            case 39:
                $this->setOrder($value);
                break;
            case 40:
                $this->setWeight($value);
                break;
            case 41:
                $this->setUpdated($value);
                break;
            case 42:
                $this->setResponsiblecode($value);
                break;
            case 43:
                $this->setIndicatorid($value);
                break;
            case 44:
                $this->setPrimarysource($value);
                break;
            case 45:
                $this->setAdditionalsource($value);
                break;
            case 46:
                $this->setStartingyear($value);
                break;
            case 47:
                $this->setEndingyear($value);
                break;
            case 48:
                $this->setSubproject($value);
                break;
            case 49:
                $this->setOngoing($value);
                break;
            case 50:
                $this->setRelatedareas($value);
                break;
            case 51:
                $this->setGoal($value);
                break;
            case 52:
                $this->setLegal($value);
                break;
            case 53:
                $this->setExecresp($value);
                break;
            case 54:
                $this->setExectenure($value);
                break;
            case 55:
                $this->setExecdependency($value);
                break;
            case 56:
                $this->setExeccontact($value);
                break;
            case 57:
                $this->setSubsecretary($value);
                break;
            case 58:
                $this->setBudgetrequested($value);
                break;
            case 59:
                $this->setBudgetsanctioned($value);
                break;
            case 60:
                $this->setBelgrano($value);
                break;
            case 61:
                $this->setClasification($value);
                break;
            case 62:
                $this->setPress($value);
                break;
            case 63:
                $this->setPriorityarea($value);
                break;
            case 64:
                $this->setBeneficiario($value);
                break;
            case 65:
                $this->setRequirecontractor($value);
                break;
            case 66:
                $this->setPurchasetype($value);
                break;
            case 67:
                $this->setConstructiontype($value);
                break;
            case 68:
                $this->setRequireexraresources($value);
                break;
            case 69:
                $this->setImplementationpartner($value);
                break;
            case 70:
                $this->setRiskfactors($value);
                break;
            case 71:
                $this->setOwnfinance($value);
                break;
            case 72:
                $this->setProvincefinance($value);
                break;
            case 73:
                $this->setNationfinance($value);
                break;
            case 74:
                $this->setOtherfinance($value);
                break;
            case 75:
                $this->setFinancedetail($value);
                break;
            case 76:
                $this->setFinanceprogram($value);
                break;
            case 77:
                $this->setCreatedAt($value);
                break;
            case 78:
                $this->setUpdatedAt($value);
                break;
            case 79:
                $this->setDeletedAt($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = ProjectPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setObjectiveid($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setCode($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setCodeaux($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setName($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setDescription($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setImpact($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setUniquegoal($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setGoalexpirationdate($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setDate($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setBudget($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setExchangerate($arr[$keys[11]]);
        if (array_key_exists($keys[12], $arr)) $this->setVisibility($arr[$keys[12]]);
        if (array_key_exists($keys[13], $arr)) $this->setCoordinateneed($arr[$keys[13]]);
        if (array_key_exists($keys[14], $arr)) $this->setFrequency($arr[$keys[14]]);
        if (array_key_exists($keys[15], $arr)) $this->setFinished($arr[$keys[15]]);
        if (array_key_exists($keys[16], $arr)) $this->setNotes($arr[$keys[16]]);
        if (array_key_exists($keys[17], $arr)) $this->setPostalcode($arr[$keys[17]]);
        if (array_key_exists($keys[18], $arr)) $this->setUniquegoalnumeric($arr[$keys[18]]);
        if (array_key_exists($keys[19], $arr)) $this->setGoalprogress($arr[$keys[19]]);
        if (array_key_exists($keys[20], $arr)) $this->setLatitude($arr[$keys[20]]);
        if (array_key_exists($keys[21], $arr)) $this->setLongitude($arr[$keys[21]]);
        if (array_key_exists($keys[22], $arr)) $this->setOldid($arr[$keys[22]]);
        if (array_key_exists($keys[23], $arr)) $this->setRegionid($arr[$keys[23]]);
        if (array_key_exists($keys[24], $arr)) $this->setOldregionid($arr[$keys[24]]);
        if (array_key_exists($keys[25], $arr)) $this->setLastmodification($arr[$keys[25]]);
        if (array_key_exists($keys[26], $arr)) $this->setAddress($arr[$keys[26]]);
        if (array_key_exists($keys[27], $arr)) $this->setStreet($arr[$keys[27]]);
        if (array_key_exists($keys[28], $arr)) $this->setNumber($arr[$keys[28]]);
        if (array_key_exists($keys[29], $arr)) $this->setPriority($arr[$keys[29]]);
        if (array_key_exists($keys[30], $arr)) $this->setModifications($arr[$keys[30]]);
        if (array_key_exists($keys[31], $arr)) $this->setPlannedstart($arr[$keys[31]]);
        if (array_key_exists($keys[32], $arr)) $this->setPlannedend($arr[$keys[32]]);
        if (array_key_exists($keys[33], $arr)) $this->setRealstart($arr[$keys[33]]);
        if (array_key_exists($keys[34], $arr)) $this->setRealend($arr[$keys[34]]);
        if (array_key_exists($keys[35], $arr)) $this->setCancelled($arr[$keys[35]]);
        if (array_key_exists($keys[36], $arr)) $this->setIsconstruction($arr[$keys[36]]);
        if (array_key_exists($keys[37], $arr)) $this->setRelevance($arr[$keys[37]]);
        if (array_key_exists($keys[38], $arr)) $this->setUserid($arr[$keys[38]]);
        if (array_key_exists($keys[39], $arr)) $this->setOrder($arr[$keys[39]]);
        if (array_key_exists($keys[40], $arr)) $this->setWeight($arr[$keys[40]]);
        if (array_key_exists($keys[41], $arr)) $this->setUpdated($arr[$keys[41]]);
        if (array_key_exists($keys[42], $arr)) $this->setResponsiblecode($arr[$keys[42]]);
        if (array_key_exists($keys[43], $arr)) $this->setIndicatorid($arr[$keys[43]]);
        if (array_key_exists($keys[44], $arr)) $this->setPrimarysource($arr[$keys[44]]);
        if (array_key_exists($keys[45], $arr)) $this->setAdditionalsource($arr[$keys[45]]);
        if (array_key_exists($keys[46], $arr)) $this->setStartingyear($arr[$keys[46]]);
        if (array_key_exists($keys[47], $arr)) $this->setEndingyear($arr[$keys[47]]);
        if (array_key_exists($keys[48], $arr)) $this->setSubproject($arr[$keys[48]]);
        if (array_key_exists($keys[49], $arr)) $this->setOngoing($arr[$keys[49]]);
        if (array_key_exists($keys[50], $arr)) $this->setRelatedareas($arr[$keys[50]]);
        if (array_key_exists($keys[51], $arr)) $this->setGoal($arr[$keys[51]]);
        if (array_key_exists($keys[52], $arr)) $this->setLegal($arr[$keys[52]]);
        if (array_key_exists($keys[53], $arr)) $this->setExecresp($arr[$keys[53]]);
        if (array_key_exists($keys[54], $arr)) $this->setExectenure($arr[$keys[54]]);
        if (array_key_exists($keys[55], $arr)) $this->setExecdependency($arr[$keys[55]]);
        if (array_key_exists($keys[56], $arr)) $this->setExeccontact($arr[$keys[56]]);
        if (array_key_exists($keys[57], $arr)) $this->setSubsecretary($arr[$keys[57]]);
        if (array_key_exists($keys[58], $arr)) $this->setBudgetrequested($arr[$keys[58]]);
        if (array_key_exists($keys[59], $arr)) $this->setBudgetsanctioned($arr[$keys[59]]);
        if (array_key_exists($keys[60], $arr)) $this->setBelgrano($arr[$keys[60]]);
        if (array_key_exists($keys[61], $arr)) $this->setClasification($arr[$keys[61]]);
        if (array_key_exists($keys[62], $arr)) $this->setPress($arr[$keys[62]]);
        if (array_key_exists($keys[63], $arr)) $this->setPriorityarea($arr[$keys[63]]);
        if (array_key_exists($keys[64], $arr)) $this->setBeneficiario($arr[$keys[64]]);
        if (array_key_exists($keys[65], $arr)) $this->setRequirecontractor($arr[$keys[65]]);
        if (array_key_exists($keys[66], $arr)) $this->setPurchasetype($arr[$keys[66]]);
        if (array_key_exists($keys[67], $arr)) $this->setConstructiontype($arr[$keys[67]]);
        if (array_key_exists($keys[68], $arr)) $this->setRequireexraresources($arr[$keys[68]]);
        if (array_key_exists($keys[69], $arr)) $this->setImplementationpartner($arr[$keys[69]]);
        if (array_key_exists($keys[70], $arr)) $this->setRiskfactors($arr[$keys[70]]);
        if (array_key_exists($keys[71], $arr)) $this->setOwnfinance($arr[$keys[71]]);
        if (array_key_exists($keys[72], $arr)) $this->setProvincefinance($arr[$keys[72]]);
        if (array_key_exists($keys[73], $arr)) $this->setNationfinance($arr[$keys[73]]);
        if (array_key_exists($keys[74], $arr)) $this->setOtherfinance($arr[$keys[74]]);
        if (array_key_exists($keys[75], $arr)) $this->setFinancedetail($arr[$keys[75]]);
        if (array_key_exists($keys[76], $arr)) $this->setFinanceprogram($arr[$keys[76]]);
        if (array_key_exists($keys[77], $arr)) $this->setCreatedAt($arr[$keys[77]]);
        if (array_key_exists($keys[78], $arr)) $this->setUpdatedAt($arr[$keys[78]]);
        if (array_key_exists($keys[79], $arr)) $this->setDeletedAt($arr[$keys[79]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(ProjectPeer::DATABASE_NAME);

        if ($this->isColumnModified(ProjectPeer::ID)) $criteria->add(ProjectPeer::ID, $this->id);
        if ($this->isColumnModified(ProjectPeer::OBJECTIVEID)) $criteria->add(ProjectPeer::OBJECTIVEID, $this->objectiveid);
        if ($this->isColumnModified(ProjectPeer::CODE)) $criteria->add(ProjectPeer::CODE, $this->code);
        if ($this->isColumnModified(ProjectPeer::CODEAUX)) $criteria->add(ProjectPeer::CODEAUX, $this->codeaux);
        if ($this->isColumnModified(ProjectPeer::NAME)) $criteria->add(ProjectPeer::NAME, $this->name);
        if ($this->isColumnModified(ProjectPeer::DESCRIPTION)) $criteria->add(ProjectPeer::DESCRIPTION, $this->description);
        if ($this->isColumnModified(ProjectPeer::IMPACT)) $criteria->add(ProjectPeer::IMPACT, $this->impact);
        if ($this->isColumnModified(ProjectPeer::UNIQUEGOAL)) $criteria->add(ProjectPeer::UNIQUEGOAL, $this->uniquegoal);
        if ($this->isColumnModified(ProjectPeer::GOALEXPIRATIONDATE)) $criteria->add(ProjectPeer::GOALEXPIRATIONDATE, $this->goalexpirationdate);
        if ($this->isColumnModified(ProjectPeer::DATE)) $criteria->add(ProjectPeer::DATE, $this->date);
        if ($this->isColumnModified(ProjectPeer::BUDGET)) $criteria->add(ProjectPeer::BUDGET, $this->budget);
        if ($this->isColumnModified(ProjectPeer::EXCHANGERATE)) $criteria->add(ProjectPeer::EXCHANGERATE, $this->exchangerate);
        if ($this->isColumnModified(ProjectPeer::VISIBILITY)) $criteria->add(ProjectPeer::VISIBILITY, $this->visibility);
        if ($this->isColumnModified(ProjectPeer::COORDINATENEED)) $criteria->add(ProjectPeer::COORDINATENEED, $this->coordinateneed);
        if ($this->isColumnModified(ProjectPeer::FREQUENCY)) $criteria->add(ProjectPeer::FREQUENCY, $this->frequency);
        if ($this->isColumnModified(ProjectPeer::FINISHED)) $criteria->add(ProjectPeer::FINISHED, $this->finished);
        if ($this->isColumnModified(ProjectPeer::NOTES)) $criteria->add(ProjectPeer::NOTES, $this->notes);
        if ($this->isColumnModified(ProjectPeer::POSTALCODE)) $criteria->add(ProjectPeer::POSTALCODE, $this->postalcode);
        if ($this->isColumnModified(ProjectPeer::UNIQUEGOALNUMERIC)) $criteria->add(ProjectPeer::UNIQUEGOALNUMERIC, $this->uniquegoalnumeric);
        if ($this->isColumnModified(ProjectPeer::GOALPROGRESS)) $criteria->add(ProjectPeer::GOALPROGRESS, $this->goalprogress);
        if ($this->isColumnModified(ProjectPeer::LATITUDE)) $criteria->add(ProjectPeer::LATITUDE, $this->latitude);
        if ($this->isColumnModified(ProjectPeer::LONGITUDE)) $criteria->add(ProjectPeer::LONGITUDE, $this->longitude);
        if ($this->isColumnModified(ProjectPeer::OLDID)) $criteria->add(ProjectPeer::OLDID, $this->oldid);
        if ($this->isColumnModified(ProjectPeer::REGIONID)) $criteria->add(ProjectPeer::REGIONID, $this->regionid);
        if ($this->isColumnModified(ProjectPeer::OLDREGIONID)) $criteria->add(ProjectPeer::OLDREGIONID, $this->oldregionid);
        if ($this->isColumnModified(ProjectPeer::LASTMODIFICATION)) $criteria->add(ProjectPeer::LASTMODIFICATION, $this->lastmodification);
        if ($this->isColumnModified(ProjectPeer::ADDRESS)) $criteria->add(ProjectPeer::ADDRESS, $this->address);
        if ($this->isColumnModified(ProjectPeer::STREET)) $criteria->add(ProjectPeer::STREET, $this->street);
        if ($this->isColumnModified(ProjectPeer::NUMBER)) $criteria->add(ProjectPeer::NUMBER, $this->number);
        if ($this->isColumnModified(ProjectPeer::PRIORITY)) $criteria->add(ProjectPeer::PRIORITY, $this->priority);
        if ($this->isColumnModified(ProjectPeer::MODIFICATIONS)) $criteria->add(ProjectPeer::MODIFICATIONS, $this->modifications);
        if ($this->isColumnModified(ProjectPeer::PLANNEDSTART)) $criteria->add(ProjectPeer::PLANNEDSTART, $this->plannedstart);
        if ($this->isColumnModified(ProjectPeer::PLANNEDEND)) $criteria->add(ProjectPeer::PLANNEDEND, $this->plannedend);
        if ($this->isColumnModified(ProjectPeer::REALSTART)) $criteria->add(ProjectPeer::REALSTART, $this->realstart);
        if ($this->isColumnModified(ProjectPeer::REALEND)) $criteria->add(ProjectPeer::REALEND, $this->realend);
        if ($this->isColumnModified(ProjectPeer::CANCELLED)) $criteria->add(ProjectPeer::CANCELLED, $this->cancelled);
        if ($this->isColumnModified(ProjectPeer::ISCONSTRUCTION)) $criteria->add(ProjectPeer::ISCONSTRUCTION, $this->isconstruction);
        if ($this->isColumnModified(ProjectPeer::RELEVANCE)) $criteria->add(ProjectPeer::RELEVANCE, $this->relevance);
        if ($this->isColumnModified(ProjectPeer::USERID)) $criteria->add(ProjectPeer::USERID, $this->userid);
        if ($this->isColumnModified(ProjectPeer::ORDER)) $criteria->add(ProjectPeer::ORDER, $this->order);
        if ($this->isColumnModified(ProjectPeer::WEIGHT)) $criteria->add(ProjectPeer::WEIGHT, $this->weight);
        if ($this->isColumnModified(ProjectPeer::UPDATED)) $criteria->add(ProjectPeer::UPDATED, $this->updated);
        if ($this->isColumnModified(ProjectPeer::RESPONSIBLECODE)) $criteria->add(ProjectPeer::RESPONSIBLECODE, $this->responsiblecode);
        if ($this->isColumnModified(ProjectPeer::INDICATORID)) $criteria->add(ProjectPeer::INDICATORID, $this->indicatorid);
        if ($this->isColumnModified(ProjectPeer::PRIMARYSOURCE)) $criteria->add(ProjectPeer::PRIMARYSOURCE, $this->primarysource);
        if ($this->isColumnModified(ProjectPeer::ADDITIONALSOURCE)) $criteria->add(ProjectPeer::ADDITIONALSOURCE, $this->additionalsource);
        if ($this->isColumnModified(ProjectPeer::STARTINGYEAR)) $criteria->add(ProjectPeer::STARTINGYEAR, $this->startingyear);
        if ($this->isColumnModified(ProjectPeer::ENDINGYEAR)) $criteria->add(ProjectPeer::ENDINGYEAR, $this->endingyear);
        if ($this->isColumnModified(ProjectPeer::SUBPROJECT)) $criteria->add(ProjectPeer::SUBPROJECT, $this->subproject);
        if ($this->isColumnModified(ProjectPeer::ONGOING)) $criteria->add(ProjectPeer::ONGOING, $this->ongoing);
        if ($this->isColumnModified(ProjectPeer::RELATEDAREAS)) $criteria->add(ProjectPeer::RELATEDAREAS, $this->relatedareas);
        if ($this->isColumnModified(ProjectPeer::GOAL)) $criteria->add(ProjectPeer::GOAL, $this->goal);
        if ($this->isColumnModified(ProjectPeer::LEGAL)) $criteria->add(ProjectPeer::LEGAL, $this->legal);
        if ($this->isColumnModified(ProjectPeer::EXECRESP)) $criteria->add(ProjectPeer::EXECRESP, $this->execresp);
        if ($this->isColumnModified(ProjectPeer::EXECTENURE)) $criteria->add(ProjectPeer::EXECTENURE, $this->exectenure);
        if ($this->isColumnModified(ProjectPeer::EXECDEPENDENCY)) $criteria->add(ProjectPeer::EXECDEPENDENCY, $this->execdependency);
        if ($this->isColumnModified(ProjectPeer::EXECCONTACT)) $criteria->add(ProjectPeer::EXECCONTACT, $this->execcontact);
        if ($this->isColumnModified(ProjectPeer::SUBSECRETARY)) $criteria->add(ProjectPeer::SUBSECRETARY, $this->subsecretary);
        if ($this->isColumnModified(ProjectPeer::BUDGETREQUESTED)) $criteria->add(ProjectPeer::BUDGETREQUESTED, $this->budgetrequested);
        if ($this->isColumnModified(ProjectPeer::BUDGETSANCTIONED)) $criteria->add(ProjectPeer::BUDGETSANCTIONED, $this->budgetsanctioned);
        if ($this->isColumnModified(ProjectPeer::BELGRANO)) $criteria->add(ProjectPeer::BELGRANO, $this->belgrano);
        if ($this->isColumnModified(ProjectPeer::CLASIFICATION)) $criteria->add(ProjectPeer::CLASIFICATION, $this->clasification);
        if ($this->isColumnModified(ProjectPeer::PRESS)) $criteria->add(ProjectPeer::PRESS, $this->press);
        if ($this->isColumnModified(ProjectPeer::PRIORITYAREA)) $criteria->add(ProjectPeer::PRIORITYAREA, $this->priorityarea);
        if ($this->isColumnModified(ProjectPeer::BENEFICIARIO)) $criteria->add(ProjectPeer::BENEFICIARIO, $this->beneficiario);
        if ($this->isColumnModified(ProjectPeer::REQUIRECONTRACTOR)) $criteria->add(ProjectPeer::REQUIRECONTRACTOR, $this->requirecontractor);
        if ($this->isColumnModified(ProjectPeer::PURCHASETYPE)) $criteria->add(ProjectPeer::PURCHASETYPE, $this->purchasetype);
        if ($this->isColumnModified(ProjectPeer::CONSTRUCTIONTYPE)) $criteria->add(ProjectPeer::CONSTRUCTIONTYPE, $this->constructiontype);
        if ($this->isColumnModified(ProjectPeer::REQUIREEXRARESOURCES)) $criteria->add(ProjectPeer::REQUIREEXRARESOURCES, $this->requireexraresources);
        if ($this->isColumnModified(ProjectPeer::IMPLEMENTATIONPARTNER)) $criteria->add(ProjectPeer::IMPLEMENTATIONPARTNER, $this->implementationpartner);
        if ($this->isColumnModified(ProjectPeer::RISKFACTORS)) $criteria->add(ProjectPeer::RISKFACTORS, $this->riskfactors);
        if ($this->isColumnModified(ProjectPeer::OWNFINANCE)) $criteria->add(ProjectPeer::OWNFINANCE, $this->ownfinance);
        if ($this->isColumnModified(ProjectPeer::PROVINCEFINANCE)) $criteria->add(ProjectPeer::PROVINCEFINANCE, $this->provincefinance);
        if ($this->isColumnModified(ProjectPeer::NATIONFINANCE)) $criteria->add(ProjectPeer::NATIONFINANCE, $this->nationfinance);
        if ($this->isColumnModified(ProjectPeer::OTHERFINANCE)) $criteria->add(ProjectPeer::OTHERFINANCE, $this->otherfinance);
        if ($this->isColumnModified(ProjectPeer::FINANCEDETAIL)) $criteria->add(ProjectPeer::FINANCEDETAIL, $this->financedetail);
        if ($this->isColumnModified(ProjectPeer::FINANCEPROGRAM)) $criteria->add(ProjectPeer::FINANCEPROGRAM, $this->financeprogram);
        if ($this->isColumnModified(ProjectPeer::CREATED_AT)) $criteria->add(ProjectPeer::CREATED_AT, $this->created_at);
        if ($this->isColumnModified(ProjectPeer::UPDATED_AT)) $criteria->add(ProjectPeer::UPDATED_AT, $this->updated_at);
        if ($this->isColumnModified(ProjectPeer::DELETED_AT)) $criteria->add(ProjectPeer::DELETED_AT, $this->deleted_at);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(ProjectPeer::DATABASE_NAME);
        $criteria->add(ProjectPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of Project (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setObjectiveid($this->getObjectiveid());
        $copyObj->setCode($this->getCode());
        $copyObj->setCodeaux($this->getCodeaux());
        $copyObj->setName($this->getName());
        $copyObj->setDescription($this->getDescription());
        $copyObj->setImpact($this->getImpact());
        $copyObj->setUniquegoal($this->getUniquegoal());
        $copyObj->setGoalexpirationdate($this->getGoalexpirationdate());
        $copyObj->setDate($this->getDate());
        $copyObj->setBudget($this->getBudget());
        $copyObj->setExchangerate($this->getExchangerate());
        $copyObj->setVisibility($this->getVisibility());
        $copyObj->setCoordinateneed($this->getCoordinateneed());
        $copyObj->setFrequency($this->getFrequency());
        $copyObj->setFinished($this->getFinished());
        $copyObj->setNotes($this->getNotes());
        $copyObj->setPostalcode($this->getPostalcode());
        $copyObj->setUniquegoalnumeric($this->getUniquegoalnumeric());
        $copyObj->setGoalprogress($this->getGoalprogress());
        $copyObj->setLatitude($this->getLatitude());
        $copyObj->setLongitude($this->getLongitude());
        $copyObj->setOldid($this->getOldid());
        $copyObj->setRegionid($this->getRegionid());
        $copyObj->setOldregionid($this->getOldregionid());
        $copyObj->setLastmodification($this->getLastmodification());
        $copyObj->setAddress($this->getAddress());
        $copyObj->setStreet($this->getStreet());
        $copyObj->setNumber($this->getNumber());
        $copyObj->setPriority($this->getPriority());
        $copyObj->setModifications($this->getModifications());
        $copyObj->setPlannedstart($this->getPlannedstart());
        $copyObj->setPlannedend($this->getPlannedend());
        $copyObj->setRealstart($this->getRealstart());
        $copyObj->setRealend($this->getRealend());
        $copyObj->setCancelled($this->getCancelled());
        $copyObj->setIsconstruction($this->getIsconstruction());
        $copyObj->setRelevance($this->getRelevance());
        $copyObj->setUserid($this->getUserid());
        $copyObj->setOrder($this->getOrder());
        $copyObj->setWeight($this->getWeight());
        $copyObj->setUpdated($this->getUpdated());
        $copyObj->setResponsiblecode($this->getResponsiblecode());
        $copyObj->setIndicatorid($this->getIndicatorid());
        $copyObj->setPrimarysource($this->getPrimarysource());
        $copyObj->setAdditionalsource($this->getAdditionalsource());
        $copyObj->setStartingyear($this->getStartingyear());
        $copyObj->setEndingyear($this->getEndingyear());
        $copyObj->setSubproject($this->getSubproject());
        $copyObj->setOngoing($this->getOngoing());
        $copyObj->setRelatedareas($this->getRelatedareas());
        $copyObj->setGoal($this->getGoal());
        $copyObj->setLegal($this->getLegal());
        $copyObj->setExecresp($this->getExecresp());
        $copyObj->setExectenure($this->getExectenure());
        $copyObj->setExecdependency($this->getExecdependency());
        $copyObj->setExeccontact($this->getExeccontact());
        $copyObj->setSubsecretary($this->getSubsecretary());
        $copyObj->setBudgetrequested($this->getBudgetrequested());
        $copyObj->setBudgetsanctioned($this->getBudgetsanctioned());
        $copyObj->setBelgrano($this->getBelgrano());
        $copyObj->setClasification($this->getClasification());
        $copyObj->setPress($this->getPress());
        $copyObj->setPriorityarea($this->getPriorityarea());
        $copyObj->setBeneficiario($this->getBeneficiario());
        $copyObj->setRequirecontractor($this->getRequirecontractor());
        $copyObj->setPurchasetype($this->getPurchasetype());
        $copyObj->setConstructiontype($this->getConstructiontype());
        $copyObj->setRequireexraresources($this->getRequireexraresources());
        $copyObj->setImplementationpartner($this->getImplementationpartner());
        $copyObj->setRiskfactors($this->getRiskfactors());
        $copyObj->setOwnfinance($this->getOwnfinance());
        $copyObj->setProvincefinance($this->getProvincefinance());
        $copyObj->setNationfinance($this->getNationfinance());
        $copyObj->setOtherfinance($this->getOtherfinance());
        $copyObj->setFinancedetail($this->getFinancedetail());
        $copyObj->setFinanceprogram($this->getFinanceprogram());
        $copyObj->setCreatedAt($this->getCreatedAt());
        $copyObj->setUpdatedAt($this->getUpdatedAt());
        $copyObj->setDeletedAt($this->getDeletedAt());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getConstructions() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addConstruction($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getGuarantees() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addGuarantee($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getAdministrativeActs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addAdministrativeAct($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectRegions() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectRegion($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectMilestones() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectMilestone($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectIndicators() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectIndicator($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectActivitys() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectActivity($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectDocuments() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectDocument($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectContractors() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectContractor($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectLog($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectMilestoneLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectMilestoneLog($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectActivityLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectActivityLog($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return Project Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return ProjectPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new ProjectPeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a Objective object.
     *
     * @param             Objective $v
     * @return Project The current object (for fluent API support)
     * @throws PropelException
     */
    public function setObjective(Objective $v = null)
    {
        if ($v === null) {
            $this->setObjectiveid(NULL);
        } else {
            $this->setObjectiveid($v->getId());
        }

        $this->aObjective = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Objective object, it will not be re-added.
        if ($v !== null) {
            $v->addProject($this);
        }


        return $this;
    }


    /**
     * Get the associated Objective object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Objective The associated Objective object.
     * @throws PropelException
     */
    public function getObjective(PropelPDO $con = null)
    {
        if ($this->aObjective === null && ($this->objectiveid !== null)) {
            $this->aObjective = ObjectiveQuery::create()->findPk($this->objectiveid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aObjective->addProjects($this);
             */
        }

        return $this->aObjective;
    }

    /**
     * Declares an association between this object and a Position object.
     *
     * @param             Position $v
     * @return Project The current object (for fluent API support)
     * @throws PropelException
     */
    public function setPosition(Position $v = null)
    {
        if ($v === null) {
            $this->setResponsiblecode(NULL);
        } else {
            $this->setResponsiblecode($v->getCode());
        }

        $this->aPosition = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Position object, it will not be re-added.
        if ($v !== null) {
            $v->addProject($this);
        }


        return $this;
    }


    /**
     * Get the associated Position object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Position The associated Position object.
     * @throws PropelException
     */
    public function getPosition(PropelPDO $con = null)
    {
        if ($this->aPosition === null && ($this->responsiblecode !== null)) {
            $this->aPosition = PositionQuery::create()
                ->filterByProject($this) // here
                ->findOne($con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aPosition->addProjects($this);
             */
        }

        return $this->aPosition;
    }

    /**
     * Declares an association between this object and a Indicator object.
     *
     * @param             Indicator $v
     * @return Project The current object (for fluent API support)
     * @throws PropelException
     */
    public function setIndicator(Indicator $v = null)
    {
        if ($v === null) {
            $this->setIndicatorid(NULL);
        } else {
            $this->setIndicatorid($v->getId());
        }

        $this->aIndicator = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Indicator object, it will not be re-added.
        if ($v !== null) {
            $v->addProject($this);
        }


        return $this;
    }


    /**
     * Get the associated Indicator object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Indicator The associated Indicator object.
     * @throws PropelException
     */
    public function getIndicator(PropelPDO $con = null)
    {
        if ($this->aIndicator === null && ($this->indicatorid !== null)) {
            $this->aIndicator = IndicatorQuery::create()->findPk($this->indicatorid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aIndicator->addProjects($this);
             */
        }

        return $this->aIndicator;
    }

    /**
     * Declares an association between this object and a User object.
     *
     * @param             User $v
     * @return Project The current object (for fluent API support)
     * @throws PropelException
     */
    public function setUser(User $v = null)
    {
        if ($v === null) {
            $this->setUserid(NULL);
        } else {
            $this->setUserid($v->getId());
        }

        $this->aUser = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the User object, it will not be re-added.
        if ($v !== null) {
            $v->addProject($this);
        }


        return $this;
    }


    /**
     * Get the associated User object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return User The associated User object.
     * @throws PropelException
     */
    public function getUser(PropelPDO $con = null)
    {
        if ($this->aUser === null && ($this->userid !== null)) {
            $this->aUser = UserQuery::create()->findPk($this->userid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aUser->addProjects($this);
             */
        }

        return $this->aUser;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('Construction' == $relationName) {
            $this->initConstructions();
        }
        if ('Guarantee' == $relationName) {
            $this->initGuarantees();
        }
        if ('AdministrativeAct' == $relationName) {
            $this->initAdministrativeActs();
        }
        if ('ProjectRegion' == $relationName) {
            $this->initProjectRegions();
        }
        if ('ProjectMilestone' == $relationName) {
            $this->initProjectMilestones();
        }
        if ('ProjectIndicator' == $relationName) {
            $this->initProjectIndicators();
        }
        if ('ProjectActivity' == $relationName) {
            $this->initProjectActivitys();
        }
        if ('ProjectDocument' == $relationName) {
            $this->initProjectDocuments();
        }
        if ('ProjectContractor' == $relationName) {
            $this->initProjectContractors();
        }
        if ('ProjectLog' == $relationName) {
            $this->initProjectLogs();
        }
        if ('ProjectMilestoneLog' == $relationName) {
            $this->initProjectMilestoneLogs();
        }
        if ('ProjectActivityLog' == $relationName) {
            $this->initProjectActivityLogs();
        }
    }

    /**
     * Clears out the collConstructions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addConstructions()
     */
    public function clearConstructions()
    {
        $this->collConstructions = null; // important to set this to null since that means it is uninitialized
        $this->collConstructionsPartial = null;
    }

    /**
     * reset is the collConstructions collection loaded partially
     *
     * @return void
     */
    public function resetPartialConstructions($v = true)
    {
        $this->collConstructionsPartial = $v;
    }

    /**
     * Initializes the collConstructions collection.
     *
     * By default this just sets the collConstructions collection to an empty array (like clearcollConstructions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initConstructions($overrideExisting = true)
    {
        if (null !== $this->collConstructions && !$overrideExisting) {
            return;
        }
        $this->collConstructions = new PropelObjectCollection();
        $this->collConstructions->setModel('Construction');
    }

    /**
     * Gets an array of Construction objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Project is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Construction[] List of Construction objects
     * @throws PropelException
     */
    public function getConstructions($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collConstructionsPartial && !$this->isNew();
        if (null === $this->collConstructions || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collConstructions) {
                // return empty collection
                $this->initConstructions();
            } else {
                $collConstructions = ConstructionQuery::create(null, $criteria)
                    ->filterByProject($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collConstructionsPartial && count($collConstructions)) {
                      $this->initConstructions(false);

                      foreach($collConstructions as $obj) {
                        if (false == $this->collConstructions->contains($obj)) {
                          $this->collConstructions->append($obj);
                        }
                      }

                      $this->collConstructionsPartial = true;
                    }

                    return $collConstructions;
                }

                if($partial && $this->collConstructions) {
                    foreach($this->collConstructions as $obj) {
                        if($obj->isNew()) {
                            $collConstructions[] = $obj;
                        }
                    }
                }

                $this->collConstructions = $collConstructions;
                $this->collConstructionsPartial = false;
            }
        }

        return $this->collConstructions;
    }

    /**
     * Sets a collection of Construction objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $constructions A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setConstructions(PropelCollection $constructions, PropelPDO $con = null)
    {
        $this->constructionsScheduledForDeletion = $this->getConstructions(new Criteria(), $con)->diff($constructions);

        foreach ($this->constructionsScheduledForDeletion as $constructionRemoved) {
            $constructionRemoved->setProject(null);
        }

        $this->collConstructions = null;
        foreach ($constructions as $construction) {
            $this->addConstruction($construction);
        }

        $this->collConstructions = $constructions;
        $this->collConstructionsPartial = false;
    }

    /**
     * Returns the number of related Construction objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Construction objects.
     * @throws PropelException
     */
    public function countConstructions(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collConstructionsPartial && !$this->isNew();
        if (null === $this->collConstructions || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collConstructions) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getConstructions());
                }
                $query = ConstructionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProject($this)
                    ->count($con);
            }
        } else {
            return count($this->collConstructions);
        }
    }

    /**
     * Method called to associate a Construction object to this object
     * through the Construction foreign key attribute.
     *
     * @param    Construction $l Construction
     * @return Project The current object (for fluent API support)
     */
    public function addConstruction(Construction $l)
    {
        if ($this->collConstructions === null) {
            $this->initConstructions();
            $this->collConstructionsPartial = true;
        }
        if (!$this->collConstructions->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddConstruction($l);
        }

        return $this;
    }

    /**
     * @param	Construction $construction The construction object to add.
     */
    protected function doAddConstruction($construction)
    {
        $this->collConstructions[]= $construction;
        $construction->setProject($this);
    }

    /**
     * @param	Construction $construction The construction object to remove.
     */
    public function removeConstruction($construction)
    {
        if ($this->getConstructions()->contains($construction)) {
            $this->collConstructions->remove($this->collConstructions->search($construction));
            if (null === $this->constructionsScheduledForDeletion) {
                $this->constructionsScheduledForDeletion = clone $this->collConstructions;
                $this->constructionsScheduledForDeletion->clear();
            }
            $this->constructionsScheduledForDeletion[]= $construction;
            $construction->setProject(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Project is new, it will return
     * an empty collection; or if this Project has previously
     * been saved, it will retrieve related Constructions from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Project.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Construction[] List of Construction objects
     */
    public function getConstructionsJoinCategory($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ConstructionQuery::create(null, $criteria);
        $query->joinWith('Category', $join_behavior);

        return $this->getConstructions($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Project is new, it will return
     * an empty collection; or if this Project has previously
     * been saved, it will retrieve related Constructions from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Project.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Construction[] List of Construction objects
     */
    public function getConstructionsJoinRegion($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ConstructionQuery::create(null, $criteria);
        $query->joinWith('Region', $join_behavior);

        return $this->getConstructions($query, $con);
    }

    /**
     * Clears out the collGuarantees collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addGuarantees()
     */
    public function clearGuarantees()
    {
        $this->collGuarantees = null; // important to set this to null since that means it is uninitialized
        $this->collGuaranteesPartial = null;
    }

    /**
     * reset is the collGuarantees collection loaded partially
     *
     * @return void
     */
    public function resetPartialGuarantees($v = true)
    {
        $this->collGuaranteesPartial = $v;
    }

    /**
     * Initializes the collGuarantees collection.
     *
     * By default this just sets the collGuarantees collection to an empty array (like clearcollGuarantees());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initGuarantees($overrideExisting = true)
    {
        if (null !== $this->collGuarantees && !$overrideExisting) {
            return;
        }
        $this->collGuarantees = new PropelObjectCollection();
        $this->collGuarantees->setModel('Guarantee');
    }

    /**
     * Gets an array of Guarantee objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Project is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Guarantee[] List of Guarantee objects
     * @throws PropelException
     */
    public function getGuarantees($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collGuaranteesPartial && !$this->isNew();
        if (null === $this->collGuarantees || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collGuarantees) {
                // return empty collection
                $this->initGuarantees();
            } else {
                $collGuarantees = GuaranteeQuery::create(null, $criteria)
                    ->filterByProject($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collGuaranteesPartial && count($collGuarantees)) {
                      $this->initGuarantees(false);

                      foreach($collGuarantees as $obj) {
                        if (false == $this->collGuarantees->contains($obj)) {
                          $this->collGuarantees->append($obj);
                        }
                      }

                      $this->collGuaranteesPartial = true;
                    }

                    return $collGuarantees;
                }

                if($partial && $this->collGuarantees) {
                    foreach($this->collGuarantees as $obj) {
                        if($obj->isNew()) {
                            $collGuarantees[] = $obj;
                        }
                    }
                }

                $this->collGuarantees = $collGuarantees;
                $this->collGuaranteesPartial = false;
            }
        }

        return $this->collGuarantees;
    }

    /**
     * Sets a collection of Guarantee objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $guarantees A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setGuarantees(PropelCollection $guarantees, PropelPDO $con = null)
    {
        $this->guaranteesScheduledForDeletion = $this->getGuarantees(new Criteria(), $con)->diff($guarantees);

        foreach ($this->guaranteesScheduledForDeletion as $guaranteeRemoved) {
            $guaranteeRemoved->setProject(null);
        }

        $this->collGuarantees = null;
        foreach ($guarantees as $guarantee) {
            $this->addGuarantee($guarantee);
        }

        $this->collGuarantees = $guarantees;
        $this->collGuaranteesPartial = false;
    }

    /**
     * Returns the number of related Guarantee objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Guarantee objects.
     * @throws PropelException
     */
    public function countGuarantees(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collGuaranteesPartial && !$this->isNew();
        if (null === $this->collGuarantees || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collGuarantees) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getGuarantees());
                }
                $query = GuaranteeQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProject($this)
                    ->count($con);
            }
        } else {
            return count($this->collGuarantees);
        }
    }

    /**
     * Method called to associate a Guarantee object to this object
     * through the Guarantee foreign key attribute.
     *
     * @param    Guarantee $l Guarantee
     * @return Project The current object (for fluent API support)
     */
    public function addGuarantee(Guarantee $l)
    {
        if ($this->collGuarantees === null) {
            $this->initGuarantees();
            $this->collGuaranteesPartial = true;
        }
        if (!$this->collGuarantees->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddGuarantee($l);
        }

        return $this;
    }

    /**
     * @param	Guarantee $guarantee The guarantee object to add.
     */
    protected function doAddGuarantee($guarantee)
    {
        $this->collGuarantees[]= $guarantee;
        $guarantee->setProject($this);
    }

    /**
     * @param	Guarantee $guarantee The guarantee object to remove.
     */
    public function removeGuarantee($guarantee)
    {
        if ($this->getGuarantees()->contains($guarantee)) {
            $this->collGuarantees->remove($this->collGuarantees->search($guarantee));
            if (null === $this->guaranteesScheduledForDeletion) {
                $this->guaranteesScheduledForDeletion = clone $this->collGuarantees;
                $this->guaranteesScheduledForDeletion->clear();
            }
            $this->guaranteesScheduledForDeletion[]= $guarantee;
            $guarantee->setProject(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Project is new, it will return
     * an empty collection; or if this Project has previously
     * been saved, it will retrieve related Guarantees from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Project.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Guarantee[] List of Guarantee objects
     */
    public function getGuaranteesJoinContractor($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = GuaranteeQuery::create(null, $criteria);
        $query->joinWith('Contractor', $join_behavior);

        return $this->getGuarantees($query, $con);
    }

    /**
     * Clears out the collAdministrativeActs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addAdministrativeActs()
     */
    public function clearAdministrativeActs()
    {
        $this->collAdministrativeActs = null; // important to set this to null since that means it is uninitialized
        $this->collAdministrativeActsPartial = null;
    }

    /**
     * reset is the collAdministrativeActs collection loaded partially
     *
     * @return void
     */
    public function resetPartialAdministrativeActs($v = true)
    {
        $this->collAdministrativeActsPartial = $v;
    }

    /**
     * Initializes the collAdministrativeActs collection.
     *
     * By default this just sets the collAdministrativeActs collection to an empty array (like clearcollAdministrativeActs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initAdministrativeActs($overrideExisting = true)
    {
        if (null !== $this->collAdministrativeActs && !$overrideExisting) {
            return;
        }
        $this->collAdministrativeActs = new PropelObjectCollection();
        $this->collAdministrativeActs->setModel('AdministrativeAct');
    }

    /**
     * Gets an array of AdministrativeAct objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Project is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|AdministrativeAct[] List of AdministrativeAct objects
     * @throws PropelException
     */
    public function getAdministrativeActs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collAdministrativeActsPartial && !$this->isNew();
        if (null === $this->collAdministrativeActs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collAdministrativeActs) {
                // return empty collection
                $this->initAdministrativeActs();
            } else {
                $collAdministrativeActs = AdministrativeActQuery::create(null, $criteria)
                    ->filterByProject($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collAdministrativeActsPartial && count($collAdministrativeActs)) {
                      $this->initAdministrativeActs(false);

                      foreach($collAdministrativeActs as $obj) {
                        if (false == $this->collAdministrativeActs->contains($obj)) {
                          $this->collAdministrativeActs->append($obj);
                        }
                      }

                      $this->collAdministrativeActsPartial = true;
                    }

                    return $collAdministrativeActs;
                }

                if($partial && $this->collAdministrativeActs) {
                    foreach($this->collAdministrativeActs as $obj) {
                        if($obj->isNew()) {
                            $collAdministrativeActs[] = $obj;
                        }
                    }
                }

                $this->collAdministrativeActs = $collAdministrativeActs;
                $this->collAdministrativeActsPartial = false;
            }
        }

        return $this->collAdministrativeActs;
    }

    /**
     * Sets a collection of AdministrativeAct objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $administrativeActs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setAdministrativeActs(PropelCollection $administrativeActs, PropelPDO $con = null)
    {
        $this->administrativeActsScheduledForDeletion = $this->getAdministrativeActs(new Criteria(), $con)->diff($administrativeActs);

        foreach ($this->administrativeActsScheduledForDeletion as $administrativeActRemoved) {
            $administrativeActRemoved->setProject(null);
        }

        $this->collAdministrativeActs = null;
        foreach ($administrativeActs as $administrativeAct) {
            $this->addAdministrativeAct($administrativeAct);
        }

        $this->collAdministrativeActs = $administrativeActs;
        $this->collAdministrativeActsPartial = false;
    }

    /**
     * Returns the number of related AdministrativeAct objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related AdministrativeAct objects.
     * @throws PropelException
     */
    public function countAdministrativeActs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collAdministrativeActsPartial && !$this->isNew();
        if (null === $this->collAdministrativeActs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collAdministrativeActs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getAdministrativeActs());
                }
                $query = AdministrativeActQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProject($this)
                    ->count($con);
            }
        } else {
            return count($this->collAdministrativeActs);
        }
    }

    /**
     * Method called to associate a AdministrativeAct object to this object
     * through the AdministrativeAct foreign key attribute.
     *
     * @param    AdministrativeAct $l AdministrativeAct
     * @return Project The current object (for fluent API support)
     */
    public function addAdministrativeAct(AdministrativeAct $l)
    {
        if ($this->collAdministrativeActs === null) {
            $this->initAdministrativeActs();
            $this->collAdministrativeActsPartial = true;
        }
        if (!$this->collAdministrativeActs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddAdministrativeAct($l);
        }

        return $this;
    }

    /**
     * @param	AdministrativeAct $administrativeAct The administrativeAct object to add.
     */
    protected function doAddAdministrativeAct($administrativeAct)
    {
        $this->collAdministrativeActs[]= $administrativeAct;
        $administrativeAct->setProject($this);
    }

    /**
     * @param	AdministrativeAct $administrativeAct The administrativeAct object to remove.
     */
    public function removeAdministrativeAct($administrativeAct)
    {
        if ($this->getAdministrativeActs()->contains($administrativeAct)) {
            $this->collAdministrativeActs->remove($this->collAdministrativeActs->search($administrativeAct));
            if (null === $this->administrativeActsScheduledForDeletion) {
                $this->administrativeActsScheduledForDeletion = clone $this->collAdministrativeActs;
                $this->administrativeActsScheduledForDeletion->clear();
            }
            $this->administrativeActsScheduledForDeletion[]= $administrativeAct;
            $administrativeAct->setProject(null);
        }
    }

    /**
     * Clears out the collProjectRegions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectRegions()
     */
    public function clearProjectRegions()
    {
        $this->collProjectRegions = null; // important to set this to null since that means it is uninitialized
        $this->collProjectRegionsPartial = null;
    }

    /**
     * reset is the collProjectRegions collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectRegions($v = true)
    {
        $this->collProjectRegionsPartial = $v;
    }

    /**
     * Initializes the collProjectRegions collection.
     *
     * By default this just sets the collProjectRegions collection to an empty array (like clearcollProjectRegions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectRegions($overrideExisting = true)
    {
        if (null !== $this->collProjectRegions && !$overrideExisting) {
            return;
        }
        $this->collProjectRegions = new PropelObjectCollection();
        $this->collProjectRegions->setModel('ProjectRegion');
    }

    /**
     * Gets an array of ProjectRegion objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Project is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectRegion[] List of ProjectRegion objects
     * @throws PropelException
     */
    public function getProjectRegions($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectRegionsPartial && !$this->isNew();
        if (null === $this->collProjectRegions || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectRegions) {
                // return empty collection
                $this->initProjectRegions();
            } else {
                $collProjectRegions = ProjectRegionQuery::create(null, $criteria)
                    ->filterByProject($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectRegionsPartial && count($collProjectRegions)) {
                      $this->initProjectRegions(false);

                      foreach($collProjectRegions as $obj) {
                        if (false == $this->collProjectRegions->contains($obj)) {
                          $this->collProjectRegions->append($obj);
                        }
                      }

                      $this->collProjectRegionsPartial = true;
                    }

                    return $collProjectRegions;
                }

                if($partial && $this->collProjectRegions) {
                    foreach($this->collProjectRegions as $obj) {
                        if($obj->isNew()) {
                            $collProjectRegions[] = $obj;
                        }
                    }
                }

                $this->collProjectRegions = $collProjectRegions;
                $this->collProjectRegionsPartial = false;
            }
        }

        return $this->collProjectRegions;
    }

    /**
     * Sets a collection of ProjectRegion objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectRegions A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectRegions(PropelCollection $projectRegions, PropelPDO $con = null)
    {
        $this->projectRegionsScheduledForDeletion = $this->getProjectRegions(new Criteria(), $con)->diff($projectRegions);

        foreach ($this->projectRegionsScheduledForDeletion as $projectRegionRemoved) {
            $projectRegionRemoved->setProject(null);
        }

        $this->collProjectRegions = null;
        foreach ($projectRegions as $projectRegion) {
            $this->addProjectRegion($projectRegion);
        }

        $this->collProjectRegions = $projectRegions;
        $this->collProjectRegionsPartial = false;
    }

    /**
     * Returns the number of related ProjectRegion objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectRegion objects.
     * @throws PropelException
     */
    public function countProjectRegions(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectRegionsPartial && !$this->isNew();
        if (null === $this->collProjectRegions || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectRegions) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectRegions());
                }
                $query = ProjectRegionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProject($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectRegions);
        }
    }

    /**
     * Method called to associate a ProjectRegion object to this object
     * through the ProjectRegion foreign key attribute.
     *
     * @param    ProjectRegion $l ProjectRegion
     * @return Project The current object (for fluent API support)
     */
    public function addProjectRegion(ProjectRegion $l)
    {
        if ($this->collProjectRegions === null) {
            $this->initProjectRegions();
            $this->collProjectRegionsPartial = true;
        }
        if (!$this->collProjectRegions->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectRegion($l);
        }

        return $this;
    }

    /**
     * @param	ProjectRegion $projectRegion The projectRegion object to add.
     */
    protected function doAddProjectRegion($projectRegion)
    {
        $this->collProjectRegions[]= $projectRegion;
        $projectRegion->setProject($this);
    }

    /**
     * @param	ProjectRegion $projectRegion The projectRegion object to remove.
     */
    public function removeProjectRegion($projectRegion)
    {
        if ($this->getProjectRegions()->contains($projectRegion)) {
            $this->collProjectRegions->remove($this->collProjectRegions->search($projectRegion));
            if (null === $this->projectRegionsScheduledForDeletion) {
                $this->projectRegionsScheduledForDeletion = clone $this->collProjectRegions;
                $this->projectRegionsScheduledForDeletion->clear();
            }
            $this->projectRegionsScheduledForDeletion[]= $projectRegion;
            $projectRegion->setProject(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Project is new, it will return
     * an empty collection; or if this Project has previously
     * been saved, it will retrieve related ProjectRegions from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Project.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectRegion[] List of ProjectRegion objects
     */
    public function getProjectRegionsJoinRegion($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectRegionQuery::create(null, $criteria);
        $query->joinWith('Region', $join_behavior);

        return $this->getProjectRegions($query, $con);
    }

    /**
     * Clears out the collProjectMilestones collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectMilestones()
     */
    public function clearProjectMilestones()
    {
        $this->collProjectMilestones = null; // important to set this to null since that means it is uninitialized
        $this->collProjectMilestonesPartial = null;
    }

    /**
     * reset is the collProjectMilestones collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectMilestones($v = true)
    {
        $this->collProjectMilestonesPartial = $v;
    }

    /**
     * Initializes the collProjectMilestones collection.
     *
     * By default this just sets the collProjectMilestones collection to an empty array (like clearcollProjectMilestones());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectMilestones($overrideExisting = true)
    {
        if (null !== $this->collProjectMilestones && !$overrideExisting) {
            return;
        }
        $this->collProjectMilestones = new PropelObjectCollection();
        $this->collProjectMilestones->setModel('ProjectMilestone');
    }

    /**
     * Gets an array of ProjectMilestone objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Project is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectMilestone[] List of ProjectMilestone objects
     * @throws PropelException
     */
    public function getProjectMilestones($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectMilestonesPartial && !$this->isNew();
        if (null === $this->collProjectMilestones || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectMilestones) {
                // return empty collection
                $this->initProjectMilestones();
            } else {
                $collProjectMilestones = ProjectMilestoneQuery::create(null, $criteria)
                    ->filterByProject($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectMilestonesPartial && count($collProjectMilestones)) {
                      $this->initProjectMilestones(false);

                      foreach($collProjectMilestones as $obj) {
                        if (false == $this->collProjectMilestones->contains($obj)) {
                          $this->collProjectMilestones->append($obj);
                        }
                      }

                      $this->collProjectMilestonesPartial = true;
                    }

                    return $collProjectMilestones;
                }

                if($partial && $this->collProjectMilestones) {
                    foreach($this->collProjectMilestones as $obj) {
                        if($obj->isNew()) {
                            $collProjectMilestones[] = $obj;
                        }
                    }
                }

                $this->collProjectMilestones = $collProjectMilestones;
                $this->collProjectMilestonesPartial = false;
            }
        }

        return $this->collProjectMilestones;
    }

    /**
     * Sets a collection of ProjectMilestone objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectMilestones A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectMilestones(PropelCollection $projectMilestones, PropelPDO $con = null)
    {
        $this->projectMilestonesScheduledForDeletion = $this->getProjectMilestones(new Criteria(), $con)->diff($projectMilestones);

        foreach ($this->projectMilestonesScheduledForDeletion as $projectMilestoneRemoved) {
            $projectMilestoneRemoved->setProject(null);
        }

        $this->collProjectMilestones = null;
        foreach ($projectMilestones as $projectMilestone) {
            $this->addProjectMilestone($projectMilestone);
        }

        $this->collProjectMilestones = $projectMilestones;
        $this->collProjectMilestonesPartial = false;
    }

    /**
     * Returns the number of related ProjectMilestone objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectMilestone objects.
     * @throws PropelException
     */
    public function countProjectMilestones(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectMilestonesPartial && !$this->isNew();
        if (null === $this->collProjectMilestones || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectMilestones) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectMilestones());
                }
                $query = ProjectMilestoneQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProject($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectMilestones);
        }
    }

    /**
     * Method called to associate a ProjectMilestone object to this object
     * through the ProjectMilestone foreign key attribute.
     *
     * @param    ProjectMilestone $l ProjectMilestone
     * @return Project The current object (for fluent API support)
     */
    public function addProjectMilestone(ProjectMilestone $l)
    {
        if ($this->collProjectMilestones === null) {
            $this->initProjectMilestones();
            $this->collProjectMilestonesPartial = true;
        }
        if (!$this->collProjectMilestones->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectMilestone($l);
        }

        return $this;
    }

    /**
     * @param	ProjectMilestone $projectMilestone The projectMilestone object to add.
     */
    protected function doAddProjectMilestone($projectMilestone)
    {
        $this->collProjectMilestones[]= $projectMilestone;
        $projectMilestone->setProject($this);
    }

    /**
     * @param	ProjectMilestone $projectMilestone The projectMilestone object to remove.
     */
    public function removeProjectMilestone($projectMilestone)
    {
        if ($this->getProjectMilestones()->contains($projectMilestone)) {
            $this->collProjectMilestones->remove($this->collProjectMilestones->search($projectMilestone));
            if (null === $this->projectMilestonesScheduledForDeletion) {
                $this->projectMilestonesScheduledForDeletion = clone $this->collProjectMilestones;
                $this->projectMilestonesScheduledForDeletion->clear();
            }
            $this->projectMilestonesScheduledForDeletion[]= $projectMilestone;
            $projectMilestone->setProject(null);
        }
    }

    /**
     * Clears out the collProjectIndicators collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectIndicators()
     */
    public function clearProjectIndicators()
    {
        $this->collProjectIndicators = null; // important to set this to null since that means it is uninitialized
        $this->collProjectIndicatorsPartial = null;
    }

    /**
     * reset is the collProjectIndicators collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectIndicators($v = true)
    {
        $this->collProjectIndicatorsPartial = $v;
    }

    /**
     * Initializes the collProjectIndicators collection.
     *
     * By default this just sets the collProjectIndicators collection to an empty array (like clearcollProjectIndicators());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectIndicators($overrideExisting = true)
    {
        if (null !== $this->collProjectIndicators && !$overrideExisting) {
            return;
        }
        $this->collProjectIndicators = new PropelObjectCollection();
        $this->collProjectIndicators->setModel('ProjectIndicator');
    }

    /**
     * Gets an array of ProjectIndicator objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Project is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectIndicator[] List of ProjectIndicator objects
     * @throws PropelException
     */
    public function getProjectIndicators($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectIndicatorsPartial && !$this->isNew();
        if (null === $this->collProjectIndicators || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectIndicators) {
                // return empty collection
                $this->initProjectIndicators();
            } else {
                $collProjectIndicators = ProjectIndicatorQuery::create(null, $criteria)
                    ->filterByProject($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectIndicatorsPartial && count($collProjectIndicators)) {
                      $this->initProjectIndicators(false);

                      foreach($collProjectIndicators as $obj) {
                        if (false == $this->collProjectIndicators->contains($obj)) {
                          $this->collProjectIndicators->append($obj);
                        }
                      }

                      $this->collProjectIndicatorsPartial = true;
                    }

                    return $collProjectIndicators;
                }

                if($partial && $this->collProjectIndicators) {
                    foreach($this->collProjectIndicators as $obj) {
                        if($obj->isNew()) {
                            $collProjectIndicators[] = $obj;
                        }
                    }
                }

                $this->collProjectIndicators = $collProjectIndicators;
                $this->collProjectIndicatorsPartial = false;
            }
        }

        return $this->collProjectIndicators;
    }

    /**
     * Sets a collection of ProjectIndicator objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectIndicators A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectIndicators(PropelCollection $projectIndicators, PropelPDO $con = null)
    {
        $this->projectIndicatorsScheduledForDeletion = $this->getProjectIndicators(new Criteria(), $con)->diff($projectIndicators);

        foreach ($this->projectIndicatorsScheduledForDeletion as $projectIndicatorRemoved) {
            $projectIndicatorRemoved->setProject(null);
        }

        $this->collProjectIndicators = null;
        foreach ($projectIndicators as $projectIndicator) {
            $this->addProjectIndicator($projectIndicator);
        }

        $this->collProjectIndicators = $projectIndicators;
        $this->collProjectIndicatorsPartial = false;
    }

    /**
     * Returns the number of related ProjectIndicator objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectIndicator objects.
     * @throws PropelException
     */
    public function countProjectIndicators(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectIndicatorsPartial && !$this->isNew();
        if (null === $this->collProjectIndicators || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectIndicators) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectIndicators());
                }
                $query = ProjectIndicatorQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProject($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectIndicators);
        }
    }

    /**
     * Method called to associate a ProjectIndicator object to this object
     * through the ProjectIndicator foreign key attribute.
     *
     * @param    ProjectIndicator $l ProjectIndicator
     * @return Project The current object (for fluent API support)
     */
    public function addProjectIndicator(ProjectIndicator $l)
    {
        if ($this->collProjectIndicators === null) {
            $this->initProjectIndicators();
            $this->collProjectIndicatorsPartial = true;
        }
        if (!$this->collProjectIndicators->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectIndicator($l);
        }

        return $this;
    }

    /**
     * @param	ProjectIndicator $projectIndicator The projectIndicator object to add.
     */
    protected function doAddProjectIndicator($projectIndicator)
    {
        $this->collProjectIndicators[]= $projectIndicator;
        $projectIndicator->setProject($this);
    }

    /**
     * @param	ProjectIndicator $projectIndicator The projectIndicator object to remove.
     */
    public function removeProjectIndicator($projectIndicator)
    {
        if ($this->getProjectIndicators()->contains($projectIndicator)) {
            $this->collProjectIndicators->remove($this->collProjectIndicators->search($projectIndicator));
            if (null === $this->projectIndicatorsScheduledForDeletion) {
                $this->projectIndicatorsScheduledForDeletion = clone $this->collProjectIndicators;
                $this->projectIndicatorsScheduledForDeletion->clear();
            }
            $this->projectIndicatorsScheduledForDeletion[]= $projectIndicator;
            $projectIndicator->setProject(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Project is new, it will return
     * an empty collection; or if this Project has previously
     * been saved, it will retrieve related ProjectIndicators from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Project.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectIndicator[] List of ProjectIndicator objects
     */
    public function getProjectIndicatorsJoinRegion($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectIndicatorQuery::create(null, $criteria);
        $query->joinWith('Region', $join_behavior);

        return $this->getProjectIndicators($query, $con);
    }

    /**
     * Clears out the collProjectActivitys collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectActivitys()
     */
    public function clearProjectActivitys()
    {
        $this->collProjectActivitys = null; // important to set this to null since that means it is uninitialized
        $this->collProjectActivitysPartial = null;
    }

    /**
     * reset is the collProjectActivitys collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectActivitys($v = true)
    {
        $this->collProjectActivitysPartial = $v;
    }

    /**
     * Initializes the collProjectActivitys collection.
     *
     * By default this just sets the collProjectActivitys collection to an empty array (like clearcollProjectActivitys());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectActivitys($overrideExisting = true)
    {
        if (null !== $this->collProjectActivitys && !$overrideExisting) {
            return;
        }
        $this->collProjectActivitys = new PropelObjectCollection();
        $this->collProjectActivitys->setModel('ProjectActivity');
    }

    /**
     * Gets an array of ProjectActivity objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Project is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectActivity[] List of ProjectActivity objects
     * @throws PropelException
     */
    public function getProjectActivitys($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectActivitysPartial && !$this->isNew();
        if (null === $this->collProjectActivitys || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectActivitys) {
                // return empty collection
                $this->initProjectActivitys();
            } else {
                $collProjectActivitys = ProjectActivityQuery::create(null, $criteria)
                    ->filterByProject($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectActivitysPartial && count($collProjectActivitys)) {
                      $this->initProjectActivitys(false);

                      foreach($collProjectActivitys as $obj) {
                        if (false == $this->collProjectActivitys->contains($obj)) {
                          $this->collProjectActivitys->append($obj);
                        }
                      }

                      $this->collProjectActivitysPartial = true;
                    }

                    return $collProjectActivitys;
                }

                if($partial && $this->collProjectActivitys) {
                    foreach($this->collProjectActivitys as $obj) {
                        if($obj->isNew()) {
                            $collProjectActivitys[] = $obj;
                        }
                    }
                }

                $this->collProjectActivitys = $collProjectActivitys;
                $this->collProjectActivitysPartial = false;
            }
        }

        return $this->collProjectActivitys;
    }

    /**
     * Sets a collection of ProjectActivity objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectActivitys A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectActivitys(PropelCollection $projectActivitys, PropelPDO $con = null)
    {
        $this->projectActivitysScheduledForDeletion = $this->getProjectActivitys(new Criteria(), $con)->diff($projectActivitys);

        foreach ($this->projectActivitysScheduledForDeletion as $projectActivityRemoved) {
            $projectActivityRemoved->setProject(null);
        }

        $this->collProjectActivitys = null;
        foreach ($projectActivitys as $projectActivity) {
            $this->addProjectActivity($projectActivity);
        }

        $this->collProjectActivitys = $projectActivitys;
        $this->collProjectActivitysPartial = false;
    }

    /**
     * Returns the number of related ProjectActivity objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectActivity objects.
     * @throws PropelException
     */
    public function countProjectActivitys(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectActivitysPartial && !$this->isNew();
        if (null === $this->collProjectActivitys || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectActivitys) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectActivitys());
                }
                $query = ProjectActivityQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProject($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectActivitys);
        }
    }

    /**
     * Method called to associate a ProjectActivity object to this object
     * through the ProjectActivity foreign key attribute.
     *
     * @param    ProjectActivity $l ProjectActivity
     * @return Project The current object (for fluent API support)
     */
    public function addProjectActivity(ProjectActivity $l)
    {
        if ($this->collProjectActivitys === null) {
            $this->initProjectActivitys();
            $this->collProjectActivitysPartial = true;
        }
        if (!$this->collProjectActivitys->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectActivity($l);
        }

        return $this;
    }

    /**
     * @param	ProjectActivity $projectActivity The projectActivity object to add.
     */
    protected function doAddProjectActivity($projectActivity)
    {
        $this->collProjectActivitys[]= $projectActivity;
        $projectActivity->setProject($this);
    }

    /**
     * @param	ProjectActivity $projectActivity The projectActivity object to remove.
     */
    public function removeProjectActivity($projectActivity)
    {
        if ($this->getProjectActivitys()->contains($projectActivity)) {
            $this->collProjectActivitys->remove($this->collProjectActivitys->search($projectActivity));
            if (null === $this->projectActivitysScheduledForDeletion) {
                $this->projectActivitysScheduledForDeletion = clone $this->collProjectActivitys;
                $this->projectActivitysScheduledForDeletion->clear();
            }
            $this->projectActivitysScheduledForDeletion[]= $projectActivity;
            $projectActivity->setProject(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Project is new, it will return
     * an empty collection; or if this Project has previously
     * been saved, it will retrieve related ProjectActivitys from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Project.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectActivity[] List of ProjectActivity objects
     */
    public function getProjectActivitysJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectActivityQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getProjectActivitys($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Project is new, it will return
     * an empty collection; or if this Project has previously
     * been saved, it will retrieve related ProjectActivitys from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Project.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectActivity[] List of ProjectActivity objects
     */
    public function getProjectActivitysJoinPosition($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectActivityQuery::create(null, $criteria);
        $query->joinWith('Position', $join_behavior);

        return $this->getProjectActivitys($query, $con);
    }

    /**
     * Clears out the collProjectDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectDocuments()
     */
    public function clearProjectDocuments()
    {
        $this->collProjectDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collProjectDocumentsPartial = null;
    }

    /**
     * reset is the collProjectDocuments collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectDocuments($v = true)
    {
        $this->collProjectDocumentsPartial = $v;
    }

    /**
     * Initializes the collProjectDocuments collection.
     *
     * By default this just sets the collProjectDocuments collection to an empty array (like clearcollProjectDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectDocuments($overrideExisting = true)
    {
        if (null !== $this->collProjectDocuments && !$overrideExisting) {
            return;
        }
        $this->collProjectDocuments = new PropelObjectCollection();
        $this->collProjectDocuments->setModel('ProjectDocument');
    }

    /**
     * Gets an array of ProjectDocument objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Project is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectDocument[] List of ProjectDocument objects
     * @throws PropelException
     */
    public function getProjectDocuments($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectDocumentsPartial && !$this->isNew();
        if (null === $this->collProjectDocuments || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectDocuments) {
                // return empty collection
                $this->initProjectDocuments();
            } else {
                $collProjectDocuments = ProjectDocumentQuery::create(null, $criteria)
                    ->filterByProject($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectDocumentsPartial && count($collProjectDocuments)) {
                      $this->initProjectDocuments(false);

                      foreach($collProjectDocuments as $obj) {
                        if (false == $this->collProjectDocuments->contains($obj)) {
                          $this->collProjectDocuments->append($obj);
                        }
                      }

                      $this->collProjectDocumentsPartial = true;
                    }

                    return $collProjectDocuments;
                }

                if($partial && $this->collProjectDocuments) {
                    foreach($this->collProjectDocuments as $obj) {
                        if($obj->isNew()) {
                            $collProjectDocuments[] = $obj;
                        }
                    }
                }

                $this->collProjectDocuments = $collProjectDocuments;
                $this->collProjectDocumentsPartial = false;
            }
        }

        return $this->collProjectDocuments;
    }

    /**
     * Sets a collection of ProjectDocument objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectDocuments A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectDocuments(PropelCollection $projectDocuments, PropelPDO $con = null)
    {
        $this->projectDocumentsScheduledForDeletion = $this->getProjectDocuments(new Criteria(), $con)->diff($projectDocuments);

        foreach ($this->projectDocumentsScheduledForDeletion as $projectDocumentRemoved) {
            $projectDocumentRemoved->setProject(null);
        }

        $this->collProjectDocuments = null;
        foreach ($projectDocuments as $projectDocument) {
            $this->addProjectDocument($projectDocument);
        }

        $this->collProjectDocuments = $projectDocuments;
        $this->collProjectDocumentsPartial = false;
    }

    /**
     * Returns the number of related ProjectDocument objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectDocument objects.
     * @throws PropelException
     */
    public function countProjectDocuments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectDocumentsPartial && !$this->isNew();
        if (null === $this->collProjectDocuments || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectDocuments) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectDocuments());
                }
                $query = ProjectDocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProject($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectDocuments);
        }
    }

    /**
     * Method called to associate a ProjectDocument object to this object
     * through the ProjectDocument foreign key attribute.
     *
     * @param    ProjectDocument $l ProjectDocument
     * @return Project The current object (for fluent API support)
     */
    public function addProjectDocument(ProjectDocument $l)
    {
        if ($this->collProjectDocuments === null) {
            $this->initProjectDocuments();
            $this->collProjectDocumentsPartial = true;
        }
        if (!$this->collProjectDocuments->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectDocument($l);
        }

        return $this;
    }

    /**
     * @param	ProjectDocument $projectDocument The projectDocument object to add.
     */
    protected function doAddProjectDocument($projectDocument)
    {
        $this->collProjectDocuments[]= $projectDocument;
        $projectDocument->setProject($this);
    }

    /**
     * @param	ProjectDocument $projectDocument The projectDocument object to remove.
     */
    public function removeProjectDocument($projectDocument)
    {
        if ($this->getProjectDocuments()->contains($projectDocument)) {
            $this->collProjectDocuments->remove($this->collProjectDocuments->search($projectDocument));
            if (null === $this->projectDocumentsScheduledForDeletion) {
                $this->projectDocumentsScheduledForDeletion = clone $this->collProjectDocuments;
                $this->projectDocumentsScheduledForDeletion->clear();
            }
            $this->projectDocumentsScheduledForDeletion[]= $projectDocument;
            $projectDocument->setProject(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Project is new, it will return
     * an empty collection; or if this Project has previously
     * been saved, it will retrieve related ProjectDocuments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Project.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectDocument[] List of ProjectDocument objects
     */
    public function getProjectDocumentsJoinDocument($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectDocumentQuery::create(null, $criteria);
        $query->joinWith('Document', $join_behavior);

        return $this->getProjectDocuments($query, $con);
    }

    /**
     * Clears out the collProjectContractors collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectContractors()
     */
    public function clearProjectContractors()
    {
        $this->collProjectContractors = null; // important to set this to null since that means it is uninitialized
        $this->collProjectContractorsPartial = null;
    }

    /**
     * reset is the collProjectContractors collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectContractors($v = true)
    {
        $this->collProjectContractorsPartial = $v;
    }

    /**
     * Initializes the collProjectContractors collection.
     *
     * By default this just sets the collProjectContractors collection to an empty array (like clearcollProjectContractors());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectContractors($overrideExisting = true)
    {
        if (null !== $this->collProjectContractors && !$overrideExisting) {
            return;
        }
        $this->collProjectContractors = new PropelObjectCollection();
        $this->collProjectContractors->setModel('ProjectContractor');
    }

    /**
     * Gets an array of ProjectContractor objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Project is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectContractor[] List of ProjectContractor objects
     * @throws PropelException
     */
    public function getProjectContractors($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectContractorsPartial && !$this->isNew();
        if (null === $this->collProjectContractors || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectContractors) {
                // return empty collection
                $this->initProjectContractors();
            } else {
                $collProjectContractors = ProjectContractorQuery::create(null, $criteria)
                    ->filterByProject($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectContractorsPartial && count($collProjectContractors)) {
                      $this->initProjectContractors(false);

                      foreach($collProjectContractors as $obj) {
                        if (false == $this->collProjectContractors->contains($obj)) {
                          $this->collProjectContractors->append($obj);
                        }
                      }

                      $this->collProjectContractorsPartial = true;
                    }

                    return $collProjectContractors;
                }

                if($partial && $this->collProjectContractors) {
                    foreach($this->collProjectContractors as $obj) {
                        if($obj->isNew()) {
                            $collProjectContractors[] = $obj;
                        }
                    }
                }

                $this->collProjectContractors = $collProjectContractors;
                $this->collProjectContractorsPartial = false;
            }
        }

        return $this->collProjectContractors;
    }

    /**
     * Sets a collection of ProjectContractor objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectContractors A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectContractors(PropelCollection $projectContractors, PropelPDO $con = null)
    {
        $this->projectContractorsScheduledForDeletion = $this->getProjectContractors(new Criteria(), $con)->diff($projectContractors);

        foreach ($this->projectContractorsScheduledForDeletion as $projectContractorRemoved) {
            $projectContractorRemoved->setProject(null);
        }

        $this->collProjectContractors = null;
        foreach ($projectContractors as $projectContractor) {
            $this->addProjectContractor($projectContractor);
        }

        $this->collProjectContractors = $projectContractors;
        $this->collProjectContractorsPartial = false;
    }

    /**
     * Returns the number of related ProjectContractor objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectContractor objects.
     * @throws PropelException
     */
    public function countProjectContractors(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectContractorsPartial && !$this->isNew();
        if (null === $this->collProjectContractors || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectContractors) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectContractors());
                }
                $query = ProjectContractorQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProject($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectContractors);
        }
    }

    /**
     * Method called to associate a ProjectContractor object to this object
     * through the ProjectContractor foreign key attribute.
     *
     * @param    ProjectContractor $l ProjectContractor
     * @return Project The current object (for fluent API support)
     */
    public function addProjectContractor(ProjectContractor $l)
    {
        if ($this->collProjectContractors === null) {
            $this->initProjectContractors();
            $this->collProjectContractorsPartial = true;
        }
        if (!$this->collProjectContractors->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectContractor($l);
        }

        return $this;
    }

    /**
     * @param	ProjectContractor $projectContractor The projectContractor object to add.
     */
    protected function doAddProjectContractor($projectContractor)
    {
        $this->collProjectContractors[]= $projectContractor;
        $projectContractor->setProject($this);
    }

    /**
     * @param	ProjectContractor $projectContractor The projectContractor object to remove.
     */
    public function removeProjectContractor($projectContractor)
    {
        if ($this->getProjectContractors()->contains($projectContractor)) {
            $this->collProjectContractors->remove($this->collProjectContractors->search($projectContractor));
            if (null === $this->projectContractorsScheduledForDeletion) {
                $this->projectContractorsScheduledForDeletion = clone $this->collProjectContractors;
                $this->projectContractorsScheduledForDeletion->clear();
            }
            $this->projectContractorsScheduledForDeletion[]= $projectContractor;
            $projectContractor->setProject(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Project is new, it will return
     * an empty collection; or if this Project has previously
     * been saved, it will retrieve related ProjectContractors from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Project.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectContractor[] List of ProjectContractor objects
     */
    public function getProjectContractorsJoinContractor($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectContractorQuery::create(null, $criteria);
        $query->joinWith('Contractor', $join_behavior);

        return $this->getProjectContractors($query, $con);
    }

    /**
     * Clears out the collProjectLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectLogs()
     */
    public function clearProjectLogs()
    {
        $this->collProjectLogs = null; // important to set this to null since that means it is uninitialized
        $this->collProjectLogsPartial = null;
    }

    /**
     * reset is the collProjectLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectLogs($v = true)
    {
        $this->collProjectLogsPartial = $v;
    }

    /**
     * Initializes the collProjectLogs collection.
     *
     * By default this just sets the collProjectLogs collection to an empty array (like clearcollProjectLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectLogs($overrideExisting = true)
    {
        if (null !== $this->collProjectLogs && !$overrideExisting) {
            return;
        }
        $this->collProjectLogs = new PropelObjectCollection();
        $this->collProjectLogs->setModel('ProjectLog');
    }

    /**
     * Gets an array of ProjectLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Project is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectLog[] List of ProjectLog objects
     * @throws PropelException
     */
    public function getProjectLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectLogsPartial && !$this->isNew();
        if (null === $this->collProjectLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectLogs) {
                // return empty collection
                $this->initProjectLogs();
            } else {
                $collProjectLogs = ProjectLogQuery::create(null, $criteria)
                    ->filterByProject($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectLogsPartial && count($collProjectLogs)) {
                      $this->initProjectLogs(false);

                      foreach($collProjectLogs as $obj) {
                        if (false == $this->collProjectLogs->contains($obj)) {
                          $this->collProjectLogs->append($obj);
                        }
                      }

                      $this->collProjectLogsPartial = true;
                    }

                    return $collProjectLogs;
                }

                if($partial && $this->collProjectLogs) {
                    foreach($this->collProjectLogs as $obj) {
                        if($obj->isNew()) {
                            $collProjectLogs[] = $obj;
                        }
                    }
                }

                $this->collProjectLogs = $collProjectLogs;
                $this->collProjectLogsPartial = false;
            }
        }

        return $this->collProjectLogs;
    }

    /**
     * Sets a collection of ProjectLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectLogs(PropelCollection $projectLogs, PropelPDO $con = null)
    {
        $this->projectLogsScheduledForDeletion = $this->getProjectLogs(new Criteria(), $con)->diff($projectLogs);

        foreach ($this->projectLogsScheduledForDeletion as $projectLogRemoved) {
            $projectLogRemoved->setProject(null);
        }

        $this->collProjectLogs = null;
        foreach ($projectLogs as $projectLog) {
            $this->addProjectLog($projectLog);
        }

        $this->collProjectLogs = $projectLogs;
        $this->collProjectLogsPartial = false;
    }

    /**
     * Returns the number of related ProjectLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectLog objects.
     * @throws PropelException
     */
    public function countProjectLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectLogsPartial && !$this->isNew();
        if (null === $this->collProjectLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectLogs());
                }
                $query = ProjectLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProject($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectLogs);
        }
    }

    /**
     * Method called to associate a ProjectLog object to this object
     * through the ProjectLog foreign key attribute.
     *
     * @param    ProjectLog $l ProjectLog
     * @return Project The current object (for fluent API support)
     */
    public function addProjectLog(ProjectLog $l)
    {
        if ($this->collProjectLogs === null) {
            $this->initProjectLogs();
            $this->collProjectLogsPartial = true;
        }
        if (!$this->collProjectLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectLog($l);
        }

        return $this;
    }

    /**
     * @param	ProjectLog $projectLog The projectLog object to add.
     */
    protected function doAddProjectLog($projectLog)
    {
        $this->collProjectLogs[]= $projectLog;
        $projectLog->setProject($this);
    }

    /**
     * @param	ProjectLog $projectLog The projectLog object to remove.
     */
    public function removeProjectLog($projectLog)
    {
        if ($this->getProjectLogs()->contains($projectLog)) {
            $this->collProjectLogs->remove($this->collProjectLogs->search($projectLog));
            if (null === $this->projectLogsScheduledForDeletion) {
                $this->projectLogsScheduledForDeletion = clone $this->collProjectLogs;
                $this->projectLogsScheduledForDeletion->clear();
            }
            $this->projectLogsScheduledForDeletion[]= $projectLog;
            $projectLog->setProject(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Project is new, it will return
     * an empty collection; or if this Project has previously
     * been saved, it will retrieve related ProjectLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Project.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectLog[] List of ProjectLog objects
     */
    public function getProjectLogsJoinObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectLogQuery::create(null, $criteria);
        $query->joinWith('Objective', $join_behavior);

        return $this->getProjectLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Project is new, it will return
     * an empty collection; or if this Project has previously
     * been saved, it will retrieve related ProjectLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Project.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectLog[] List of ProjectLog objects
     */
    public function getProjectLogsJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectLogQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getProjectLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Project is new, it will return
     * an empty collection; or if this Project has previously
     * been saved, it will retrieve related ProjectLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Project.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectLog[] List of ProjectLog objects
     */
    public function getProjectLogsJoinPosition($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectLogQuery::create(null, $criteria);
        $query->joinWith('Position', $join_behavior);

        return $this->getProjectLogs($query, $con);
    }

    /**
     * Clears out the collProjectMilestoneLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectMilestoneLogs()
     */
    public function clearProjectMilestoneLogs()
    {
        $this->collProjectMilestoneLogs = null; // important to set this to null since that means it is uninitialized
        $this->collProjectMilestoneLogsPartial = null;
    }

    /**
     * reset is the collProjectMilestoneLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectMilestoneLogs($v = true)
    {
        $this->collProjectMilestoneLogsPartial = $v;
    }

    /**
     * Initializes the collProjectMilestoneLogs collection.
     *
     * By default this just sets the collProjectMilestoneLogs collection to an empty array (like clearcollProjectMilestoneLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectMilestoneLogs($overrideExisting = true)
    {
        if (null !== $this->collProjectMilestoneLogs && !$overrideExisting) {
            return;
        }
        $this->collProjectMilestoneLogs = new PropelObjectCollection();
        $this->collProjectMilestoneLogs->setModel('ProjectMilestoneLog');
    }

    /**
     * Gets an array of ProjectMilestoneLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Project is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectMilestoneLog[] List of ProjectMilestoneLog objects
     * @throws PropelException
     */
    public function getProjectMilestoneLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectMilestoneLogsPartial && !$this->isNew();
        if (null === $this->collProjectMilestoneLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectMilestoneLogs) {
                // return empty collection
                $this->initProjectMilestoneLogs();
            } else {
                $collProjectMilestoneLogs = ProjectMilestoneLogQuery::create(null, $criteria)
                    ->filterByProject($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectMilestoneLogsPartial && count($collProjectMilestoneLogs)) {
                      $this->initProjectMilestoneLogs(false);

                      foreach($collProjectMilestoneLogs as $obj) {
                        if (false == $this->collProjectMilestoneLogs->contains($obj)) {
                          $this->collProjectMilestoneLogs->append($obj);
                        }
                      }

                      $this->collProjectMilestoneLogsPartial = true;
                    }

                    return $collProjectMilestoneLogs;
                }

                if($partial && $this->collProjectMilestoneLogs) {
                    foreach($this->collProjectMilestoneLogs as $obj) {
                        if($obj->isNew()) {
                            $collProjectMilestoneLogs[] = $obj;
                        }
                    }
                }

                $this->collProjectMilestoneLogs = $collProjectMilestoneLogs;
                $this->collProjectMilestoneLogsPartial = false;
            }
        }

        return $this->collProjectMilestoneLogs;
    }

    /**
     * Sets a collection of ProjectMilestoneLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectMilestoneLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectMilestoneLogs(PropelCollection $projectMilestoneLogs, PropelPDO $con = null)
    {
        $this->projectMilestoneLogsScheduledForDeletion = $this->getProjectMilestoneLogs(new Criteria(), $con)->diff($projectMilestoneLogs);

        foreach ($this->projectMilestoneLogsScheduledForDeletion as $projectMilestoneLogRemoved) {
            $projectMilestoneLogRemoved->setProject(null);
        }

        $this->collProjectMilestoneLogs = null;
        foreach ($projectMilestoneLogs as $projectMilestoneLog) {
            $this->addProjectMilestoneLog($projectMilestoneLog);
        }

        $this->collProjectMilestoneLogs = $projectMilestoneLogs;
        $this->collProjectMilestoneLogsPartial = false;
    }

    /**
     * Returns the number of related ProjectMilestoneLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectMilestoneLog objects.
     * @throws PropelException
     */
    public function countProjectMilestoneLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectMilestoneLogsPartial && !$this->isNew();
        if (null === $this->collProjectMilestoneLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectMilestoneLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectMilestoneLogs());
                }
                $query = ProjectMilestoneLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProject($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectMilestoneLogs);
        }
    }

    /**
     * Method called to associate a ProjectMilestoneLog object to this object
     * through the ProjectMilestoneLog foreign key attribute.
     *
     * @param    ProjectMilestoneLog $l ProjectMilestoneLog
     * @return Project The current object (for fluent API support)
     */
    public function addProjectMilestoneLog(ProjectMilestoneLog $l)
    {
        if ($this->collProjectMilestoneLogs === null) {
            $this->initProjectMilestoneLogs();
            $this->collProjectMilestoneLogsPartial = true;
        }
        if (!$this->collProjectMilestoneLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectMilestoneLog($l);
        }

        return $this;
    }

    /**
     * @param	ProjectMilestoneLog $projectMilestoneLog The projectMilestoneLog object to add.
     */
    protected function doAddProjectMilestoneLog($projectMilestoneLog)
    {
        $this->collProjectMilestoneLogs[]= $projectMilestoneLog;
        $projectMilestoneLog->setProject($this);
    }

    /**
     * @param	ProjectMilestoneLog $projectMilestoneLog The projectMilestoneLog object to remove.
     */
    public function removeProjectMilestoneLog($projectMilestoneLog)
    {
        if ($this->getProjectMilestoneLogs()->contains($projectMilestoneLog)) {
            $this->collProjectMilestoneLogs->remove($this->collProjectMilestoneLogs->search($projectMilestoneLog));
            if (null === $this->projectMilestoneLogsScheduledForDeletion) {
                $this->projectMilestoneLogsScheduledForDeletion = clone $this->collProjectMilestoneLogs;
                $this->projectMilestoneLogsScheduledForDeletion->clear();
            }
            $this->projectMilestoneLogsScheduledForDeletion[]= $projectMilestoneLog;
            $projectMilestoneLog->setProject(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Project is new, it will return
     * an empty collection; or if this Project has previously
     * been saved, it will retrieve related ProjectMilestoneLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Project.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectMilestoneLog[] List of ProjectMilestoneLog objects
     */
    public function getProjectMilestoneLogsJoinProjectMilestone($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectMilestoneLogQuery::create(null, $criteria);
        $query->joinWith('ProjectMilestone', $join_behavior);

        return $this->getProjectMilestoneLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Project is new, it will return
     * an empty collection; or if this Project has previously
     * been saved, it will retrieve related ProjectMilestoneLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Project.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectMilestoneLog[] List of ProjectMilestoneLog objects
     */
    public function getProjectMilestoneLogsJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectMilestoneLogQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getProjectMilestoneLogs($query, $con);
    }

    /**
     * Clears out the collProjectActivityLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectActivityLogs()
     */
    public function clearProjectActivityLogs()
    {
        $this->collProjectActivityLogs = null; // important to set this to null since that means it is uninitialized
        $this->collProjectActivityLogsPartial = null;
    }

    /**
     * reset is the collProjectActivityLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectActivityLogs($v = true)
    {
        $this->collProjectActivityLogsPartial = $v;
    }

    /**
     * Initializes the collProjectActivityLogs collection.
     *
     * By default this just sets the collProjectActivityLogs collection to an empty array (like clearcollProjectActivityLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectActivityLogs($overrideExisting = true)
    {
        if (null !== $this->collProjectActivityLogs && !$overrideExisting) {
            return;
        }
        $this->collProjectActivityLogs = new PropelObjectCollection();
        $this->collProjectActivityLogs->setModel('ProjectActivityLog');
    }

    /**
     * Gets an array of ProjectActivityLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Project is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectActivityLog[] List of ProjectActivityLog objects
     * @throws PropelException
     */
    public function getProjectActivityLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectActivityLogsPartial && !$this->isNew();
        if (null === $this->collProjectActivityLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectActivityLogs) {
                // return empty collection
                $this->initProjectActivityLogs();
            } else {
                $collProjectActivityLogs = ProjectActivityLogQuery::create(null, $criteria)
                    ->filterByProject($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectActivityLogsPartial && count($collProjectActivityLogs)) {
                      $this->initProjectActivityLogs(false);

                      foreach($collProjectActivityLogs as $obj) {
                        if (false == $this->collProjectActivityLogs->contains($obj)) {
                          $this->collProjectActivityLogs->append($obj);
                        }
                      }

                      $this->collProjectActivityLogsPartial = true;
                    }

                    return $collProjectActivityLogs;
                }

                if($partial && $this->collProjectActivityLogs) {
                    foreach($this->collProjectActivityLogs as $obj) {
                        if($obj->isNew()) {
                            $collProjectActivityLogs[] = $obj;
                        }
                    }
                }

                $this->collProjectActivityLogs = $collProjectActivityLogs;
                $this->collProjectActivityLogsPartial = false;
            }
        }

        return $this->collProjectActivityLogs;
    }

    /**
     * Sets a collection of ProjectActivityLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectActivityLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectActivityLogs(PropelCollection $projectActivityLogs, PropelPDO $con = null)
    {
        $this->projectActivityLogsScheduledForDeletion = $this->getProjectActivityLogs(new Criteria(), $con)->diff($projectActivityLogs);

        foreach ($this->projectActivityLogsScheduledForDeletion as $projectActivityLogRemoved) {
            $projectActivityLogRemoved->setProject(null);
        }

        $this->collProjectActivityLogs = null;
        foreach ($projectActivityLogs as $projectActivityLog) {
            $this->addProjectActivityLog($projectActivityLog);
        }

        $this->collProjectActivityLogs = $projectActivityLogs;
        $this->collProjectActivityLogsPartial = false;
    }

    /**
     * Returns the number of related ProjectActivityLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectActivityLog objects.
     * @throws PropelException
     */
    public function countProjectActivityLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectActivityLogsPartial && !$this->isNew();
        if (null === $this->collProjectActivityLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectActivityLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectActivityLogs());
                }
                $query = ProjectActivityLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProject($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectActivityLogs);
        }
    }

    /**
     * Method called to associate a ProjectActivityLog object to this object
     * through the ProjectActivityLog foreign key attribute.
     *
     * @param    ProjectActivityLog $l ProjectActivityLog
     * @return Project The current object (for fluent API support)
     */
    public function addProjectActivityLog(ProjectActivityLog $l)
    {
        if ($this->collProjectActivityLogs === null) {
            $this->initProjectActivityLogs();
            $this->collProjectActivityLogsPartial = true;
        }
        if (!$this->collProjectActivityLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectActivityLog($l);
        }

        return $this;
    }

    /**
     * @param	ProjectActivityLog $projectActivityLog The projectActivityLog object to add.
     */
    protected function doAddProjectActivityLog($projectActivityLog)
    {
        $this->collProjectActivityLogs[]= $projectActivityLog;
        $projectActivityLog->setProject($this);
    }

    /**
     * @param	ProjectActivityLog $projectActivityLog The projectActivityLog object to remove.
     */
    public function removeProjectActivityLog($projectActivityLog)
    {
        if ($this->getProjectActivityLogs()->contains($projectActivityLog)) {
            $this->collProjectActivityLogs->remove($this->collProjectActivityLogs->search($projectActivityLog));
            if (null === $this->projectActivityLogsScheduledForDeletion) {
                $this->projectActivityLogsScheduledForDeletion = clone $this->collProjectActivityLogs;
                $this->projectActivityLogsScheduledForDeletion->clear();
            }
            $this->projectActivityLogsScheduledForDeletion[]= $projectActivityLog;
            $projectActivityLog->setProject(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Project is new, it will return
     * an empty collection; or if this Project has previously
     * been saved, it will retrieve related ProjectActivityLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Project.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectActivityLog[] List of ProjectActivityLog objects
     */
    public function getProjectActivityLogsJoinProjectActivity($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectActivityLogQuery::create(null, $criteria);
        $query->joinWith('ProjectActivity', $join_behavior);

        return $this->getProjectActivityLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Project is new, it will return
     * an empty collection; or if this Project has previously
     * been saved, it will retrieve related ProjectActivityLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Project.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectActivityLog[] List of ProjectActivityLog objects
     */
    public function getProjectActivityLogsJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectActivityLogQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getProjectActivityLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Project is new, it will return
     * an empty collection; or if this Project has previously
     * been saved, it will retrieve related ProjectActivityLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Project.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectActivityLog[] List of ProjectActivityLog objects
     */
    public function getProjectActivityLogsJoinPosition($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectActivityLogQuery::create(null, $criteria);
        $query->joinWith('Position', $join_behavior);

        return $this->getProjectActivityLogs($query, $con);
    }

    /**
     * Clears out the collRegions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addRegions()
     */
    public function clearRegions()
    {
        $this->collRegions = null; // important to set this to null since that means it is uninitialized
        $this->collRegionsPartial = null;
    }

    /**
     * Initializes the collRegions collection.
     *
     * By default this just sets the collRegions collection to an empty collection (like clearRegions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initRegions()
    {
        $this->collRegions = new PropelObjectCollection();
        $this->collRegions->setModel('Region');
    }

    /**
     * Gets a collection of Region objects related by a many-to-many relationship
     * to the current object by way of the projects_region cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Project is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Region[] List of Region objects
     */
    public function getRegions($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collRegions || null !== $criteria) {
            if ($this->isNew() && null === $this->collRegions) {
                // return empty collection
                $this->initRegions();
            } else {
                $collRegions = RegionQuery::create(null, $criteria)
                    ->filterByProject($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collRegions;
                }
                $this->collRegions = $collRegions;
            }
        }

        return $this->collRegions;
    }

    /**
     * Sets a collection of Region objects related by a many-to-many relationship
     * to the current object by way of the projects_region cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $regions A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setRegions(PropelCollection $regions, PropelPDO $con = null)
    {
        $this->clearRegions();
        $currentRegions = $this->getRegions();

        $this->regionsScheduledForDeletion = $currentRegions->diff($regions);

        foreach ($regions as $region) {
            if (!$currentRegions->contains($region)) {
                $this->doAddRegion($region);
            }
        }

        $this->collRegions = $regions;
    }

    /**
     * Gets the number of Region objects related by a many-to-many relationship
     * to the current object by way of the projects_region cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Region objects
     */
    public function countRegions($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collRegions || null !== $criteria) {
            if ($this->isNew() && null === $this->collRegions) {
                return 0;
            } else {
                $query = RegionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProject($this)
                    ->count($con);
            }
        } else {
            return count($this->collRegions);
        }
    }

    /**
     * Associate a Region object to this object
     * through the projects_region cross reference table.
     *
     * @param  Region $region The ProjectRegion object to relate
     * @return void
     */
    public function addRegion(Region $region)
    {
        if ($this->collRegions === null) {
            $this->initRegions();
        }
        if (!$this->collRegions->contains($region)) { // only add it if the **same** object is not already associated
            $this->doAddRegion($region);

            $this->collRegions[]= $region;
        }
    }

    /**
     * @param	Region $region The region object to add.
     */
    protected function doAddRegion($region)
    {
        $projectRegion = new ProjectRegion();
        $projectRegion->setRegion($region);
        $this->addProjectRegion($projectRegion);
    }

    /**
     * Remove a Region object to this object
     * through the projects_region cross reference table.
     *
     * @param Region $region The ProjectRegion object to relate
     * @return void
     */
    public function removeRegion(Region $region)
    {
        if ($this->getRegions()->contains($region)) {
            $this->collRegions->remove($this->collRegions->search($region));
            if (null === $this->regionsScheduledForDeletion) {
                $this->regionsScheduledForDeletion = clone $this->collRegions;
                $this->regionsScheduledForDeletion->clear();
            }
            $this->regionsScheduledForDeletion[]= $region;
        }
    }

    /**
     * Clears out the collDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addDocuments()
     */
    public function clearDocuments()
    {
        $this->collDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collDocumentsPartial = null;
    }

    /**
     * Initializes the collDocuments collection.
     *
     * By default this just sets the collDocuments collection to an empty collection (like clearDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initDocuments()
    {
        $this->collDocuments = new PropelObjectCollection();
        $this->collDocuments->setModel('Document');
    }

    /**
     * Gets a collection of Document objects related by a many-to-many relationship
     * to the current object by way of the projects_document cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Project is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Document[] List of Document objects
     */
    public function getDocuments($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collDocuments || null !== $criteria) {
            if ($this->isNew() && null === $this->collDocuments) {
                // return empty collection
                $this->initDocuments();
            } else {
                $collDocuments = DocumentQuery::create(null, $criteria)
                    ->filterByProject($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collDocuments;
                }
                $this->collDocuments = $collDocuments;
            }
        }

        return $this->collDocuments;
    }

    /**
     * Sets a collection of Document objects related by a many-to-many relationship
     * to the current object by way of the projects_document cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $documents A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setDocuments(PropelCollection $documents, PropelPDO $con = null)
    {
        $this->clearDocuments();
        $currentDocuments = $this->getDocuments();

        $this->documentsScheduledForDeletion = $currentDocuments->diff($documents);

        foreach ($documents as $document) {
            if (!$currentDocuments->contains($document)) {
                $this->doAddDocument($document);
            }
        }

        $this->collDocuments = $documents;
    }

    /**
     * Gets the number of Document objects related by a many-to-many relationship
     * to the current object by way of the projects_document cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Document objects
     */
    public function countDocuments($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collDocuments || null !== $criteria) {
            if ($this->isNew() && null === $this->collDocuments) {
                return 0;
            } else {
                $query = DocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProject($this)
                    ->count($con);
            }
        } else {
            return count($this->collDocuments);
        }
    }

    /**
     * Associate a Document object to this object
     * through the projects_document cross reference table.
     *
     * @param  Document $document The ProjectDocument object to relate
     * @return void
     */
    public function addDocument(Document $document)
    {
        if ($this->collDocuments === null) {
            $this->initDocuments();
        }
        if (!$this->collDocuments->contains($document)) { // only add it if the **same** object is not already associated
            $this->doAddDocument($document);

            $this->collDocuments[]= $document;
        }
    }

    /**
     * @param	Document $document The document object to add.
     */
    protected function doAddDocument($document)
    {
        $projectDocument = new ProjectDocument();
        $projectDocument->setDocument($document);
        $this->addProjectDocument($projectDocument);
    }

    /**
     * Remove a Document object to this object
     * through the projects_document cross reference table.
     *
     * @param Document $document The ProjectDocument object to relate
     * @return void
     */
    public function removeDocument(Document $document)
    {
        if ($this->getDocuments()->contains($document)) {
            $this->collDocuments->remove($this->collDocuments->search($document));
            if (null === $this->documentsScheduledForDeletion) {
                $this->documentsScheduledForDeletion = clone $this->collDocuments;
                $this->documentsScheduledForDeletion->clear();
            }
            $this->documentsScheduledForDeletion[]= $document;
        }
    }

    /**
     * Clears out the collContractors collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addContractors()
     */
    public function clearContractors()
    {
        $this->collContractors = null; // important to set this to null since that means it is uninitialized
        $this->collContractorsPartial = null;
    }

    /**
     * Initializes the collContractors collection.
     *
     * By default this just sets the collContractors collection to an empty collection (like clearContractors());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initContractors()
    {
        $this->collContractors = new PropelObjectCollection();
        $this->collContractors->setModel('Contractor');
    }

    /**
     * Gets a collection of Contractor objects related by a many-to-many relationship
     * to the current object by way of the projects_contractor cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Project is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Contractor[] List of Contractor objects
     */
    public function getContractors($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collContractors || null !== $criteria) {
            if ($this->isNew() && null === $this->collContractors) {
                // return empty collection
                $this->initContractors();
            } else {
                $collContractors = ContractorQuery::create(null, $criteria)
                    ->filterByProject($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collContractors;
                }
                $this->collContractors = $collContractors;
            }
        }

        return $this->collContractors;
    }

    /**
     * Sets a collection of Contractor objects related by a many-to-many relationship
     * to the current object by way of the projects_contractor cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $contractors A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setContractors(PropelCollection $contractors, PropelPDO $con = null)
    {
        $this->clearContractors();
        $currentContractors = $this->getContractors();

        $this->contractorsScheduledForDeletion = $currentContractors->diff($contractors);

        foreach ($contractors as $contractor) {
            if (!$currentContractors->contains($contractor)) {
                $this->doAddContractor($contractor);
            }
        }

        $this->collContractors = $contractors;
    }

    /**
     * Gets the number of Contractor objects related by a many-to-many relationship
     * to the current object by way of the projects_contractor cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Contractor objects
     */
    public function countContractors($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collContractors || null !== $criteria) {
            if ($this->isNew() && null === $this->collContractors) {
                return 0;
            } else {
                $query = ContractorQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProject($this)
                    ->count($con);
            }
        } else {
            return count($this->collContractors);
        }
    }

    /**
     * Associate a Contractor object to this object
     * through the projects_contractor cross reference table.
     *
     * @param  Contractor $contractor The ProjectContractor object to relate
     * @return void
     */
    public function addContractor(Contractor $contractor)
    {
        if ($this->collContractors === null) {
            $this->initContractors();
        }
        if (!$this->collContractors->contains($contractor)) { // only add it if the **same** object is not already associated
            $this->doAddContractor($contractor);

            $this->collContractors[]= $contractor;
        }
    }

    /**
     * @param	Contractor $contractor The contractor object to add.
     */
    protected function doAddContractor($contractor)
    {
        $projectContractor = new ProjectContractor();
        $projectContractor->setContractor($contractor);
        $this->addProjectContractor($projectContractor);
    }

    /**
     * Remove a Contractor object to this object
     * through the projects_contractor cross reference table.
     *
     * @param Contractor $contractor The ProjectContractor object to relate
     * @return void
     */
    public function removeContractor(Contractor $contractor)
    {
        if ($this->getContractors()->contains($contractor)) {
            $this->collContractors->remove($this->collContractors->search($contractor));
            if (null === $this->contractorsScheduledForDeletion) {
                $this->contractorsScheduledForDeletion = clone $this->collContractors;
                $this->contractorsScheduledForDeletion->clear();
            }
            $this->contractorsScheduledForDeletion[]= $contractor;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->objectiveid = null;
        $this->code = null;
        $this->codeaux = null;
        $this->name = null;
        $this->description = null;
        $this->impact = null;
        $this->uniquegoal = null;
        $this->goalexpirationdate = null;
        $this->date = null;
        $this->budget = null;
        $this->exchangerate = null;
        $this->visibility = null;
        $this->coordinateneed = null;
        $this->frequency = null;
        $this->finished = null;
        $this->notes = null;
        $this->postalcode = null;
        $this->uniquegoalnumeric = null;
        $this->goalprogress = null;
        $this->latitude = null;
        $this->longitude = null;
        $this->oldid = null;
        $this->regionid = null;
        $this->oldregionid = null;
        $this->lastmodification = null;
        $this->address = null;
        $this->street = null;
        $this->number = null;
        $this->priority = null;
        $this->modifications = null;
        $this->plannedstart = null;
        $this->plannedend = null;
        $this->realstart = null;
        $this->realend = null;
        $this->cancelled = null;
        $this->isconstruction = null;
        $this->relevance = null;
        $this->userid = null;
        $this->order = null;
        $this->weight = null;
        $this->updated = null;
        $this->responsiblecode = null;
        $this->indicatorid = null;
        $this->primarysource = null;
        $this->additionalsource = null;
        $this->startingyear = null;
        $this->endingyear = null;
        $this->subproject = null;
        $this->ongoing = null;
        $this->relatedareas = null;
        $this->goal = null;
        $this->legal = null;
        $this->execresp = null;
        $this->exectenure = null;
        $this->execdependency = null;
        $this->execcontact = null;
        $this->subsecretary = null;
        $this->budgetrequested = null;
        $this->budgetsanctioned = null;
        $this->belgrano = null;
        $this->clasification = null;
        $this->press = null;
        $this->priorityarea = null;
        $this->beneficiario = null;
        $this->requirecontractor = null;
        $this->purchasetype = null;
        $this->constructiontype = null;
        $this->requireexraresources = null;
        $this->implementationpartner = null;
        $this->riskfactors = null;
        $this->ownfinance = null;
        $this->provincefinance = null;
        $this->nationfinance = null;
        $this->otherfinance = null;
        $this->financedetail = null;
        $this->financeprogram = null;
        $this->created_at = null;
        $this->updated_at = null;
        $this->deleted_at = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collConstructions) {
                foreach ($this->collConstructions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collGuarantees) {
                foreach ($this->collGuarantees as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collAdministrativeActs) {
                foreach ($this->collAdministrativeActs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectRegions) {
                foreach ($this->collProjectRegions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectMilestones) {
                foreach ($this->collProjectMilestones as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectIndicators) {
                foreach ($this->collProjectIndicators as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectActivitys) {
                foreach ($this->collProjectActivitys as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectDocuments) {
                foreach ($this->collProjectDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectContractors) {
                foreach ($this->collProjectContractors as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectLogs) {
                foreach ($this->collProjectLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectMilestoneLogs) {
                foreach ($this->collProjectMilestoneLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectActivityLogs) {
                foreach ($this->collProjectActivityLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collRegions) {
                foreach ($this->collRegions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collDocuments) {
                foreach ($this->collDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collContractors) {
                foreach ($this->collContractors as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collConstructions instanceof PropelCollection) {
            $this->collConstructions->clearIterator();
        }
        $this->collConstructions = null;
        if ($this->collGuarantees instanceof PropelCollection) {
            $this->collGuarantees->clearIterator();
        }
        $this->collGuarantees = null;
        if ($this->collAdministrativeActs instanceof PropelCollection) {
            $this->collAdministrativeActs->clearIterator();
        }
        $this->collAdministrativeActs = null;
        if ($this->collProjectRegions instanceof PropelCollection) {
            $this->collProjectRegions->clearIterator();
        }
        $this->collProjectRegions = null;
        if ($this->collProjectMilestones instanceof PropelCollection) {
            $this->collProjectMilestones->clearIterator();
        }
        $this->collProjectMilestones = null;
        if ($this->collProjectIndicators instanceof PropelCollection) {
            $this->collProjectIndicators->clearIterator();
        }
        $this->collProjectIndicators = null;
        if ($this->collProjectActivitys instanceof PropelCollection) {
            $this->collProjectActivitys->clearIterator();
        }
        $this->collProjectActivitys = null;
        if ($this->collProjectDocuments instanceof PropelCollection) {
            $this->collProjectDocuments->clearIterator();
        }
        $this->collProjectDocuments = null;
        if ($this->collProjectContractors instanceof PropelCollection) {
            $this->collProjectContractors->clearIterator();
        }
        $this->collProjectContractors = null;
        if ($this->collProjectLogs instanceof PropelCollection) {
            $this->collProjectLogs->clearIterator();
        }
        $this->collProjectLogs = null;
        if ($this->collProjectMilestoneLogs instanceof PropelCollection) {
            $this->collProjectMilestoneLogs->clearIterator();
        }
        $this->collProjectMilestoneLogs = null;
        if ($this->collProjectActivityLogs instanceof PropelCollection) {
            $this->collProjectActivityLogs->clearIterator();
        }
        $this->collProjectActivityLogs = null;
        if ($this->collRegions instanceof PropelCollection) {
            $this->collRegions->clearIterator();
        }
        $this->collRegions = null;
        if ($this->collDocuments instanceof PropelCollection) {
            $this->collDocuments->clearIterator();
        }
        $this->collDocuments = null;
        if ($this->collContractors instanceof PropelCollection) {
            $this->collContractors->clearIterator();
        }
        $this->collContractors = null;
        $this->aObjective = null;
        $this->aPosition = null;
        $this->aIndicator = null;
        $this->aUser = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string The value of the 'name' column
     */
    public function __toString()
    {
        return (string) $this->getName();
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

    // timestampable behavior

    /**
     * Mark the current object so that the update date doesn't get updated during next save
     *
     * @return     Project The current object (for fluent API support)
     */
    public function keepUpdateDateUnchanged()
    {
        $this->modifiedColumns[] = ProjectPeer::UPDATED_AT;

        return $this;
    }

    // soft_delete behavior

    /**
     * Bypass the soft_delete behavior and force a hard delete of the current object
     */
    public function forceDelete(PropelPDO $con = null)
    {
        if ($isSoftDeleteEnabled = ProjectPeer::isSoftDeleteEnabled()) {
            ProjectPeer::disableSoftDelete();
        }
        $this->delete($con);
        if ($isSoftDeleteEnabled) {
            ProjectPeer::enableSoftDelete();
        }
    }

    /**
     * Undelete a row that was soft_deleted
     *
     * @return		 int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        $this->setDeletedAt(null);

        return $this->save($con);
    }

}
