<?php

use Egytca\Planning\YearFilter as PlanningYearFilter;

/**
 * Skeleton subclass for performing query and update operations on the 'projects_activity' table.
 *
 * Activity
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.projects.classes
 */
class ProjectActivityQuery extends BaseProjectActivityQuery {

	use PlanningYearFilter;

	private $useLoggedUserGroupAutoFilter = false;

	public function __construct($dbName = 'application', $modelName = 'ProjectActivity', $modelAlias = null) {

		parent::__construct($dbName, $modelName, $modelAlias);

		$loggedUser = Common::getLoggedUser();
		if ($loggedUser && !$loggedUser->isSupervisor() && ConfigModule::get('users', 'useFilterByUserGroup')) {
			$this->useLoggedUserGroupAutoFilter = true;
		}

		$this->filterByPlanningYears();

		return $this;
	}

	/**
	 * Agrega filtros por nombre y descripcion.
	 *
	 * @param   type string $filterValue texto a buscar
	 * @return condicion de filtrado por texto a buscar
	 */
	public function searchString($filterValue) {
		return $this->filterByName("%$filterValue%", Criteria::LIKE)
				->_or()
					->filterByDescription("%$filterValue%", Criteria::LIKE);
				//->_or()
				//	->useProjectQuery()
				//		->filterByName("%$filterValue%", Criteria::LIKE)
				//	->endUse();				
	}

	function preSelect() {
		if ($this->useLoggedUserGroupAutoFilter) {
			$this->filterByLoggedUserGroup();
		}
	}

	function setLoggedUserGroupAutoFilter($value) {
		$this->useLoggedUserGroupAutoFilter = $value;
		return $this;
	}

	function filterByLoggedUserGroup() {
		return $this->useProjectQuery()
				->filterByLoggedUserGroup()
			->endUse();
	}
	
	function filterByDelayed2($value) {
		
		$currentTime = date('Y-m-d');
		
		// Si se usa tolerancia en dias
		global $system;
		if ($system["config"]["tablero"]["activities"]["parameterControl"]["value"] == "DAYS") {
			$days = $system["config"]["tablero"]["activities"]["delayed"]; 
			$currentTime = time() - ($days * 24 * 60 * 60);		
		}

		return $this->filterByPlannedstart(null, $value ? Criteria::ISNOTNULL : Criteria::ISNULL)
			->filterByPlannedstart($currentTime, $value ? Criteria::GREATER_THAN : Criteria::LESS_EQUAL)
			->filterByStarted(!$value);
	}
	
	function filterByStarted($value) {
		return $this->filterByRealstart(null, $value ? Criteria::ISNOTNULL : Criteria::ISNULL);
	}

	/**
	 * Devuelve la criteria para filtrar por fecha de finalización planificada a fin de armar un reporte de alertas de actividades.
	 */
	public function filterByPendingEnd($date, $comparison = null) {
		return $this->filterByCompleted(false)
			->filterByPlannedEnd($date, $comparison)
			->filterByRealend(null, Criteria::ISNULL);
	}

	/**
	 * Filtar por estado.
	 * @param array status filtros por estado.
	 * $status['delayed'] == 1 filtar por retrasados.
	 * $status['ended'] == 1 filtra por finalizados
	 * $status['working'] == 1 filtra por en ejecucion
	 *
	 * Los filtros se combinan con OR ya que se puede filtrar por mas de uno a la ves.
	 */
	function filterByStatus($status) {

		$criterion;

		if (array_key_exists('delayed', $status)) {

			if ($status['delayed']) {
				$criterionDelayedFinished = new Criterion($this, ProjectActivityPeer::PLANNEDEND, date('Y-m-d') . " 00:00:00", Criteria::LESS_EQUAL );
				$criterionDelayedFinished->addAnd(new Criterion($this, ProjectActivityPeer::COMPLETED, 0, Criteria::EQUAL));

				$criterionDelayedStarted = new Criterion($this, ProjectActivityPeer::PLANNEDSTART, date('Y-m-d') . " 00:00:00", Criteria::LESS_EQUAL);
				$criterionDelayedStarted->addAnd(new Criterion($this, ProjectActivityPeer::REALSTART, null, Criteria::ISNULL));

				$criterionDelayedFinished->addOr($criterionDelayedStarted);

				$criterion = $criterionDelayedFinished;
			}
		}

		if (array_key_exists('ended', $status)) {

			if ($status['ended']) {
				if (empty($criterion))
					$criterion = new Criterion($this, ProjectActivityPeer::COMPLETED,1,Criteria::EQUAL);
				else
					$criterion->addOr(new Criterion($this, ProjectActivityPeer::COMPLETED,1,Criteria::EQUAL));	
			}
		}

		if (array_key_exists('working', $status)) {

			if ($status['working']) {

				$criterionWorkingFinished = new Criterion($this, ProjectActivityPeer::COMPLETED,0,Criteria::EQUAL);
			
				$criterionWorking = new Criterion($this, ProjectActivityPeer::REALSTART, null, Criteria::ISNOTNULL);
				$criterionWorkingFinished->addAnd($criterionWorking);
				
				if (empty($criterion))
					$criterion = $criterionWorkingFinished;
				else
					$criterion->addOr($criterionWorkingFinished);				
				}
			}

		$this->add($criterion);

		return $this;
	}

} // ProjectActivityQuery

