<?php


/**
 * Base class that represents a query for the 'positions_positionTenure' table.
 *
 * Ejercicio del cargo
 *
 * @method PositionTenureQuery orderById($order = Criteria::ASC) Order by the id column
 * @method PositionTenureQuery orderByUserid($order = Criteria::ASC) Order by the userId column
 * @method PositionTenureQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method PositionTenureQuery orderByDatefrom($order = Criteria::ASC) Order by the dateFrom column
 * @method PositionTenureQuery orderByDateto($order = Criteria::ASC) Order by the dateTo column
 * @method PositionTenureQuery orderByPositioncode($order = Criteria::ASC) Order by the positionCode column
 * @method PositionTenureQuery orderByOwnername($order = Criteria::ASC) Order by the ownerName column
 * @method PositionTenureQuery orderByObjecttype($order = Criteria::ASC) Order by the objectType column
 * @method PositionTenureQuery orderByObjectid($order = Criteria::ASC) Order by the objectId column
 *
 * @method PositionTenureQuery groupById() Group by the id column
 * @method PositionTenureQuery groupByUserid() Group by the userId column
 * @method PositionTenureQuery groupByName() Group by the name column
 * @method PositionTenureQuery groupByDatefrom() Group by the dateFrom column
 * @method PositionTenureQuery groupByDateto() Group by the dateTo column
 * @method PositionTenureQuery groupByPositioncode() Group by the positionCode column
 * @method PositionTenureQuery groupByOwnername() Group by the ownerName column
 * @method PositionTenureQuery groupByObjecttype() Group by the objectType column
 * @method PositionTenureQuery groupByObjectid() Group by the objectId column
 *
 * @method PositionTenureQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method PositionTenureQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method PositionTenureQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method PositionTenureQuery leftJoinPosition($relationAlias = null) Adds a LEFT JOIN clause to the query using the Position relation
 * @method PositionTenureQuery rightJoinPosition($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Position relation
 * @method PositionTenureQuery innerJoinPosition($relationAlias = null) Adds a INNER JOIN clause to the query using the Position relation
 *
 * @method PositionTenure findOne(PropelPDO $con = null) Return the first PositionTenure matching the query
 * @method PositionTenure findOneOrCreate(PropelPDO $con = null) Return the first PositionTenure matching the query, or a new PositionTenure object populated from the query conditions when no match is found
 *
 * @method PositionTenure findOneById(int $id) Return the first PositionTenure filtered by the id column
 * @method PositionTenure findOneByUserid(int $userId) Return the first PositionTenure filtered by the userId column
 * @method PositionTenure findOneByName(string $name) Return the first PositionTenure filtered by the name column
 * @method PositionTenure findOneByDatefrom(string $dateFrom) Return the first PositionTenure filtered by the dateFrom column
 * @method PositionTenure findOneByDateto(string $dateTo) Return the first PositionTenure filtered by the dateTo column
 * @method PositionTenure findOneByPositioncode(int $positionCode) Return the first PositionTenure filtered by the positionCode column
 * @method PositionTenure findOneByOwnername(string $ownerName) Return the first PositionTenure filtered by the ownerName column
 * @method PositionTenure findOneByObjecttype(string $objectType) Return the first PositionTenure filtered by the objectType column
 * @method PositionTenure findOneByObjectid(int $objectId) Return the first PositionTenure filtered by the objectId column
 *
 * @method array findById(int $id) Return PositionTenure objects filtered by the id column
 * @method array findByUserid(int $userId) Return PositionTenure objects filtered by the userId column
 * @method array findByName(string $name) Return PositionTenure objects filtered by the name column
 * @method array findByDatefrom(string $dateFrom) Return PositionTenure objects filtered by the dateFrom column
 * @method array findByDateto(string $dateTo) Return PositionTenure objects filtered by the dateTo column
 * @method array findByPositioncode(int $positionCode) Return PositionTenure objects filtered by the positionCode column
 * @method array findByOwnername(string $ownerName) Return PositionTenure objects filtered by the ownerName column
 * @method array findByObjecttype(string $objectType) Return PositionTenure objects filtered by the objectType column
 * @method array findByObjectid(int $objectId) Return PositionTenure objects filtered by the objectId column
 *
 * @package    propel.generator.positions.classes.om
 */
abstract class BasePositionTenureQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BasePositionTenureQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'PositionTenure', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new PositionTenureQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     PositionTenureQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return PositionTenureQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof PositionTenureQuery) {
            return $criteria;
        }
        $query = new PositionTenureQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   PositionTenure|PositionTenure[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = PositionTenurePeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(PositionTenurePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   PositionTenure A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `USERID`, `NAME`, `DATEFROM`, `DATETO`, `POSITIONCODE`, `OWNERNAME`, `OBJECTTYPE`, `OBJECTID` FROM `positions_positionTenure` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new PositionTenure();
            $obj->hydrate($row);
            PositionTenurePeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return PositionTenure|PositionTenure[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|PositionTenure[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return PositionTenureQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(PositionTenurePeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return PositionTenureQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(PositionTenurePeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionTenureQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(PositionTenurePeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the userId column
     *
     * Example usage:
     * <code>
     * $query->filterByUserid(1234); // WHERE userId = 1234
     * $query->filterByUserid(array(12, 34)); // WHERE userId IN (12, 34)
     * $query->filterByUserid(array('min' => 12)); // WHERE userId > 12
     * </code>
     *
     * @param     mixed $userid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionTenureQuery The current query, for fluid interface
     */
    public function filterByUserid($userid = null, $comparison = null)
    {
        if (is_array($userid)) {
            $useMinMax = false;
            if (isset($userid['min'])) {
                $this->addUsingAlias(PositionTenurePeer::USERID, $userid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($userid['max'])) {
                $this->addUsingAlias(PositionTenurePeer::USERID, $userid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionTenurePeer::USERID, $userid, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionTenureQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(PositionTenurePeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the dateFrom column
     *
     * Example usage:
     * <code>
     * $query->filterByDatefrom('2011-03-14'); // WHERE dateFrom = '2011-03-14'
     * $query->filterByDatefrom('now'); // WHERE dateFrom = '2011-03-14'
     * $query->filterByDatefrom(array('max' => 'yesterday')); // WHERE dateFrom > '2011-03-13'
     * </code>
     *
     * @param     mixed $datefrom The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionTenureQuery The current query, for fluid interface
     */
    public function filterByDatefrom($datefrom = null, $comparison = null)
    {
        if (is_array($datefrom)) {
            $useMinMax = false;
            if (isset($datefrom['min'])) {
                $this->addUsingAlias(PositionTenurePeer::DATEFROM, $datefrom['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($datefrom['max'])) {
                $this->addUsingAlias(PositionTenurePeer::DATEFROM, $datefrom['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionTenurePeer::DATEFROM, $datefrom, $comparison);
    }

    /**
     * Filter the query on the dateTo column
     *
     * Example usage:
     * <code>
     * $query->filterByDateto('2011-03-14'); // WHERE dateTo = '2011-03-14'
     * $query->filterByDateto('now'); // WHERE dateTo = '2011-03-14'
     * $query->filterByDateto(array('max' => 'yesterday')); // WHERE dateTo > '2011-03-13'
     * </code>
     *
     * @param     mixed $dateto The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionTenureQuery The current query, for fluid interface
     */
    public function filterByDateto($dateto = null, $comparison = null)
    {
        if (is_array($dateto)) {
            $useMinMax = false;
            if (isset($dateto['min'])) {
                $this->addUsingAlias(PositionTenurePeer::DATETO, $dateto['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($dateto['max'])) {
                $this->addUsingAlias(PositionTenurePeer::DATETO, $dateto['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionTenurePeer::DATETO, $dateto, $comparison);
    }

    /**
     * Filter the query on the positionCode column
     *
     * Example usage:
     * <code>
     * $query->filterByPositioncode(1234); // WHERE positionCode = 1234
     * $query->filterByPositioncode(array(12, 34)); // WHERE positionCode IN (12, 34)
     * $query->filterByPositioncode(array('min' => 12)); // WHERE positionCode > 12
     * </code>
     *
     * @see       filterByPosition()
     *
     * @param     mixed $positioncode The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionTenureQuery The current query, for fluid interface
     */
    public function filterByPositioncode($positioncode = null, $comparison = null)
    {
        if (is_array($positioncode)) {
            $useMinMax = false;
            if (isset($positioncode['min'])) {
                $this->addUsingAlias(PositionTenurePeer::POSITIONCODE, $positioncode['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($positioncode['max'])) {
                $this->addUsingAlias(PositionTenurePeer::POSITIONCODE, $positioncode['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionTenurePeer::POSITIONCODE, $positioncode, $comparison);
    }

    /**
     * Filter the query on the ownerName column
     *
     * Example usage:
     * <code>
     * $query->filterByOwnername('fooValue');   // WHERE ownerName = 'fooValue'
     * $query->filterByOwnername('%fooValue%'); // WHERE ownerName LIKE '%fooValue%'
     * </code>
     *
     * @param     string $ownername The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionTenureQuery The current query, for fluid interface
     */
    public function filterByOwnername($ownername = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($ownername)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $ownername)) {
                $ownername = str_replace('*', '%', $ownername);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(PositionTenurePeer::OWNERNAME, $ownername, $comparison);
    }

    /**
     * Filter the query on the objectType column
     *
     * Example usage:
     * <code>
     * $query->filterByObjecttype('fooValue');   // WHERE objectType = 'fooValue'
     * $query->filterByObjecttype('%fooValue%'); // WHERE objectType LIKE '%fooValue%'
     * </code>
     *
     * @param     string $objecttype The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionTenureQuery The current query, for fluid interface
     */
    public function filterByObjecttype($objecttype = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($objecttype)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $objecttype)) {
                $objecttype = str_replace('*', '%', $objecttype);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(PositionTenurePeer::OBJECTTYPE, $objecttype, $comparison);
    }

    /**
     * Filter the query on the objectId column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectid(1234); // WHERE objectId = 1234
     * $query->filterByObjectid(array(12, 34)); // WHERE objectId IN (12, 34)
     * $query->filterByObjectid(array('min' => 12)); // WHERE objectId > 12
     * </code>
     *
     * @param     mixed $objectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PositionTenureQuery The current query, for fluid interface
     */
    public function filterByObjectid($objectid = null, $comparison = null)
    {
        if (is_array($objectid)) {
            $useMinMax = false;
            if (isset($objectid['min'])) {
                $this->addUsingAlias(PositionTenurePeer::OBJECTID, $objectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($objectid['max'])) {
                $this->addUsingAlias(PositionTenurePeer::OBJECTID, $objectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PositionTenurePeer::OBJECTID, $objectid, $comparison);
    }

    /**
     * Filter the query by a related Position object
     *
     * @param   Position|PropelObjectCollection $position The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PositionTenureQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPosition($position, $comparison = null)
    {
        if ($position instanceof Position) {
            return $this
                ->addUsingAlias(PositionTenurePeer::POSITIONCODE, $position->getCode(), $comparison);
        } elseif ($position instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(PositionTenurePeer::POSITIONCODE, $position->toKeyValue('PrimaryKey', 'Code'), $comparison);
        } else {
            throw new PropelException('filterByPosition() only accepts arguments of type Position or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Position relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PositionTenureQuery The current query, for fluid interface
     */
    public function joinPosition($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Position');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Position');
        }

        return $this;
    }

    /**
     * Use the Position relation Position object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PositionQuery A secondary query class using the current class as primary query
     */
    public function usePositionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPosition($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Position', 'PositionQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   PositionTenure $positionTenure Object to remove from the list of results
     *
     * @return PositionTenureQuery The current query, for fluid interface
     */
    public function prune($positionTenure = null)
    {
        if ($positionTenure) {
            $this->addUsingAlias(PositionTenurePeer::ID, $positionTenure->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
