<?php


/**
 * Base static class for performing query and update operations on the 'panel_reportSection' table.
 *
 * Seccion de reporte al BM
 *
 * @package propel.generator.panel.classes.om
 */
abstract class BaseReportSectionPeer
{

    /** the default database name for this class */
    const DATABASE_NAME = 'application';

    /** the table name for this class */
    const TABLE_NAME = 'panel_reportSection';

    /** the related Propel class for this table */
    const OM_CLASS = 'ReportSection';

    /** the related TableMap class for this table */
    const TM_CLASS = 'ReportSectionTableMap';

    /** The total number of columns. */
    const NUM_COLUMNS = 15;

    /** The number of lazy-loaded columns. */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /** The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS) */
    const NUM_HYDRATE_COLUMNS = 15;

    /** the column name for the ID field */
    const ID = 'panel_reportSection.ID';

    /** the column name for the CODE field */
    const CODE = 'panel_reportSection.CODE';

    /** the column name for the NAME field */
    const NAME = 'panel_reportSection.NAME';

    /** the column name for the VERSIONID field */
    const VERSIONID = 'panel_reportSection.VERSIONID';

    /** the column name for the TYPE field */
    const TYPE = 'panel_reportSection.TYPE';

    /** the column name for the CONTENT field */
    const CONTENT = 'panel_reportSection.CONTENT';

    /** the column name for the ENVIROMENTALSUPERVISION field */
    const ENVIROMENTALSUPERVISION = 'panel_reportSection.ENVIROMENTALSUPERVISION';

    /** the column name for the OBJECTTYPE field */
    const OBJECTTYPE = 'panel_reportSection.OBJECTTYPE';

    /** the column name for the OBJECTID field */
    const OBJECTID = 'panel_reportSection.OBJECTID';

    /** the column name for the COMPLETED field */
    const COMPLETED = 'panel_reportSection.COMPLETED';

    /** the column name for the UPDATED field */
    const UPDATED = 'panel_reportSection.UPDATED';

    /** the column name for the TREE_LEFT field */
    const TREE_LEFT = 'panel_reportSection.TREE_LEFT';

    /** the column name for the TREE_RIGHT field */
    const TREE_RIGHT = 'panel_reportSection.TREE_RIGHT';

    /** the column name for the TREE_LEVEL field */
    const TREE_LEVEL = 'panel_reportSection.TREE_LEVEL';

    /** the column name for the DELETED_AT field */
    const DELETED_AT = 'panel_reportSection.DELETED_AT';

    /** The default string format for model objects of the related table **/
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * An identiy map to hold any loaded instances of ReportSection objects.
     * This must be public so that other peer classes can access this when hydrating from JOIN
     * queries.
     * @var        array ReportSection[]
     */
    public static $instances = array();


    // nested_set behavior

    /**
     * Left column for the set
     */
    const LEFT_COL = 'panel_reportSection.TREE_LEFT';

    /**
     * Right column for the set
     */
    const RIGHT_COL = 'panel_reportSection.TREE_RIGHT';

    /**
     * Level column for the set
     */
    const LEVEL_COL = 'panel_reportSection.TREE_LEVEL';

    /**
     * Scope column for the set
     */
    const SCOPE_COL = 'panel_reportSection.VERSIONID';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. ReportSectionPeer::$fieldNames[ReportSectionPeer::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        BasePeer::TYPE_PHPNAME => array ('Id', 'Code', 'Name', 'Versionid', 'Type', 'Content', 'Enviromentalsupervision', 'Objecttype', 'Objectid', 'Completed', 'Updated', 'TreeLeft', 'TreeRight', 'TreeLevel', 'DeletedAt', ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id', 'code', 'name', 'versionid', 'type', 'content', 'enviromentalsupervision', 'objecttype', 'objectid', 'completed', 'updated', 'treeLeft', 'treeRight', 'treeLevel', 'deletedAt', ),
        BasePeer::TYPE_COLNAME => array (ReportSectionPeer::ID, ReportSectionPeer::CODE, ReportSectionPeer::NAME, ReportSectionPeer::VERSIONID, ReportSectionPeer::TYPE, ReportSectionPeer::CONTENT, ReportSectionPeer::ENVIROMENTALSUPERVISION, ReportSectionPeer::OBJECTTYPE, ReportSectionPeer::OBJECTID, ReportSectionPeer::COMPLETED, ReportSectionPeer::UPDATED, ReportSectionPeer::TREE_LEFT, ReportSectionPeer::TREE_RIGHT, ReportSectionPeer::TREE_LEVEL, ReportSectionPeer::DELETED_AT, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID', 'CODE', 'NAME', 'VERSIONID', 'TYPE', 'CONTENT', 'ENVIROMENTALSUPERVISION', 'OBJECTTYPE', 'OBJECTID', 'COMPLETED', 'UPDATED', 'TREE_LEFT', 'TREE_RIGHT', 'TREE_LEVEL', 'DELETED_AT', ),
        BasePeer::TYPE_FIELDNAME => array ('id', 'code', 'name', 'versionId', 'type', 'content', 'enviromentalSupervision', 'objectType', 'objectId', 'completed', 'updated', 'tree_left', 'tree_right', 'tree_level', 'deleted_at', ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. ReportSectionPeer::$fieldNames[BasePeer::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        BasePeer::TYPE_PHPNAME => array ('Id' => 0, 'Code' => 1, 'Name' => 2, 'Versionid' => 3, 'Type' => 4, 'Content' => 5, 'Enviromentalsupervision' => 6, 'Objecttype' => 7, 'Objectid' => 8, 'Completed' => 9, 'Updated' => 10, 'TreeLeft' => 11, 'TreeRight' => 12, 'TreeLevel' => 13, 'DeletedAt' => 14, ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id' => 0, 'code' => 1, 'name' => 2, 'versionid' => 3, 'type' => 4, 'content' => 5, 'enviromentalsupervision' => 6, 'objecttype' => 7, 'objectid' => 8, 'completed' => 9, 'updated' => 10, 'treeLeft' => 11, 'treeRight' => 12, 'treeLevel' => 13, 'deletedAt' => 14, ),
        BasePeer::TYPE_COLNAME => array (ReportSectionPeer::ID => 0, ReportSectionPeer::CODE => 1, ReportSectionPeer::NAME => 2, ReportSectionPeer::VERSIONID => 3, ReportSectionPeer::TYPE => 4, ReportSectionPeer::CONTENT => 5, ReportSectionPeer::ENVIROMENTALSUPERVISION => 6, ReportSectionPeer::OBJECTTYPE => 7, ReportSectionPeer::OBJECTID => 8, ReportSectionPeer::COMPLETED => 9, ReportSectionPeer::UPDATED => 10, ReportSectionPeer::TREE_LEFT => 11, ReportSectionPeer::TREE_RIGHT => 12, ReportSectionPeer::TREE_LEVEL => 13, ReportSectionPeer::DELETED_AT => 14, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID' => 0, 'CODE' => 1, 'NAME' => 2, 'VERSIONID' => 3, 'TYPE' => 4, 'CONTENT' => 5, 'ENVIROMENTALSUPERVISION' => 6, 'OBJECTTYPE' => 7, 'OBJECTID' => 8, 'COMPLETED' => 9, 'UPDATED' => 10, 'TREE_LEFT' => 11, 'TREE_RIGHT' => 12, 'TREE_LEVEL' => 13, 'DELETED_AT' => 14, ),
        BasePeer::TYPE_FIELDNAME => array ('id' => 0, 'code' => 1, 'name' => 2, 'versionId' => 3, 'type' => 4, 'content' => 5, 'enviromentalSupervision' => 6, 'objectType' => 7, 'objectId' => 8, 'completed' => 9, 'updated' => 10, 'tree_left' => 11, 'tree_right' => 12, 'tree_level' => 13, 'deleted_at' => 14, ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, )
    );

    /**
     * Translates a fieldname to another type
     *
     * @param      string $name field name
     * @param      string $fromType One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                         BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @param      string $toType   One of the class type constants
     * @return string          translated name of the field.
     * @throws PropelException - if the specified name could not be found in the fieldname mappings.
     */
    public static function translateFieldName($name, $fromType, $toType)
    {
        $toNames = ReportSectionPeer::getFieldNames($toType);
        $key = isset(ReportSectionPeer::$fieldKeys[$fromType][$name]) ? ReportSectionPeer::$fieldKeys[$fromType][$name] : null;
        if ($key === null) {
            throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(ReportSectionPeer::$fieldKeys[$fromType], true));
        }

        return $toNames[$key];
    }

    /**
     * Returns an array of field names.
     *
     * @param      string $type The type of fieldnames to return:
     *                      One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                      BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @return array           A list of field names
     * @throws PropelException - if the type is not valid.
     */
    public static function getFieldNames($type = BasePeer::TYPE_PHPNAME)
    {
        if (!array_key_exists($type, ReportSectionPeer::$fieldNames)) {
            throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME, BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. ' . $type . ' was given.');
        }

        return ReportSectionPeer::$fieldNames[$type];
    }

    /**
     * Convenience method which changes table.column to alias.column.
     *
     * Using this method you can maintain SQL abstraction while using column aliases.
     * <code>
     *		$c->addAlias("alias1", TablePeer::TABLE_NAME);
     *		$c->addJoin(TablePeer::alias("alias1", TablePeer::PRIMARY_KEY_COLUMN), TablePeer::PRIMARY_KEY_COLUMN);
     * </code>
     * @param      string $alias The alias for the current table.
     * @param      string $column The column name for current table. (i.e. ReportSectionPeer::COLUMN_NAME).
     * @return string
     */
    public static function alias($alias, $column)
    {
        return str_replace(ReportSectionPeer::TABLE_NAME.'.', $alias.'.', $column);
    }

    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param      Criteria $criteria object containing the columns to add.
     * @param      string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(ReportSectionPeer::ID);
            $criteria->addSelectColumn(ReportSectionPeer::CODE);
            $criteria->addSelectColumn(ReportSectionPeer::NAME);
            $criteria->addSelectColumn(ReportSectionPeer::VERSIONID);
            $criteria->addSelectColumn(ReportSectionPeer::TYPE);
            $criteria->addSelectColumn(ReportSectionPeer::CONTENT);
            $criteria->addSelectColumn(ReportSectionPeer::ENVIROMENTALSUPERVISION);
            $criteria->addSelectColumn(ReportSectionPeer::OBJECTTYPE);
            $criteria->addSelectColumn(ReportSectionPeer::OBJECTID);
            $criteria->addSelectColumn(ReportSectionPeer::COMPLETED);
            $criteria->addSelectColumn(ReportSectionPeer::UPDATED);
            $criteria->addSelectColumn(ReportSectionPeer::TREE_LEFT);
            $criteria->addSelectColumn(ReportSectionPeer::TREE_RIGHT);
            $criteria->addSelectColumn(ReportSectionPeer::TREE_LEVEL);
            $criteria->addSelectColumn(ReportSectionPeer::DELETED_AT);
        } else {
            $criteria->addSelectColumn($alias . '.ID');
            $criteria->addSelectColumn($alias . '.CODE');
            $criteria->addSelectColumn($alias . '.NAME');
            $criteria->addSelectColumn($alias . '.VERSIONID');
            $criteria->addSelectColumn($alias . '.TYPE');
            $criteria->addSelectColumn($alias . '.CONTENT');
            $criteria->addSelectColumn($alias . '.ENVIROMENTALSUPERVISION');
            $criteria->addSelectColumn($alias . '.OBJECTTYPE');
            $criteria->addSelectColumn($alias . '.OBJECTID');
            $criteria->addSelectColumn($alias . '.COMPLETED');
            $criteria->addSelectColumn($alias . '.UPDATED');
            $criteria->addSelectColumn($alias . '.TREE_LEFT');
            $criteria->addSelectColumn($alias . '.TREE_RIGHT');
            $criteria->addSelectColumn($alias . '.TREE_LEVEL');
            $criteria->addSelectColumn($alias . '.DELETED_AT');
        }
    }

    /**
     * Returns the number of rows matching criteria.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @return int Number of matching rows.
     */
    public static function doCount(Criteria $criteria, $distinct = false, PropelPDO $con = null)
    {
        // we may modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ReportSectionPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ReportSectionPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count
        $criteria->setDbName(ReportSectionPeer::DATABASE_NAME); // Set the correct dbName

        if ($con === null) {
            $con = Propel::getConnection(ReportSectionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        // soft_delete behavior
        if (ReportSectionQuery::isSoftDeleteEnabled()) {
            $criteria->add(ReportSectionPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ReportSectionPeer::enableSoftDelete();
        }
        // BasePeer returns a PDOStatement
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }
    /**
     * Selects one object from the DB.
     *
     * @param      Criteria $criteria object used to create the SELECT statement.
     * @param      PropelPDO $con
     * @return                 ReportSection
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectOne(Criteria $criteria, PropelPDO $con = null)
    {
        $critcopy = clone $criteria;
        $critcopy->setLimit(1);
        $objects = ReportSectionPeer::doSelect($critcopy, $con);
        if ($objects) {
            return $objects[0];
        }

        return null;
    }
    /**
     * Selects several row from the DB.
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con
     * @return array           Array of selected Objects
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelect(Criteria $criteria, PropelPDO $con = null)
    {
        return ReportSectionPeer::populateObjects(ReportSectionPeer::doSelectStmt($criteria, $con));
    }
    /**
     * Prepares the Criteria object and uses the parent doSelect() method to execute a PDOStatement.
     *
     * Use this method directly if you want to work with an executed statement durirectly (for example
     * to perform your own object hydration).
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con The connection to use
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return PDOStatement The executed PDOStatement object.
     * @see        BasePeer::doSelect()
     */
    public static function doSelectStmt(Criteria $criteria, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ReportSectionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        if (!$criteria->hasSelectClause()) {
            $criteria = clone $criteria;
            ReportSectionPeer::addSelectColumns($criteria);
        }

        // Set the correct dbName
        $criteria->setDbName(ReportSectionPeer::DATABASE_NAME);
        // soft_delete behavior
        if (ReportSectionQuery::isSoftDeleteEnabled()) {
            $criteria->add(ReportSectionPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ReportSectionPeer::enableSoftDelete();
        }

        // BasePeer returns a PDOStatement
        return BasePeer::doSelect($criteria, $con);
    }
    /**
     * Adds an object to the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doSelect*()
     * methods in your stub classes -- you may need to explicitly add objects
     * to the cache in order to ensure that the same objects are always returned by doSelect*()
     * and retrieveByPK*() calls.
     *
     * @param      ReportSection $obj A ReportSection object.
     * @param      string $key (optional) key to use for instance map (for performance boost if key was already calculated externally).
     */
    public static function addInstanceToPool($obj, $key = null)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if ($key === null) {
                $key = (string) $obj->getId();
            } // if key === null
            ReportSectionPeer::$instances[$key] = $obj;
        }
    }

    /**
     * Removes an object from the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doDelete
     * methods in your stub classes -- you may need to explicitly remove objects
     * from the cache in order to prevent returning objects that no longer exist.
     *
     * @param      mixed $value A ReportSection object or a primary key value.
     *
     * @return void
     * @throws PropelException - if the value is invalid.
     */
    public static function removeInstanceFromPool($value)
    {
        if (Propel::isInstancePoolingEnabled() && $value !== null) {
            if (is_object($value) && $value instanceof ReportSection) {
                $key = (string) $value->getId();
            } elseif (is_scalar($value)) {
                // assume we've been passed a primary key
                $key = (string) $value;
            } else {
                $e = new PropelException("Invalid value passed to removeInstanceFromPool().  Expected primary key or ReportSection object; got " . (is_object($value) ? get_class($value) . ' object.' : var_export($value,true)));
                throw $e;
            }

            unset(ReportSectionPeer::$instances[$key]);
        }
    } // removeInstanceFromPool()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      string $key The key (@see getPrimaryKeyHash()) for this instance.
     * @return   ReportSection Found object or null if 1) no instance exists for specified key or 2) instance pooling has been disabled.
     * @see        getPrimaryKeyHash()
     */
    public static function getInstanceFromPool($key)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if (isset(ReportSectionPeer::$instances[$key])) {
                return ReportSectionPeer::$instances[$key];
            }
        }

        return null; // just to be explicit
    }

    /**
     * Clear the instance pool.
     *
     * @return void
     */
    public static function clearInstancePool()
    {
        ReportSectionPeer::$instances = array();
    }

    /**
     * Method to invalidate the instance pool of all tables related to panel_reportSection
     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool()
    {
        // Invalidate objects in ReportSectionDocumentPeer instance pool,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        ReportSectionDocumentPeer::clearInstancePool();
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return string A string version of PK or null if the components of primary key in result array are all null.
     */
    public static function getPrimaryKeyHashFromRow($row, $startcol = 0)
    {
        // If the PK cannot be derived from the row, return null.
        if ($row[$startcol] === null) {
            return null;
        }

        return (string) $row[$startcol];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $startcol = 0)
    {

        return (int) $row[$startcol];
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function populateObjects(PDOStatement $stmt)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = ReportSectionPeer::getOMClass();
        // populate the object(s)
        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key = ReportSectionPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj = ReportSectionPeer::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                ReportSectionPeer::addInstanceToPool($obj, $key);
            } // if key exists
        }
        $stmt->closeCursor();

        return $results;
    }
    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return array (ReportSection object, last column rank)
     */
    public static function populateObject($row, $startcol = 0)
    {
        $key = ReportSectionPeer::getPrimaryKeyHashFromRow($row, $startcol);
        if (null !== ($obj = ReportSectionPeer::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $startcol, true); // rehydrate
            $col = $startcol + ReportSectionPeer::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = ReportSectionPeer::OM_CLASS;
            $obj = new $cls();
            $col = $obj->hydrate($row, $startcol);
            ReportSectionPeer::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }


    /**
     * Returns the number of rows matching criteria, joining the related ReportVersion table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinReportVersion(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ReportSectionPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ReportSectionPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ReportSectionPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ReportSectionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ReportSectionPeer::VERSIONID, ReportVersionPeer::ID, $join_behavior);

        // soft_delete behavior
        if (ReportSectionQuery::isSoftDeleteEnabled()) {
            $criteria->add(ReportSectionPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ReportSectionPeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Selects a collection of ReportSection objects pre-filled with their ReportVersion objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ReportSection objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinReportVersion(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ReportSectionPeer::DATABASE_NAME);
        }

        ReportSectionPeer::addSelectColumns($criteria);
        $startcol = ReportSectionPeer::NUM_HYDRATE_COLUMNS;
        ReportVersionPeer::addSelectColumns($criteria);

        $criteria->addJoin(ReportSectionPeer::VERSIONID, ReportVersionPeer::ID, $join_behavior);

        // soft_delete behavior
        if (ReportSectionQuery::isSoftDeleteEnabled()) {
            $criteria->add(ReportSectionPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ReportSectionPeer::enableSoftDelete();
        }
        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ReportSectionPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ReportSectionPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = ReportSectionPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ReportSectionPeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = ReportVersionPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = ReportVersionPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = ReportVersionPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    ReportVersionPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (ReportSection) to $obj2 (ReportVersion)
                $obj2->addReportSection($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Returns the number of rows matching criteria, joining all related tables
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAll(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ReportSectionPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ReportSectionPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ReportSectionPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ReportSectionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ReportSectionPeer::VERSIONID, ReportVersionPeer::ID, $join_behavior);

        // soft_delete behavior
        if (ReportSectionQuery::isSoftDeleteEnabled()) {
            $criteria->add(ReportSectionPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ReportSectionPeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }

    /**
     * Selects a collection of ReportSection objects pre-filled with all related objects.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ReportSection objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAll(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ReportSectionPeer::DATABASE_NAME);
        }

        ReportSectionPeer::addSelectColumns($criteria);
        $startcol2 = ReportSectionPeer::NUM_HYDRATE_COLUMNS;

        ReportVersionPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + ReportVersionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ReportSectionPeer::VERSIONID, ReportVersionPeer::ID, $join_behavior);

        // soft_delete behavior
        if (ReportSectionQuery::isSoftDeleteEnabled()) {
            $criteria->add(ReportSectionPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ReportSectionPeer::enableSoftDelete();
        }
        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ReportSectionPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ReportSectionPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ReportSectionPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ReportSectionPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

            // Add objects for joined ReportVersion rows

            $key2 = ReportVersionPeer::getPrimaryKeyHashFromRow($row, $startcol2);
            if ($key2 !== null) {
                $obj2 = ReportVersionPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = ReportVersionPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    ReportVersionPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 loaded

                // Add the $obj1 (ReportSection) to the collection in $obj2 (ReportVersion)
                $obj2->addReportSection($obj1);
            } // if joined row not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }

    /**
     * Returns the TableMap related to this peer.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getDatabaseMap(ReportSectionPeer::DATABASE_NAME)->getTable(ReportSectionPeer::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this peer class.
     */
    public static function buildTableMap()
    {
      $dbMap = Propel::getDatabaseMap(BaseReportSectionPeer::DATABASE_NAME);
      if (!$dbMap->hasTable(BaseReportSectionPeer::TABLE_NAME)) {
        $dbMap->addTableObject(new ReportSectionTableMap());
      }
    }

    /**
     * The class that the Peer will make instances of.
     *
     *
     * @return string ClassName
     */
    public static function getOMClass()
    {
        return ReportSectionPeer::OM_CLASS;
    }

    /**
     * Performs an INSERT on the database, given a ReportSection or Criteria object.
     *
     * @param      mixed $values Criteria or ReportSection object containing data that is used to create the INSERT statement.
     * @param      PropelPDO $con the PropelPDO connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doInsert($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ReportSectionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity
        } else {
            $criteria = $values->buildCriteria(); // build Criteria from ReportSection object
        }

        if ($criteria->containsKey(ReportSectionPeer::ID) && $criteria->keyContainsValue(ReportSectionPeer::ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.ReportSectionPeer::ID.')');
        }


        // Set the correct dbName
        $criteria->setDbName(ReportSectionPeer::DATABASE_NAME);

        try {
            // use transaction because $criteria could contain info
            // for more than one table (I guess, conceivably)
            $con->beginTransaction();
            $pk = BasePeer::doInsert($criteria, $con);
            $con->commit();
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }

        return $pk;
    }

    /**
     * Performs an UPDATE on the database, given a ReportSection or Criteria object.
     *
     * @param      mixed $values Criteria or ReportSection object containing data that is used to create the UPDATE statement.
     * @param      PropelPDO $con The connection to use (specify PropelPDO connection object to exert more control over transactions).
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doUpdate($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ReportSectionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $selectCriteria = new Criteria(ReportSectionPeer::DATABASE_NAME);

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity

            $comparison = $criteria->getComparison(ReportSectionPeer::ID);
            $value = $criteria->remove(ReportSectionPeer::ID);
            if ($value) {
                $selectCriteria->add(ReportSectionPeer::ID, $value, $comparison);
            } else {
                $selectCriteria->setPrimaryTableName(ReportSectionPeer::TABLE_NAME);
            }

        } else { // $values is ReportSection object
            $criteria = $values->buildCriteria(); // gets full criteria
            $selectCriteria = $values->buildPkeyCriteria(); // gets criteria w/ primary key(s)
        }

        // set the correct dbName
        $criteria->setDbName(ReportSectionPeer::DATABASE_NAME);

        return BasePeer::doUpdate($selectCriteria, $criteria, $con);
    }

    /**
     * Deletes all rows from the panel_reportSection table.
     *
     * @param      PropelPDO $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException
     */
    public static function doForceDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ReportSectionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $affectedRows = 0; // initialize var to track total num of affected rows
        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();
            $affectedRows += ReportSectionPeer::doOnDeleteCascade(new Criteria(ReportSectionPeer::DATABASE_NAME), $con);
            $affectedRows += BasePeer::doDeleteAll(ReportSectionPeer::TABLE_NAME, $con, ReportSectionPeer::DATABASE_NAME);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ReportSectionPeer::clearInstancePool();
            ReportSectionPeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs a DELETE on the database, given a ReportSection or Criteria object OR a primary key value.
     *
     * @param      mixed $values Criteria or ReportSection object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param      PropelPDO $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *				if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
     public static function doForceDelete($values, PropelPDO $con = null)
     {
        if ($con === null) {
            $con = Propel::getConnection(ReportSectionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = clone $values;
        } elseif ($values instanceof ReportSection) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(ReportSectionPeer::DATABASE_NAME);
            $criteria->add(ReportSectionPeer::ID, (array) $values, Criteria::IN);
        }

        // Set the correct dbName
        $criteria->setDbName(ReportSectionPeer::DATABASE_NAME);

        $affectedRows = 0; // initialize var to track total num of affected rows

        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();

            // cloning the Criteria in case it's modified by doSelect() or doSelectStmt()
            $c = clone $criteria;
            $affectedRows += ReportSectionPeer::doOnDeleteCascade($c, $con);

            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            if ($values instanceof Criteria) {
                ReportSectionPeer::clearInstancePool();
            } elseif ($values instanceof ReportSection) { // it's a model object
                ReportSectionPeer::removeInstanceFromPool($values);
            } else { // it's a primary key, or an array of pks
                foreach ((array) $values as $singleval) {
                    ReportSectionPeer::removeInstanceFromPool($singleval);
                }
            }

            $affectedRows += BasePeer::doDelete($criteria, $con);
            ReportSectionPeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * This is a method for emulating ON DELETE CASCADE for DBs that don't support this
     * feature (like MySQL or SQLite).
     *
     * This method is not very speedy because it must perform a query first to get
     * the implicated records and then perform the deletes by calling those Peer classes.
     *
     * This method should be used within a transaction if possible.
     *
     * @param      Criteria $criteria
     * @param      PropelPDO $con
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    protected static function doOnDeleteCascade(Criteria $criteria, PropelPDO $con)
    {
        // initialize var to track total num of affected rows
        $affectedRows = 0;

        // first find the objects that are implicated by the $criteria
        $objects = ReportSectionPeer::doSelect($criteria, $con);
        foreach ($objects as $obj) {


            // delete related ReportSectionDocument objects
            $criteria = new Criteria(ReportSectionDocumentPeer::DATABASE_NAME);

            $criteria->add(ReportSectionDocumentPeer::REPORTSECTIONID, $obj->getId());
            $affectedRows += ReportSectionDocumentPeer::doDelete($criteria, $con);
        }

        return $affectedRows;
    }

    /**
     * Validates all modified columns of given ReportSection object.
     * If parameter $columns is either a single column name or an array of column names
     * than only those columns are validated.
     *
     * NOTICE: This does not apply to primary or foreign keys for now.
     *
     * @param      ReportSection $obj The object to validate.
     * @param      mixed $cols Column name or array of column names.
     *
     * @return mixed TRUE if all columns are valid or the error message of the first invalid column.
     */
    public static function doValidate($obj, $cols = null)
    {
        $columns = array();

        if ($cols) {
            $dbMap = Propel::getDatabaseMap(ReportSectionPeer::DATABASE_NAME);
            $tableMap = $dbMap->getTable(ReportSectionPeer::TABLE_NAME);

            if (! is_array($cols)) {
                $cols = array($cols);
            }

            foreach ($cols as $colName) {
                if ($tableMap->hasColumn($colName)) {
                    $get = 'get' . $tableMap->getColumn($colName)->getPhpName();
                    $columns[$colName] = $obj->$get();
                }
            }
        } else {

        }

        return BasePeer::doValidate(ReportSectionPeer::DATABASE_NAME, ReportSectionPeer::TABLE_NAME, $columns);
    }

    /**
     * Retrieve a single object by pkey.
     *
     * @param      int $pk the primary key.
     * @param      PropelPDO $con the connection to use
     * @return ReportSection
     */
    public static function retrieveByPK($pk, PropelPDO $con = null)
    {

        if (null !== ($obj = ReportSectionPeer::getInstanceFromPool((string) $pk))) {
            return $obj;
        }

        if ($con === null) {
            $con = Propel::getConnection(ReportSectionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria = new Criteria(ReportSectionPeer::DATABASE_NAME);
        $criteria->add(ReportSectionPeer::ID, $pk);

        $v = ReportSectionPeer::doSelect($criteria, $con);

        return !empty($v) > 0 ? $v[0] : null;
    }

    /**
     * Retrieve multiple objects by pkey.
     *
     * @param      array $pks List of primary keys
     * @param      PropelPDO $con the connection to use
     * @return ReportSection[]
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function retrieveByPKs($pks, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ReportSectionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $objs = null;
        if (empty($pks)) {
            $objs = array();
        } else {
            $criteria = new Criteria(ReportSectionPeer::DATABASE_NAME);
            $criteria->add(ReportSectionPeer::ID, $pks, Criteria::IN);
            $objs = ReportSectionPeer::doSelect($criteria, $con);
        }

        return $objs;
    }

    // nested_set behavior

    /**
     * Returns the root nodes for the tree
     *
     * @param      PropelPDO $con	Connection to use.
     * @return     ReportSection			Propel object for root node
     */
    public static function retrieveRoots(Criteria $criteria = null, PropelPDO $con = null)
    {
        if ($criteria === null) {
            $criteria = new Criteria(ReportSectionPeer::DATABASE_NAME);
        }
        $criteria->add(ReportSectionPeer::LEFT_COL, 1, Criteria::EQUAL);

        return ReportSectionPeer::doSelect($criteria, $con);
    }

    /**
     * Returns the root node for a given scope
     *
     * @param      int $scope		Scope to determine which root node to return
     * @param      PropelPDO $con	Connection to use.
     * @return     ReportSection			Propel object for root node
     */
    public static function retrieveRoot($scope = null, PropelPDO $con = null)
    {
        $c = new Criteria(ReportSectionPeer::DATABASE_NAME);
        $c->add(ReportSectionPeer::LEFT_COL, 1, Criteria::EQUAL);
        $c->add(ReportSectionPeer::SCOPE_COL, $scope, Criteria::EQUAL);

        return ReportSectionPeer::doSelectOne($c, $con);
    }

    /**
     * Returns the whole tree node for a given scope
     *
     * @param      int $scope		Scope to determine which root node to return
     * @param      Criteria $criteria	Optional Criteria to filter the query
     * @param      PropelPDO $con	Connection to use.
     * @return     ReportSection			Propel object for root node
     */
    public static function retrieveTree($scope = null, Criteria $criteria = null, PropelPDO $con = null)
    {
        if ($criteria === null) {
            $criteria = new Criteria(ReportSectionPeer::DATABASE_NAME);
        }
        $criteria->addAscendingOrderByColumn(ReportSectionPeer::LEFT_COL);
        $criteria->add(ReportSectionPeer::SCOPE_COL, $scope, Criteria::EQUAL);

        return ReportSectionPeer::doSelect($criteria, $con);
    }

    /**
     * Tests if node is valid
     *
     * @param      ReportSection $node	Propel object for src node
     * @return     bool
     */
    public static function isValid(ReportSection $node = null)
    {
        if (is_object($node) && $node->getRightValue() > $node->getLeftValue()) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Delete an entire tree
     *
     * @param      int $scope		Scope to determine which tree to delete
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     int  The number of deleted nodes
     */
    public static function deleteTree($scope = null, PropelPDO $con = null)
    {
        $c = new Criteria(ReportSectionPeer::DATABASE_NAME);
        $c->add(ReportSectionPeer::SCOPE_COL, $scope, Criteria::EQUAL);

        return ReportSectionPeer::doDelete($c, $con);
    }

    /**
     * Adds $delta to all L and R values that are >= $first and <= $last.
     * '$delta' can also be negative.
     *
     * @param      int $delta		Value to be shifted by, can be negative
     * @param      int $first		First node to be shifted
     * @param      int $last			Last node to be shifted (optional)
     * @param      int $scope		Scope to use for the shift
     * @param      PropelPDO $con		Connection to use.
     */
    public static function shiftRLValues($delta, $first, $last = null, $scope = null, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ReportSectionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        // Shift left column values
        $whereCriteria = new Criteria(ReportSectionPeer::DATABASE_NAME);
        $criterion = $whereCriteria->getNewCriterion(ReportSectionPeer::LEFT_COL, $first, Criteria::GREATER_EQUAL);
        if (null !== $last) {
            $criterion->addAnd($whereCriteria->getNewCriterion(ReportSectionPeer::LEFT_COL, $last, Criteria::LESS_EQUAL));
        }
        $whereCriteria->add($criterion);
        $whereCriteria->add(ReportSectionPeer::SCOPE_COL, $scope, Criteria::EQUAL);

        $valuesCriteria = new Criteria(ReportSectionPeer::DATABASE_NAME);
        $valuesCriteria->add(ReportSectionPeer::LEFT_COL, array('raw' => ReportSectionPeer::LEFT_COL . ' + ?', 'value' => $delta), Criteria::CUSTOM_EQUAL);

        BasePeer::doUpdate($whereCriteria, $valuesCriteria, $con);

        // Shift right column values
        $whereCriteria = new Criteria(ReportSectionPeer::DATABASE_NAME);
        $criterion = $whereCriteria->getNewCriterion(ReportSectionPeer::RIGHT_COL, $first, Criteria::GREATER_EQUAL);
        if (null !== $last) {
            $criterion->addAnd($whereCriteria->getNewCriterion(ReportSectionPeer::RIGHT_COL, $last, Criteria::LESS_EQUAL));
        }
        $whereCriteria->add($criterion);
        $whereCriteria->add(ReportSectionPeer::SCOPE_COL, $scope, Criteria::EQUAL);

        $valuesCriteria = new Criteria(ReportSectionPeer::DATABASE_NAME);
        $valuesCriteria->add(ReportSectionPeer::RIGHT_COL, array('raw' => ReportSectionPeer::RIGHT_COL . ' + ?', 'value' => $delta), Criteria::CUSTOM_EQUAL);

        BasePeer::doUpdate($whereCriteria, $valuesCriteria, $con);
    }

    /**
     * Adds $delta to level for nodes having left value >= $first and right value <= $last.
     * '$delta' can also be negative.
     *
     * @param      int $delta		Value to be shifted by, can be negative
     * @param      int $first		First node to be shifted
     * @param      int $last			Last node to be shifted
     * @param      int $scope		Scope to use for the shift
     * @param      PropelPDO $con		Connection to use.
     */
    public static function shiftLevel($delta, $first, $last, $scope = null, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ReportSectionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $whereCriteria = new Criteria(ReportSectionPeer::DATABASE_NAME);
        $whereCriteria->add(ReportSectionPeer::LEFT_COL, $first, Criteria::GREATER_EQUAL);
        $whereCriteria->add(ReportSectionPeer::RIGHT_COL, $last, Criteria::LESS_EQUAL);
        $whereCriteria->add(ReportSectionPeer::SCOPE_COL, $scope, Criteria::EQUAL);

        $valuesCriteria = new Criteria(ReportSectionPeer::DATABASE_NAME);
        $valuesCriteria->add(ReportSectionPeer::LEVEL_COL, array('raw' => ReportSectionPeer::LEVEL_COL . ' + ?', 'value' => $delta), Criteria::CUSTOM_EQUAL);

        BasePeer::doUpdate($whereCriteria, $valuesCriteria, $con);
    }

    /**
     * Reload all already loaded nodes to sync them with updated db
     *
     * @param      ReportSection $prune		Object to prune from the update
     * @param      PropelPDO $con		Connection to use.
     */
    public static function updateLoadedNodes($prune = null, PropelPDO $con = null)
    {
        if (Propel::isInstancePoolingEnabled()) {
            $keys = array();
            foreach (ReportSectionPeer::$instances as $obj) {
                if (!$prune || !$prune->equals($obj)) {
                    $keys[] = $obj->getPrimaryKey();
                }
            }

            if (!empty($keys)) {
                // We don't need to alter the object instance pool; we're just modifying these ones
                // already in the pool.
                $criteria = new Criteria(ReportSectionPeer::DATABASE_NAME);
                $criteria->add(ReportSectionPeer::ID, $keys, Criteria::IN);
                $stmt = ReportSectionPeer::doSelectStmt($criteria, $con);
                while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
                    $key = ReportSectionPeer::getPrimaryKeyHashFromRow($row, 0);
                    if (null !== ($object = ReportSectionPeer::getInstanceFromPool($key))) {
                        $object->setLeftValue($row[11]);
                        $object->setRightValue($row[12]);
                        $object->setLevel($row[13]);
                        $object->clearNestedSetChildren();
                    }
                }
                $stmt->closeCursor();
            }
        }
    }

    /**
     * Update the tree to allow insertion of a leaf at the specified position
     *
     * @param      int $left	left column value
     * @param      integer $scope	scope column value
     * @param      mixed $prune	Object to prune from the shift
     * @param      PropelPDO $con	Connection to use.
     */
    public static function makeRoomForLeaf($left, $scope, $prune = null, PropelPDO $con = null)
    {
        // Update database nodes
        ReportSectionPeer::shiftRLValues(2, $left, null, $scope, $con);

        // Update all loaded nodes
        ReportSectionPeer::updateLoadedNodes($prune, $con);
    }

    /**
     * Update the tree to allow insertion of a leaf at the specified position
     *
     * @param      integer $scope	scope column value
     * @param      PropelPDO $con	Connection to use.
     */
    public static function fixLevels($scope, PropelPDO $con = null)
    {
        $c = new Criteria();
        $c->add(ReportSectionPeer::SCOPE_COL, $scope, Criteria::EQUAL);
        $c->addAscendingOrderByColumn(ReportSectionPeer::LEFT_COL);
        $stmt = ReportSectionPeer::doSelectStmt($c, $con);

        // set the class once to avoid overhead in the loop
        $cls = ReportSectionPeer::getOMClass(false);
        $level = null;
        // iterate over the statement
        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {

            // hydrate object
            $key = ReportSectionPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null === ($obj = ReportSectionPeer::getInstanceFromPool($key))) {
                $obj = new $cls();
                $obj->hydrate($row);
                ReportSectionPeer::addInstanceToPool($obj, $key);
            }

            // compute level
            // Algorithm shamelessly stolen from sfPropelActAsNestedSetBehaviorPlugin
            // Probably authored by Tristan Rivoallan
            if ($level === null) {
                $level = 0;
                $i = 0;
                $prev = array($obj->getRightValue());
            } else {
                while ($obj->getRightValue() > $prev[$i]) {
                    $i--;
                }
                $level = ++$i;
                $prev[$i] = $obj->getRightValue();
            }

            // update level in node if necessary
            if ($obj->getLevel() !== $level) {
                $obj->setLevel($level);
                $obj->save($con);
            }
        }
        $stmt->closeCursor();
    }

    // soft_delete behavior

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        ReportSectionQuery::enableSoftDelete();
        // some soft_deleted objects may be in the instance pool
        ReportSectionPeer::clearInstancePool();
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        ReportSectionQuery::disableSoftDelete();
    }

    /**
     * Check the soft_delete behavior for this model
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return ReportSectionQuery::isSoftDeleteEnabled();
    }

    /**
     * Soft delete records, given a ReportSection or Criteria object OR a primary key value.
     *
     * @param			 mixed $values Criteria or ReportSection object or primary key or array of primary keys
     *							which is used to create the DELETE statement
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doSoftDelete($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ReportSectionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        if ($values instanceof Criteria) {
            // rename for clarity
            $selectCriteria = clone $values;
         } elseif ($values instanceof ReportSection) {
            // create criteria based on pk values
            $selectCriteria = $values->buildPkeyCriteria();
        } else {
            // it must be the primary key
            $selectCriteria = new Criteria(self::DATABASE_NAME);
             $selectCriteria->add(ReportSectionPeer::ID, (array) $values, Criteria::IN);
        }
        // Set the correct dbName
        $selectCriteria->setDbName(ReportSectionPeer::DATABASE_NAME);
        $updateCriteria = new Criteria(self::DATABASE_NAME);
        $updateCriteria->add(ReportSectionPeer::DELETED_AT, time());

         return BasePeer::doUpdate($selectCriteria, $updateCriteria, $con);
    }

    /**
     * Delete or soft delete records, depending on ReportSectionPeer::$softDelete
     *
     * @param			 mixed $values Criteria or ReportSection object or primary key or array of primary keys
     *							which is used to create the DELETE statement
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doDelete($values, PropelPDO $con = null)
    {
        if (ReportSectionPeer::isSoftDeleteEnabled()) {
            return ReportSectionPeer::doSoftDelete($values, $con);
        } else {
            return ReportSectionPeer::doForceDelete($values, $con);
        }
    }
    /**
     * Method to soft delete all rows from the panel_reportSection table.
     *
     * @param			 PropelPDO $con the connection to use
     * @return		 int The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doSoftDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ReportSectionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $selectCriteria = new Criteria();
        $selectCriteria->add(ReportSectionPeer::DELETED_AT, null, Criteria::ISNULL);
        $selectCriteria->setDbName(ReportSectionPeer::DATABASE_NAME);
        $modifyCriteria = new Criteria();
        $modifyCriteria->add(ReportSectionPeer::DELETED_AT, time());

        return BasePeer::doUpdate($selectCriteria, $modifyCriteria, $con);
    }

    /**
     * Delete or soft delete all records, depending on ReportSectionPeer::$softDelete
     *
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doDeleteAll(PropelPDO $con = null)
    {
        if (ReportSectionPeer::isSoftDeleteEnabled()) {
            return ReportSectionPeer::doSoftDeleteAll($con);
        } else {
            return ReportSectionPeer::doForceDeleteAll($con);
        }
    }

} // BaseReportSectionPeer

// This is the static code needed to register the TableMap for this table with the main Propel class.
//
BaseReportSectionPeer::buildTableMap();

