<?php


/**
 * Base class that represents a query for the 'panel_mission' table.
 *
 * Base de Misiones
 *
 * @method MissionQuery orderById($order = Criteria::ASC) Order by the id column
 * @method MissionQuery orderByType($order = Criteria::ASC) Order by the type column
 * @method MissionQuery orderByStartdate($order = Criteria::ASC) Order by the startDate column
 * @method MissionQuery orderByFinishdate($order = Criteria::ASC) Order by the finishDate column
 * @method MissionQuery orderByPolicyguidelineid($order = Criteria::ASC) Order by the policyGuidelineId column
 * @method MissionQuery orderByDescription($order = Criteria::ASC) Order by the description column
 * @method MissionQuery orderByResponsible($order = Criteria::ASC) Order by the responsible column
 * @method MissionQuery orderByDeletedAt($order = Criteria::ASC) Order by the deleted_at column
 *
 * @method MissionQuery groupById() Group by the id column
 * @method MissionQuery groupByType() Group by the type column
 * @method MissionQuery groupByStartdate() Group by the startDate column
 * @method MissionQuery groupByFinishdate() Group by the finishDate column
 * @method MissionQuery groupByPolicyguidelineid() Group by the policyGuidelineId column
 * @method MissionQuery groupByDescription() Group by the description column
 * @method MissionQuery groupByResponsible() Group by the responsible column
 * @method MissionQuery groupByDeletedAt() Group by the deleted_at column
 *
 * @method MissionQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method MissionQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method MissionQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method MissionQuery leftJoinPolicyGuideline($relationAlias = null) Adds a LEFT JOIN clause to the query using the PolicyGuideline relation
 * @method MissionQuery rightJoinPolicyGuideline($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PolicyGuideline relation
 * @method MissionQuery innerJoinPolicyGuideline($relationAlias = null) Adds a INNER JOIN clause to the query using the PolicyGuideline relation
 *
 * @method MissionQuery leftJoinMissionParticipant($relationAlias = null) Adds a LEFT JOIN clause to the query using the MissionParticipant relation
 * @method MissionQuery rightJoinMissionParticipant($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MissionParticipant relation
 * @method MissionQuery innerJoinMissionParticipant($relationAlias = null) Adds a INNER JOIN clause to the query using the MissionParticipant relation
 *
 * @method MissionQuery leftJoinMissionCommitment($relationAlias = null) Adds a LEFT JOIN clause to the query using the MissionCommitment relation
 * @method MissionQuery rightJoinMissionCommitment($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MissionCommitment relation
 * @method MissionQuery innerJoinMissionCommitment($relationAlias = null) Adds a INNER JOIN clause to the query using the MissionCommitment relation
 *
 * @method MissionQuery leftJoinMissionDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the MissionDocument relation
 * @method MissionQuery rightJoinMissionDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MissionDocument relation
 * @method MissionQuery innerJoinMissionDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the MissionDocument relation
 *
 * @method Mission findOne(PropelPDO $con = null) Return the first Mission matching the query
 * @method Mission findOneOrCreate(PropelPDO $con = null) Return the first Mission matching the query, or a new Mission object populated from the query conditions when no match is found
 *
 * @method Mission findOneById(int $id) Return the first Mission filtered by the id column
 * @method Mission findOneByType(int $type) Return the first Mission filtered by the type column
 * @method Mission findOneByStartdate(string $startDate) Return the first Mission filtered by the startDate column
 * @method Mission findOneByFinishdate(string $finishDate) Return the first Mission filtered by the finishDate column
 * @method Mission findOneByPolicyguidelineid(int $policyGuidelineId) Return the first Mission filtered by the policyGuidelineId column
 * @method Mission findOneByDescription(string $description) Return the first Mission filtered by the description column
 * @method Mission findOneByResponsible(string $responsible) Return the first Mission filtered by the responsible column
 * @method Mission findOneByDeletedAt(string $deleted_at) Return the first Mission filtered by the deleted_at column
 *
 * @method array findById(int $id) Return Mission objects filtered by the id column
 * @method array findByType(int $type) Return Mission objects filtered by the type column
 * @method array findByStartdate(string $startDate) Return Mission objects filtered by the startDate column
 * @method array findByFinishdate(string $finishDate) Return Mission objects filtered by the finishDate column
 * @method array findByPolicyguidelineid(int $policyGuidelineId) Return Mission objects filtered by the policyGuidelineId column
 * @method array findByDescription(string $description) Return Mission objects filtered by the description column
 * @method array findByResponsible(string $responsible) Return Mission objects filtered by the responsible column
 * @method array findByDeletedAt(string $deleted_at) Return Mission objects filtered by the deleted_at column
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseMissionQuery extends \Egytca\Propel\Query
{
    // soft_delete behavior
    protected static $softDelete = true;
    protected $localSoftDelete = true;

    /**
     * Initializes internal state of BaseMissionQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'Mission', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new MissionQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     MissionQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return MissionQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof MissionQuery) {
            return $criteria;
        }
        $query = new MissionQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   Mission|Mission[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = MissionPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(MissionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   Mission A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `TYPE`, `STARTDATE`, `FINISHDATE`, `POLICYGUIDELINEID`, `DESCRIPTION`, `RESPONSIBLE`, `DELETED_AT` FROM `panel_mission` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new Mission();
            $obj->hydrate($row);
            MissionPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return Mission|Mission[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|Mission[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(MissionPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(MissionPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(MissionPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the type column
     *
     * Example usage:
     * <code>
     * $query->filterByType(1234); // WHERE type = 1234
     * $query->filterByType(array(12, 34)); // WHERE type IN (12, 34)
     * $query->filterByType(array('min' => 12)); // WHERE type > 12
     * </code>
     *
     * @param     mixed $type The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByType($type = null, $comparison = null)
    {
        if (is_array($type)) {
            $useMinMax = false;
            if (isset($type['min'])) {
                $this->addUsingAlias(MissionPeer::TYPE, $type['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($type['max'])) {
                $this->addUsingAlias(MissionPeer::TYPE, $type['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionPeer::TYPE, $type, $comparison);
    }

    /**
     * Filter the query on the startDate column
     *
     * Example usage:
     * <code>
     * $query->filterByStartdate('2011-03-14'); // WHERE startDate = '2011-03-14'
     * $query->filterByStartdate('now'); // WHERE startDate = '2011-03-14'
     * $query->filterByStartdate(array('max' => 'yesterday')); // WHERE startDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $startdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByStartdate($startdate = null, $comparison = null)
    {
        if (is_array($startdate)) {
            $useMinMax = false;
            if (isset($startdate['min'])) {
                $this->addUsingAlias(MissionPeer::STARTDATE, $startdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($startdate['max'])) {
                $this->addUsingAlias(MissionPeer::STARTDATE, $startdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionPeer::STARTDATE, $startdate, $comparison);
    }

    /**
     * Filter the query on the finishDate column
     *
     * Example usage:
     * <code>
     * $query->filterByFinishdate('2011-03-14'); // WHERE finishDate = '2011-03-14'
     * $query->filterByFinishdate('now'); // WHERE finishDate = '2011-03-14'
     * $query->filterByFinishdate(array('max' => 'yesterday')); // WHERE finishDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $finishdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByFinishdate($finishdate = null, $comparison = null)
    {
        if (is_array($finishdate)) {
            $useMinMax = false;
            if (isset($finishdate['min'])) {
                $this->addUsingAlias(MissionPeer::FINISHDATE, $finishdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($finishdate['max'])) {
                $this->addUsingAlias(MissionPeer::FINISHDATE, $finishdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionPeer::FINISHDATE, $finishdate, $comparison);
    }

    /**
     * Filter the query on the policyGuidelineId column
     *
     * Example usage:
     * <code>
     * $query->filterByPolicyguidelineid(1234); // WHERE policyGuidelineId = 1234
     * $query->filterByPolicyguidelineid(array(12, 34)); // WHERE policyGuidelineId IN (12, 34)
     * $query->filterByPolicyguidelineid(array('min' => 12)); // WHERE policyGuidelineId > 12
     * </code>
     *
     * @see       filterByPolicyGuideline()
     *
     * @param     mixed $policyguidelineid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByPolicyguidelineid($policyguidelineid = null, $comparison = null)
    {
        if (is_array($policyguidelineid)) {
            $useMinMax = false;
            if (isset($policyguidelineid['min'])) {
                $this->addUsingAlias(MissionPeer::POLICYGUIDELINEID, $policyguidelineid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($policyguidelineid['max'])) {
                $this->addUsingAlias(MissionPeer::POLICYGUIDELINEID, $policyguidelineid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionPeer::POLICYGUIDELINEID, $policyguidelineid, $comparison);
    }

    /**
     * Filter the query on the description column
     *
     * Example usage:
     * <code>
     * $query->filterByDescription('fooValue');   // WHERE description = 'fooValue'
     * $query->filterByDescription('%fooValue%'); // WHERE description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $description The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByDescription($description = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($description)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $description)) {
                $description = str_replace('*', '%', $description);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(MissionPeer::DESCRIPTION, $description, $comparison);
    }

    /**
     * Filter the query on the responsible column
     *
     * Example usage:
     * <code>
     * $query->filterByResponsible('fooValue');   // WHERE responsible = 'fooValue'
     * $query->filterByResponsible('%fooValue%'); // WHERE responsible LIKE '%fooValue%'
     * </code>
     *
     * @param     string $responsible The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByResponsible($responsible = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($responsible)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $responsible)) {
                $responsible = str_replace('*', '%', $responsible);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(MissionPeer::RESPONSIBLE, $responsible, $comparison);
    }

    /**
     * Filter the query on the deleted_at column
     *
     * Example usage:
     * <code>
     * $query->filterByDeletedAt('2011-03-14'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt('now'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt(array('max' => 'yesterday')); // WHERE deleted_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $deletedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function filterByDeletedAt($deletedAt = null, $comparison = null)
    {
        if (is_array($deletedAt)) {
            $useMinMax = false;
            if (isset($deletedAt['min'])) {
                $this->addUsingAlias(MissionPeer::DELETED_AT, $deletedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deletedAt['max'])) {
                $this->addUsingAlias(MissionPeer::DELETED_AT, $deletedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionPeer::DELETED_AT, $deletedAt, $comparison);
    }

    /**
     * Filter the query by a related PolicyGuideline object
     *
     * @param   PolicyGuideline|PropelObjectCollection $policyGuideline The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPolicyGuideline($policyGuideline, $comparison = null)
    {
        if ($policyGuideline instanceof PolicyGuideline) {
            return $this
                ->addUsingAlias(MissionPeer::POLICYGUIDELINEID, $policyGuideline->getId(), $comparison);
        } elseif ($policyGuideline instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(MissionPeer::POLICYGUIDELINEID, $policyGuideline->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByPolicyGuideline() only accepts arguments of type PolicyGuideline or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PolicyGuideline relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function joinPolicyGuideline($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PolicyGuideline');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PolicyGuideline');
        }

        return $this;
    }

    /**
     * Use the PolicyGuideline relation PolicyGuideline object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PolicyGuidelineQuery A secondary query class using the current class as primary query
     */
    public function usePolicyGuidelineQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinPolicyGuideline($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PolicyGuideline', 'PolicyGuidelineQuery');
    }

    /**
     * Filter the query by a related MissionParticipant object
     *
     * @param   MissionParticipant|PropelObjectCollection $missionParticipant  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMissionParticipant($missionParticipant, $comparison = null)
    {
        if ($missionParticipant instanceof MissionParticipant) {
            return $this
                ->addUsingAlias(MissionPeer::ID, $missionParticipant->getMissionid(), $comparison);
        } elseif ($missionParticipant instanceof PropelObjectCollection) {
            return $this
                ->useMissionParticipantQuery()
                ->filterByPrimaryKeys($missionParticipant->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByMissionParticipant() only accepts arguments of type MissionParticipant or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MissionParticipant relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function joinMissionParticipant($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MissionParticipant');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MissionParticipant');
        }

        return $this;
    }

    /**
     * Use the MissionParticipant relation MissionParticipant object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MissionParticipantQuery A secondary query class using the current class as primary query
     */
    public function useMissionParticipantQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinMissionParticipant($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MissionParticipant', 'MissionParticipantQuery');
    }

    /**
     * Filter the query by a related MissionCommitment object
     *
     * @param   MissionCommitment|PropelObjectCollection $missionCommitment  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMissionCommitment($missionCommitment, $comparison = null)
    {
        if ($missionCommitment instanceof MissionCommitment) {
            return $this
                ->addUsingAlias(MissionPeer::ID, $missionCommitment->getMissionid(), $comparison);
        } elseif ($missionCommitment instanceof PropelObjectCollection) {
            return $this
                ->useMissionCommitmentQuery()
                ->filterByPrimaryKeys($missionCommitment->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByMissionCommitment() only accepts arguments of type MissionCommitment or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MissionCommitment relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function joinMissionCommitment($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MissionCommitment');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MissionCommitment');
        }

        return $this;
    }

    /**
     * Use the MissionCommitment relation MissionCommitment object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MissionCommitmentQuery A secondary query class using the current class as primary query
     */
    public function useMissionCommitmentQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinMissionCommitment($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MissionCommitment', 'MissionCommitmentQuery');
    }

    /**
     * Filter the query by a related MissionDocument object
     *
     * @param   MissionDocument|PropelObjectCollection $missionDocument  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMissionDocument($missionDocument, $comparison = null)
    {
        if ($missionDocument instanceof MissionDocument) {
            return $this
                ->addUsingAlias(MissionPeer::ID, $missionDocument->getMissionid(), $comparison);
        } elseif ($missionDocument instanceof PropelObjectCollection) {
            return $this
                ->useMissionDocumentQuery()
                ->filterByPrimaryKeys($missionDocument->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByMissionDocument() only accepts arguments of type MissionDocument or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MissionDocument relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function joinMissionDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MissionDocument');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MissionDocument');
        }

        return $this;
    }

    /**
     * Use the MissionDocument relation MissionDocument object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MissionDocumentQuery A secondary query class using the current class as primary query
     */
    public function useMissionDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinMissionDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MissionDocument', 'MissionDocumentQuery');
    }

    /**
     * Filter the query by a related Document object
     * using the panel_missionDocument table as cross reference
     *
     * @param   Document $document the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionQuery The current query, for fluid interface
     */
    public function filterByDocument($document, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useMissionDocumentQuery()
            ->filterByDocument($document, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   Mission $mission Object to remove from the list of results
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function prune($mission = null)
    {
        if ($mission) {
            $this->addUsingAlias(MissionPeer::ID, $mission->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every SELECT statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreSelect(PropelPDO $con)
    {
        // soft_delete behavior
        if (MissionQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            $this->addUsingAlias(MissionPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            MissionPeer::enableSoftDelete();
        }

        return $this->preSelect($con);
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreDelete(PropelPDO $con)
    {
        // soft_delete behavior
        if (MissionQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            return $this->softDelete($con);
        } else {
            return $this->hasWhereClause() ? $this->forceDelete($con) : $this->forceDeleteAll($con);
        }

        return $this->preDelete($con);
    }

    // soft_delete behavior

    /**
     * Temporarily disable the filter on deleted rows
     * Valid only for the current query
     *
     * @see MissionQuery::disableSoftDelete() to disable the filter for more than one query
     *
     * @return MissionQuery The current query, for fluid interface
     */
    public function includeDeleted()
    {
        $this->localSoftDelete = false;

        return $this;
    }

    /**
     * Soft delete the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of updated rows
     */
    public function softDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => time()), $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDelete(PropelPDO $con = null)
    {
        return MissionPeer::doForceDelete($this, $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of all the rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDeleteAll(PropelPDO $con = null)
    {
        return MissionPeer::doForceDeleteAll($con);}

    /**
     * Undelete selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => null), $con);
    }

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        self::$softDelete = true;
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        self::$softDelete = false;
    }

    /**
     * Check the soft_delete behavior for this model
     *
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return self::$softDelete;
    }

}
