<?php


/**
 * Base class that represents a row from the 'panel_mission' table.
 *
 * Base de Misiones
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseMission extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'MissionPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        MissionPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the type field.
     * @var        int
     */
    protected $type;

    /**
     * The value for the startdate field.
     * @var        string
     */
    protected $startdate;

    /**
     * The value for the finishdate field.
     * @var        string
     */
    protected $finishdate;

    /**
     * The value for the policyguidelineid field.
     * @var        int
     */
    protected $policyguidelineid;

    /**
     * The value for the description field.
     * @var        string
     */
    protected $description;

    /**
     * The value for the responsible field.
     * @var        string
     */
    protected $responsible;

    /**
     * The value for the deleted_at field.
     * @var        string
     */
    protected $deleted_at;

    /**
     * @var        PolicyGuideline
     */
    protected $aPolicyGuideline;

    /**
     * @var        PropelObjectCollection|MissionParticipant[] Collection to store aggregation of MissionParticipant objects.
     */
    protected $collMissionParticipants;
    protected $collMissionParticipantsPartial;

    /**
     * @var        PropelObjectCollection|MissionCommitment[] Collection to store aggregation of MissionCommitment objects.
     */
    protected $collMissionCommitments;
    protected $collMissionCommitmentsPartial;

    /**
     * @var        PropelObjectCollection|MissionDocument[] Collection to store aggregation of MissionDocument objects.
     */
    protected $collMissionDocuments;
    protected $collMissionDocumentsPartial;

    /**
     * @var        PropelObjectCollection|Document[] Collection to store aggregation of Document objects.
     */
    protected $collDocuments;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $documentsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $missionParticipantsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $missionCommitmentsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $missionDocumentsScheduledForDeletion = null;

    /**
     * Get the [id] column value.
     * Identificacion de la Mision
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [type] column value.
     * Tipo de Mision
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Get the [optionally formatted] temporal [startdate] column value.
     * Fecha de la mision
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getStartdate($format = '%Y/%m/%d')
    {
        if ($this->startdate === null) {
            return null;
        }

        if ($this->startdate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->startdate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->startdate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [finishdate] column value.
     * Fecha de la mision
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getFinishdate($format = '%Y/%m/%d')
    {
        if ($this->finishdate === null) {
            return null;
        }

        if ($this->finishdate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->finishdate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->finishdate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [policyguidelineid] column value.
     * Prestamo asociado
     * @return int
     */
    public function getPolicyguidelineid()
    {
        return $this->policyguidelineid;
    }

    /**
     * Get the [description] column value.
     * Descripcion de la Mision
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Get the [responsible] column value.
     * Persona Responsable de la mision
     * @return string
     */
    public function getResponsible()
    {
        return $this->responsible;
    }

    /**
     * Get the [optionally formatted] temporal [deleted_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDeletedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->deleted_at === null) {
            return null;
        }

        if ($this->deleted_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->deleted_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->deleted_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Set the value of [id] column.
     * Identificacion de la Mision
     * @param int $v new value
     * @return Mission The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = MissionPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [type] column.
     * Tipo de Mision
     * @param int $v new value
     * @return Mission The current object (for fluent API support)
     */
    public function setType($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->type !== $v) {
            $this->type = $v;
            $this->modifiedColumns[] = MissionPeer::TYPE;
        }


        return $this;
    } // setType()

    /**
     * Sets the value of [startdate] column to a normalized version of the date/time value specified.
     * Fecha de la mision
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Mission The current object (for fluent API support)
     */
    public function setStartdate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->startdate !== null || $dt !== null) {
            $currentDateAsString = ($this->startdate !== null && $tmpDt = new DateTime($this->startdate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->startdate = $newDateAsString;
                $this->modifiedColumns[] = MissionPeer::STARTDATE;
            }
        } // if either are not null


        return $this;
    } // setStartdate()

    /**
     * Sets the value of [finishdate] column to a normalized version of the date/time value specified.
     * Fecha de la mision
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Mission The current object (for fluent API support)
     */
    public function setFinishdate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->finishdate !== null || $dt !== null) {
            $currentDateAsString = ($this->finishdate !== null && $tmpDt = new DateTime($this->finishdate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->finishdate = $newDateAsString;
                $this->modifiedColumns[] = MissionPeer::FINISHDATE;
            }
        } // if either are not null


        return $this;
    } // setFinishdate()

    /**
     * Set the value of [policyguidelineid] column.
     * Prestamo asociado
     * @param int $v new value
     * @return Mission The current object (for fluent API support)
     */
    public function setPolicyguidelineid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->policyguidelineid !== $v) {
            $this->policyguidelineid = $v;
            $this->modifiedColumns[] = MissionPeer::POLICYGUIDELINEID;
        }

        if ($this->aPolicyGuideline !== null && $this->aPolicyGuideline->getId() !== $v) {
            $this->aPolicyGuideline = null;
        }


        return $this;
    } // setPolicyguidelineid()

    /**
     * Set the value of [description] column.
     * Descripcion de la Mision
     * @param string $v new value
     * @return Mission The current object (for fluent API support)
     */
    public function setDescription($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->description !== $v) {
            $this->description = $v;
            $this->modifiedColumns[] = MissionPeer::DESCRIPTION;
        }


        return $this;
    } // setDescription()

    /**
     * Set the value of [responsible] column.
     * Persona Responsable de la mision
     * @param string $v new value
     * @return Mission The current object (for fluent API support)
     */
    public function setResponsible($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->responsible !== $v) {
            $this->responsible = $v;
            $this->modifiedColumns[] = MissionPeer::RESPONSIBLE;
        }


        return $this;
    } // setResponsible()

    /**
     * Sets the value of [deleted_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Mission The current object (for fluent API support)
     */
    public function setDeletedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->deleted_at !== null || $dt !== null) {
            $currentDateAsString = ($this->deleted_at !== null && $tmpDt = new DateTime($this->deleted_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->deleted_at = $newDateAsString;
                $this->modifiedColumns[] = MissionPeer::DELETED_AT;
            }
        } // if either are not null


        return $this;
    } // setDeletedAt()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->type = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
            $this->startdate = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
            $this->finishdate = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->policyguidelineid = ($row[$startcol + 4] !== null) ? (int) $row[$startcol + 4] : null;
            $this->description = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->responsible = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->deleted_at = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 8; // 8 = MissionPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating Mission object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aPolicyGuideline !== null && $this->policyguidelineid !== $this->aPolicyGuideline->getId()) {
            $this->aPolicyGuideline = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(MissionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = MissionPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aPolicyGuideline = null;
            $this->collMissionParticipants = null;

            $this->collMissionCommitments = null;

            $this->collMissionDocuments = null;

            $this->collDocuments = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(MissionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = MissionQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            // soft_delete behavior
            if (!empty($ret) && MissionQuery::isSoftDeleteEnabled()) {
                $this->setDeletedAt(time());
                $this->save($con);
                $this->postDelete($con);
                $con->commit();
                MissionPeer::removeInstanceFromPool($this);

                return;
            }

            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(MissionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                MissionPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aPolicyGuideline !== null) {
                if ($this->aPolicyGuideline->isModified() || $this->aPolicyGuideline->isNew()) {
                    $affectedRows += $this->aPolicyGuideline->save($con);
                }
                $this->setPolicyGuideline($this->aPolicyGuideline);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->documentsScheduledForDeletion !== null) {
                if (!$this->documentsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->documentsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    MissionDocumentQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->documentsScheduledForDeletion = null;
                }

                foreach ($this->getDocuments() as $document) {
                    if ($document->isModified()) {
                        $document->save($con);
                    }
                }
            }

            if ($this->missionParticipantsScheduledForDeletion !== null) {
                if (!$this->missionParticipantsScheduledForDeletion->isEmpty()) {
                    MissionParticipantQuery::create()
                        ->filterByPrimaryKeys($this->missionParticipantsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->missionParticipantsScheduledForDeletion = null;
                }
            }

            if ($this->collMissionParticipants !== null) {
                foreach ($this->collMissionParticipants as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->missionCommitmentsScheduledForDeletion !== null) {
                if (!$this->missionCommitmentsScheduledForDeletion->isEmpty()) {
                    foreach ($this->missionCommitmentsScheduledForDeletion as $missionCommitment) {
                        // need to save related object because we set the relation to null
                        $missionCommitment->save($con);
                    }
                    $this->missionCommitmentsScheduledForDeletion = null;
                }
            }

            if ($this->collMissionCommitments !== null) {
                foreach ($this->collMissionCommitments as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->missionDocumentsScheduledForDeletion !== null) {
                if (!$this->missionDocumentsScheduledForDeletion->isEmpty()) {
                    MissionDocumentQuery::create()
                        ->filterByPrimaryKeys($this->missionDocumentsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->missionDocumentsScheduledForDeletion = null;
                }
            }

            if ($this->collMissionDocuments !== null) {
                foreach ($this->collMissionDocuments as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = MissionPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . MissionPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(MissionPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(MissionPeer::TYPE)) {
            $modifiedColumns[':p' . $index++]  = '`TYPE`';
        }
        if ($this->isColumnModified(MissionPeer::STARTDATE)) {
            $modifiedColumns[':p' . $index++]  = '`STARTDATE`';
        }
        if ($this->isColumnModified(MissionPeer::FINISHDATE)) {
            $modifiedColumns[':p' . $index++]  = '`FINISHDATE`';
        }
        if ($this->isColumnModified(MissionPeer::POLICYGUIDELINEID)) {
            $modifiedColumns[':p' . $index++]  = '`POLICYGUIDELINEID`';
        }
        if ($this->isColumnModified(MissionPeer::DESCRIPTION)) {
            $modifiedColumns[':p' . $index++]  = '`DESCRIPTION`';
        }
        if ($this->isColumnModified(MissionPeer::RESPONSIBLE)) {
            $modifiedColumns[':p' . $index++]  = '`RESPONSIBLE`';
        }
        if ($this->isColumnModified(MissionPeer::DELETED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`DELETED_AT`';
        }

        $sql = sprintf(
            'INSERT INTO `panel_mission` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`TYPE`':
                        $stmt->bindValue($identifier, $this->type, PDO::PARAM_INT);
                        break;
                    case '`STARTDATE`':
                        $stmt->bindValue($identifier, $this->startdate, PDO::PARAM_STR);
                        break;
                    case '`FINISHDATE`':
                        $stmt->bindValue($identifier, $this->finishdate, PDO::PARAM_STR);
                        break;
                    case '`POLICYGUIDELINEID`':
                        $stmt->bindValue($identifier, $this->policyguidelineid, PDO::PARAM_INT);
                        break;
                    case '`DESCRIPTION`':
                        $stmt->bindValue($identifier, $this->description, PDO::PARAM_STR);
                        break;
                    case '`RESPONSIBLE`':
                        $stmt->bindValue($identifier, $this->responsible, PDO::PARAM_STR);
                        break;
                    case '`DELETED_AT`':
                        $stmt->bindValue($identifier, $this->deleted_at, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aPolicyGuideline !== null) {
                if (!$this->aPolicyGuideline->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aPolicyGuideline->getValidationFailures());
                }
            }


            if (($retval = MissionPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collMissionParticipants !== null) {
                    foreach ($this->collMissionParticipants as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collMissionCommitments !== null) {
                    foreach ($this->collMissionCommitments as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collMissionDocuments !== null) {
                    foreach ($this->collMissionDocuments as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = MissionPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getType();
                break;
            case 2:
                return $this->getStartdate();
                break;
            case 3:
                return $this->getFinishdate();
                break;
            case 4:
                return $this->getPolicyguidelineid();
                break;
            case 5:
                return $this->getDescription();
                break;
            case 6:
                return $this->getResponsible();
                break;
            case 7:
                return $this->getDeletedAt();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['Mission'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Mission'][$this->getPrimaryKey()] = true;
        $keys = MissionPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getType(),
            $keys[2] => $this->getStartdate(),
            $keys[3] => $this->getFinishdate(),
            $keys[4] => $this->getPolicyguidelineid(),
            $keys[5] => $this->getDescription(),
            $keys[6] => $this->getResponsible(),
            $keys[7] => $this->getDeletedAt(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aPolicyGuideline) {
                $result['PolicyGuideline'] = $this->aPolicyGuideline->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collMissionParticipants) {
                $result['MissionParticipants'] = $this->collMissionParticipants->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collMissionCommitments) {
                $result['MissionCommitments'] = $this->collMissionCommitments->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collMissionDocuments) {
                $result['MissionDocuments'] = $this->collMissionDocuments->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = MissionPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setType($value);
                break;
            case 2:
                $this->setStartdate($value);
                break;
            case 3:
                $this->setFinishdate($value);
                break;
            case 4:
                $this->setPolicyguidelineid($value);
                break;
            case 5:
                $this->setDescription($value);
                break;
            case 6:
                $this->setResponsible($value);
                break;
            case 7:
                $this->setDeletedAt($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = MissionPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setType($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setStartdate($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setFinishdate($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setPolicyguidelineid($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setDescription($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setResponsible($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setDeletedAt($arr[$keys[7]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(MissionPeer::DATABASE_NAME);

        if ($this->isColumnModified(MissionPeer::ID)) $criteria->add(MissionPeer::ID, $this->id);
        if ($this->isColumnModified(MissionPeer::TYPE)) $criteria->add(MissionPeer::TYPE, $this->type);
        if ($this->isColumnModified(MissionPeer::STARTDATE)) $criteria->add(MissionPeer::STARTDATE, $this->startdate);
        if ($this->isColumnModified(MissionPeer::FINISHDATE)) $criteria->add(MissionPeer::FINISHDATE, $this->finishdate);
        if ($this->isColumnModified(MissionPeer::POLICYGUIDELINEID)) $criteria->add(MissionPeer::POLICYGUIDELINEID, $this->policyguidelineid);
        if ($this->isColumnModified(MissionPeer::DESCRIPTION)) $criteria->add(MissionPeer::DESCRIPTION, $this->description);
        if ($this->isColumnModified(MissionPeer::RESPONSIBLE)) $criteria->add(MissionPeer::RESPONSIBLE, $this->responsible);
        if ($this->isColumnModified(MissionPeer::DELETED_AT)) $criteria->add(MissionPeer::DELETED_AT, $this->deleted_at);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(MissionPeer::DATABASE_NAME);
        $criteria->add(MissionPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of Mission (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setType($this->getType());
        $copyObj->setStartdate($this->getStartdate());
        $copyObj->setFinishdate($this->getFinishdate());
        $copyObj->setPolicyguidelineid($this->getPolicyguidelineid());
        $copyObj->setDescription($this->getDescription());
        $copyObj->setResponsible($this->getResponsible());
        $copyObj->setDeletedAt($this->getDeletedAt());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getMissionParticipants() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addMissionParticipant($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getMissionCommitments() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addMissionCommitment($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getMissionDocuments() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addMissionDocument($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return Mission Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return MissionPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new MissionPeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a PolicyGuideline object.
     *
     * @param             PolicyGuideline $v
     * @return Mission The current object (for fluent API support)
     * @throws PropelException
     */
    public function setPolicyGuideline(PolicyGuideline $v = null)
    {
        if ($v === null) {
            $this->setPolicyguidelineid(NULL);
        } else {
            $this->setPolicyguidelineid($v->getId());
        }

        $this->aPolicyGuideline = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the PolicyGuideline object, it will not be re-added.
        if ($v !== null) {
            $v->addMission($this);
        }


        return $this;
    }


    /**
     * Get the associated PolicyGuideline object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return PolicyGuideline The associated PolicyGuideline object.
     * @throws PropelException
     */
    public function getPolicyGuideline(PropelPDO $con = null)
    {
        if ($this->aPolicyGuideline === null && ($this->policyguidelineid !== null)) {
            $this->aPolicyGuideline = PolicyGuidelineQuery::create()->findPk($this->policyguidelineid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aPolicyGuideline->addMissions($this);
             */
        }

        return $this->aPolicyGuideline;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('MissionParticipant' == $relationName) {
            $this->initMissionParticipants();
        }
        if ('MissionCommitment' == $relationName) {
            $this->initMissionCommitments();
        }
        if ('MissionDocument' == $relationName) {
            $this->initMissionDocuments();
        }
    }

    /**
     * Clears out the collMissionParticipants collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addMissionParticipants()
     */
    public function clearMissionParticipants()
    {
        $this->collMissionParticipants = null; // important to set this to null since that means it is uninitialized
        $this->collMissionParticipantsPartial = null;
    }

    /**
     * reset is the collMissionParticipants collection loaded partially
     *
     * @return void
     */
    public function resetPartialMissionParticipants($v = true)
    {
        $this->collMissionParticipantsPartial = $v;
    }

    /**
     * Initializes the collMissionParticipants collection.
     *
     * By default this just sets the collMissionParticipants collection to an empty array (like clearcollMissionParticipants());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initMissionParticipants($overrideExisting = true)
    {
        if (null !== $this->collMissionParticipants && !$overrideExisting) {
            return;
        }
        $this->collMissionParticipants = new PropelObjectCollection();
        $this->collMissionParticipants->setModel('MissionParticipant');
    }

    /**
     * Gets an array of MissionParticipant objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Mission is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|MissionParticipant[] List of MissionParticipant objects
     * @throws PropelException
     */
    public function getMissionParticipants($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collMissionParticipantsPartial && !$this->isNew();
        if (null === $this->collMissionParticipants || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collMissionParticipants) {
                // return empty collection
                $this->initMissionParticipants();
            } else {
                $collMissionParticipants = MissionParticipantQuery::create(null, $criteria)
                    ->filterByMission($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collMissionParticipantsPartial && count($collMissionParticipants)) {
                      $this->initMissionParticipants(false);

                      foreach($collMissionParticipants as $obj) {
                        if (false == $this->collMissionParticipants->contains($obj)) {
                          $this->collMissionParticipants->append($obj);
                        }
                      }

                      $this->collMissionParticipantsPartial = true;
                    }

                    return $collMissionParticipants;
                }

                if($partial && $this->collMissionParticipants) {
                    foreach($this->collMissionParticipants as $obj) {
                        if($obj->isNew()) {
                            $collMissionParticipants[] = $obj;
                        }
                    }
                }

                $this->collMissionParticipants = $collMissionParticipants;
                $this->collMissionParticipantsPartial = false;
            }
        }

        return $this->collMissionParticipants;
    }

    /**
     * Sets a collection of MissionParticipant objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $missionParticipants A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setMissionParticipants(PropelCollection $missionParticipants, PropelPDO $con = null)
    {
        $this->missionParticipantsScheduledForDeletion = $this->getMissionParticipants(new Criteria(), $con)->diff($missionParticipants);

        foreach ($this->missionParticipantsScheduledForDeletion as $missionParticipantRemoved) {
            $missionParticipantRemoved->setMission(null);
        }

        $this->collMissionParticipants = null;
        foreach ($missionParticipants as $missionParticipant) {
            $this->addMissionParticipant($missionParticipant);
        }

        $this->collMissionParticipants = $missionParticipants;
        $this->collMissionParticipantsPartial = false;
    }

    /**
     * Returns the number of related MissionParticipant objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related MissionParticipant objects.
     * @throws PropelException
     */
    public function countMissionParticipants(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collMissionParticipantsPartial && !$this->isNew();
        if (null === $this->collMissionParticipants || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collMissionParticipants) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getMissionParticipants());
                }
                $query = MissionParticipantQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByMission($this)
                    ->count($con);
            }
        } else {
            return count($this->collMissionParticipants);
        }
    }

    /**
     * Method called to associate a MissionParticipant object to this object
     * through the MissionParticipant foreign key attribute.
     *
     * @param    MissionParticipant $l MissionParticipant
     * @return Mission The current object (for fluent API support)
     */
    public function addMissionParticipant(MissionParticipant $l)
    {
        if ($this->collMissionParticipants === null) {
            $this->initMissionParticipants();
            $this->collMissionParticipantsPartial = true;
        }
        if (!$this->collMissionParticipants->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddMissionParticipant($l);
        }

        return $this;
    }

    /**
     * @param	MissionParticipant $missionParticipant The missionParticipant object to add.
     */
    protected function doAddMissionParticipant($missionParticipant)
    {
        $this->collMissionParticipants[]= $missionParticipant;
        $missionParticipant->setMission($this);
    }

    /**
     * @param	MissionParticipant $missionParticipant The missionParticipant object to remove.
     */
    public function removeMissionParticipant($missionParticipant)
    {
        if ($this->getMissionParticipants()->contains($missionParticipant)) {
            $this->collMissionParticipants->remove($this->collMissionParticipants->search($missionParticipant));
            if (null === $this->missionParticipantsScheduledForDeletion) {
                $this->missionParticipantsScheduledForDeletion = clone $this->collMissionParticipants;
                $this->missionParticipantsScheduledForDeletion->clear();
            }
            $this->missionParticipantsScheduledForDeletion[]= $missionParticipant;
            $missionParticipant->setMission(null);
        }
    }

    /**
     * Clears out the collMissionCommitments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addMissionCommitments()
     */
    public function clearMissionCommitments()
    {
        $this->collMissionCommitments = null; // important to set this to null since that means it is uninitialized
        $this->collMissionCommitmentsPartial = null;
    }

    /**
     * reset is the collMissionCommitments collection loaded partially
     *
     * @return void
     */
    public function resetPartialMissionCommitments($v = true)
    {
        $this->collMissionCommitmentsPartial = $v;
    }

    /**
     * Initializes the collMissionCommitments collection.
     *
     * By default this just sets the collMissionCommitments collection to an empty array (like clearcollMissionCommitments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initMissionCommitments($overrideExisting = true)
    {
        if (null !== $this->collMissionCommitments && !$overrideExisting) {
            return;
        }
        $this->collMissionCommitments = new PropelObjectCollection();
        $this->collMissionCommitments->setModel('MissionCommitment');
    }

    /**
     * Gets an array of MissionCommitment objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Mission is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|MissionCommitment[] List of MissionCommitment objects
     * @throws PropelException
     */
    public function getMissionCommitments($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collMissionCommitmentsPartial && !$this->isNew();
        if (null === $this->collMissionCommitments || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collMissionCommitments) {
                // return empty collection
                $this->initMissionCommitments();
            } else {
                $collMissionCommitments = MissionCommitmentQuery::create(null, $criteria)
                    ->filterByMission($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collMissionCommitmentsPartial && count($collMissionCommitments)) {
                      $this->initMissionCommitments(false);

                      foreach($collMissionCommitments as $obj) {
                        if (false == $this->collMissionCommitments->contains($obj)) {
                          $this->collMissionCommitments->append($obj);
                        }
                      }

                      $this->collMissionCommitmentsPartial = true;
                    }

                    return $collMissionCommitments;
                }

                if($partial && $this->collMissionCommitments) {
                    foreach($this->collMissionCommitments as $obj) {
                        if($obj->isNew()) {
                            $collMissionCommitments[] = $obj;
                        }
                    }
                }

                $this->collMissionCommitments = $collMissionCommitments;
                $this->collMissionCommitmentsPartial = false;
            }
        }

        return $this->collMissionCommitments;
    }

    /**
     * Sets a collection of MissionCommitment objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $missionCommitments A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setMissionCommitments(PropelCollection $missionCommitments, PropelPDO $con = null)
    {
        $this->missionCommitmentsScheduledForDeletion = $this->getMissionCommitments(new Criteria(), $con)->diff($missionCommitments);

        foreach ($this->missionCommitmentsScheduledForDeletion as $missionCommitmentRemoved) {
            $missionCommitmentRemoved->setMission(null);
        }

        $this->collMissionCommitments = null;
        foreach ($missionCommitments as $missionCommitment) {
            $this->addMissionCommitment($missionCommitment);
        }

        $this->collMissionCommitments = $missionCommitments;
        $this->collMissionCommitmentsPartial = false;
    }

    /**
     * Returns the number of related MissionCommitment objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related MissionCommitment objects.
     * @throws PropelException
     */
    public function countMissionCommitments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collMissionCommitmentsPartial && !$this->isNew();
        if (null === $this->collMissionCommitments || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collMissionCommitments) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getMissionCommitments());
                }
                $query = MissionCommitmentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByMission($this)
                    ->count($con);
            }
        } else {
            return count($this->collMissionCommitments);
        }
    }

    /**
     * Method called to associate a MissionCommitment object to this object
     * through the MissionCommitment foreign key attribute.
     *
     * @param    MissionCommitment $l MissionCommitment
     * @return Mission The current object (for fluent API support)
     */
    public function addMissionCommitment(MissionCommitment $l)
    {
        if ($this->collMissionCommitments === null) {
            $this->initMissionCommitments();
            $this->collMissionCommitmentsPartial = true;
        }
        if (!$this->collMissionCommitments->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddMissionCommitment($l);
        }

        return $this;
    }

    /**
     * @param	MissionCommitment $missionCommitment The missionCommitment object to add.
     */
    protected function doAddMissionCommitment($missionCommitment)
    {
        $this->collMissionCommitments[]= $missionCommitment;
        $missionCommitment->setMission($this);
    }

    /**
     * @param	MissionCommitment $missionCommitment The missionCommitment object to remove.
     */
    public function removeMissionCommitment($missionCommitment)
    {
        if ($this->getMissionCommitments()->contains($missionCommitment)) {
            $this->collMissionCommitments->remove($this->collMissionCommitments->search($missionCommitment));
            if (null === $this->missionCommitmentsScheduledForDeletion) {
                $this->missionCommitmentsScheduledForDeletion = clone $this->collMissionCommitments;
                $this->missionCommitmentsScheduledForDeletion->clear();
            }
            $this->missionCommitmentsScheduledForDeletion[]= $missionCommitment;
            $missionCommitment->setMission(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Mission is new, it will return
     * an empty collection; or if this Mission has previously
     * been saved, it will retrieve related MissionCommitments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Mission.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|MissionCommitment[] List of MissionCommitment objects
     */
    public function getMissionCommitmentsJoinMissionParticipant($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = MissionCommitmentQuery::create(null, $criteria);
        $query->joinWith('MissionParticipant', $join_behavior);

        return $this->getMissionCommitments($query, $con);
    }

    /**
     * Clears out the collMissionDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addMissionDocuments()
     */
    public function clearMissionDocuments()
    {
        $this->collMissionDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collMissionDocumentsPartial = null;
    }

    /**
     * reset is the collMissionDocuments collection loaded partially
     *
     * @return void
     */
    public function resetPartialMissionDocuments($v = true)
    {
        $this->collMissionDocumentsPartial = $v;
    }

    /**
     * Initializes the collMissionDocuments collection.
     *
     * By default this just sets the collMissionDocuments collection to an empty array (like clearcollMissionDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initMissionDocuments($overrideExisting = true)
    {
        if (null !== $this->collMissionDocuments && !$overrideExisting) {
            return;
        }
        $this->collMissionDocuments = new PropelObjectCollection();
        $this->collMissionDocuments->setModel('MissionDocument');
    }

    /**
     * Gets an array of MissionDocument objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Mission is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|MissionDocument[] List of MissionDocument objects
     * @throws PropelException
     */
    public function getMissionDocuments($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collMissionDocumentsPartial && !$this->isNew();
        if (null === $this->collMissionDocuments || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collMissionDocuments) {
                // return empty collection
                $this->initMissionDocuments();
            } else {
                $collMissionDocuments = MissionDocumentQuery::create(null, $criteria)
                    ->filterByMission($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collMissionDocumentsPartial && count($collMissionDocuments)) {
                      $this->initMissionDocuments(false);

                      foreach($collMissionDocuments as $obj) {
                        if (false == $this->collMissionDocuments->contains($obj)) {
                          $this->collMissionDocuments->append($obj);
                        }
                      }

                      $this->collMissionDocumentsPartial = true;
                    }

                    return $collMissionDocuments;
                }

                if($partial && $this->collMissionDocuments) {
                    foreach($this->collMissionDocuments as $obj) {
                        if($obj->isNew()) {
                            $collMissionDocuments[] = $obj;
                        }
                    }
                }

                $this->collMissionDocuments = $collMissionDocuments;
                $this->collMissionDocumentsPartial = false;
            }
        }

        return $this->collMissionDocuments;
    }

    /**
     * Sets a collection of MissionDocument objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $missionDocuments A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setMissionDocuments(PropelCollection $missionDocuments, PropelPDO $con = null)
    {
        $this->missionDocumentsScheduledForDeletion = $this->getMissionDocuments(new Criteria(), $con)->diff($missionDocuments);

        foreach ($this->missionDocumentsScheduledForDeletion as $missionDocumentRemoved) {
            $missionDocumentRemoved->setMission(null);
        }

        $this->collMissionDocuments = null;
        foreach ($missionDocuments as $missionDocument) {
            $this->addMissionDocument($missionDocument);
        }

        $this->collMissionDocuments = $missionDocuments;
        $this->collMissionDocumentsPartial = false;
    }

    /**
     * Returns the number of related MissionDocument objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related MissionDocument objects.
     * @throws PropelException
     */
    public function countMissionDocuments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collMissionDocumentsPartial && !$this->isNew();
        if (null === $this->collMissionDocuments || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collMissionDocuments) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getMissionDocuments());
                }
                $query = MissionDocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByMission($this)
                    ->count($con);
            }
        } else {
            return count($this->collMissionDocuments);
        }
    }

    /**
     * Method called to associate a MissionDocument object to this object
     * through the MissionDocument foreign key attribute.
     *
     * @param    MissionDocument $l MissionDocument
     * @return Mission The current object (for fluent API support)
     */
    public function addMissionDocument(MissionDocument $l)
    {
        if ($this->collMissionDocuments === null) {
            $this->initMissionDocuments();
            $this->collMissionDocumentsPartial = true;
        }
        if (!$this->collMissionDocuments->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddMissionDocument($l);
        }

        return $this;
    }

    /**
     * @param	MissionDocument $missionDocument The missionDocument object to add.
     */
    protected function doAddMissionDocument($missionDocument)
    {
        $this->collMissionDocuments[]= $missionDocument;
        $missionDocument->setMission($this);
    }

    /**
     * @param	MissionDocument $missionDocument The missionDocument object to remove.
     */
    public function removeMissionDocument($missionDocument)
    {
        if ($this->getMissionDocuments()->contains($missionDocument)) {
            $this->collMissionDocuments->remove($this->collMissionDocuments->search($missionDocument));
            if (null === $this->missionDocumentsScheduledForDeletion) {
                $this->missionDocumentsScheduledForDeletion = clone $this->collMissionDocuments;
                $this->missionDocumentsScheduledForDeletion->clear();
            }
            $this->missionDocumentsScheduledForDeletion[]= $missionDocument;
            $missionDocument->setMission(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Mission is new, it will return
     * an empty collection; or if this Mission has previously
     * been saved, it will retrieve related MissionDocuments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Mission.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|MissionDocument[] List of MissionDocument objects
     */
    public function getMissionDocumentsJoinDocument($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = MissionDocumentQuery::create(null, $criteria);
        $query->joinWith('Document', $join_behavior);

        return $this->getMissionDocuments($query, $con);
    }

    /**
     * Clears out the collDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addDocuments()
     */
    public function clearDocuments()
    {
        $this->collDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collDocumentsPartial = null;
    }

    /**
     * Initializes the collDocuments collection.
     *
     * By default this just sets the collDocuments collection to an empty collection (like clearDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initDocuments()
    {
        $this->collDocuments = new PropelObjectCollection();
        $this->collDocuments->setModel('Document');
    }

    /**
     * Gets a collection of Document objects related by a many-to-many relationship
     * to the current object by way of the panel_missionDocument cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Mission is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Document[] List of Document objects
     */
    public function getDocuments($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collDocuments || null !== $criteria) {
            if ($this->isNew() && null === $this->collDocuments) {
                // return empty collection
                $this->initDocuments();
            } else {
                $collDocuments = DocumentQuery::create(null, $criteria)
                    ->filterByMission($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collDocuments;
                }
                $this->collDocuments = $collDocuments;
            }
        }

        return $this->collDocuments;
    }

    /**
     * Sets a collection of Document objects related by a many-to-many relationship
     * to the current object by way of the panel_missionDocument cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $documents A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setDocuments(PropelCollection $documents, PropelPDO $con = null)
    {
        $this->clearDocuments();
        $currentDocuments = $this->getDocuments();

        $this->documentsScheduledForDeletion = $currentDocuments->diff($documents);

        foreach ($documents as $document) {
            if (!$currentDocuments->contains($document)) {
                $this->doAddDocument($document);
            }
        }

        $this->collDocuments = $documents;
    }

    /**
     * Gets the number of Document objects related by a many-to-many relationship
     * to the current object by way of the panel_missionDocument cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Document objects
     */
    public function countDocuments($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collDocuments || null !== $criteria) {
            if ($this->isNew() && null === $this->collDocuments) {
                return 0;
            } else {
                $query = DocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByMission($this)
                    ->count($con);
            }
        } else {
            return count($this->collDocuments);
        }
    }

    /**
     * Associate a Document object to this object
     * through the panel_missionDocument cross reference table.
     *
     * @param  Document $document The MissionDocument object to relate
     * @return void
     */
    public function addDocument(Document $document)
    {
        if ($this->collDocuments === null) {
            $this->initDocuments();
        }
        if (!$this->collDocuments->contains($document)) { // only add it if the **same** object is not already associated
            $this->doAddDocument($document);

            $this->collDocuments[]= $document;
        }
    }

    /**
     * @param	Document $document The document object to add.
     */
    protected function doAddDocument($document)
    {
        $missionDocument = new MissionDocument();
        $missionDocument->setDocument($document);
        $this->addMissionDocument($missionDocument);
    }

    /**
     * Remove a Document object to this object
     * through the panel_missionDocument cross reference table.
     *
     * @param Document $document The MissionDocument object to relate
     * @return void
     */
    public function removeDocument(Document $document)
    {
        if ($this->getDocuments()->contains($document)) {
            $this->collDocuments->remove($this->collDocuments->search($document));
            if (null === $this->documentsScheduledForDeletion) {
                $this->documentsScheduledForDeletion = clone $this->collDocuments;
                $this->documentsScheduledForDeletion->clear();
            }
            $this->documentsScheduledForDeletion[]= $document;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->type = null;
        $this->startdate = null;
        $this->finishdate = null;
        $this->policyguidelineid = null;
        $this->description = null;
        $this->responsible = null;
        $this->deleted_at = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collMissionParticipants) {
                foreach ($this->collMissionParticipants as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collMissionCommitments) {
                foreach ($this->collMissionCommitments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collMissionDocuments) {
                foreach ($this->collMissionDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collDocuments) {
                foreach ($this->collDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collMissionParticipants instanceof PropelCollection) {
            $this->collMissionParticipants->clearIterator();
        }
        $this->collMissionParticipants = null;
        if ($this->collMissionCommitments instanceof PropelCollection) {
            $this->collMissionCommitments->clearIterator();
        }
        $this->collMissionCommitments = null;
        if ($this->collMissionDocuments instanceof PropelCollection) {
            $this->collMissionDocuments->clearIterator();
        }
        $this->collMissionDocuments = null;
        if ($this->collDocuments instanceof PropelCollection) {
            $this->collDocuments->clearIterator();
        }
        $this->collDocuments = null;
        $this->aPolicyGuideline = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(MissionPeer::DEFAULT_STRING_FORMAT);
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

    // soft_delete behavior

    /**
     * Bypass the soft_delete behavior and force a hard delete of the current object
     */
    public function forceDelete(PropelPDO $con = null)
    {
        if ($isSoftDeleteEnabled = MissionPeer::isSoftDeleteEnabled()) {
            MissionPeer::disableSoftDelete();
        }
        $this->delete($con);
        if ($isSoftDeleteEnabled) {
            MissionPeer::enableSoftDelete();
        }
    }

    /**
     * Undelete a row that was soft_deleted
     *
     * @return		 int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        $this->setDeletedAt(null);

        return $this->save($con);
    }

}
