<?php



/**
 * Skeleton subclass for representing a row from the 'panel_notification' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.panel.classes
 */
class Notification extends BaseNotification {

	function getObject() {
		if ($this->getObjectId() && $this->getObjectType()) {
			$queryClass = $this->getObjectType().'Query';
			return $queryClass::create()->findOneById($this->getObjectId());
		} else {
			return new User();
		}
	}

	function getMailTo() {
		if ($this->getType() === NotificationPeer::DIGEST) {
			return explode(',', $this->getMailAddress());
		} else {
			$destinatary = $this->getObject();
			return $destinatary ? $destinatary->getMailAddress() : null;
		}
	}

} // Notification
