<?php

require_once 'AlertDigestMail.php';
require_once 'AlertMail.php';
require_once 'ScheduleMail.php';

class AlertManager {

	private function getAlertPeriodCount() {
		$panelConfig = Common::getConfiguration('Panel');
		$alertPeriodType = $panelConfig['alert']['timePeriod']['type']['value'];
		return $panelConfig['alert']['timePeriod']['count'];
	}

	private function getSchedulePeriodCount() {
		$panelConfig = Common::getConfiguration('Panel');
		$schedulePeriodType = $panelConfig['schedule']['timePeriod']['type']['value'];
		return $panelConfig['schedule']['timePeriod']['count'];
	}

	function getUpcomingAlertMinMax() {

		$alertPeriodCount = $this->getAlertPeriodCount();

		$min = new DateTime('today');
		$max = new DateTime('today');
		if ($alertPeriodType == 'DAYS_COUNT')
			$max->modify("+$alertPeriodCount days");
		else if ($alertPeriodType == 'WEEKS_COUNT')
			$max->modify("+$alertPeriodCount weeks");
		else
			$max->modify("+7 days");

		return ['min' => $min, 'max' => $max];
	}

	function getDelayedAlertMinMax() {

		$alertPeriodCount = $this->getAlertPeriodCount();

		$min = new DateTime('yesterday');
		$max = new DateTime('yesterday');
		if ($alertPeriodType == 'DAYS_COUNT')
			$min->modify("-$alertPeriodCount days");
		else if ($alertPeriodType == 'WEEKS_COUNT')
			$min->modify("-$alertPeriodCount weeks");
		else
			$min->modify("-7 days");

		return ['min' => $min, 'max' => $max];
	}

	function getScheduleMinMax() {

		$schedulePeriodCount = $this->getSchedulePeriodCount();

		$max = new DateTime('today');
		$min = new DateTime('today');
		if ($schedulePeriodType == 'DAYS_COUNT') {
			$max->modify("+$schedulePeriodCount days");
		} else if ($schedulePeriodType == 'MONTHS_COUNT') {
			$max->modify("+$schedulePeriodCount months");
		} else {
			$max->modify("+1 month");
		}

		return ['min' => $min, 'max' => $max];
	}

	function getAlertObjects($position, $objectClass, $dateFilter, $minMax) {
		$getAllObjectsWithDescendants = 'getAll'.$objectClass.'sWithDescendants';
		$getAllObjectsWithDescendants = str_replace('Activitys', 'Activities', $getAllObjectsWithDescendants);
		$queryClass = $objectClass.'Query';
		$alertTypeCriteria = $queryClass::create()->$dateFilter($minMax);
		return $position->$getAllObjectsWithDescendants($alertTypeCriteria);
	}

	function getScheduleStartObjects($position, $objectClass) {
		$minMax = $this->getScheduleMinMax();
		return $this->getAlertObjects($position, $objectClass, 'filterByPlannedStart', $minMax);
	}

	function getScheduleEndObjects($position, $objectClass) {
		$minMax = $this->getScheduleMinMax();
		return $this->getAlertObjects($position, $objectClass, 'filterByPlannedEnd', $minMax);
	}

	function getUpcomingAlertObjects($position, $objectClass) {
		$minMax = $this->getUpcomingAlertMinMax();
		return $this->getAlertObjects($position, $objectClass, 'filterByPendingEnd', $minMax);
	}

	function getDelayedAlertObjects($position, $objectClass) {
		$minMax = $this->getDelayedAlertMinMax();
		return $this->getAlertObjects($position, $objectClass, 'filterByPendingEnd', $minMax);
	}

	function createAlertMail($position) {

		$tenure = $position->getPositionTenures()->getFirst();
		if (!$tenure) {
			return null;
		}

		$responsible = $tenure->getObject();
		if (!$responsible) {
			return null;
		}

		$upcomingObjectives = $this->getUpcomingAlertObjects($position, 'Objective');
		$delayedObjectives = $this->getDelayedAlertObjects($position, 'Objective');
		$upcomingProjects = $this->getUpcomingAlertObjects($position, 'Project');
		$delayedProjects = $this->getDelayedAlertObjects($position, 'Project');
		$upcomingProjectActivities = $this->getUpcomingAlertObjects($position, 'ProjectActivity');
		$delayedProjectActivities = $this->getDelayedAlertObjects($position, 'ProjectActivity');

		if ( count($upcomingObjectives) > 0 || count($delayedObjectives) > 0 ||
			 count($upcomingProjects) > 0 || count($delayedProjects) > 0 ||
			 count($upcomingProjectActivities) > 0 || count($delayedProjectActivities) > 0 ) {

			$alertMail = AlertMail::create($position, $responsible, [
				'upcomingObjectives' => $upcomingObjectives,
				'delayedObjectives' => $delayedObjectives,
				'upcomingProjects' => $upcomingProjects,
				'delayedProjects' => $delayedProjects,
				'upcomingProjectActivities' => $upcomingProjectActivities,
				'delayedProjectActivities' => $delayedProjectActivities,
			]);

			return $alertMail;

		} else {

			return null;

		}
	}

	function createAlertDigestMail($positions) {

		$alertBodies = [];

		foreach ($positions as $position) {
			$alertMail = $this->createAlertMail($position);
			if ($alertMail) {
				$alertBodies[] = $alertMail->getBody();
			}
		}

		return AlertDigestMail::create(
			$alertBodies,
			$this->getUpcomingAlertMinMax(),
			$this->getDelayedAlertMinMax()
		);
	}

	function createScheduleMail($position) {

		$tenure = $position->getPositionTenures()->getFirst();
		if (!$tenure) {
			return null;
		}

		$responsible = $tenure->getObject();

		$startingObjectives = $this->getScheduleStartObjects($position, 'Objective');
		$endingObjectives = $this->getScheduleEndObjects($position, 'Objective');
		$startingProjects = $this->getScheduleStartObjects($position, 'Project');
		$endingProjects = $this->getScheduleEndObjects($position, 'Project');
		$startingProjectActivities = $this->getScheduleStartObjects($position, 'ProjectActivity');
		$endingProjectActivities = $this->getScheduleEndObjects($position, 'ProjectActivity');

		if ( count($startingObjectives) > 0 || count($endingObjectives) > 0 ||
			 count($startingProjects) > 0 || count($endingProjects) > 0 ||
			 count($startingProjectActivities) > 0 || count($endingProjectActivities) > 0 ) {

			$scheduleMail = ScheduleMail::create($position, $responsible, [
				'startingObjectives' => $startingObjectives,
				'endingObjectives' => $endingObjectives,
				'startingProjects' => $startingProjects,
				'endingProjects' => $endingProjects,
				'startingProjectActivities' => $startingProjectActivities,
				'endingProjectActivities' => $endingProjectActivities,
			]);

			return $scheduleMail;

		} else {

			return null;

		}
	}
}
