<?php


/**
 * Base class that represents a query for the 'objectives_strategic' table.
 *
 * Strategic Objective
 *
 * @method StrategicObjectiveQuery orderById($order = Criteria::ASC) Order by the id column
 * @method StrategicObjectiveQuery orderByPolicyguidelineid($order = Criteria::ASC) Order by the policyGuidelineId column
 * @method StrategicObjectiveQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method StrategicObjectiveQuery orderByDescription($order = Criteria::ASC) Order by the description column
 * @method StrategicObjectiveQuery orderByUserid($order = Criteria::ASC) Order by the userId column
 * @method StrategicObjectiveQuery orderByAffiliateid($order = Criteria::ASC) Order by the affiliateId column
 * @method StrategicObjectiveQuery orderByUserbyaffiliatesid($order = Criteria::ASC) Order by the userByAffiliatesId column
 * @method StrategicObjectiveQuery orderByUpdated($order = Criteria::ASC) Order by the updated column
 * @method StrategicObjectiveQuery orderByChanges($order = Criteria::ASC) Order by the changes column
 * @method StrategicObjectiveQuery orderByOldid($order = Criteria::ASC) Order by the oldId column
 * @method StrategicObjectiveQuery orderByStartingyear($order = Criteria::ASC) Order by the startingYear column
 * @method StrategicObjectiveQuery orderByEndingyear($order = Criteria::ASC) Order by the endingYear column
 * @method StrategicObjectiveQuery orderByDeletedAt($order = Criteria::ASC) Order by the deleted_at column
 *
 * @method StrategicObjectiveQuery groupById() Group by the id column
 * @method StrategicObjectiveQuery groupByPolicyguidelineid() Group by the policyGuidelineId column
 * @method StrategicObjectiveQuery groupByName() Group by the name column
 * @method StrategicObjectiveQuery groupByDescription() Group by the description column
 * @method StrategicObjectiveQuery groupByUserid() Group by the userId column
 * @method StrategicObjectiveQuery groupByAffiliateid() Group by the affiliateId column
 * @method StrategicObjectiveQuery groupByUserbyaffiliatesid() Group by the userByAffiliatesId column
 * @method StrategicObjectiveQuery groupByUpdated() Group by the updated column
 * @method StrategicObjectiveQuery groupByChanges() Group by the changes column
 * @method StrategicObjectiveQuery groupByOldid() Group by the oldId column
 * @method StrategicObjectiveQuery groupByStartingyear() Group by the startingYear column
 * @method StrategicObjectiveQuery groupByEndingyear() Group by the endingYear column
 * @method StrategicObjectiveQuery groupByDeletedAt() Group by the deleted_at column
 *
 * @method StrategicObjectiveQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method StrategicObjectiveQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method StrategicObjectiveQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method StrategicObjectiveQuery leftJoinPolicyGuideline($relationAlias = null) Adds a LEFT JOIN clause to the query using the PolicyGuideline relation
 * @method StrategicObjectiveQuery rightJoinPolicyGuideline($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PolicyGuideline relation
 * @method StrategicObjectiveQuery innerJoinPolicyGuideline($relationAlias = null) Adds a INNER JOIN clause to the query using the PolicyGuideline relation
 *
 * @method StrategicObjectiveQuery leftJoinUser($relationAlias = null) Adds a LEFT JOIN clause to the query using the User relation
 * @method StrategicObjectiveQuery rightJoinUser($relationAlias = null) Adds a RIGHT JOIN clause to the query using the User relation
 * @method StrategicObjectiveQuery innerJoinUser($relationAlias = null) Adds a INNER JOIN clause to the query using the User relation
 *
 * @method StrategicObjectiveQuery leftJoinObjective($relationAlias = null) Adds a LEFT JOIN clause to the query using the Objective relation
 * @method StrategicObjectiveQuery rightJoinObjective($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Objective relation
 * @method StrategicObjectiveQuery innerJoinObjective($relationAlias = null) Adds a INNER JOIN clause to the query using the Objective relation
 *
 * @method StrategicObjectiveQuery leftJoinStrategicObjectiveLog($relationAlias = null) Adds a LEFT JOIN clause to the query using the StrategicObjectiveLog relation
 * @method StrategicObjectiveQuery rightJoinStrategicObjectiveLog($relationAlias = null) Adds a RIGHT JOIN clause to the query using the StrategicObjectiveLog relation
 * @method StrategicObjectiveQuery innerJoinStrategicObjectiveLog($relationAlias = null) Adds a INNER JOIN clause to the query using the StrategicObjectiveLog relation
 *
 * @method StrategicObjectiveQuery leftJoinObjectiveLog($relationAlias = null) Adds a LEFT JOIN clause to the query using the ObjectiveLog relation
 * @method StrategicObjectiveQuery rightJoinObjectiveLog($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ObjectiveLog relation
 * @method StrategicObjectiveQuery innerJoinObjectiveLog($relationAlias = null) Adds a INNER JOIN clause to the query using the ObjectiveLog relation
 *
 * @method StrategicObjective findOne(PropelPDO $con = null) Return the first StrategicObjective matching the query
 * @method StrategicObjective findOneOrCreate(PropelPDO $con = null) Return the first StrategicObjective matching the query, or a new StrategicObjective object populated from the query conditions when no match is found
 *
 * @method StrategicObjective findOneById(int $id) Return the first StrategicObjective filtered by the id column
 * @method StrategicObjective findOneByPolicyguidelineid(int $policyGuidelineId) Return the first StrategicObjective filtered by the policyGuidelineId column
 * @method StrategicObjective findOneByName(string $name) Return the first StrategicObjective filtered by the name column
 * @method StrategicObjective findOneByDescription(string $description) Return the first StrategicObjective filtered by the description column
 * @method StrategicObjective findOneByUserid(int $userId) Return the first StrategicObjective filtered by the userId column
 * @method StrategicObjective findOneByAffiliateid(int $affiliateId) Return the first StrategicObjective filtered by the affiliateId column
 * @method StrategicObjective findOneByUserbyaffiliatesid(int $userByAffiliatesId) Return the first StrategicObjective filtered by the userByAffiliatesId column
 * @method StrategicObjective findOneByUpdated(string $updated) Return the first StrategicObjective filtered by the updated column
 * @method StrategicObjective findOneByChanges(int $changes) Return the first StrategicObjective filtered by the changes column
 * @method StrategicObjective findOneByOldid(int $oldId) Return the first StrategicObjective filtered by the oldId column
 * @method StrategicObjective findOneByStartingyear(int $startingYear) Return the first StrategicObjective filtered by the startingYear column
 * @method StrategicObjective findOneByEndingyear(int $endingYear) Return the first StrategicObjective filtered by the endingYear column
 * @method StrategicObjective findOneByDeletedAt(string $deleted_at) Return the first StrategicObjective filtered by the deleted_at column
 *
 * @method array findById(int $id) Return StrategicObjective objects filtered by the id column
 * @method array findByPolicyguidelineid(int $policyGuidelineId) Return StrategicObjective objects filtered by the policyGuidelineId column
 * @method array findByName(string $name) Return StrategicObjective objects filtered by the name column
 * @method array findByDescription(string $description) Return StrategicObjective objects filtered by the description column
 * @method array findByUserid(int $userId) Return StrategicObjective objects filtered by the userId column
 * @method array findByAffiliateid(int $affiliateId) Return StrategicObjective objects filtered by the affiliateId column
 * @method array findByUserbyaffiliatesid(int $userByAffiliatesId) Return StrategicObjective objects filtered by the userByAffiliatesId column
 * @method array findByUpdated(string $updated) Return StrategicObjective objects filtered by the updated column
 * @method array findByChanges(int $changes) Return StrategicObjective objects filtered by the changes column
 * @method array findByOldid(int $oldId) Return StrategicObjective objects filtered by the oldId column
 * @method array findByStartingyear(int $startingYear) Return StrategicObjective objects filtered by the startingYear column
 * @method array findByEndingyear(int $endingYear) Return StrategicObjective objects filtered by the endingYear column
 * @method array findByDeletedAt(string $deleted_at) Return StrategicObjective objects filtered by the deleted_at column
 *
 * @package    propel.generator.objectives.classes.om
 */
abstract class BaseStrategicObjectiveQuery extends \Egytca\Propel\Query
{
    // soft_delete behavior
    protected static $softDelete = true;
    protected $localSoftDelete = true;

    /**
     * Initializes internal state of BaseStrategicObjectiveQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'StrategicObjective', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new StrategicObjectiveQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     StrategicObjectiveQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return StrategicObjectiveQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof StrategicObjectiveQuery) {
            return $criteria;
        }
        $query = new StrategicObjectiveQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   StrategicObjective|StrategicObjective[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = StrategicObjectivePeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(StrategicObjectivePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   StrategicObjective A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `POLICYGUIDELINEID`, `NAME`, `DESCRIPTION`, `USERID`, `AFFILIATEID`, `USERBYAFFILIATESID`, `UPDATED`, `CHANGES`, `OLDID`, `STARTINGYEAR`, `ENDINGYEAR`, `DELETED_AT` FROM `objectives_strategic` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new StrategicObjective();
            $obj->hydrate($row);
            StrategicObjectivePeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return StrategicObjective|StrategicObjective[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|StrategicObjective[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(StrategicObjectivePeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(StrategicObjectivePeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(StrategicObjectivePeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the policyGuidelineId column
     *
     * Example usage:
     * <code>
     * $query->filterByPolicyguidelineid(1234); // WHERE policyGuidelineId = 1234
     * $query->filterByPolicyguidelineid(array(12, 34)); // WHERE policyGuidelineId IN (12, 34)
     * $query->filterByPolicyguidelineid(array('min' => 12)); // WHERE policyGuidelineId > 12
     * </code>
     *
     * @see       filterByPolicyGuideline()
     *
     * @param     mixed $policyguidelineid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function filterByPolicyguidelineid($policyguidelineid = null, $comparison = null)
    {
        if (is_array($policyguidelineid)) {
            $useMinMax = false;
            if (isset($policyguidelineid['min'])) {
                $this->addUsingAlias(StrategicObjectivePeer::POLICYGUIDELINEID, $policyguidelineid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($policyguidelineid['max'])) {
                $this->addUsingAlias(StrategicObjectivePeer::POLICYGUIDELINEID, $policyguidelineid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectivePeer::POLICYGUIDELINEID, $policyguidelineid, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(StrategicObjectivePeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the description column
     *
     * Example usage:
     * <code>
     * $query->filterByDescription('fooValue');   // WHERE description = 'fooValue'
     * $query->filterByDescription('%fooValue%'); // WHERE description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $description The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function filterByDescription($description = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($description)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $description)) {
                $description = str_replace('*', '%', $description);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(StrategicObjectivePeer::DESCRIPTION, $description, $comparison);
    }

    /**
     * Filter the query on the userId column
     *
     * Example usage:
     * <code>
     * $query->filterByUserid(1234); // WHERE userId = 1234
     * $query->filterByUserid(array(12, 34)); // WHERE userId IN (12, 34)
     * $query->filterByUserid(array('min' => 12)); // WHERE userId > 12
     * </code>
     *
     * @see       filterByUser()
     *
     * @param     mixed $userid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function filterByUserid($userid = null, $comparison = null)
    {
        if (is_array($userid)) {
            $useMinMax = false;
            if (isset($userid['min'])) {
                $this->addUsingAlias(StrategicObjectivePeer::USERID, $userid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($userid['max'])) {
                $this->addUsingAlias(StrategicObjectivePeer::USERID, $userid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectivePeer::USERID, $userid, $comparison);
    }

    /**
     * Filter the query on the affiliateId column
     *
     * Example usage:
     * <code>
     * $query->filterByAffiliateid(1234); // WHERE affiliateId = 1234
     * $query->filterByAffiliateid(array(12, 34)); // WHERE affiliateId IN (12, 34)
     * $query->filterByAffiliateid(array('min' => 12)); // WHERE affiliateId > 12
     * </code>
     *
     * @param     mixed $affiliateid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function filterByAffiliateid($affiliateid = null, $comparison = null)
    {
        if (is_array($affiliateid)) {
            $useMinMax = false;
            if (isset($affiliateid['min'])) {
                $this->addUsingAlias(StrategicObjectivePeer::AFFILIATEID, $affiliateid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($affiliateid['max'])) {
                $this->addUsingAlias(StrategicObjectivePeer::AFFILIATEID, $affiliateid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectivePeer::AFFILIATEID, $affiliateid, $comparison);
    }

    /**
     * Filter the query on the userByAffiliatesId column
     *
     * Example usage:
     * <code>
     * $query->filterByUserbyaffiliatesid(1234); // WHERE userByAffiliatesId = 1234
     * $query->filterByUserbyaffiliatesid(array(12, 34)); // WHERE userByAffiliatesId IN (12, 34)
     * $query->filterByUserbyaffiliatesid(array('min' => 12)); // WHERE userByAffiliatesId > 12
     * </code>
     *
     * @param     mixed $userbyaffiliatesid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function filterByUserbyaffiliatesid($userbyaffiliatesid = null, $comparison = null)
    {
        if (is_array($userbyaffiliatesid)) {
            $useMinMax = false;
            if (isset($userbyaffiliatesid['min'])) {
                $this->addUsingAlias(StrategicObjectivePeer::USERBYAFFILIATESID, $userbyaffiliatesid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($userbyaffiliatesid['max'])) {
                $this->addUsingAlias(StrategicObjectivePeer::USERBYAFFILIATESID, $userbyaffiliatesid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectivePeer::USERBYAFFILIATESID, $userbyaffiliatesid, $comparison);
    }

    /**
     * Filter the query on the updated column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdated('2011-03-14'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated('now'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated(array('max' => 'yesterday')); // WHERE updated > '2011-03-13'
     * </code>
     *
     * @param     mixed $updated The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function filterByUpdated($updated = null, $comparison = null)
    {
        if (is_array($updated)) {
            $useMinMax = false;
            if (isset($updated['min'])) {
                $this->addUsingAlias(StrategicObjectivePeer::UPDATED, $updated['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updated['max'])) {
                $this->addUsingAlias(StrategicObjectivePeer::UPDATED, $updated['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectivePeer::UPDATED, $updated, $comparison);
    }

    /**
     * Filter the query on the changes column
     *
     * Example usage:
     * <code>
     * $query->filterByChanges(1234); // WHERE changes = 1234
     * $query->filterByChanges(array(12, 34)); // WHERE changes IN (12, 34)
     * $query->filterByChanges(array('min' => 12)); // WHERE changes > 12
     * </code>
     *
     * @param     mixed $changes The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function filterByChanges($changes = null, $comparison = null)
    {
        if (is_array($changes)) {
            $useMinMax = false;
            if (isset($changes['min'])) {
                $this->addUsingAlias(StrategicObjectivePeer::CHANGES, $changes['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($changes['max'])) {
                $this->addUsingAlias(StrategicObjectivePeer::CHANGES, $changes['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectivePeer::CHANGES, $changes, $comparison);
    }

    /**
     * Filter the query on the oldId column
     *
     * Example usage:
     * <code>
     * $query->filterByOldid(1234); // WHERE oldId = 1234
     * $query->filterByOldid(array(12, 34)); // WHERE oldId IN (12, 34)
     * $query->filterByOldid(array('min' => 12)); // WHERE oldId > 12
     * </code>
     *
     * @param     mixed $oldid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function filterByOldid($oldid = null, $comparison = null)
    {
        if (is_array($oldid)) {
            $useMinMax = false;
            if (isset($oldid['min'])) {
                $this->addUsingAlias(StrategicObjectivePeer::OLDID, $oldid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($oldid['max'])) {
                $this->addUsingAlias(StrategicObjectivePeer::OLDID, $oldid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectivePeer::OLDID, $oldid, $comparison);
    }

    /**
     * Filter the query on the startingYear column
     *
     * Example usage:
     * <code>
     * $query->filterByStartingyear(1234); // WHERE startingYear = 1234
     * $query->filterByStartingyear(array(12, 34)); // WHERE startingYear IN (12, 34)
     * $query->filterByStartingyear(array('min' => 12)); // WHERE startingYear > 12
     * </code>
     *
     * @param     mixed $startingyear The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function filterByStartingyear($startingyear = null, $comparison = null)
    {
        if (is_array($startingyear)) {
            $useMinMax = false;
            if (isset($startingyear['min'])) {
                $this->addUsingAlias(StrategicObjectivePeer::STARTINGYEAR, $startingyear['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($startingyear['max'])) {
                $this->addUsingAlias(StrategicObjectivePeer::STARTINGYEAR, $startingyear['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectivePeer::STARTINGYEAR, $startingyear, $comparison);
    }

    /**
     * Filter the query on the endingYear column
     *
     * Example usage:
     * <code>
     * $query->filterByEndingyear(1234); // WHERE endingYear = 1234
     * $query->filterByEndingyear(array(12, 34)); // WHERE endingYear IN (12, 34)
     * $query->filterByEndingyear(array('min' => 12)); // WHERE endingYear > 12
     * </code>
     *
     * @param     mixed $endingyear The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function filterByEndingyear($endingyear = null, $comparison = null)
    {
        if (is_array($endingyear)) {
            $useMinMax = false;
            if (isset($endingyear['min'])) {
                $this->addUsingAlias(StrategicObjectivePeer::ENDINGYEAR, $endingyear['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($endingyear['max'])) {
                $this->addUsingAlias(StrategicObjectivePeer::ENDINGYEAR, $endingyear['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectivePeer::ENDINGYEAR, $endingyear, $comparison);
    }

    /**
     * Filter the query on the deleted_at column
     *
     * Example usage:
     * <code>
     * $query->filterByDeletedAt('2011-03-14'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt('now'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt(array('max' => 'yesterday')); // WHERE deleted_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $deletedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function filterByDeletedAt($deletedAt = null, $comparison = null)
    {
        if (is_array($deletedAt)) {
            $useMinMax = false;
            if (isset($deletedAt['min'])) {
                $this->addUsingAlias(StrategicObjectivePeer::DELETED_AT, $deletedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deletedAt['max'])) {
                $this->addUsingAlias(StrategicObjectivePeer::DELETED_AT, $deletedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectivePeer::DELETED_AT, $deletedAt, $comparison);
    }

    /**
     * Filter the query by a related PolicyGuideline object
     *
     * @param   PolicyGuideline|PropelObjectCollection $policyGuideline The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   StrategicObjectiveQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPolicyGuideline($policyGuideline, $comparison = null)
    {
        if ($policyGuideline instanceof PolicyGuideline) {
            return $this
                ->addUsingAlias(StrategicObjectivePeer::POLICYGUIDELINEID, $policyGuideline->getId(), $comparison);
        } elseif ($policyGuideline instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(StrategicObjectivePeer::POLICYGUIDELINEID, $policyGuideline->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByPolicyGuideline() only accepts arguments of type PolicyGuideline or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PolicyGuideline relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function joinPolicyGuideline($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PolicyGuideline');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PolicyGuideline');
        }

        return $this;
    }

    /**
     * Use the PolicyGuideline relation PolicyGuideline object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PolicyGuidelineQuery A secondary query class using the current class as primary query
     */
    public function usePolicyGuidelineQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinPolicyGuideline($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PolicyGuideline', 'PolicyGuidelineQuery');
    }

    /**
     * Filter the query by a related User object
     *
     * @param   User|PropelObjectCollection $user The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   StrategicObjectiveQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByUser($user, $comparison = null)
    {
        if ($user instanceof User) {
            return $this
                ->addUsingAlias(StrategicObjectivePeer::USERID, $user->getId(), $comparison);
        } elseif ($user instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(StrategicObjectivePeer::USERID, $user->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByUser() only accepts arguments of type User or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the User relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function joinUser($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('User');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'User');
        }

        return $this;
    }

    /**
     * Use the User relation User object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   UserQuery A secondary query class using the current class as primary query
     */
    public function useUserQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinUser($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'User', 'UserQuery');
    }

    /**
     * Filter the query by a related Objective object
     *
     * @param   Objective|PropelObjectCollection $objective  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   StrategicObjectiveQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByObjective($objective, $comparison = null)
    {
        if ($objective instanceof Objective) {
            return $this
                ->addUsingAlias(StrategicObjectivePeer::ID, $objective->getStrategicobjectiveid(), $comparison);
        } elseif ($objective instanceof PropelObjectCollection) {
            return $this
                ->useObjectiveQuery()
                ->filterByPrimaryKeys($objective->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByObjective() only accepts arguments of type Objective or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Objective relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function joinObjective($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Objective');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Objective');
        }

        return $this;
    }

    /**
     * Use the Objective relation Objective object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ObjectiveQuery A secondary query class using the current class as primary query
     */
    public function useObjectiveQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinObjective($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Objective', 'ObjectiveQuery');
    }

    /**
     * Filter the query by a related StrategicObjectiveLog object
     *
     * @param   StrategicObjectiveLog|PropelObjectCollection $strategicObjectiveLog  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   StrategicObjectiveQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByStrategicObjectiveLog($strategicObjectiveLog, $comparison = null)
    {
        if ($strategicObjectiveLog instanceof StrategicObjectiveLog) {
            return $this
                ->addUsingAlias(StrategicObjectivePeer::ID, $strategicObjectiveLog->getStrategicid(), $comparison);
        } elseif ($strategicObjectiveLog instanceof PropelObjectCollection) {
            return $this
                ->useStrategicObjectiveLogQuery()
                ->filterByPrimaryKeys($strategicObjectiveLog->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByStrategicObjectiveLog() only accepts arguments of type StrategicObjectiveLog or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the StrategicObjectiveLog relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function joinStrategicObjectiveLog($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('StrategicObjectiveLog');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'StrategicObjectiveLog');
        }

        return $this;
    }

    /**
     * Use the StrategicObjectiveLog relation StrategicObjectiveLog object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   StrategicObjectiveLogQuery A secondary query class using the current class as primary query
     */
    public function useStrategicObjectiveLogQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinStrategicObjectiveLog($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'StrategicObjectiveLog', 'StrategicObjectiveLogQuery');
    }

    /**
     * Filter the query by a related ObjectiveLog object
     *
     * @param   ObjectiveLog|PropelObjectCollection $objectiveLog  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   StrategicObjectiveQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByObjectiveLog($objectiveLog, $comparison = null)
    {
        if ($objectiveLog instanceof ObjectiveLog) {
            return $this
                ->addUsingAlias(StrategicObjectivePeer::ID, $objectiveLog->getStrategicobjectiveid(), $comparison);
        } elseif ($objectiveLog instanceof PropelObjectCollection) {
            return $this
                ->useObjectiveLogQuery()
                ->filterByPrimaryKeys($objectiveLog->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByObjectiveLog() only accepts arguments of type ObjectiveLog or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ObjectiveLog relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function joinObjectiveLog($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ObjectiveLog');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ObjectiveLog');
        }

        return $this;
    }

    /**
     * Use the ObjectiveLog relation ObjectiveLog object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ObjectiveLogQuery A secondary query class using the current class as primary query
     */
    public function useObjectiveLogQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinObjectiveLog($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ObjectiveLog', 'ObjectiveLogQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   StrategicObjective $strategicObjective Object to remove from the list of results
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function prune($strategicObjective = null)
    {
        if ($strategicObjective) {
            $this->addUsingAlias(StrategicObjectivePeer::ID, $strategicObjective->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every SELECT statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreSelect(PropelPDO $con)
    {
        // soft_delete behavior
        if (StrategicObjectiveQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            $this->addUsingAlias(StrategicObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            StrategicObjectivePeer::enableSoftDelete();
        }

        return $this->preSelect($con);
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreDelete(PropelPDO $con)
    {
        // soft_delete behavior
        if (StrategicObjectiveQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            return $this->softDelete($con);
        } else {
            return $this->hasWhereClause() ? $this->forceDelete($con) : $this->forceDeleteAll($con);
        }

        return $this->preDelete($con);
    }

    // soft_delete behavior

    /**
     * Temporarily disable the filter on deleted rows
     * Valid only for the current query
     *
     * @see StrategicObjectiveQuery::disableSoftDelete() to disable the filter for more than one query
     *
     * @return StrategicObjectiveQuery The current query, for fluid interface
     */
    public function includeDeleted()
    {
        $this->localSoftDelete = false;

        return $this;
    }

    /**
     * Soft delete the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of updated rows
     */
    public function softDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => time()), $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDelete(PropelPDO $con = null)
    {
        return StrategicObjectivePeer::doForceDelete($this, $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of all the rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDeleteAll(PropelPDO $con = null)
    {
        return StrategicObjectivePeer::doForceDeleteAll($con);}

    /**
     * Undelete selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => null), $con);
    }

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        self::$softDelete = true;
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        self::$softDelete = false;
    }

    /**
     * Check the soft_delete behavior for this model
     *
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return self::$softDelete;
    }

}
