<?php



/**
 * This class defines the structure of the 'objectives_policyGuideline' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    propel.generator.objectives.classes.map
 */
class PolicyGuidelineTableMap extends TableMap
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'objectives.classes.map.PolicyGuidelineTableMap';

    /**
     * Initialize the table attributes, columns and validators
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('objectives_policyGuideline');
        $this->setPhpName('PolicyGuideline');
        $this->setClassname('PolicyGuideline');
        $this->setPackage('objectives.classes');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('NAME', 'Name', 'LONGVARCHAR', true, 255, null);
        $this->getColumn('NAME', false)->setPrimaryString(true);
        $this->addColumn('DESCRIPTION', 'Description', 'LONGVARCHAR', false, null, null);
        $this->addColumn('EXCHANGERATE', 'Exchangerate', 'FLOAT', false, null, null);
        $this->addForeignKey('USERID', 'Userid', 'INTEGER', 'users_user', 'ID', false, null, null);
        $this->addColumn('OBJECTTYPE', 'Objecttype', 'VARCHAR', true, 50, null);
        $this->addColumn('OBJECTID', 'Objectid', 'INTEGER', true, null, null);
        $this->addColumn('STARTINGYEAR', 'Startingyear', 'INTEGER', false, null, null);
        $this->addColumn('ENDINGYEAR', 'Endingyear', 'INTEGER', false, null, null);
        $this->addColumn('UPDATED', 'Updated', 'TIMESTAMP', false, null, null);
        $this->addColumn('CHANGES', 'Changes', 'INTEGER', false, null, null);
        $this->addColumn('DELETED_AT', 'DeletedAt', 'TIMESTAMP', false, null, null);
        // validators
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('User', 'User', RelationMap::MANY_TO_ONE, array('userId' => 'id', ), null, null);
        $this->addRelation('PolicyGuidelineIndicators', 'PolicyGuidelineIndicators', RelationMap::ONE_TO_MANY, array('id' => 'policyGuidelineId', ), 'CASCADE', null, 'PolicyGuidelineIndicatorss');
        $this->addRelation('StrategicObjective', 'StrategicObjective', RelationMap::ONE_TO_MANY, array('id' => 'policyGuidelineId', ), null, null, 'StrategicObjectives');
        $this->addRelation('Objective', 'Objective', RelationMap::ONE_TO_MANY, array('id' => 'policyGuidelineId', ), null, null, 'Objectives');
        $this->addRelation('PolicyGuidelineLog', 'PolicyGuidelineLog', RelationMap::ONE_TO_MANY, array('id' => 'policyGuidelineId', ), null, null, 'PolicyGuidelineLogs');
        $this->addRelation('StrategicObjectiveLog', 'StrategicObjectiveLog', RelationMap::ONE_TO_MANY, array('id' => 'policyGuidelineId', ), null, null, 'StrategicObjectiveLogs');
        $this->addRelation('ObjectiveLog', 'ObjectiveLog', RelationMap::ONE_TO_MANY, array('id' => 'policyGuidelineId', ), null, null, 'ObjectiveLogs');
        $this->addRelation('Mission', 'Mission', RelationMap::ONE_TO_MANY, array('id' => 'policyGuidelineId', ), 'SET NULL', null, 'Missions');
        $this->addRelation('Indicator', 'Indicator', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Indicators');
    } // buildRelations()

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array Associative array (name => parameters) of behaviors
     */
    public function getBehaviors()
    {
        return array(
            'soft_delete' => array('deleted_column' => 'deleted_at', ),
        );
    } // getBehaviors()

} // PolicyGuidelineTableMap
