<?php

class ObjectivesListAction extends BaseListAction {

        /**
         * 
         * @param type $entityClassName
         * Constructor
         */
	function __construct($entityClassName = 'Objective') {
		parent::__construct($entityClassName);
	}
        
        
        /**
         * 
         * Asignacion de variables a Smarty
         */
         protected function postList() {
             
             parent::postList();
            
            /**
             * 
             * Consulta a la base de datos
             */            
            $objectives = BaseQuery::create('Objective')->find();
            /**
             * 
             * Preparacion del array para transformarlo a json
             * Autocomplete
             */
            foreach ($objectives as $k => $v){
                $datos[] = ['id' => $v->getID(),'label' => $v->getName()];
            }
            $this->smarty->assign('objetivos', json_encode($datos));
            /**
             * 
             * Inicializando template Jquery
             */
             $this->smarty->assign('includeJQuery', true);
             $plugInKey = 'SMARTY_PLUGIN';
             $this->actionServer->getPlugIn($plugInKey);

            $module = 'Objectives';
            $section = 'Objectives';

            $this->smarty->assign('module',$module);
            $this->smarty->assign('section',$section);

            $moduleConfig = Common::getModuleConfiguration($module);
            $this->smarty->assign('moduleConfig',$moduleConfig);
            
             $version = PositionPeer::getLatestVersion();
			 $types = array_keys(ConfigModule::get('objectives','positionsTypes'));
             $positions = PositionPeer::getAllResponsiblesByPositionType($types,$version);
             $this->smarty->assign('positions',$positions);
         }
         
}