<?php
class ObjectivesEditAction extends BaseSelectAction {

	/**
	* 
	* @param type $entityClassName
	* Constructor
	*/
	function __construct($entityClassName = 'Objective') {
		parent::__construct($entityClassName);
	}
	
	/**
	* 
	* Asignacion de variables a Smarty
	*/
	protected function postSelect() {
		parent::postSelect();

		$this->smarty->assign('includeJQuery', true);

		if ($this->entity->isNew()) {
			$this->entity->setStartingYear($_SESSION['planning']['startingYear']);
			$this->entity->setEndingYear($_SESSION['planning']['endingYear']);
		}
		
		$version = PositionPeer::getLatestVersion();
		$types = array_keys(ConfigModule::get('objectives','positionsTypes'));
		$positions = PositionPeer::getAllResponsiblesByPositionType($types,$version);
		
		$strategicObjectives = StrategicObjectiveQuery::create()->find();
		
		$this->smarty->assign('positions',$positions);
		$this->smarty->assign('strategicObjectives',$strategicObjectives);
 	}
        
}
