<?php

/**
 * IndicatorsGraphDoEditAction
 *
 * Edicion de graficos de indicadores extendiendo BaseSelectAction
 *
 * @package indicators
 */

class IndicatorsGraphDoEditAction extends BaseDoEditAction {

	/**
	 * Constructor
	 */
	function __construct($entityClassName = 'IndicatorGraph') {
		parent::__construct($entityClassName);
	}

	function preSave() {
		parent::preSave();
		$this->updateNumericIndicators();
	}

	function updateNumericIndicators() {

		$wantedIndicatorsIds = $_POST['numericIndicatorIds'];

		IndicatorGraphSerieQuery::create()
			->filterByGraphId($this->entity->getId())
			->filterByIndicatorId($wantedIndicatorsIds, Criteria::NOT_IN)
			->delete();

		$existentIndicatorsIds = IndicatorGraphSerieQuery::create()
			->filterByGraphId($this->entity->getId())
			->filterByIndicatorId($wantedIndicatorsIds, Criteria::IN)
			->select('indicatorId')
			->find()
			->toArray();

		$missingIndicatorsIds = array_diff($wantedIndicatorsIds, $existentIndicatorsIds);
		foreach ($missingIndicatorsIds as $missingIndicatorId) {
			$serie = new IndicatorGraphSerie();
			$serie->setGraphId($this->entity->getId())
				->setIndicatorId($missingIndicatorId)
				->save();
		}
	}
}