<?php


/**
 * Base class that represents a query for the 'constructions_inspection' table.
 *
 * Inspecciones a la obra
 *
 * @method InspectionQuery orderById($order = Criteria::ASC) Order by the id column
 * @method InspectionQuery orderByConstructionid($order = Criteria::ASC) Order by the constructionId column
 * @method InspectionQuery orderByInspectorid($order = Criteria::ASC) Order by the inspectorId column
 * @method InspectionQuery orderByVisitdate($order = Criteria::ASC) Order by the visitDate column
 * @method InspectionQuery orderByEnddate($order = Criteria::ASC) Order by the endDate column
 * @method InspectionQuery orderByEnddateministry($order = Criteria::ASC) Order by the endDateMinistry column
 * @method InspectionQuery orderByWorkshop($order = Criteria::ASC) Order by the workshop column
 * @method InspectionQuery orderByProgressinspector($order = Criteria::ASC) Order by the progressInspector column
 * @method InspectionQuery orderByWorkingrate($order = Criteria::ASC) Order by the workingRate column
 * @method InspectionQuery orderByProgress($order = Criteria::ASC) Order by the progress column
 * @method InspectionQuery orderByConclusion($order = Criteria::ASC) Order by the conclusion column
 * @method InspectionQuery orderByWorkers($order = Criteria::ASC) Order by the workers column
 * @method InspectionQuery orderByStatus($order = Criteria::ASC) Order by the status column
 * @method InspectionQuery orderByOthercomments($order = Criteria::ASC) Order by the otherComments column
 *
 * @method InspectionQuery groupById() Group by the id column
 * @method InspectionQuery groupByConstructionid() Group by the constructionId column
 * @method InspectionQuery groupByInspectorid() Group by the inspectorId column
 * @method InspectionQuery groupByVisitdate() Group by the visitDate column
 * @method InspectionQuery groupByEnddate() Group by the endDate column
 * @method InspectionQuery groupByEnddateministry() Group by the endDateMinistry column
 * @method InspectionQuery groupByWorkshop() Group by the workshop column
 * @method InspectionQuery groupByProgressinspector() Group by the progressInspector column
 * @method InspectionQuery groupByWorkingrate() Group by the workingRate column
 * @method InspectionQuery groupByProgress() Group by the progress column
 * @method InspectionQuery groupByConclusion() Group by the conclusion column
 * @method InspectionQuery groupByWorkers() Group by the workers column
 * @method InspectionQuery groupByStatus() Group by the status column
 * @method InspectionQuery groupByOthercomments() Group by the otherComments column
 *
 * @method InspectionQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method InspectionQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method InspectionQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method InspectionQuery leftJoinConstruction($relationAlias = null) Adds a LEFT JOIN clause to the query using the Construction relation
 * @method InspectionQuery rightJoinConstruction($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Construction relation
 * @method InspectionQuery innerJoinConstruction($relationAlias = null) Adds a INNER JOIN clause to the query using the Construction relation
 *
 * @method InspectionQuery leftJoinInspector($relationAlias = null) Adds a LEFT JOIN clause to the query using the Inspector relation
 * @method InspectionQuery rightJoinInspector($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Inspector relation
 * @method InspectionQuery innerJoinInspector($relationAlias = null) Adds a INNER JOIN clause to the query using the Inspector relation
 *
 * @method InspectionQuery leftJoinInspectionPhoto($relationAlias = null) Adds a LEFT JOIN clause to the query using the InspectionPhoto relation
 * @method InspectionQuery rightJoinInspectionPhoto($relationAlias = null) Adds a RIGHT JOIN clause to the query using the InspectionPhoto relation
 * @method InspectionQuery innerJoinInspectionPhoto($relationAlias = null) Adds a INNER JOIN clause to the query using the InspectionPhoto relation
 *
 * @method Inspection findOne(PropelPDO $con = null) Return the first Inspection matching the query
 * @method Inspection findOneOrCreate(PropelPDO $con = null) Return the first Inspection matching the query, or a new Inspection object populated from the query conditions when no match is found
 *
 * @method Inspection findOneById(int $id) Return the first Inspection filtered by the id column
 * @method Inspection findOneByConstructionid(int $constructionId) Return the first Inspection filtered by the constructionId column
 * @method Inspection findOneByInspectorid(int $inspectorId) Return the first Inspection filtered by the inspectorId column
 * @method Inspection findOneByVisitdate(string $visitDate) Return the first Inspection filtered by the visitDate column
 * @method Inspection findOneByEnddate(string $endDate) Return the first Inspection filtered by the endDate column
 * @method Inspection findOneByEnddateministry(string $endDateMinistry) Return the first Inspection filtered by the endDateMinistry column
 * @method Inspection findOneByWorkshop(boolean $workshop) Return the first Inspection filtered by the workshop column
 * @method Inspection findOneByProgressinspector(int $progressInspector) Return the first Inspection filtered by the progressInspector column
 * @method Inspection findOneByWorkingrate(int $workingRate) Return the first Inspection filtered by the workingRate column
 * @method Inspection findOneByProgress(string $progress) Return the first Inspection filtered by the progress column
 * @method Inspection findOneByConclusion(string $conclusion) Return the first Inspection filtered by the conclusion column
 * @method Inspection findOneByWorkers(int $workers) Return the first Inspection filtered by the workers column
 * @method Inspection findOneByStatus(int $status) Return the first Inspection filtered by the status column
 * @method Inspection findOneByOthercomments(string $otherComments) Return the first Inspection filtered by the otherComments column
 *
 * @method array findById(int $id) Return Inspection objects filtered by the id column
 * @method array findByConstructionid(int $constructionId) Return Inspection objects filtered by the constructionId column
 * @method array findByInspectorid(int $inspectorId) Return Inspection objects filtered by the inspectorId column
 * @method array findByVisitdate(string $visitDate) Return Inspection objects filtered by the visitDate column
 * @method array findByEnddate(string $endDate) Return Inspection objects filtered by the endDate column
 * @method array findByEnddateministry(string $endDateMinistry) Return Inspection objects filtered by the endDateMinistry column
 * @method array findByWorkshop(boolean $workshop) Return Inspection objects filtered by the workshop column
 * @method array findByProgressinspector(int $progressInspector) Return Inspection objects filtered by the progressInspector column
 * @method array findByWorkingrate(int $workingRate) Return Inspection objects filtered by the workingRate column
 * @method array findByProgress(string $progress) Return Inspection objects filtered by the progress column
 * @method array findByConclusion(string $conclusion) Return Inspection objects filtered by the conclusion column
 * @method array findByWorkers(int $workers) Return Inspection objects filtered by the workers column
 * @method array findByStatus(int $status) Return Inspection objects filtered by the status column
 * @method array findByOthercomments(string $otherComments) Return Inspection objects filtered by the otherComments column
 *
 * @package    propel.generator.constructions.classes.om
 */
abstract class BaseInspectionQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseInspectionQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'Inspection', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new InspectionQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     InspectionQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return InspectionQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof InspectionQuery) {
            return $criteria;
        }
        $query = new InspectionQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   Inspection|Inspection[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = InspectionPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(InspectionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   Inspection A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `CONSTRUCTIONID`, `INSPECTORID`, `VISITDATE`, `ENDDATE`, `ENDDATEMINISTRY`, `WORKSHOP`, `PROGRESSINSPECTOR`, `WORKINGRATE`, `PROGRESS`, `CONCLUSION`, `WORKERS`, `STATUS`, `OTHERCOMMENTS` FROM `constructions_inspection` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new Inspection();
            $obj->hydrate($row);
            InspectionPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return Inspection|Inspection[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|Inspection[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return InspectionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(InspectionPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return InspectionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(InspectionPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return InspectionQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(InspectionPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the constructionId column
     *
     * Example usage:
     * <code>
     * $query->filterByConstructionid(1234); // WHERE constructionId = 1234
     * $query->filterByConstructionid(array(12, 34)); // WHERE constructionId IN (12, 34)
     * $query->filterByConstructionid(array('min' => 12)); // WHERE constructionId > 12
     * </code>
     *
     * @see       filterByConstruction()
     *
     * @param     mixed $constructionid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return InspectionQuery The current query, for fluid interface
     */
    public function filterByConstructionid($constructionid = null, $comparison = null)
    {
        if (is_array($constructionid)) {
            $useMinMax = false;
            if (isset($constructionid['min'])) {
                $this->addUsingAlias(InspectionPeer::CONSTRUCTIONID, $constructionid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($constructionid['max'])) {
                $this->addUsingAlias(InspectionPeer::CONSTRUCTIONID, $constructionid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(InspectionPeer::CONSTRUCTIONID, $constructionid, $comparison);
    }

    /**
     * Filter the query on the inspectorId column
     *
     * Example usage:
     * <code>
     * $query->filterByInspectorid(1234); // WHERE inspectorId = 1234
     * $query->filterByInspectorid(array(12, 34)); // WHERE inspectorId IN (12, 34)
     * $query->filterByInspectorid(array('min' => 12)); // WHERE inspectorId > 12
     * </code>
     *
     * @see       filterByInspector()
     *
     * @param     mixed $inspectorid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return InspectionQuery The current query, for fluid interface
     */
    public function filterByInspectorid($inspectorid = null, $comparison = null)
    {
        if (is_array($inspectorid)) {
            $useMinMax = false;
            if (isset($inspectorid['min'])) {
                $this->addUsingAlias(InspectionPeer::INSPECTORID, $inspectorid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($inspectorid['max'])) {
                $this->addUsingAlias(InspectionPeer::INSPECTORID, $inspectorid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(InspectionPeer::INSPECTORID, $inspectorid, $comparison);
    }

    /**
     * Filter the query on the visitDate column
     *
     * Example usage:
     * <code>
     * $query->filterByVisitdate('2011-03-14'); // WHERE visitDate = '2011-03-14'
     * $query->filterByVisitdate('now'); // WHERE visitDate = '2011-03-14'
     * $query->filterByVisitdate(array('max' => 'yesterday')); // WHERE visitDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $visitdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return InspectionQuery The current query, for fluid interface
     */
    public function filterByVisitdate($visitdate = null, $comparison = null)
    {
        if (is_array($visitdate)) {
            $useMinMax = false;
            if (isset($visitdate['min'])) {
                $this->addUsingAlias(InspectionPeer::VISITDATE, $visitdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($visitdate['max'])) {
                $this->addUsingAlias(InspectionPeer::VISITDATE, $visitdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(InspectionPeer::VISITDATE, $visitdate, $comparison);
    }

    /**
     * Filter the query on the endDate column
     *
     * Example usage:
     * <code>
     * $query->filterByEnddate('2011-03-14'); // WHERE endDate = '2011-03-14'
     * $query->filterByEnddate('now'); // WHERE endDate = '2011-03-14'
     * $query->filterByEnddate(array('max' => 'yesterday')); // WHERE endDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $enddate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return InspectionQuery The current query, for fluid interface
     */
    public function filterByEnddate($enddate = null, $comparison = null)
    {
        if (is_array($enddate)) {
            $useMinMax = false;
            if (isset($enddate['min'])) {
                $this->addUsingAlias(InspectionPeer::ENDDATE, $enddate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($enddate['max'])) {
                $this->addUsingAlias(InspectionPeer::ENDDATE, $enddate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(InspectionPeer::ENDDATE, $enddate, $comparison);
    }

    /**
     * Filter the query on the endDateMinistry column
     *
     * Example usage:
     * <code>
     * $query->filterByEnddateministry('2011-03-14'); // WHERE endDateMinistry = '2011-03-14'
     * $query->filterByEnddateministry('now'); // WHERE endDateMinistry = '2011-03-14'
     * $query->filterByEnddateministry(array('max' => 'yesterday')); // WHERE endDateMinistry > '2011-03-13'
     * </code>
     *
     * @param     mixed $enddateministry The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return InspectionQuery The current query, for fluid interface
     */
    public function filterByEnddateministry($enddateministry = null, $comparison = null)
    {
        if (is_array($enddateministry)) {
            $useMinMax = false;
            if (isset($enddateministry['min'])) {
                $this->addUsingAlias(InspectionPeer::ENDDATEMINISTRY, $enddateministry['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($enddateministry['max'])) {
                $this->addUsingAlias(InspectionPeer::ENDDATEMINISTRY, $enddateministry['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(InspectionPeer::ENDDATEMINISTRY, $enddateministry, $comparison);
    }

    /**
     * Filter the query on the workshop column
     *
     * Example usage:
     * <code>
     * $query->filterByWorkshop(true); // WHERE workshop = true
     * $query->filterByWorkshop('yes'); // WHERE workshop = true
     * </code>
     *
     * @param     boolean|string $workshop The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return InspectionQuery The current query, for fluid interface
     */
    public function filterByWorkshop($workshop = null, $comparison = null)
    {
        if (is_string($workshop)) {
            $workshop = in_array(strtolower($workshop), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(InspectionPeer::WORKSHOP, $workshop, $comparison);
    }

    /**
     * Filter the query on the progressInspector column
     *
     * Example usage:
     * <code>
     * $query->filterByProgressinspector(1234); // WHERE progressInspector = 1234
     * $query->filterByProgressinspector(array(12, 34)); // WHERE progressInspector IN (12, 34)
     * $query->filterByProgressinspector(array('min' => 12)); // WHERE progressInspector > 12
     * </code>
     *
     * @param     mixed $progressinspector The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return InspectionQuery The current query, for fluid interface
     */
    public function filterByProgressinspector($progressinspector = null, $comparison = null)
    {
        if (is_array($progressinspector)) {
            $useMinMax = false;
            if (isset($progressinspector['min'])) {
                $this->addUsingAlias(InspectionPeer::PROGRESSINSPECTOR, $progressinspector['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($progressinspector['max'])) {
                $this->addUsingAlias(InspectionPeer::PROGRESSINSPECTOR, $progressinspector['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(InspectionPeer::PROGRESSINSPECTOR, $progressinspector, $comparison);
    }

    /**
     * Filter the query on the workingRate column
     *
     * Example usage:
     * <code>
     * $query->filterByWorkingrate(1234); // WHERE workingRate = 1234
     * $query->filterByWorkingrate(array(12, 34)); // WHERE workingRate IN (12, 34)
     * $query->filterByWorkingrate(array('min' => 12)); // WHERE workingRate > 12
     * </code>
     *
     * @param     mixed $workingrate The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return InspectionQuery The current query, for fluid interface
     */
    public function filterByWorkingrate($workingrate = null, $comparison = null)
    {
        if (is_array($workingrate)) {
            $useMinMax = false;
            if (isset($workingrate['min'])) {
                $this->addUsingAlias(InspectionPeer::WORKINGRATE, $workingrate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($workingrate['max'])) {
                $this->addUsingAlias(InspectionPeer::WORKINGRATE, $workingrate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(InspectionPeer::WORKINGRATE, $workingrate, $comparison);
    }

    /**
     * Filter the query on the progress column
     *
     * Example usage:
     * <code>
     * $query->filterByProgress('fooValue');   // WHERE progress = 'fooValue'
     * $query->filterByProgress('%fooValue%'); // WHERE progress LIKE '%fooValue%'
     * </code>
     *
     * @param     string $progress The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return InspectionQuery The current query, for fluid interface
     */
    public function filterByProgress($progress = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($progress)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $progress)) {
                $progress = str_replace('*', '%', $progress);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(InspectionPeer::PROGRESS, $progress, $comparison);
    }

    /**
     * Filter the query on the conclusion column
     *
     * Example usage:
     * <code>
     * $query->filterByConclusion('fooValue');   // WHERE conclusion = 'fooValue'
     * $query->filterByConclusion('%fooValue%'); // WHERE conclusion LIKE '%fooValue%'
     * </code>
     *
     * @param     string $conclusion The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return InspectionQuery The current query, for fluid interface
     */
    public function filterByConclusion($conclusion = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($conclusion)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $conclusion)) {
                $conclusion = str_replace('*', '%', $conclusion);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(InspectionPeer::CONCLUSION, $conclusion, $comparison);
    }

    /**
     * Filter the query on the workers column
     *
     * Example usage:
     * <code>
     * $query->filterByWorkers(1234); // WHERE workers = 1234
     * $query->filterByWorkers(array(12, 34)); // WHERE workers IN (12, 34)
     * $query->filterByWorkers(array('min' => 12)); // WHERE workers > 12
     * </code>
     *
     * @param     mixed $workers The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return InspectionQuery The current query, for fluid interface
     */
    public function filterByWorkers($workers = null, $comparison = null)
    {
        if (is_array($workers)) {
            $useMinMax = false;
            if (isset($workers['min'])) {
                $this->addUsingAlias(InspectionPeer::WORKERS, $workers['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($workers['max'])) {
                $this->addUsingAlias(InspectionPeer::WORKERS, $workers['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(InspectionPeer::WORKERS, $workers, $comparison);
    }

    /**
     * Filter the query on the status column
     *
     * Example usage:
     * <code>
     * $query->filterByStatus(1234); // WHERE status = 1234
     * $query->filterByStatus(array(12, 34)); // WHERE status IN (12, 34)
     * $query->filterByStatus(array('min' => 12)); // WHERE status > 12
     * </code>
     *
     * @param     mixed $status The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return InspectionQuery The current query, for fluid interface
     */
    public function filterByStatus($status = null, $comparison = null)
    {
        if (is_array($status)) {
            $useMinMax = false;
            if (isset($status['min'])) {
                $this->addUsingAlias(InspectionPeer::STATUS, $status['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($status['max'])) {
                $this->addUsingAlias(InspectionPeer::STATUS, $status['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(InspectionPeer::STATUS, $status, $comparison);
    }

    /**
     * Filter the query on the otherComments column
     *
     * Example usage:
     * <code>
     * $query->filterByOthercomments('fooValue');   // WHERE otherComments = 'fooValue'
     * $query->filterByOthercomments('%fooValue%'); // WHERE otherComments LIKE '%fooValue%'
     * </code>
     *
     * @param     string $othercomments The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return InspectionQuery The current query, for fluid interface
     */
    public function filterByOthercomments($othercomments = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($othercomments)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $othercomments)) {
                $othercomments = str_replace('*', '%', $othercomments);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(InspectionPeer::OTHERCOMMENTS, $othercomments, $comparison);
    }

    /**
     * Filter the query by a related Construction object
     *
     * @param   Construction|PropelObjectCollection $construction The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   InspectionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByConstruction($construction, $comparison = null)
    {
        if ($construction instanceof Construction) {
            return $this
                ->addUsingAlias(InspectionPeer::CONSTRUCTIONID, $construction->getId(), $comparison);
        } elseif ($construction instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(InspectionPeer::CONSTRUCTIONID, $construction->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByConstruction() only accepts arguments of type Construction or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Construction relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return InspectionQuery The current query, for fluid interface
     */
    public function joinConstruction($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Construction');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Construction');
        }

        return $this;
    }

    /**
     * Use the Construction relation Construction object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ConstructionQuery A secondary query class using the current class as primary query
     */
    public function useConstructionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinConstruction($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Construction', 'ConstructionQuery');
    }

    /**
     * Filter the query by a related Inspector object
     *
     * @param   Inspector|PropelObjectCollection $inspector The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   InspectionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByInspector($inspector, $comparison = null)
    {
        if ($inspector instanceof Inspector) {
            return $this
                ->addUsingAlias(InspectionPeer::INSPECTORID, $inspector->getId(), $comparison);
        } elseif ($inspector instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(InspectionPeer::INSPECTORID, $inspector->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByInspector() only accepts arguments of type Inspector or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Inspector relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return InspectionQuery The current query, for fluid interface
     */
    public function joinInspector($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Inspector');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Inspector');
        }

        return $this;
    }

    /**
     * Use the Inspector relation Inspector object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   InspectorQuery A secondary query class using the current class as primary query
     */
    public function useInspectorQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinInspector($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Inspector', 'InspectorQuery');
    }

    /**
     * Filter the query by a related InspectionPhoto object
     *
     * @param   InspectionPhoto|PropelObjectCollection $inspectionPhoto  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   InspectionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByInspectionPhoto($inspectionPhoto, $comparison = null)
    {
        if ($inspectionPhoto instanceof InspectionPhoto) {
            return $this
                ->addUsingAlias(InspectionPeer::ID, $inspectionPhoto->getInspectionid(), $comparison);
        } elseif ($inspectionPhoto instanceof PropelObjectCollection) {
            return $this
                ->useInspectionPhotoQuery()
                ->filterByPrimaryKeys($inspectionPhoto->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByInspectionPhoto() only accepts arguments of type InspectionPhoto or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the InspectionPhoto relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return InspectionQuery The current query, for fluid interface
     */
    public function joinInspectionPhoto($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('InspectionPhoto');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'InspectionPhoto');
        }

        return $this;
    }

    /**
     * Use the InspectionPhoto relation InspectionPhoto object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   InspectionPhotoQuery A secondary query class using the current class as primary query
     */
    public function useInspectionPhotoQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinInspectionPhoto($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'InspectionPhoto', 'InspectionPhotoQuery');
    }

    /**
     * Filter the query by a related Resource object
     * using the constructions_inspectionPhoto table as cross reference
     *
     * @param   Resource $resource the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   InspectionQuery The current query, for fluid interface
     */
    public function filterByResource($resource, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useInspectionPhotoQuery()
            ->filterByResource($resource, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   Inspection $inspection Object to remove from the list of results
     *
     * @return InspectionQuery The current query, for fluid interface
     */
    public function prune($inspection = null)
    {
        if ($inspection) {
            $this->addUsingAlias(InspectionPeer::ID, $inspection->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
