<?php

/**
 * BackupSendByEmailAction
 *
 * Envio de respaldo generado por mail extendiendo el BaseAction
 *
 * @package backup
 */

class BackupSendByEmailAction extends BaseAction {

	/**
	 * Acciones a ejecutar antes de generar el display
	 */
	protected function exec() {
		parent::exec();

		require_once('Backup.php');
		$backup = new Backup();

		$filename = null;
		$email = null;
		$complete = null;

		if (!empty($_POST['filename']))
			$filename = $_POST['filename'];

		if (!empty($_POST['email']))
			$email = $_POST['email'];

		if (!empty($_POST['complete']))
			$complete = $_POST['complete'];

		if($backup->sendBackupToEmail($email, $filename, $complete)) {
			Common::doLog('success', 'system');
			if (empty($filename))
				die; //Estamos ejecutando por cron.
			return true;
		}
		else {
			Common::doLog('failure', 'system');
			if (empty($filename))
				die; //Estamos ejecutando por cron.
			return false;
		}

	} //End exec

}
