var setOpStatus = function(statusContainer, status) {

	egytcaDeprecate('setOpStatus is deprecated: use GifStatusView instead.');

	if (status == 'success')
		statusContainer.innerHTML = '<img src="images/icon_yes.png" alt="success">';
	else if (status == 'failure')
		statusContainer.innerHTML = '<img src="images/icon_no.png" alt="failure">';
	else if (status == 'working')
		statusContainer.innerHTML = '<img src="images/spinner.gif" alt="working...">';
	else if (status == 'clear')
		statusContainer.innerHTML = '';
	else
		throw 'invalid status';
};

var replaceOrPushEntity = function(entity, array) {
	var index = findIndexByKeyValue('Id', entity.Id, array);
	if (index !== false)
		array[index] = entity;
	else
		array.push(entity);
};

var removeEntity = function(entity, array) {
	array.splice(array.indexOf(entity), 1);
};

var createResourcesArray = function(entities, Resource) {
	return entities.map(function(entity) {
		return new Resource(entity);
	});
};


/* ******************************* */
var basicCreate = function(entitiesArray, initNewEntity, statusView) {
	return function(entity) {

		statusView.setStatusWorking();

		entity.$save(function(response) {
			entitiesArray.push(entity);
			initNewEntity();
			statusView.setStatusSuccess();
		}, function(response) {
			statusView.setStatusFailure();
		});
	};
};

var basicSave = function(statusView, updateWindowHref) {
	return function(entity) {

		if (!validationValidateFormClienSide(this.form, false))
			return;

		statusView.setStatusWorking();

		entity.$save(function(response) {
			statusView.setStatusSuccess();

			if (updateWindowHref) {

				var id = response.Id;
				var href = window.location.href;

				href = href.replace(/#$/, '');
				if (!href.match(/&id=/)) { // new object creation
					var newHref = href + '&id=' + id;
					window.history.replaceState(null, '', newHref);
				}
			}

		}, function(response) {
			statusView.setStatusFailure();
		});
	};
};

var basicDelete = function(entitiesArray, statusView) {
	return function(entity, confirmMessage) {

		if (!confirm(confirmMessage))
			return;

		statusView.setStatusWorking();

		entity.$delete(function(response) {
			removeEntity(entity, entitiesArray);
			statusView.setStatusSuccess();
		}, function(response) {
			statusView.setStatusFailure();
		});
	};
};
/* ******************************* */


/* ******** GifStatusView ******** */
var GifStatusView = function(boxes) {
	this.boxes = boxes instanceof Array ? boxes : [boxes];
};

GifStatusView.prototype = {

	setStatusSuccess: function() {
		this.setStatusHTML('<img src="images/icon_yes.png" alt="success">');
	},

	setStatusFailure: function() {
		this.setStatusHTML('<img src="images/icon_no.png" alt="failure">');
	},

	setStatusWorking: function() {
		this.setStatusHTML('<img src="images/spinner.gif" alt="working...">');
	},

	setStatusHTML: function(html) {
		this.boxes.forEach(function(box) {
			box.innerHTML = html;
		});
	}
};
/* ****** end GifStatusView ****** */
