|-*
params:
	entityService: name of service of associatedEntities
	entities: entities
	parentIdField:
	parent
*-|

|-block "assign"-||-/block-|

|-counter name="tplId" assign="tplId"-|

<style>
	table.associatedEntities {
		width: 100%;
	}
</style>

<div ng-controller="AssociatedEntitiesListController-|-$tplId-|">
	<table class="tableTdBorders associatedEntities">
		<thead>
			<th colspan="3" class="thFillTitle">
				<div class="rightLink">
					<span id="new-entity-status-|-$tplId-|"></span>
					<a ng-click="createEntity(newEntity)" class="addLink">|-$addEntity|default:'##common,125,Agregar item##'-|</a>
				</div>
			</th>
			<tr>
				<th width="5%" nowrap="nowrap">##panel,33,Estado##</th>
				<th width="90%" nowrap="nowrap">##common,121,Nombre##</th>
				<th width="5%" nowrap="nowrap">&nbsp;</th>
			</tr>
		</thead>
		<tbody>
			<tr ng-repeat="entity in entities">
				<td align="center" nowrap="nowrap"><div class="status {{entity.Status}}"></div></td>
				<td><a ng-click="viewEntity(entity)">{{entity.Name}}</a></td>
				<td align="center" nowrap="nowrap">
					<button type="button" class="icon iconEdit" ng-click="editEntity(entity)" title="##common,1,Editar##">##common,1,Editar##</button>
					<button type="button" class="icon iconDelete" ng-click="deleteEntity(entity)" title="##common,2,Eliminar##">##common,2,Eliminar##</button>
					<span id="entity-status-{{entity.Id}}-|-$tplId-|"></span>
				</td>
			</tr>
			<tr ng-show="entities.length == 0">
				<td colspan="3">No hay items.</td>
			</tr>
		</tbody>
	</table>

	<div style="display: none;">
		<div id="entity-edit-box-|-$tplId-|">
			<entity-edit entity="editBoxEntity" entity-type="|-$entityService-|" entity-parent="parentEntity"
				save-fn="saveEntity" cancel-fn="cancelEntityEdition">
			</entity-edit>
		</div>
	</div>
	<div style="display: none;">
		<div id="entity-view-box-|-$tplId-|">
			<entity-view entity="viewBoxEntity" entity-type="|-$entityService-|" entity-parent="parentEntity">
			</entity-view>
		</div>
	</div>
</div>
<script>
	egytcaApp.controller('AssociatedEntitiesListController-|-$tplId-|', ['$scope', '|-$entityService-|',
		function($scope, |-$entityService-|) {

			$scope.entities = [];
			|-foreach $entities as $entity-|
				var entity = new |-$entityService-|(|-$entity->toJSON()-|);
				$scope.entities.push(entity);
			|-/foreach-|

			var createNewEntity = function() {
				var newEntity = new |-$entityService-|();
				newEntity.|-$parentIdField-| = |-$parent->getId()-|;
				return newEntity;
			};

			$scope.parentEntity = |-$parent->toJSON()-|;
			$scope.newEntity = createNewEntity();
			$scope.editBoxEntity = {};
			$scope.viewBoxEntity = {};

			$scope.viewEntity = function(entity) {
				$scope.viewBoxEntity = entity;
				$.fancybox.open('#entity-view-box-|-$tplId-|');
			};

			$scope.createEntity = function(entity) {
				$scope.editBoxEntity = createNewEntity();
				$.fancybox.open('#entity-edit-box-|-$tplId-|');
			};

			$scope.editEntity = function(entity) {
				$scope.editBoxEntity = new |-$entityService-|(entity);
				$.fancybox.open('#entity-edit-box-|-$tplId-|');
			};

			$scope.cancelEntityEdition = function(entity) {
				$.fancybox.close();
			};

			$scope.saveEntity = function(entity) {

				var statusContainer = getStatusContainer(entity);
				setOpStatus(statusContainer, 'working');

				entity.$save(function(entity) {
					replaceOrPushEntity(entity, $scope.entities);
					setTimeout(function() { setOpStatus(statusContainer, 'success'); }, 200); // arreglar
					$.fancybox.close();
				}, function() {
					setOpStatus(statusContainer, 'failure');
				});
			};

			$scope.deleteEntity = function(entity) {

				if (confirm('¿Está seguro de que desea eliminar el item?')) {

					var statusContainer = getStatusContainer(entity);
					setOpStatus(statusContainer, 'working');

					entity.$delete(function(entity) {
						setOpStatus(statusContainer, 'success');
						removeEntity(entity, $scope.entities);
					}, function() {
						setOpStatus(statusContainer, 'failure');
					});
				}
			};

			var getStatusContainer = function(entity) {
				var newEntityStatusId = 'new-entity-status-|-$tplId-|';
				var entityStatusId = 'entity-status-' + entity.Id + '-|-$tplId-|';
				var id = entity.Id === undefined ? newEntityStatusId : entityStatusId;
				return document.getElementById(id);
			};
		}
	]);
</script>