<?php
/** 
 * UsersWelcomeAction
 *
 * @package users 
 */

class UsersWelcomeAction extends BaseAction {

	function UsersWelcomeAction() {
		;
	}

	function execute($mapping, $form, &$request, &$response) {

    BaseAction::execute($mapping, $form, $request, $response);

		//////////
		// Use a different template
		$this->template->template = "TemplateWelcome.tpl";

		//////////
		// Access the Smarty PlugIn instance
		// Note the reference "=&"
		$plugInKey = 'SMARTY_PLUGIN';
		$smarty =& $this->actionServer->getPlugIn($plugInKey);
		if($smarty == NULL) {
			echo 'No PlugIn found matching key: '.$plugInKey."<br>\n";
		}

		$module = "Users";
		
		$projectsCountByColors = ProjectPeer::getProjectsByStatusColorCountAssoc();
		$smarty->assign('projectsCountByColors', $projectsCountByColors);		
		
		$projectsSpeed = ProjectPeer::getSpeed();
		$smarty->assign('projectsSpeed', $projectsSpeed);
		
		$smarty->assign('projects', ProjectQuery::create()
																						->filterByLatitude(0, Criteria::NOT_EQUAL)
																						->filterByLongitude(0, Criteria::NOT_EQUAL)
																						->filterByResponsible()
																						->find());
		if (ConfigModule::get("users","internalMail"))
			$smarty->assign('newInternalMail', InternalMailQuery::create()->filterByRecipient(Common::getLoggedUser())->filterByReadon(NULL)->count());

		return $mapping->findForwardConfig('success');
	}

}
