<link type="text/css" href="css/chosen/chosen.min.css" rel="stylesheet" />
<link type="text/css" href="css/smoothness/jquery-ui-1.8.19.custom.css" rel="Stylesheet" />
<link rel="stylesheet" type="text/css" href="css/featherlight/featherlight.min.css">

<script type="text/javascript" src="scripts/jquery/chosen/chosen.min.js"></script>
<script type="text/javascript" src="scripts/jquery/jquery-ui-1.8.19.custom.min.js"></script>
<script type="text/javascript" src="scripts/jquery/featherlight/featherlight.min.js"></script> 

<script type="text/javascript">
	
	$(document).ready(function() {

		$('.chzn-select').chosen({
			search_contains: true, // full text search
			inherit_select_classes: true // hereda clases del select padre
		});

		$.datepicker.setDefaults({
			dateFormat: 'dd-mm-yy',
			maxDate: "+20y",
			changeMonth: true,
			changeYear: true
		});

		$('#fechaPlanHasta').datepicker();
		$('#fechaPlanDesde').datepicker();

	});

	function getProjectActivitiesViewX (projectId) {
		$.ajax({
			url: 'Main.php?do=projectsActivitiesViewX',
			type: 'get',
			data: {id : projectId},
			success: function(data) {
				$.featherlight(data, {loading:'Loading Projects..'});
				$('.featherlight').css("background", "rgba(0,0,0,.8)")
			}
		});
	}

</script>

<style>
	.chosen-container.chosen-container-single {
		width: 45% !important;
	}
</style>

<h2>Tablero de Gestión</h2>
<h1>Actividades</h1>
|-*<p>A continuación se muestra la lista de actividades cargadas en el sistema.</p>*-|
|-if is_object($parentObject)-|
	<div id="navBar">
		|-include file="NavigationParentInclude.tpl" object=$parentObject first="true"-| |-$parentObject->getName()-|
	</div>
|-/if-|
<div id="div_Activities">
	|-if $message eq "ok"-|
		<div class="successMessage">Actividad guardada correctamente</div>
	|-elseif $message eq "deleted_ok"-|
		<div class="successMessage">Actividad eliminada correctamente</div>
	|-/if-|
	<table id="tabla-Activities" class='tableTdBorders' cellpadding='5' cellspacing='0' width='100%'>
		<thead>
		<tr>
			<td colspan="8" class="tdSearch">
				|-if "projectsActivitiesEdit"|security_has_access-|
					<a href="Main.php?do=projectsActivitiesEdit|-include file="FiltersRedirectUrlInclude.tpl" filters=$filters-||-if isset($pager) && ($pager->getPage() ne 1)-|&page=|-$pager->getPage()-||-/if-|" class="addLink rightLink">Agregar Actividad</a>
				|-/if-|
				<a href="javascript:void(null);" onClick='switch_vis("divSearch");' class="tdTitSearch" style="clear: left;">Busqueda actividades</a>
				<div id="divSearch" style="display:|-if $filters|@count gt 0 && !($filters.fromProjects)-|block|-else-|none|-/if-|;">
					<form action='Main.php' method='get' style="display:inline;">
						<input type="hidden" name="do" value="projectsActivitiesList" />					
						<p>
							<label for="filters[responsibleCode]">Dependencia</label>
							<select name="filters[responsibleCode]" class="chzn-select" style="width:40%;">
								<option value="">Todas</option>
								|-foreach from=$positions item=positionItem name=for_positions-| |-*Controlo el is_numeric porque los positions empiezan con el codigo 0*-|
									<option value="|-$positionItem->getCode()-|" |-if isset($filters.responsibleCode) and $filters.responsibleCode eq $positionItem->getCode() and is_numeric($filters.responsibleCode) -|selected="selected"|-/if-|>|-$positionItem->getName()-|</option>
								|-/foreach-|
							</select> 
							<label>Incluir dependientes</label>
							&nbsp;
							|-if isset($filters)-|
								<input id="includeDep" type="checkbox" name="filters[includeDependents]" value="1" title="Incluye todas las dependencias que dependen de esta"
								|-$filters.includeDependents|checked_bool-|>
							|-else-|
								<input id="includeDep" type="checkbox" name="filters[includeDependents]" value="1" title="Incluye todas las dependencias que dependen de esta" checked>
							|-/if-|
						</p>					
						<p>
							<label for="filters[searchString]">Nombre</label><input name="filters[searchString]" type="text" value="|-if isset($filters.searchString)-||-$filters.searchString-||-/if-|" size="50" />
						</p>
						<p>
							<label>Estado</label>

							&nbsp;
							<input type="checkbox" name="filters[status][delayed]" value="1" title="Mostrar solo proyectos con fecha de fin planificado vencida" |-$filters.status.delayed|checked_bool-|>
							<label for="filters[status][delayed]" class="widthAuto">Retrasados</label>

							&nbsp;
							<input type="checkbox" name="filters[status][ontime]" value="1" title="Actividades en fecha" |-$filters.status.ontime|checked_bool-| />
							<label for="filters[status][ontime]" class="widthAuto">En Ejecución</label>

							&nbsp;
							<input type="checkbox" name="filters[status][ended]" value="1"  title="Proyectos finalizados" |-$filters.status.ended|checked_bool-|>
							<label for="filters[status][ended]" class="widthAuto">Finalizados</label>
						</p>
						<p>
							<label for="filters[dateFrom]">Planificado desde</label>
							<input id="fechaPlanDesde" name="filters[dateFrom]" type="text" value="|-$filters.dateFrom-|" size="12" title="Fecha desde dd-mm-aaaa" /> 
							<img src="images/calendar.png" width="16" height="15" border="0" title="Seleccione la fecha desde dd-mm-aaaa">
							
							<label for="filters[dateTo]"> hasta</label>
							<input id="fechaPlanHasta" name="filters[dateTo]" type="text" value="|-$filters.dateTo-|" size="12" title="Fecha hasta dd-mm-aaaa" />
							<img src="images/calendar.png" width="16" height="15" border="0" title="Seleccione la fecha hasta dd-mm-aaaa">
						</p>
						<p>
							<label>Interés prensa</label>

							<input type="radio" name="filters[press]" value="1" |-$filters.press|checked_bool-|>
							Sí
							&nbsp;

							<input type="radio" name="filters[press]" value="0" |-($filters.press === '0')|checked_bool-|>
							No
							&nbsp;

							<input type="radio" name="filters[press]" value="" |-(!$filters.press && $filters.press !== '0')|checked_bool-|>
							No filtrar
							&nbsp;
						</p>
						<input type='submit' value='Buscar' />
					</form>

					|-if $filters|@count gt 0-|
						<form action='Main.php' method="get">
							<input type="hidden" name="do" value="projectsActivitiesList" />
							<input type="submit" value="Quitar Filtros" />
						</form>
					|-/if-|
				</div>
			</td>
		</tr>
		

		|-include file="ProjectsActivitiesListTableInclude.tpl"-|
				
		<tr>
			<td colspan="9" class="pages">
			|-if $filters|@count gt 0-|
					Mostrando |-$pager->getNbResults()-| Actividades filtradas de un total de |-ProjectActivityQuery::create()->count()-|
				|-else-|
					Mostrando |-$pager->getNbResults()-| Actividades
			|-/if-|			
			|-if isset($pager) && $pager->haveToPaginate()-|
				<br /><br />
				|-include file="ModelPagerInclude.tpl"-|
			|-/if-|
			</td>
		</tr>
		

		|-if "projectsActivitiesDoDelete"|security_has_access-|
		<tr>
			<th colspan="8" class="thFillTitle">
				|-if $projectActivityColl|@count gt 5-|
					<div class="rightLink">
						<a href="Main.php?do=projectsActivitiesEdit|-include file="FiltersRedirectUrlInclude.tpl" filters=$filters-||-if isset($page) && ($pager->getPage() ne 1)-|&page=|-$pager->getPage()-||-/if-|" class="addLink">Agregar Actividad</a>
					</div>
				|-/if-|
			</th>
		</tr>
		|-/if-|
		</tbody>
	</table>
</div>
