<?php


/**
 * Base class that represents a query for the 'projects_milestone' table.
 *
 * Milestone
 *
 * @method ProjectMilestoneQuery orderById($order = Criteria::ASC) Order by the id column
 * @method ProjectMilestoneQuery orderByProjectid($order = Criteria::ASC) Order by the projectId column
 * @method ProjectMilestoneQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method ProjectMilestoneQuery orderByDate($order = Criteria::ASC) Order by the date column
 * @method ProjectMilestoneQuery orderByExpirationdate($order = Criteria::ASC) Order by the expirationDate column
 * @method ProjectMilestoneQuery orderByCompleted($order = Criteria::ASC) Order by the completed column
 * @method ProjectMilestoneQuery orderByNotes($order = Criteria::ASC) Order by the notes column
 *
 * @method ProjectMilestoneQuery groupById() Group by the id column
 * @method ProjectMilestoneQuery groupByProjectid() Group by the projectId column
 * @method ProjectMilestoneQuery groupByName() Group by the name column
 * @method ProjectMilestoneQuery groupByDate() Group by the date column
 * @method ProjectMilestoneQuery groupByExpirationdate() Group by the expirationDate column
 * @method ProjectMilestoneQuery groupByCompleted() Group by the completed column
 * @method ProjectMilestoneQuery groupByNotes() Group by the notes column
 *
 * @method ProjectMilestoneQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ProjectMilestoneQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ProjectMilestoneQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ProjectMilestoneQuery leftJoinProject($relationAlias = null) Adds a LEFT JOIN clause to the query using the Project relation
 * @method ProjectMilestoneQuery rightJoinProject($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Project relation
 * @method ProjectMilestoneQuery innerJoinProject($relationAlias = null) Adds a INNER JOIN clause to the query using the Project relation
 *
 * @method ProjectMilestoneQuery leftJoinProjectMilestoneLog($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectMilestoneLog relation
 * @method ProjectMilestoneQuery rightJoinProjectMilestoneLog($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectMilestoneLog relation
 * @method ProjectMilestoneQuery innerJoinProjectMilestoneLog($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectMilestoneLog relation
 *
 * @method ProjectMilestone findOne(PropelPDO $con = null) Return the first ProjectMilestone matching the query
 * @method ProjectMilestone findOneOrCreate(PropelPDO $con = null) Return the first ProjectMilestone matching the query, or a new ProjectMilestone object populated from the query conditions when no match is found
 *
 * @method ProjectMilestone findOneById(int $id) Return the first ProjectMilestone filtered by the id column
 * @method ProjectMilestone findOneByProjectid(int $projectId) Return the first ProjectMilestone filtered by the projectId column
 * @method ProjectMilestone findOneByName(string $name) Return the first ProjectMilestone filtered by the name column
 * @method ProjectMilestone findOneByDate(string $date) Return the first ProjectMilestone filtered by the date column
 * @method ProjectMilestone findOneByExpirationdate(string $expirationDate) Return the first ProjectMilestone filtered by the expirationDate column
 * @method ProjectMilestone findOneByCompleted(boolean $completed) Return the first ProjectMilestone filtered by the completed column
 * @method ProjectMilestone findOneByNotes(string $notes) Return the first ProjectMilestone filtered by the notes column
 *
 * @method array findById(int $id) Return ProjectMilestone objects filtered by the id column
 * @method array findByProjectid(int $projectId) Return ProjectMilestone objects filtered by the projectId column
 * @method array findByName(string $name) Return ProjectMilestone objects filtered by the name column
 * @method array findByDate(string $date) Return ProjectMilestone objects filtered by the date column
 * @method array findByExpirationdate(string $expirationDate) Return ProjectMilestone objects filtered by the expirationDate column
 * @method array findByCompleted(boolean $completed) Return ProjectMilestone objects filtered by the completed column
 * @method array findByNotes(string $notes) Return ProjectMilestone objects filtered by the notes column
 *
 * @package    propel.generator.projects.classes.om
 */
abstract class BaseProjectMilestoneQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseProjectMilestoneQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'ProjectMilestone', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ProjectMilestoneQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ProjectMilestoneQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ProjectMilestoneQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ProjectMilestoneQuery) {
            return $criteria;
        }
        $query = new ProjectMilestoneQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   ProjectMilestone|ProjectMilestone[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ProjectMilestonePeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ProjectMilestonePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   ProjectMilestone A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `PROJECTID`, `NAME`, `DATE`, `EXPIRATIONDATE`, `COMPLETED`, `NOTES` FROM `projects_milestone` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new ProjectMilestone();
            $obj->hydrate($row);
            ProjectMilestonePeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return ProjectMilestone|ProjectMilestone[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|ProjectMilestone[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ProjectMilestoneQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ProjectMilestonePeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ProjectMilestoneQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ProjectMilestonePeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectMilestoneQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ProjectMilestonePeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the projectId column
     *
     * Example usage:
     * <code>
     * $query->filterByProjectid(1234); // WHERE projectId = 1234
     * $query->filterByProjectid(array(12, 34)); // WHERE projectId IN (12, 34)
     * $query->filterByProjectid(array('min' => 12)); // WHERE projectId > 12
     * </code>
     *
     * @see       filterByProject()
     *
     * @param     mixed $projectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectMilestoneQuery The current query, for fluid interface
     */
    public function filterByProjectid($projectid = null, $comparison = null)
    {
        if (is_array($projectid)) {
            $useMinMax = false;
            if (isset($projectid['min'])) {
                $this->addUsingAlias(ProjectMilestonePeer::PROJECTID, $projectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($projectid['max'])) {
                $this->addUsingAlias(ProjectMilestonePeer::PROJECTID, $projectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectMilestonePeer::PROJECTID, $projectid, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectMilestoneQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectMilestonePeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the date column
     *
     * Example usage:
     * <code>
     * $query->filterByDate('2011-03-14'); // WHERE date = '2011-03-14'
     * $query->filterByDate('now'); // WHERE date = '2011-03-14'
     * $query->filterByDate(array('max' => 'yesterday')); // WHERE date > '2011-03-13'
     * </code>
     *
     * @param     mixed $date The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectMilestoneQuery The current query, for fluid interface
     */
    public function filterByDate($date = null, $comparison = null)
    {
        if (is_array($date)) {
            $useMinMax = false;
            if (isset($date['min'])) {
                $this->addUsingAlias(ProjectMilestonePeer::DATE, $date['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($date['max'])) {
                $this->addUsingAlias(ProjectMilestonePeer::DATE, $date['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectMilestonePeer::DATE, $date, $comparison);
    }

    /**
     * Filter the query on the expirationDate column
     *
     * Example usage:
     * <code>
     * $query->filterByExpirationdate('2011-03-14'); // WHERE expirationDate = '2011-03-14'
     * $query->filterByExpirationdate('now'); // WHERE expirationDate = '2011-03-14'
     * $query->filterByExpirationdate(array('max' => 'yesterday')); // WHERE expirationDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $expirationdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectMilestoneQuery The current query, for fluid interface
     */
    public function filterByExpirationdate($expirationdate = null, $comparison = null)
    {
        if (is_array($expirationdate)) {
            $useMinMax = false;
            if (isset($expirationdate['min'])) {
                $this->addUsingAlias(ProjectMilestonePeer::EXPIRATIONDATE, $expirationdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($expirationdate['max'])) {
                $this->addUsingAlias(ProjectMilestonePeer::EXPIRATIONDATE, $expirationdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectMilestonePeer::EXPIRATIONDATE, $expirationdate, $comparison);
    }

    /**
     * Filter the query on the completed column
     *
     * Example usage:
     * <code>
     * $query->filterByCompleted(true); // WHERE completed = true
     * $query->filterByCompleted('yes'); // WHERE completed = true
     * </code>
     *
     * @param     boolean|string $completed The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectMilestoneQuery The current query, for fluid interface
     */
    public function filterByCompleted($completed = null, $comparison = null)
    {
        if (is_string($completed)) {
            $completed = in_array(strtolower($completed), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectMilestonePeer::COMPLETED, $completed, $comparison);
    }

    /**
     * Filter the query on the notes column
     *
     * Example usage:
     * <code>
     * $query->filterByNotes('fooValue');   // WHERE notes = 'fooValue'
     * $query->filterByNotes('%fooValue%'); // WHERE notes LIKE '%fooValue%'
     * </code>
     *
     * @param     string $notes The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectMilestoneQuery The current query, for fluid interface
     */
    public function filterByNotes($notes = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($notes)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $notes)) {
                $notes = str_replace('*', '%', $notes);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectMilestonePeer::NOTES, $notes, $comparison);
    }

    /**
     * Filter the query by a related Project object
     *
     * @param   Project|PropelObjectCollection $project The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectMilestoneQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProject($project, $comparison = null)
    {
        if ($project instanceof Project) {
            return $this
                ->addUsingAlias(ProjectMilestonePeer::PROJECTID, $project->getId(), $comparison);
        } elseif ($project instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectMilestonePeer::PROJECTID, $project->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProject() only accepts arguments of type Project or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Project relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectMilestoneQuery The current query, for fluid interface
     */
    public function joinProject($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Project');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Project');
        }

        return $this;
    }

    /**
     * Use the Project relation Project object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectQuery A secondary query class using the current class as primary query
     */
    public function useProjectQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProject($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Project', 'ProjectQuery');
    }

    /**
     * Filter the query by a related ProjectMilestoneLog object
     *
     * @param   ProjectMilestoneLog|PropelObjectCollection $projectMilestoneLog  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectMilestoneQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectMilestoneLog($projectMilestoneLog, $comparison = null)
    {
        if ($projectMilestoneLog instanceof ProjectMilestoneLog) {
            return $this
                ->addUsingAlias(ProjectMilestonePeer::ID, $projectMilestoneLog->getMilestoneid(), $comparison);
        } elseif ($projectMilestoneLog instanceof PropelObjectCollection) {
            return $this
                ->useProjectMilestoneLogQuery()
                ->filterByPrimaryKeys($projectMilestoneLog->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProjectMilestoneLog() only accepts arguments of type ProjectMilestoneLog or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectMilestoneLog relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectMilestoneQuery The current query, for fluid interface
     */
    public function joinProjectMilestoneLog($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectMilestoneLog');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectMilestoneLog');
        }

        return $this;
    }

    /**
     * Use the ProjectMilestoneLog relation ProjectMilestoneLog object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectMilestoneLogQuery A secondary query class using the current class as primary query
     */
    public function useProjectMilestoneLogQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProjectMilestoneLog($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectMilestoneLog', 'ProjectMilestoneLogQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ProjectMilestone $projectMilestone Object to remove from the list of results
     *
     * @return ProjectMilestoneQuery The current query, for fluid interface
     */
    public function prune($projectMilestone = null)
    {
        if ($projectMilestone) {
            $this->addUsingAlias(ProjectMilestonePeer::ID, $projectMilestone->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
