<?php


/**
 * Base class that represents a query for the 'projects_milestoneLog' table.
 *
 * Milestone Log
 *
 * @method ProjectMilestoneLogQuery orderById($order = Criteria::ASC) Order by the id column
 * @method ProjectMilestoneLogQuery orderByMilestoneid($order = Criteria::ASC) Order by the milestoneId column
 * @method ProjectMilestoneLogQuery orderByProjectid($order = Criteria::ASC) Order by the projectId column
 * @method ProjectMilestoneLogQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method ProjectMilestoneLogQuery orderByDate($order = Criteria::ASC) Order by the date column
 * @method ProjectMilestoneLogQuery orderByExpirationdate($order = Criteria::ASC) Order by the expirationDate column
 * @method ProjectMilestoneLogQuery orderByCompleted($order = Criteria::ASC) Order by the completed column
 * @method ProjectMilestoneLogQuery orderByNotes($order = Criteria::ASC) Order by the notes column
 * @method ProjectMilestoneLogQuery orderByUserid($order = Criteria::ASC) Order by the userId column
 * @method ProjectMilestoneLogQuery orderByUserbyaffiliatesid($order = Criteria::ASC) Order by the userByAffiliatesId column
 * @method ProjectMilestoneLogQuery orderByUpdated($order = Criteria::ASC) Order by the updated column
 * @method ProjectMilestoneLogQuery orderByLastmodification($order = Criteria::ASC) Order by the lastModification column
 * @method ProjectMilestoneLogQuery orderByChanges($order = Criteria::ASC) Order by the changes column
 *
 * @method ProjectMilestoneLogQuery groupById() Group by the id column
 * @method ProjectMilestoneLogQuery groupByMilestoneid() Group by the milestoneId column
 * @method ProjectMilestoneLogQuery groupByProjectid() Group by the projectId column
 * @method ProjectMilestoneLogQuery groupByName() Group by the name column
 * @method ProjectMilestoneLogQuery groupByDate() Group by the date column
 * @method ProjectMilestoneLogQuery groupByExpirationdate() Group by the expirationDate column
 * @method ProjectMilestoneLogQuery groupByCompleted() Group by the completed column
 * @method ProjectMilestoneLogQuery groupByNotes() Group by the notes column
 * @method ProjectMilestoneLogQuery groupByUserid() Group by the userId column
 * @method ProjectMilestoneLogQuery groupByUserbyaffiliatesid() Group by the userByAffiliatesId column
 * @method ProjectMilestoneLogQuery groupByUpdated() Group by the updated column
 * @method ProjectMilestoneLogQuery groupByLastmodification() Group by the lastModification column
 * @method ProjectMilestoneLogQuery groupByChanges() Group by the changes column
 *
 * @method ProjectMilestoneLogQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ProjectMilestoneLogQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ProjectMilestoneLogQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ProjectMilestoneLogQuery leftJoinProject($relationAlias = null) Adds a LEFT JOIN clause to the query using the Project relation
 * @method ProjectMilestoneLogQuery rightJoinProject($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Project relation
 * @method ProjectMilestoneLogQuery innerJoinProject($relationAlias = null) Adds a INNER JOIN clause to the query using the Project relation
 *
 * @method ProjectMilestoneLogQuery leftJoinProjectMilestone($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectMilestone relation
 * @method ProjectMilestoneLogQuery rightJoinProjectMilestone($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectMilestone relation
 * @method ProjectMilestoneLogQuery innerJoinProjectMilestone($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectMilestone relation
 *
 * @method ProjectMilestoneLogQuery leftJoinUser($relationAlias = null) Adds a LEFT JOIN clause to the query using the User relation
 * @method ProjectMilestoneLogQuery rightJoinUser($relationAlias = null) Adds a RIGHT JOIN clause to the query using the User relation
 * @method ProjectMilestoneLogQuery innerJoinUser($relationAlias = null) Adds a INNER JOIN clause to the query using the User relation
 *
 * @method ProjectMilestoneLog findOne(PropelPDO $con = null) Return the first ProjectMilestoneLog matching the query
 * @method ProjectMilestoneLog findOneOrCreate(PropelPDO $con = null) Return the first ProjectMilestoneLog matching the query, or a new ProjectMilestoneLog object populated from the query conditions when no match is found
 *
 * @method ProjectMilestoneLog findOneById(int $id) Return the first ProjectMilestoneLog filtered by the id column
 * @method ProjectMilestoneLog findOneByMilestoneid(int $milestoneId) Return the first ProjectMilestoneLog filtered by the milestoneId column
 * @method ProjectMilestoneLog findOneByProjectid(int $projectId) Return the first ProjectMilestoneLog filtered by the projectId column
 * @method ProjectMilestoneLog findOneByName(string $name) Return the first ProjectMilestoneLog filtered by the name column
 * @method ProjectMilestoneLog findOneByDate(string $date) Return the first ProjectMilestoneLog filtered by the date column
 * @method ProjectMilestoneLog findOneByExpirationdate(string $expirationDate) Return the first ProjectMilestoneLog filtered by the expirationDate column
 * @method ProjectMilestoneLog findOneByCompleted(boolean $completed) Return the first ProjectMilestoneLog filtered by the completed column
 * @method ProjectMilestoneLog findOneByNotes(string $notes) Return the first ProjectMilestoneLog filtered by the notes column
 * @method ProjectMilestoneLog findOneByUserid(int $userId) Return the first ProjectMilestoneLog filtered by the userId column
 * @method ProjectMilestoneLog findOneByUserbyaffiliatesid(int $userByAffiliatesId) Return the first ProjectMilestoneLog filtered by the userByAffiliatesId column
 * @method ProjectMilestoneLog findOneByUpdated(string $updated) Return the first ProjectMilestoneLog filtered by the updated column
 * @method ProjectMilestoneLog findOneByLastmodification(string $lastModification) Return the first ProjectMilestoneLog filtered by the lastModification column
 * @method ProjectMilestoneLog findOneByChanges(int $changes) Return the first ProjectMilestoneLog filtered by the changes column
 *
 * @method array findById(int $id) Return ProjectMilestoneLog objects filtered by the id column
 * @method array findByMilestoneid(int $milestoneId) Return ProjectMilestoneLog objects filtered by the milestoneId column
 * @method array findByProjectid(int $projectId) Return ProjectMilestoneLog objects filtered by the projectId column
 * @method array findByName(string $name) Return ProjectMilestoneLog objects filtered by the name column
 * @method array findByDate(string $date) Return ProjectMilestoneLog objects filtered by the date column
 * @method array findByExpirationdate(string $expirationDate) Return ProjectMilestoneLog objects filtered by the expirationDate column
 * @method array findByCompleted(boolean $completed) Return ProjectMilestoneLog objects filtered by the completed column
 * @method array findByNotes(string $notes) Return ProjectMilestoneLog objects filtered by the notes column
 * @method array findByUserid(int $userId) Return ProjectMilestoneLog objects filtered by the userId column
 * @method array findByUserbyaffiliatesid(int $userByAffiliatesId) Return ProjectMilestoneLog objects filtered by the userByAffiliatesId column
 * @method array findByUpdated(string $updated) Return ProjectMilestoneLog objects filtered by the updated column
 * @method array findByLastmodification(string $lastModification) Return ProjectMilestoneLog objects filtered by the lastModification column
 * @method array findByChanges(int $changes) Return ProjectMilestoneLog objects filtered by the changes column
 *
 * @package    propel.generator.projects.classes.om
 */
abstract class BaseProjectMilestoneLogQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseProjectMilestoneLogQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'ProjectMilestoneLog', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ProjectMilestoneLogQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ProjectMilestoneLogQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ProjectMilestoneLogQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ProjectMilestoneLogQuery) {
            return $criteria;
        }
        $query = new ProjectMilestoneLogQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   ProjectMilestoneLog|ProjectMilestoneLog[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ProjectMilestoneLogPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ProjectMilestoneLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   ProjectMilestoneLog A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `MILESTONEID`, `PROJECTID`, `NAME`, `DATE`, `EXPIRATIONDATE`, `COMPLETED`, `NOTES`, `USERID`, `USERBYAFFILIATESID`, `UPDATED`, `LASTMODIFICATION`, `CHANGES` FROM `projects_milestoneLog` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new ProjectMilestoneLog();
            $obj->hydrate($row);
            ProjectMilestoneLogPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return ProjectMilestoneLog|ProjectMilestoneLog[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|ProjectMilestoneLog[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ProjectMilestoneLogQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ProjectMilestoneLogPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ProjectMilestoneLogQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ProjectMilestoneLogPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectMilestoneLogQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ProjectMilestoneLogPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the milestoneId column
     *
     * Example usage:
     * <code>
     * $query->filterByMilestoneid(1234); // WHERE milestoneId = 1234
     * $query->filterByMilestoneid(array(12, 34)); // WHERE milestoneId IN (12, 34)
     * $query->filterByMilestoneid(array('min' => 12)); // WHERE milestoneId > 12
     * </code>
     *
     * @see       filterByProjectMilestone()
     *
     * @param     mixed $milestoneid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectMilestoneLogQuery The current query, for fluid interface
     */
    public function filterByMilestoneid($milestoneid = null, $comparison = null)
    {
        if (is_array($milestoneid)) {
            $useMinMax = false;
            if (isset($milestoneid['min'])) {
                $this->addUsingAlias(ProjectMilestoneLogPeer::MILESTONEID, $milestoneid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($milestoneid['max'])) {
                $this->addUsingAlias(ProjectMilestoneLogPeer::MILESTONEID, $milestoneid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectMilestoneLogPeer::MILESTONEID, $milestoneid, $comparison);
    }

    /**
     * Filter the query on the projectId column
     *
     * Example usage:
     * <code>
     * $query->filterByProjectid(1234); // WHERE projectId = 1234
     * $query->filterByProjectid(array(12, 34)); // WHERE projectId IN (12, 34)
     * $query->filterByProjectid(array('min' => 12)); // WHERE projectId > 12
     * </code>
     *
     * @see       filterByProject()
     *
     * @param     mixed $projectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectMilestoneLogQuery The current query, for fluid interface
     */
    public function filterByProjectid($projectid = null, $comparison = null)
    {
        if (is_array($projectid)) {
            $useMinMax = false;
            if (isset($projectid['min'])) {
                $this->addUsingAlias(ProjectMilestoneLogPeer::PROJECTID, $projectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($projectid['max'])) {
                $this->addUsingAlias(ProjectMilestoneLogPeer::PROJECTID, $projectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectMilestoneLogPeer::PROJECTID, $projectid, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectMilestoneLogQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectMilestoneLogPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the date column
     *
     * Example usage:
     * <code>
     * $query->filterByDate('2011-03-14'); // WHERE date = '2011-03-14'
     * $query->filterByDate('now'); // WHERE date = '2011-03-14'
     * $query->filterByDate(array('max' => 'yesterday')); // WHERE date > '2011-03-13'
     * </code>
     *
     * @param     mixed $date The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectMilestoneLogQuery The current query, for fluid interface
     */
    public function filterByDate($date = null, $comparison = null)
    {
        if (is_array($date)) {
            $useMinMax = false;
            if (isset($date['min'])) {
                $this->addUsingAlias(ProjectMilestoneLogPeer::DATE, $date['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($date['max'])) {
                $this->addUsingAlias(ProjectMilestoneLogPeer::DATE, $date['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectMilestoneLogPeer::DATE, $date, $comparison);
    }

    /**
     * Filter the query on the expirationDate column
     *
     * Example usage:
     * <code>
     * $query->filterByExpirationdate('2011-03-14'); // WHERE expirationDate = '2011-03-14'
     * $query->filterByExpirationdate('now'); // WHERE expirationDate = '2011-03-14'
     * $query->filterByExpirationdate(array('max' => 'yesterday')); // WHERE expirationDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $expirationdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectMilestoneLogQuery The current query, for fluid interface
     */
    public function filterByExpirationdate($expirationdate = null, $comparison = null)
    {
        if (is_array($expirationdate)) {
            $useMinMax = false;
            if (isset($expirationdate['min'])) {
                $this->addUsingAlias(ProjectMilestoneLogPeer::EXPIRATIONDATE, $expirationdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($expirationdate['max'])) {
                $this->addUsingAlias(ProjectMilestoneLogPeer::EXPIRATIONDATE, $expirationdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectMilestoneLogPeer::EXPIRATIONDATE, $expirationdate, $comparison);
    }

    /**
     * Filter the query on the completed column
     *
     * Example usage:
     * <code>
     * $query->filterByCompleted(true); // WHERE completed = true
     * $query->filterByCompleted('yes'); // WHERE completed = true
     * </code>
     *
     * @param     boolean|string $completed The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectMilestoneLogQuery The current query, for fluid interface
     */
    public function filterByCompleted($completed = null, $comparison = null)
    {
        if (is_string($completed)) {
            $completed = in_array(strtolower($completed), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectMilestoneLogPeer::COMPLETED, $completed, $comparison);
    }

    /**
     * Filter the query on the notes column
     *
     * Example usage:
     * <code>
     * $query->filterByNotes('fooValue');   // WHERE notes = 'fooValue'
     * $query->filterByNotes('%fooValue%'); // WHERE notes LIKE '%fooValue%'
     * </code>
     *
     * @param     string $notes The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectMilestoneLogQuery The current query, for fluid interface
     */
    public function filterByNotes($notes = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($notes)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $notes)) {
                $notes = str_replace('*', '%', $notes);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectMilestoneLogPeer::NOTES, $notes, $comparison);
    }

    /**
     * Filter the query on the userId column
     *
     * Example usage:
     * <code>
     * $query->filterByUserid(1234); // WHERE userId = 1234
     * $query->filterByUserid(array(12, 34)); // WHERE userId IN (12, 34)
     * $query->filterByUserid(array('min' => 12)); // WHERE userId > 12
     * </code>
     *
     * @see       filterByUser()
     *
     * @param     mixed $userid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectMilestoneLogQuery The current query, for fluid interface
     */
    public function filterByUserid($userid = null, $comparison = null)
    {
        if (is_array($userid)) {
            $useMinMax = false;
            if (isset($userid['min'])) {
                $this->addUsingAlias(ProjectMilestoneLogPeer::USERID, $userid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($userid['max'])) {
                $this->addUsingAlias(ProjectMilestoneLogPeer::USERID, $userid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectMilestoneLogPeer::USERID, $userid, $comparison);
    }

    /**
     * Filter the query on the userByAffiliatesId column
     *
     * Example usage:
     * <code>
     * $query->filterByUserbyaffiliatesid(1234); // WHERE userByAffiliatesId = 1234
     * $query->filterByUserbyaffiliatesid(array(12, 34)); // WHERE userByAffiliatesId IN (12, 34)
     * $query->filterByUserbyaffiliatesid(array('min' => 12)); // WHERE userByAffiliatesId > 12
     * </code>
     *
     * @param     mixed $userbyaffiliatesid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectMilestoneLogQuery The current query, for fluid interface
     */
    public function filterByUserbyaffiliatesid($userbyaffiliatesid = null, $comparison = null)
    {
        if (is_array($userbyaffiliatesid)) {
            $useMinMax = false;
            if (isset($userbyaffiliatesid['min'])) {
                $this->addUsingAlias(ProjectMilestoneLogPeer::USERBYAFFILIATESID, $userbyaffiliatesid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($userbyaffiliatesid['max'])) {
                $this->addUsingAlias(ProjectMilestoneLogPeer::USERBYAFFILIATESID, $userbyaffiliatesid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectMilestoneLogPeer::USERBYAFFILIATESID, $userbyaffiliatesid, $comparison);
    }

    /**
     * Filter the query on the updated column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdated('2011-03-14'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated('now'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated(array('max' => 'yesterday')); // WHERE updated > '2011-03-13'
     * </code>
     *
     * @param     mixed $updated The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectMilestoneLogQuery The current query, for fluid interface
     */
    public function filterByUpdated($updated = null, $comparison = null)
    {
        if (is_array($updated)) {
            $useMinMax = false;
            if (isset($updated['min'])) {
                $this->addUsingAlias(ProjectMilestoneLogPeer::UPDATED, $updated['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updated['max'])) {
                $this->addUsingAlias(ProjectMilestoneLogPeer::UPDATED, $updated['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectMilestoneLogPeer::UPDATED, $updated, $comparison);
    }

    /**
     * Filter the query on the lastModification column
     *
     * Example usage:
     * <code>
     * $query->filterByLastmodification('2011-03-14'); // WHERE lastModification = '2011-03-14'
     * $query->filterByLastmodification('now'); // WHERE lastModification = '2011-03-14'
     * $query->filterByLastmodification(array('max' => 'yesterday')); // WHERE lastModification > '2011-03-13'
     * </code>
     *
     * @param     mixed $lastmodification The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectMilestoneLogQuery The current query, for fluid interface
     */
    public function filterByLastmodification($lastmodification = null, $comparison = null)
    {
        if (is_array($lastmodification)) {
            $useMinMax = false;
            if (isset($lastmodification['min'])) {
                $this->addUsingAlias(ProjectMilestoneLogPeer::LASTMODIFICATION, $lastmodification['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($lastmodification['max'])) {
                $this->addUsingAlias(ProjectMilestoneLogPeer::LASTMODIFICATION, $lastmodification['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectMilestoneLogPeer::LASTMODIFICATION, $lastmodification, $comparison);
    }

    /**
     * Filter the query on the changes column
     *
     * Example usage:
     * <code>
     * $query->filterByChanges(1234); // WHERE changes = 1234
     * $query->filterByChanges(array(12, 34)); // WHERE changes IN (12, 34)
     * $query->filterByChanges(array('min' => 12)); // WHERE changes > 12
     * </code>
     *
     * @param     mixed $changes The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectMilestoneLogQuery The current query, for fluid interface
     */
    public function filterByChanges($changes = null, $comparison = null)
    {
        if (is_array($changes)) {
            $useMinMax = false;
            if (isset($changes['min'])) {
                $this->addUsingAlias(ProjectMilestoneLogPeer::CHANGES, $changes['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($changes['max'])) {
                $this->addUsingAlias(ProjectMilestoneLogPeer::CHANGES, $changes['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectMilestoneLogPeer::CHANGES, $changes, $comparison);
    }

    /**
     * Filter the query by a related Project object
     *
     * @param   Project|PropelObjectCollection $project The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectMilestoneLogQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProject($project, $comparison = null)
    {
        if ($project instanceof Project) {
            return $this
                ->addUsingAlias(ProjectMilestoneLogPeer::PROJECTID, $project->getId(), $comparison);
        } elseif ($project instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectMilestoneLogPeer::PROJECTID, $project->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProject() only accepts arguments of type Project or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Project relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectMilestoneLogQuery The current query, for fluid interface
     */
    public function joinProject($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Project');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Project');
        }

        return $this;
    }

    /**
     * Use the Project relation Project object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectQuery A secondary query class using the current class as primary query
     */
    public function useProjectQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProject($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Project', 'ProjectQuery');
    }

    /**
     * Filter the query by a related ProjectMilestone object
     *
     * @param   ProjectMilestone|PropelObjectCollection $projectMilestone The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectMilestoneLogQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectMilestone($projectMilestone, $comparison = null)
    {
        if ($projectMilestone instanceof ProjectMilestone) {
            return $this
                ->addUsingAlias(ProjectMilestoneLogPeer::MILESTONEID, $projectMilestone->getId(), $comparison);
        } elseif ($projectMilestone instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectMilestoneLogPeer::MILESTONEID, $projectMilestone->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProjectMilestone() only accepts arguments of type ProjectMilestone or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectMilestone relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectMilestoneLogQuery The current query, for fluid interface
     */
    public function joinProjectMilestone($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectMilestone');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectMilestone');
        }

        return $this;
    }

    /**
     * Use the ProjectMilestone relation ProjectMilestone object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectMilestoneQuery A secondary query class using the current class as primary query
     */
    public function useProjectMilestoneQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProjectMilestone($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectMilestone', 'ProjectMilestoneQuery');
    }

    /**
     * Filter the query by a related User object
     *
     * @param   User|PropelObjectCollection $user The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectMilestoneLogQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByUser($user, $comparison = null)
    {
        if ($user instanceof User) {
            return $this
                ->addUsingAlias(ProjectMilestoneLogPeer::USERID, $user->getId(), $comparison);
        } elseif ($user instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectMilestoneLogPeer::USERID, $user->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByUser() only accepts arguments of type User or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the User relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectMilestoneLogQuery The current query, for fluid interface
     */
    public function joinUser($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('User');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'User');
        }

        return $this;
    }

    /**
     * Use the User relation User object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   UserQuery A secondary query class using the current class as primary query
     */
    public function useUserQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinUser($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'User', 'UserQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ProjectMilestoneLog $projectMilestoneLog Object to remove from the list of results
     *
     * @return ProjectMilestoneLogQuery The current query, for fluid interface
     */
    public function prune($projectMilestoneLog = null)
    {
        if ($projectMilestoneLog) {
            $this->addUsingAlias(ProjectMilestoneLogPeer::ID, $projectMilestoneLog->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
