<?php


/**
 * Base class that represents a query for the 'projects_activityDocument' table.
 *
 *
 *
 * @method ActivityDocumentQuery orderByActivityId($order = Criteria::ASC) Order by the activity_id column
 * @method ActivityDocumentQuery orderByDocumentId($order = Criteria::ASC) Order by the document_id column
 *
 * @method ActivityDocumentQuery groupByActivityId() Group by the activity_id column
 * @method ActivityDocumentQuery groupByDocumentId() Group by the document_id column
 *
 * @method ActivityDocumentQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ActivityDocumentQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ActivityDocumentQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ActivityDocumentQuery leftJoinProjectActivity($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectActivity relation
 * @method ActivityDocumentQuery rightJoinProjectActivity($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectActivity relation
 * @method ActivityDocumentQuery innerJoinProjectActivity($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectActivity relation
 *
 * @method ActivityDocumentQuery leftJoinDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the Document relation
 * @method ActivityDocumentQuery rightJoinDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Document relation
 * @method ActivityDocumentQuery innerJoinDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the Document relation
 *
 * @method ActivityDocument findOne(PropelPDO $con = null) Return the first ActivityDocument matching the query
 * @method ActivityDocument findOneOrCreate(PropelPDO $con = null) Return the first ActivityDocument matching the query, or a new ActivityDocument object populated from the query conditions when no match is found
 *
 * @method ActivityDocument findOneByActivityId(int $activity_id) Return the first ActivityDocument filtered by the activity_id column
 * @method ActivityDocument findOneByDocumentId(int $document_id) Return the first ActivityDocument filtered by the document_id column
 *
 * @method array findByActivityId(int $activity_id) Return ActivityDocument objects filtered by the activity_id column
 * @method array findByDocumentId(int $document_id) Return ActivityDocument objects filtered by the document_id column
 *
 * @package    propel.generator.projects.classes.om
 */
abstract class BaseActivityDocumentQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseActivityDocumentQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'ActivityDocument', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ActivityDocumentQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ActivityDocumentQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ActivityDocumentQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ActivityDocumentQuery) {
            return $criteria;
        }
        $query = new ActivityDocumentQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array $key Primary key to use for the query
                         A Primary key composition: [$activity_id, $document_id]
     * @param     PropelPDO $con an optional connection object
     *
     * @return   ActivityDocument|ActivityDocument[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ActivityDocumentPeer::getInstanceFromPool(serialize(array((string) $key[0], (string) $key[1]))))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ActivityDocumentPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   ActivityDocument A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ACTIVITY_ID`, `DOCUMENT_ID` FROM `projects_activityDocument` WHERE `ACTIVITY_ID` = :p0 AND `DOCUMENT_ID` = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new ActivityDocument();
            $obj->hydrate($row);
            ActivityDocumentPeer::addInstanceToPool($obj, serialize(array((string) $key[0], (string) $key[1])));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return ActivityDocument|ActivityDocument[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|ActivityDocument[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ActivityDocumentQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(ActivityDocumentPeer::ACTIVITY_ID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(ActivityDocumentPeer::DOCUMENT_ID, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ActivityDocumentQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(ActivityDocumentPeer::ACTIVITY_ID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(ActivityDocumentPeer::DOCUMENT_ID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the activity_id column
     *
     * Example usage:
     * <code>
     * $query->filterByActivityId(1234); // WHERE activity_id = 1234
     * $query->filterByActivityId(array(12, 34)); // WHERE activity_id IN (12, 34)
     * $query->filterByActivityId(array('min' => 12)); // WHERE activity_id > 12
     * </code>
     *
     * @see       filterByProjectActivity()
     *
     * @param     mixed $activityId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActivityDocumentQuery The current query, for fluid interface
     */
    public function filterByActivityId($activityId = null, $comparison = null)
    {
        if (is_array($activityId) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ActivityDocumentPeer::ACTIVITY_ID, $activityId, $comparison);
    }

    /**
     * Filter the query on the document_id column
     *
     * Example usage:
     * <code>
     * $query->filterByDocumentId(1234); // WHERE document_id = 1234
     * $query->filterByDocumentId(array(12, 34)); // WHERE document_id IN (12, 34)
     * $query->filterByDocumentId(array('min' => 12)); // WHERE document_id > 12
     * </code>
     *
     * @see       filterByDocument()
     *
     * @param     mixed $documentId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActivityDocumentQuery The current query, for fluid interface
     */
    public function filterByDocumentId($documentId = null, $comparison = null)
    {
        if (is_array($documentId) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ActivityDocumentPeer::DOCUMENT_ID, $documentId, $comparison);
    }

    /**
     * Filter the query by a related ProjectActivity object
     *
     * @param   ProjectActivity|PropelObjectCollection $projectActivity The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ActivityDocumentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectActivity($projectActivity, $comparison = null)
    {
        if ($projectActivity instanceof ProjectActivity) {
            return $this
                ->addUsingAlias(ActivityDocumentPeer::ACTIVITY_ID, $projectActivity->getId(), $comparison);
        } elseif ($projectActivity instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ActivityDocumentPeer::ACTIVITY_ID, $projectActivity->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProjectActivity() only accepts arguments of type ProjectActivity or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectActivity relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ActivityDocumentQuery The current query, for fluid interface
     */
    public function joinProjectActivity($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectActivity');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectActivity');
        }

        return $this;
    }

    /**
     * Use the ProjectActivity relation ProjectActivity object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectActivityQuery A secondary query class using the current class as primary query
     */
    public function useProjectActivityQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProjectActivity($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectActivity', 'ProjectActivityQuery');
    }

    /**
     * Filter the query by a related Document object
     *
     * @param   Document|PropelObjectCollection $document The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ActivityDocumentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByDocument($document, $comparison = null)
    {
        if ($document instanceof Document) {
            return $this
                ->addUsingAlias(ActivityDocumentPeer::DOCUMENT_ID, $document->getId(), $comparison);
        } elseif ($document instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ActivityDocumentPeer::DOCUMENT_ID, $document->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByDocument() only accepts arguments of type Document or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Document relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ActivityDocumentQuery The current query, for fluid interface
     */
    public function joinDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Document');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Document');
        }

        return $this;
    }

    /**
     * Use the Document relation Document object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   DocumentQuery A secondary query class using the current class as primary query
     */
    public function useDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Document', 'DocumentQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ActivityDocument $activityDocument Object to remove from the list of results
     *
     * @return ActivityDocumentQuery The current query, for fluid interface
     */
    public function prune($activityDocument = null)
    {
        if ($activityDocument) {
            $this->addCond('pruneCond0', $this->getAliasedColName(ActivityDocumentPeer::ACTIVITY_ID), $activityDocument->getActivityId(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(ActivityDocumentPeer::DOCUMENT_ID), $activityDocument->getDocumentId(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

}
