<?php


/**
 * Base class that represents a query for the 'panel_contractor' table.
 *
 * Base de Contratistas
 *
 * @method ContractorQuery orderById($order = Criteria::ASC) Order by the id column
 * @method ContractorQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method ContractorQuery orderByCuit($order = Criteria::ASC) Order by the cuit column
 * @method ContractorQuery orderByAddress($order = Criteria::ASC) Order by the address column
 * @method ContractorQuery orderByPhone($order = Criteria::ASC) Order by the phone column
 * @method ContractorQuery orderByContact($order = Criteria::ASC) Order by the contact column
 * @method ContractorQuery orderByDeletedAt($order = Criteria::ASC) Order by the deleted_at column
 *
 * @method ContractorQuery groupById() Group by the id column
 * @method ContractorQuery groupByName() Group by the name column
 * @method ContractorQuery groupByCuit() Group by the cuit column
 * @method ContractorQuery groupByAddress() Group by the address column
 * @method ContractorQuery groupByPhone() Group by the phone column
 * @method ContractorQuery groupByContact() Group by the contact column
 * @method ContractorQuery groupByDeletedAt() Group by the deleted_at column
 *
 * @method ContractorQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ContractorQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ContractorQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ContractorQuery leftJoinGuarantee($relationAlias = null) Adds a LEFT JOIN clause to the query using the Guarantee relation
 * @method ContractorQuery rightJoinGuarantee($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Guarantee relation
 * @method ContractorQuery innerJoinGuarantee($relationAlias = null) Adds a INNER JOIN clause to the query using the Guarantee relation
 *
 * @method ContractorQuery leftJoinContractorCategoryRelation($relationAlias = null) Adds a LEFT JOIN clause to the query using the ContractorCategoryRelation relation
 * @method ContractorQuery rightJoinContractorCategoryRelation($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ContractorCategoryRelation relation
 * @method ContractorQuery innerJoinContractorCategoryRelation($relationAlias = null) Adds a INNER JOIN clause to the query using the ContractorCategoryRelation relation
 *
 * @method ContractorQuery leftJoinProjectContractor($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectContractor relation
 * @method ContractorQuery rightJoinProjectContractor($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectContractor relation
 * @method ContractorQuery innerJoinProjectContractor($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectContractor relation
 *
 * @method Contractor findOne(PropelPDO $con = null) Return the first Contractor matching the query
 * @method Contractor findOneOrCreate(PropelPDO $con = null) Return the first Contractor matching the query, or a new Contractor object populated from the query conditions when no match is found
 *
 * @method Contractor findOneById(int $id) Return the first Contractor filtered by the id column
 * @method Contractor findOneByName(string $name) Return the first Contractor filtered by the name column
 * @method Contractor findOneByCuit(string $cuit) Return the first Contractor filtered by the cuit column
 * @method Contractor findOneByAddress(string $address) Return the first Contractor filtered by the address column
 * @method Contractor findOneByPhone(string $phone) Return the first Contractor filtered by the phone column
 * @method Contractor findOneByContact(string $contact) Return the first Contractor filtered by the contact column
 * @method Contractor findOneByDeletedAt(string $deleted_at) Return the first Contractor filtered by the deleted_at column
 *
 * @method array findById(int $id) Return Contractor objects filtered by the id column
 * @method array findByName(string $name) Return Contractor objects filtered by the name column
 * @method array findByCuit(string $cuit) Return Contractor objects filtered by the cuit column
 * @method array findByAddress(string $address) Return Contractor objects filtered by the address column
 * @method array findByPhone(string $phone) Return Contractor objects filtered by the phone column
 * @method array findByContact(string $contact) Return Contractor objects filtered by the contact column
 * @method array findByDeletedAt(string $deleted_at) Return Contractor objects filtered by the deleted_at column
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseContractorQuery extends \Egytca\Propel\Query
{
    // soft_delete behavior
    protected static $softDelete = true;
    protected $localSoftDelete = true;

    /**
     * Initializes internal state of BaseContractorQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'Contractor', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ContractorQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ContractorQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ContractorQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ContractorQuery) {
            return $criteria;
        }
        $query = new ContractorQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   Contractor|Contractor[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ContractorPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ContractorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   Contractor A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `NAME`, `CUIT`, `ADDRESS`, `PHONE`, `CONTACT`, `DELETED_AT` FROM `panel_contractor` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new Contractor();
            $obj->hydrate($row);
            ContractorPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return Contractor|Contractor[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|Contractor[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ContractorQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ContractorPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ContractorQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ContractorPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ContractorQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ContractorPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ContractorQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ContractorPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the cuit column
     *
     * Example usage:
     * <code>
     * $query->filterByCuit('fooValue');   // WHERE cuit = 'fooValue'
     * $query->filterByCuit('%fooValue%'); // WHERE cuit LIKE '%fooValue%'
     * </code>
     *
     * @param     string $cuit The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ContractorQuery The current query, for fluid interface
     */
    public function filterByCuit($cuit = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($cuit)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $cuit)) {
                $cuit = str_replace('*', '%', $cuit);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ContractorPeer::CUIT, $cuit, $comparison);
    }

    /**
     * Filter the query on the address column
     *
     * Example usage:
     * <code>
     * $query->filterByAddress('fooValue');   // WHERE address = 'fooValue'
     * $query->filterByAddress('%fooValue%'); // WHERE address LIKE '%fooValue%'
     * </code>
     *
     * @param     string $address The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ContractorQuery The current query, for fluid interface
     */
    public function filterByAddress($address = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($address)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $address)) {
                $address = str_replace('*', '%', $address);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ContractorPeer::ADDRESS, $address, $comparison);
    }

    /**
     * Filter the query on the phone column
     *
     * Example usage:
     * <code>
     * $query->filterByPhone('fooValue');   // WHERE phone = 'fooValue'
     * $query->filterByPhone('%fooValue%'); // WHERE phone LIKE '%fooValue%'
     * </code>
     *
     * @param     string $phone The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ContractorQuery The current query, for fluid interface
     */
    public function filterByPhone($phone = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($phone)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $phone)) {
                $phone = str_replace('*', '%', $phone);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ContractorPeer::PHONE, $phone, $comparison);
    }

    /**
     * Filter the query on the contact column
     *
     * Example usage:
     * <code>
     * $query->filterByContact('fooValue');   // WHERE contact = 'fooValue'
     * $query->filterByContact('%fooValue%'); // WHERE contact LIKE '%fooValue%'
     * </code>
     *
     * @param     string $contact The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ContractorQuery The current query, for fluid interface
     */
    public function filterByContact($contact = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($contact)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $contact)) {
                $contact = str_replace('*', '%', $contact);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ContractorPeer::CONTACT, $contact, $comparison);
    }

    /**
     * Filter the query on the deleted_at column
     *
     * Example usage:
     * <code>
     * $query->filterByDeletedAt('2011-03-14'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt('now'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt(array('max' => 'yesterday')); // WHERE deleted_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $deletedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ContractorQuery The current query, for fluid interface
     */
    public function filterByDeletedAt($deletedAt = null, $comparison = null)
    {
        if (is_array($deletedAt)) {
            $useMinMax = false;
            if (isset($deletedAt['min'])) {
                $this->addUsingAlias(ContractorPeer::DELETED_AT, $deletedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deletedAt['max'])) {
                $this->addUsingAlias(ContractorPeer::DELETED_AT, $deletedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ContractorPeer::DELETED_AT, $deletedAt, $comparison);
    }

    /**
     * Filter the query by a related Guarantee object
     *
     * @param   Guarantee|PropelObjectCollection $guarantee  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ContractorQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByGuarantee($guarantee, $comparison = null)
    {
        if ($guarantee instanceof Guarantee) {
            return $this
                ->addUsingAlias(ContractorPeer::ID, $guarantee->getContractorid(), $comparison);
        } elseif ($guarantee instanceof PropelObjectCollection) {
            return $this
                ->useGuaranteeQuery()
                ->filterByPrimaryKeys($guarantee->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByGuarantee() only accepts arguments of type Guarantee or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Guarantee relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ContractorQuery The current query, for fluid interface
     */
    public function joinGuarantee($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Guarantee');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Guarantee');
        }

        return $this;
    }

    /**
     * Use the Guarantee relation Guarantee object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   GuaranteeQuery A secondary query class using the current class as primary query
     */
    public function useGuaranteeQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinGuarantee($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Guarantee', 'GuaranteeQuery');
    }

    /**
     * Filter the query by a related ContractorCategoryRelation object
     *
     * @param   ContractorCategoryRelation|PropelObjectCollection $contractorCategoryRelation  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ContractorQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByContractorCategoryRelation($contractorCategoryRelation, $comparison = null)
    {
        if ($contractorCategoryRelation instanceof ContractorCategoryRelation) {
            return $this
                ->addUsingAlias(ContractorPeer::ID, $contractorCategoryRelation->getContractorid(), $comparison);
        } elseif ($contractorCategoryRelation instanceof PropelObjectCollection) {
            return $this
                ->useContractorCategoryRelationQuery()
                ->filterByPrimaryKeys($contractorCategoryRelation->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByContractorCategoryRelation() only accepts arguments of type ContractorCategoryRelation or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ContractorCategoryRelation relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ContractorQuery The current query, for fluid interface
     */
    public function joinContractorCategoryRelation($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ContractorCategoryRelation');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ContractorCategoryRelation');
        }

        return $this;
    }

    /**
     * Use the ContractorCategoryRelation relation ContractorCategoryRelation object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ContractorCategoryRelationQuery A secondary query class using the current class as primary query
     */
    public function useContractorCategoryRelationQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinContractorCategoryRelation($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ContractorCategoryRelation', 'ContractorCategoryRelationQuery');
    }

    /**
     * Filter the query by a related ProjectContractor object
     *
     * @param   ProjectContractor|PropelObjectCollection $projectContractor  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ContractorQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectContractor($projectContractor, $comparison = null)
    {
        if ($projectContractor instanceof ProjectContractor) {
            return $this
                ->addUsingAlias(ContractorPeer::ID, $projectContractor->getContractorId(), $comparison);
        } elseif ($projectContractor instanceof PropelObjectCollection) {
            return $this
                ->useProjectContractorQuery()
                ->filterByPrimaryKeys($projectContractor->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProjectContractor() only accepts arguments of type ProjectContractor or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectContractor relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ContractorQuery The current query, for fluid interface
     */
    public function joinProjectContractor($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectContractor');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectContractor');
        }

        return $this;
    }

    /**
     * Use the ProjectContractor relation ProjectContractor object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectContractorQuery A secondary query class using the current class as primary query
     */
    public function useProjectContractorQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinProjectContractor($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectContractor', 'ProjectContractorQuery');
    }

    /**
     * Filter the query by a related ContractorCategory object
     * using the panel_contractorCategoryRelation table as cross reference
     *
     * @param   ContractorCategory $contractorCategory the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ContractorQuery The current query, for fluid interface
     */
    public function filterByContractorCategory($contractorCategory, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useContractorCategoryRelationQuery()
            ->filterByContractorCategory($contractorCategory, $comparison)
            ->endUse();
    }

    /**
     * Filter the query by a related Project object
     * using the projects_contractor table as cross reference
     *
     * @param   Project $project the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ContractorQuery The current query, for fluid interface
     */
    public function filterByProject($project, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useProjectContractorQuery()
            ->filterByProject($project, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   Contractor $contractor Object to remove from the list of results
     *
     * @return ContractorQuery The current query, for fluid interface
     */
    public function prune($contractor = null)
    {
        if ($contractor) {
            $this->addUsingAlias(ContractorPeer::ID, $contractor->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every SELECT statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreSelect(PropelPDO $con)
    {
        // soft_delete behavior
        if (ContractorQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            $this->addUsingAlias(ContractorPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ContractorPeer::enableSoftDelete();
        }

        return $this->preSelect($con);
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreDelete(PropelPDO $con)
    {
        // soft_delete behavior
        if (ContractorQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            return $this->softDelete($con);
        } else {
            return $this->hasWhereClause() ? $this->forceDelete($con) : $this->forceDeleteAll($con);
        }

        return $this->preDelete($con);
    }

    // soft_delete behavior

    /**
     * Temporarily disable the filter on deleted rows
     * Valid only for the current query
     *
     * @see ContractorQuery::disableSoftDelete() to disable the filter for more than one query
     *
     * @return ContractorQuery The current query, for fluid interface
     */
    public function includeDeleted()
    {
        $this->localSoftDelete = false;

        return $this;
    }

    /**
     * Soft delete the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of updated rows
     */
    public function softDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => time()), $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDelete(PropelPDO $con = null)
    {
        return ContractorPeer::doForceDelete($this, $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of all the rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDeleteAll(PropelPDO $con = null)
    {
        return ContractorPeer::doForceDeleteAll($con);}

    /**
     * Undelete selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => null), $con);
    }

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        self::$softDelete = true;
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        self::$softDelete = false;
    }

    /**
     * Check the soft_delete behavior for this model
     *
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return self::$softDelete;
    }

}
