<?php



/**
 * This class defines the structure of the 'panel_mission' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    propel.generator.panel.classes.map
 */
class MissionTableMap extends TableMap
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'panel.classes.map.MissionTableMap';

    /**
     * Initialize the table attributes, columns and validators
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('panel_mission');
        $this->setPhpName('Mission');
        $this->setClassname('Mission');
        $this->setPackage('panel.classes');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('TYPE', 'Type', 'INTEGER', false, null, null);
        $this->addColumn('STARTDATE', 'Startdate', 'DATE', true, null, null);
        $this->addColumn('FINISHDATE', 'Finishdate', 'DATE', true, null, null);
        $this->addForeignKey('PROJECTID', 'Projectid', 'INTEGER', 'projects_project', 'ID', false, null, null);
        $this->addColumn('DESCRIPTION', 'Description', 'LONGVARCHAR', false, null, null);
        $this->addColumn('RESPONSIBLE', 'Responsible', 'CHAR', false, 120, null);
        $this->addForeignKey('USERID', 'Userid', 'INTEGER', 'users_user', 'ID', false, null, null);
        $this->addForeignKey('UPDATERUSERID', 'Updateruserid', 'INTEGER', 'users_user', 'ID', false, null, null);
        $this->addColumn('DELETED_AT', 'DeletedAt', 'TIMESTAMP', false, null, null);
        $this->addColumn('CREATED_AT', 'CreatedAt', 'TIMESTAMP', false, null, null);
        $this->addColumn('UPDATED_AT', 'UpdatedAt', 'TIMESTAMP', false, null, null);
        // validators
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Project', 'Project', RelationMap::MANY_TO_ONE, array('projectId' => 'id', ), 'SET NULL', null);
        $this->addRelation('UserRelatedByUserid', 'User', RelationMap::MANY_TO_ONE, array('userId' => 'id', ), 'SET NULL', null);
        $this->addRelation('UserRelatedByUpdateruserid', 'User', RelationMap::MANY_TO_ONE, array('updaterUserId' => 'id', ), 'SET NULL', null);
        $this->addRelation('MissionParticipant', 'MissionParticipant', RelationMap::ONE_TO_MANY, array('id' => 'missionId', ), 'CASCADE', null, 'MissionParticipants');
        $this->addRelation('MissionCommitment', 'MissionCommitment', RelationMap::ONE_TO_MANY, array('id' => 'missionId', ), 'CASCADE', null, 'MissionCommitments');
        $this->addRelation('MissionDocument', 'MissionDocument', RelationMap::ONE_TO_MANY, array('id' => 'missionId', ), 'CASCADE', null, 'MissionDocuments');
        $this->addRelation('MissionUpdate', 'MissionUpdate', RelationMap::ONE_TO_ONE, array('id' => 'missionId', ), 'CASCADE', null);
        $this->addRelation('Document', 'Document', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Documents');
    } // buildRelations()

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array Associative array (name => parameters) of behaviors
     */
    public function getBehaviors()
    {
        return array(
            'soft_delete' => array('deleted_column' => 'deleted_at', ),
            'timestampable' => array('create_column' => 'created_at', 'update_column' => 'updated_at', 'disable_updated_at' => 'false', ),
        );
    } // getBehaviors()

} // MissionTableMap
