<?php


/**
 * Base class that represents a query for the 'issues_issue' table.
 *
 * Asuntos
 *
 * @method IssueQuery orderById($order = Criteria::ASC) Order by the id column
 * @method IssueQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method IssueQuery orderByParentid($order = Criteria::ASC) Order by the parentId column
 * @method IssueQuery orderByDescription($order = Criteria::ASC) Order by the description column
 * @method IssueQuery orderByImpact($order = Criteria::ASC) Order by the impact column
 * @method IssueQuery orderByValoration($order = Criteria::ASC) Order by the valoration column
 * @method IssueQuery orderByEvolution($order = Criteria::ASC) Order by the evolution column
 * @method IssueQuery orderByObjecttype($order = Criteria::ASC) Order by the objectType column
 * @method IssueQuery orderByObjectid($order = Criteria::ASC) Order by the objectId column
 * @method IssueQuery orderByCreatedAt($order = Criteria::ASC) Order by the created_at column
 * @method IssueQuery orderByUpdatedAt($order = Criteria::ASC) Order by the updated_at column
 * @method IssueQuery orderByDeletedAt($order = Criteria::ASC) Order by the deleted_at column
 * @method IssueQuery orderByVersion($order = Criteria::ASC) Order by the version column
 * @method IssueQuery orderByVersionCreatedBy($order = Criteria::ASC) Order by the version_created_by column
 *
 * @method IssueQuery groupById() Group by the id column
 * @method IssueQuery groupByName() Group by the name column
 * @method IssueQuery groupByParentid() Group by the parentId column
 * @method IssueQuery groupByDescription() Group by the description column
 * @method IssueQuery groupByImpact() Group by the impact column
 * @method IssueQuery groupByValoration() Group by the valoration column
 * @method IssueQuery groupByEvolution() Group by the evolution column
 * @method IssueQuery groupByObjecttype() Group by the objectType column
 * @method IssueQuery groupByObjectid() Group by the objectId column
 * @method IssueQuery groupByCreatedAt() Group by the created_at column
 * @method IssueQuery groupByUpdatedAt() Group by the updated_at column
 * @method IssueQuery groupByDeletedAt() Group by the deleted_at column
 * @method IssueQuery groupByVersion() Group by the version column
 * @method IssueQuery groupByVersionCreatedBy() Group by the version_created_by column
 *
 * @method IssueQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method IssueQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method IssueQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method IssueQuery leftJoinHeadlineIssue($relationAlias = null) Adds a LEFT JOIN clause to the query using the HeadlineIssue relation
 * @method IssueQuery rightJoinHeadlineIssue($relationAlias = null) Adds a RIGHT JOIN clause to the query using the HeadlineIssue relation
 * @method IssueQuery innerJoinHeadlineIssue($relationAlias = null) Adds a INNER JOIN clause to the query using the HeadlineIssue relation
 *
 * @method IssueQuery leftJoinIssueCategoryRelation($relationAlias = null) Adds a LEFT JOIN clause to the query using the IssueCategoryRelation relation
 * @method IssueQuery rightJoinIssueCategoryRelation($relationAlias = null) Adds a RIGHT JOIN clause to the query using the IssueCategoryRelation relation
 * @method IssueQuery innerJoinIssueCategoryRelation($relationAlias = null) Adds a INNER JOIN clause to the query using the IssueCategoryRelation relation
 *
 * @method IssueQuery leftJoinIssueActor($relationAlias = null) Adds a LEFT JOIN clause to the query using the IssueActor relation
 * @method IssueQuery rightJoinIssueActor($relationAlias = null) Adds a RIGHT JOIN clause to the query using the IssueActor relation
 * @method IssueQuery innerJoinIssueActor($relationAlias = null) Adds a INNER JOIN clause to the query using the IssueActor relation
 *
 * @method IssueQuery leftJoinIssueVersion($relationAlias = null) Adds a LEFT JOIN clause to the query using the IssueVersion relation
 * @method IssueQuery rightJoinIssueVersion($relationAlias = null) Adds a RIGHT JOIN clause to the query using the IssueVersion relation
 * @method IssueQuery innerJoinIssueVersion($relationAlias = null) Adds a INNER JOIN clause to the query using the IssueVersion relation
 *
 * @method Issue findOne(PropelPDO $con = null) Return the first Issue matching the query
 * @method Issue findOneOrCreate(PropelPDO $con = null) Return the first Issue matching the query, or a new Issue object populated from the query conditions when no match is found
 *
 * @method Issue findOneById(int $id) Return the first Issue filtered by the id column
 * @method Issue findOneByName(string $name) Return the first Issue filtered by the name column
 * @method Issue findOneByParentid(int $parentId) Return the first Issue filtered by the parentId column
 * @method Issue findOneByDescription(string $description) Return the first Issue filtered by the description column
 * @method Issue findOneByImpact(int $impact) Return the first Issue filtered by the impact column
 * @method Issue findOneByValoration(int $valoration) Return the first Issue filtered by the valoration column
 * @method Issue findOneByEvolution(int $evolution) Return the first Issue filtered by the evolution column
 * @method Issue findOneByObjecttype(string $objectType) Return the first Issue filtered by the objectType column
 * @method Issue findOneByObjectid(int $objectId) Return the first Issue filtered by the objectId column
 * @method Issue findOneByCreatedAt(string $created_at) Return the first Issue filtered by the created_at column
 * @method Issue findOneByUpdatedAt(string $updated_at) Return the first Issue filtered by the updated_at column
 * @method Issue findOneByDeletedAt(string $deleted_at) Return the first Issue filtered by the deleted_at column
 * @method Issue findOneByVersion(int $version) Return the first Issue filtered by the version column
 * @method Issue findOneByVersionCreatedBy(string $version_created_by) Return the first Issue filtered by the version_created_by column
 *
 * @method array findById(int $id) Return Issue objects filtered by the id column
 * @method array findByName(string $name) Return Issue objects filtered by the name column
 * @method array findByParentid(int $parentId) Return Issue objects filtered by the parentId column
 * @method array findByDescription(string $description) Return Issue objects filtered by the description column
 * @method array findByImpact(int $impact) Return Issue objects filtered by the impact column
 * @method array findByValoration(int $valoration) Return Issue objects filtered by the valoration column
 * @method array findByEvolution(int $evolution) Return Issue objects filtered by the evolution column
 * @method array findByObjecttype(string $objectType) Return Issue objects filtered by the objectType column
 * @method array findByObjectid(int $objectId) Return Issue objects filtered by the objectId column
 * @method array findByCreatedAt(string $created_at) Return Issue objects filtered by the created_at column
 * @method array findByUpdatedAt(string $updated_at) Return Issue objects filtered by the updated_at column
 * @method array findByDeletedAt(string $deleted_at) Return Issue objects filtered by the deleted_at column
 * @method array findByVersion(int $version) Return Issue objects filtered by the version column
 * @method array findByVersionCreatedBy(string $version_created_by) Return Issue objects filtered by the version_created_by column
 *
 * @package    propel.generator.issues.classes.om
 */
abstract class BaseIssueQuery extends \Egytca\Propel\Query
{
    // soft_delete behavior
    protected static $softDelete = true;
    protected $localSoftDelete = true;

    /**
     * Initializes internal state of BaseIssueQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'Issue', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new IssueQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     IssueQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return IssueQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof IssueQuery) {
            return $criteria;
        }
        $query = new IssueQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   Issue|Issue[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = IssuePeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(IssuePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   Issue A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `NAME`, `PARENTID`, `DESCRIPTION`, `IMPACT`, `VALORATION`, `EVOLUTION`, `OBJECTTYPE`, `OBJECTID`, `CREATED_AT`, `UPDATED_AT`, `DELETED_AT`, `VERSION`, `VERSION_CREATED_BY` FROM `issues_issue` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new Issue();
            $obj->hydrate($row);
            IssuePeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return Issue|Issue[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|Issue[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(IssuePeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(IssuePeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(IssuePeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(IssuePeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the parentId column
     *
     * Example usage:
     * <code>
     * $query->filterByParentid(1234); // WHERE parentId = 1234
     * $query->filterByParentid(array(12, 34)); // WHERE parentId IN (12, 34)
     * $query->filterByParentid(array('min' => 12)); // WHERE parentId > 12
     * </code>
     *
     * @param     mixed $parentid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function filterByParentid($parentid = null, $comparison = null)
    {
        if (is_array($parentid)) {
            $useMinMax = false;
            if (isset($parentid['min'])) {
                $this->addUsingAlias(IssuePeer::PARENTID, $parentid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($parentid['max'])) {
                $this->addUsingAlias(IssuePeer::PARENTID, $parentid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssuePeer::PARENTID, $parentid, $comparison);
    }

    /**
     * Filter the query on the description column
     *
     * Example usage:
     * <code>
     * $query->filterByDescription('fooValue');   // WHERE description = 'fooValue'
     * $query->filterByDescription('%fooValue%'); // WHERE description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $description The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function filterByDescription($description = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($description)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $description)) {
                $description = str_replace('*', '%', $description);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(IssuePeer::DESCRIPTION, $description, $comparison);
    }

    /**
     * Filter the query on the impact column
     *
     * Example usage:
     * <code>
     * $query->filterByImpact(1234); // WHERE impact = 1234
     * $query->filterByImpact(array(12, 34)); // WHERE impact IN (12, 34)
     * $query->filterByImpact(array('min' => 12)); // WHERE impact > 12
     * </code>
     *
     * @param     mixed $impact The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function filterByImpact($impact = null, $comparison = null)
    {
        if (is_array($impact)) {
            $useMinMax = false;
            if (isset($impact['min'])) {
                $this->addUsingAlias(IssuePeer::IMPACT, $impact['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($impact['max'])) {
                $this->addUsingAlias(IssuePeer::IMPACT, $impact['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssuePeer::IMPACT, $impact, $comparison);
    }

    /**
     * Filter the query on the valoration column
     *
     * Example usage:
     * <code>
     * $query->filterByValoration(1234); // WHERE valoration = 1234
     * $query->filterByValoration(array(12, 34)); // WHERE valoration IN (12, 34)
     * $query->filterByValoration(array('min' => 12)); // WHERE valoration > 12
     * </code>
     *
     * @param     mixed $valoration The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function filterByValoration($valoration = null, $comparison = null)
    {
        if (is_array($valoration)) {
            $useMinMax = false;
            if (isset($valoration['min'])) {
                $this->addUsingAlias(IssuePeer::VALORATION, $valoration['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($valoration['max'])) {
                $this->addUsingAlias(IssuePeer::VALORATION, $valoration['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssuePeer::VALORATION, $valoration, $comparison);
    }

    /**
     * Filter the query on the evolution column
     *
     * Example usage:
     * <code>
     * $query->filterByEvolution(1234); // WHERE evolution = 1234
     * $query->filterByEvolution(array(12, 34)); // WHERE evolution IN (12, 34)
     * $query->filterByEvolution(array('min' => 12)); // WHERE evolution > 12
     * </code>
     *
     * @param     mixed $evolution The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function filterByEvolution($evolution = null, $comparison = null)
    {
        if (is_array($evolution)) {
            $useMinMax = false;
            if (isset($evolution['min'])) {
                $this->addUsingAlias(IssuePeer::EVOLUTION, $evolution['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($evolution['max'])) {
                $this->addUsingAlias(IssuePeer::EVOLUTION, $evolution['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssuePeer::EVOLUTION, $evolution, $comparison);
    }

    /**
     * Filter the query on the objectType column
     *
     * Example usage:
     * <code>
     * $query->filterByObjecttype('fooValue');   // WHERE objectType = 'fooValue'
     * $query->filterByObjecttype('%fooValue%'); // WHERE objectType LIKE '%fooValue%'
     * </code>
     *
     * @param     string $objecttype The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function filterByObjecttype($objecttype = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($objecttype)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $objecttype)) {
                $objecttype = str_replace('*', '%', $objecttype);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(IssuePeer::OBJECTTYPE, $objecttype, $comparison);
    }

    /**
     * Filter the query on the objectId column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectid(1234); // WHERE objectId = 1234
     * $query->filterByObjectid(array(12, 34)); // WHERE objectId IN (12, 34)
     * $query->filterByObjectid(array('min' => 12)); // WHERE objectId > 12
     * </code>
     *
     * @param     mixed $objectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function filterByObjectid($objectid = null, $comparison = null)
    {
        if (is_array($objectid)) {
            $useMinMax = false;
            if (isset($objectid['min'])) {
                $this->addUsingAlias(IssuePeer::OBJECTID, $objectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($objectid['max'])) {
                $this->addUsingAlias(IssuePeer::OBJECTID, $objectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssuePeer::OBJECTID, $objectid, $comparison);
    }

    /**
     * Filter the query on the created_at column
     *
     * Example usage:
     * <code>
     * $query->filterByCreatedAt('2011-03-14'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt('now'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt(array('max' => 'yesterday')); // WHERE created_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $createdAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function filterByCreatedAt($createdAt = null, $comparison = null)
    {
        if (is_array($createdAt)) {
            $useMinMax = false;
            if (isset($createdAt['min'])) {
                $this->addUsingAlias(IssuePeer::CREATED_AT, $createdAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($createdAt['max'])) {
                $this->addUsingAlias(IssuePeer::CREATED_AT, $createdAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssuePeer::CREATED_AT, $createdAt, $comparison);
    }

    /**
     * Filter the query on the updated_at column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdatedAt('2011-03-14'); // WHERE updated_at = '2011-03-14'
     * $query->filterByUpdatedAt('now'); // WHERE updated_at = '2011-03-14'
     * $query->filterByUpdatedAt(array('max' => 'yesterday')); // WHERE updated_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $updatedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function filterByUpdatedAt($updatedAt = null, $comparison = null)
    {
        if (is_array($updatedAt)) {
            $useMinMax = false;
            if (isset($updatedAt['min'])) {
                $this->addUsingAlias(IssuePeer::UPDATED_AT, $updatedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updatedAt['max'])) {
                $this->addUsingAlias(IssuePeer::UPDATED_AT, $updatedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssuePeer::UPDATED_AT, $updatedAt, $comparison);
    }

    /**
     * Filter the query on the deleted_at column
     *
     * Example usage:
     * <code>
     * $query->filterByDeletedAt('2011-03-14'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt('now'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt(array('max' => 'yesterday')); // WHERE deleted_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $deletedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function filterByDeletedAt($deletedAt = null, $comparison = null)
    {
        if (is_array($deletedAt)) {
            $useMinMax = false;
            if (isset($deletedAt['min'])) {
                $this->addUsingAlias(IssuePeer::DELETED_AT, $deletedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deletedAt['max'])) {
                $this->addUsingAlias(IssuePeer::DELETED_AT, $deletedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssuePeer::DELETED_AT, $deletedAt, $comparison);
    }

    /**
     * Filter the query on the version column
     *
     * Example usage:
     * <code>
     * $query->filterByVersion(1234); // WHERE version = 1234
     * $query->filterByVersion(array(12, 34)); // WHERE version IN (12, 34)
     * $query->filterByVersion(array('min' => 12)); // WHERE version > 12
     * </code>
     *
     * @param     mixed $version The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function filterByVersion($version = null, $comparison = null)
    {
        if (is_array($version)) {
            $useMinMax = false;
            if (isset($version['min'])) {
                $this->addUsingAlias(IssuePeer::VERSION, $version['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($version['max'])) {
                $this->addUsingAlias(IssuePeer::VERSION, $version['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssuePeer::VERSION, $version, $comparison);
    }

    /**
     * Filter the query on the version_created_by column
     *
     * Example usage:
     * <code>
     * $query->filterByVersionCreatedBy('fooValue');   // WHERE version_created_by = 'fooValue'
     * $query->filterByVersionCreatedBy('%fooValue%'); // WHERE version_created_by LIKE '%fooValue%'
     * </code>
     *
     * @param     string $versionCreatedBy The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function filterByVersionCreatedBy($versionCreatedBy = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($versionCreatedBy)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $versionCreatedBy)) {
                $versionCreatedBy = str_replace('*', '%', $versionCreatedBy);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(IssuePeer::VERSION_CREATED_BY, $versionCreatedBy, $comparison);
    }

    /**
     * Filter the query by a related HeadlineIssue object
     *
     * @param   HeadlineIssue|PropelObjectCollection $headlineIssue  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IssueQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByHeadlineIssue($headlineIssue, $comparison = null)
    {
        if ($headlineIssue instanceof HeadlineIssue) {
            return $this
                ->addUsingAlias(IssuePeer::ID, $headlineIssue->getIssueid(), $comparison);
        } elseif ($headlineIssue instanceof PropelObjectCollection) {
            return $this
                ->useHeadlineIssueQuery()
                ->filterByPrimaryKeys($headlineIssue->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByHeadlineIssue() only accepts arguments of type HeadlineIssue or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the HeadlineIssue relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function joinHeadlineIssue($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('HeadlineIssue');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'HeadlineIssue');
        }

        return $this;
    }

    /**
     * Use the HeadlineIssue relation HeadlineIssue object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   HeadlineIssueQuery A secondary query class using the current class as primary query
     */
    public function useHeadlineIssueQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinHeadlineIssue($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'HeadlineIssue', 'HeadlineIssueQuery');
    }

    /**
     * Filter the query by a related IssueCategoryRelation object
     *
     * @param   IssueCategoryRelation|PropelObjectCollection $issueCategoryRelation  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IssueQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByIssueCategoryRelation($issueCategoryRelation, $comparison = null)
    {
        if ($issueCategoryRelation instanceof IssueCategoryRelation) {
            return $this
                ->addUsingAlias(IssuePeer::ID, $issueCategoryRelation->getIssueid(), $comparison);
        } elseif ($issueCategoryRelation instanceof PropelObjectCollection) {
            return $this
                ->useIssueCategoryRelationQuery()
                ->filterByPrimaryKeys($issueCategoryRelation->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByIssueCategoryRelation() only accepts arguments of type IssueCategoryRelation or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the IssueCategoryRelation relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function joinIssueCategoryRelation($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('IssueCategoryRelation');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'IssueCategoryRelation');
        }

        return $this;
    }

    /**
     * Use the IssueCategoryRelation relation IssueCategoryRelation object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   IssueCategoryRelationQuery A secondary query class using the current class as primary query
     */
    public function useIssueCategoryRelationQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinIssueCategoryRelation($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'IssueCategoryRelation', 'IssueCategoryRelationQuery');
    }

    /**
     * Filter the query by a related IssueActor object
     *
     * @param   IssueActor|PropelObjectCollection $issueActor  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IssueQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByIssueActor($issueActor, $comparison = null)
    {
        if ($issueActor instanceof IssueActor) {
            return $this
                ->addUsingAlias(IssuePeer::ID, $issueActor->getIssueid(), $comparison);
        } elseif ($issueActor instanceof PropelObjectCollection) {
            return $this
                ->useIssueActorQuery()
                ->filterByPrimaryKeys($issueActor->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByIssueActor() only accepts arguments of type IssueActor or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the IssueActor relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function joinIssueActor($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('IssueActor');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'IssueActor');
        }

        return $this;
    }

    /**
     * Use the IssueActor relation IssueActor object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   IssueActorQuery A secondary query class using the current class as primary query
     */
    public function useIssueActorQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinIssueActor($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'IssueActor', 'IssueActorQuery');
    }

    /**
     * Filter the query by a related IssueVersion object
     *
     * @param   IssueVersion|PropelObjectCollection $issueVersion  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IssueQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByIssueVersion($issueVersion, $comparison = null)
    {
        if ($issueVersion instanceof IssueVersion) {
            return $this
                ->addUsingAlias(IssuePeer::ID, $issueVersion->getId(), $comparison);
        } elseif ($issueVersion instanceof PropelObjectCollection) {
            return $this
                ->useIssueVersionQuery()
                ->filterByPrimaryKeys($issueVersion->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByIssueVersion() only accepts arguments of type IssueVersion or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the IssueVersion relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function joinIssueVersion($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('IssueVersion');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'IssueVersion');
        }

        return $this;
    }

    /**
     * Use the IssueVersion relation IssueVersion object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   IssueVersionQuery A secondary query class using the current class as primary query
     */
    public function useIssueVersionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinIssueVersion($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'IssueVersion', 'IssueVersionQuery');
    }

    /**
     * Filter the query by a related Headline object
     * using the headlines_issue table as cross reference
     *
     * @param   Headline $headline the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IssueQuery The current query, for fluid interface
     */
    public function filterByHeadline($headline, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useHeadlineIssueQuery()
            ->filterByHeadline($headline, $comparison)
            ->endUse();
    }

    /**
     * Filter the query by a related IssueCategory object
     * using the issues_issuesCategory table as cross reference
     *
     * @param   IssueCategory $issueCategory the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IssueQuery The current query, for fluid interface
     */
    public function filterByIssueCategory($issueCategory, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useIssueCategoryRelationQuery()
            ->filterByIssueCategory($issueCategory, $comparison)
            ->endUse();
    }

    /**
     * Filter the query by a related Actor object
     * using the issues_actors table as cross reference
     *
     * @param   Actor $actor the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IssueQuery The current query, for fluid interface
     */
    public function filterByActor($actor, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useIssueActorQuery()
            ->filterByActor($actor, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   Issue $issue Object to remove from the list of results
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function prune($issue = null)
    {
        if ($issue) {
            $this->addUsingAlias(IssuePeer::ID, $issue->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every SELECT statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreSelect(PropelPDO $con)
    {
        // soft_delete behavior
        if (IssueQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            $this->addUsingAlias(IssuePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            IssuePeer::enableSoftDelete();
        }

        return $this->preSelect($con);
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreDelete(PropelPDO $con)
    {
        // soft_delete behavior
        if (IssueQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            return $this->softDelete($con);
        } else {
            return $this->hasWhereClause() ? $this->forceDelete($con) : $this->forceDeleteAll($con);
        }

        return $this->preDelete($con);
    }

    // timestampable behavior

    /**
     * Filter by the latest updated
     *
     * @param      int $nbDays Maximum age of the latest update in days
     *
     * @return     IssueQuery The current query, for fluid interface
     */
    public function recentlyUpdated($nbDays = 7)
    {
        return $this->addUsingAlias(IssuePeer::UPDATED_AT, time() - $nbDays * 24 * 60 * 60, Criteria::GREATER_EQUAL);
    }

    /**
     * Order by update date desc
     *
     * @return     IssueQuery The current query, for fluid interface
     */
    public function lastUpdatedFirst()
    {
        return $this->addDescendingOrderByColumn(IssuePeer::UPDATED_AT);
    }

    /**
     * Order by update date asc
     *
     * @return     IssueQuery The current query, for fluid interface
     */
    public function firstUpdatedFirst()
    {
        return $this->addAscendingOrderByColumn(IssuePeer::UPDATED_AT);
    }

    /**
     * Filter by the latest created
     *
     * @param      int $nbDays Maximum age of in days
     *
     * @return     IssueQuery The current query, for fluid interface
     */
    public function recentlyCreated($nbDays = 7)
    {
        return $this->addUsingAlias(IssuePeer::CREATED_AT, time() - $nbDays * 24 * 60 * 60, Criteria::GREATER_EQUAL);
    }

    /**
     * Order by create date desc
     *
     * @return     IssueQuery The current query, for fluid interface
     */
    public function lastCreatedFirst()
    {
        return $this->addDescendingOrderByColumn(IssuePeer::CREATED_AT);
    }

    /**
     * Order by create date asc
     *
     * @return     IssueQuery The current query, for fluid interface
     */
    public function firstCreatedFirst()
    {
        return $this->addAscendingOrderByColumn(IssuePeer::CREATED_AT);
    }
    // soft_delete behavior

    /**
     * Temporarily disable the filter on deleted rows
     * Valid only for the current query
     *
     * @see IssueQuery::disableSoftDelete() to disable the filter for more than one query
     *
     * @return IssueQuery The current query, for fluid interface
     */
    public function includeDeleted()
    {
        $this->localSoftDelete = false;

        return $this;
    }

    /**
     * Soft delete the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of updated rows
     */
    public function softDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => time()), $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDelete(PropelPDO $con = null)
    {
        return IssuePeer::doForceDelete($this, $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of all the rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDeleteAll(PropelPDO $con = null)
    {
        return IssuePeer::doForceDeleteAll($con);}

    /**
     * Undelete selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => null), $con);
    }

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        self::$softDelete = true;
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        self::$softDelete = false;
    }

    /**
     * Check the soft_delete behavior for this model
     *
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return self::$softDelete;
    }

}
