<?php

class IndicatorsNumericValuesEditAction extends BaseAction {

	function execute($mapping, $form, &$request, &$response) {

		parent::execute($mapping, $form, $request, $response);

		$this->smarty->assign('includeJQuery', true);

		if (empty($_GET['id']))
			throw new Exception('param "id" is required');

		$numericIndicator = NumericIndicatorQuery::create()->findOneById($_GET['id']);
		if (!$numericIndicator)
			throw new Exception('invalid id');

		$expectedValues = $numericIndicator
			->getExpectedIndicatorValues()
			->toArray();
		$realValues = $numericIndicator
			->getRealIndicatorValues()
			->toArray();

		$this->smarty->assign([
			'numericIndicator' => $numericIndicator,
			'expectedValues' => json_encode($expectedValues),
			'realValues' => json_encode($realValues)
		]);

		return $mapping->findForwardConfig('success');
	}
}