<?php


/**
 * Base class that represents a query for the 'documents_document' table.
 *
 * Documentos del sistema
 *
 * @method DocumentQuery orderById($order = Criteria::ASC) Order by the id column
 * @method DocumentQuery orderByTitle($order = Criteria::ASC) Order by the title column
 * @method DocumentQuery orderByRealfilename($order = Criteria::ASC) Order by the realFilename column
 * @method DocumentQuery orderByDate($order = Criteria::ASC) Order by the date column
 * @method DocumentQuery orderByCategoryid($order = Criteria::ASC) Order by the categoryId column
 * @method DocumentQuery orderByDescription($order = Criteria::ASC) Order by the description column
 * @method DocumentQuery orderByDocumentDate($order = Criteria::ASC) Order by the document_date column
 * @method DocumentQuery orderByPassword($order = Criteria::ASC) Order by the password column
 * @method DocumentQuery orderByAuthor($order = Criteria::ASC) Order by the author column
 * @method DocumentQuery orderByKeywords($order = Criteria::ASC) Order by the keyWords column
 * @method DocumentQuery orderByNumber($order = Criteria::ASC) Order by the number column
 * @method DocumentQuery orderBySize($order = Criteria::ASC) Order by the size column
 * @method DocumentQuery orderByFulltextcontent($order = Criteria::ASC) Order by the fullTextContent column
 *
 * @method DocumentQuery groupById() Group by the id column
 * @method DocumentQuery groupByTitle() Group by the title column
 * @method DocumentQuery groupByRealfilename() Group by the realFilename column
 * @method DocumentQuery groupByDate() Group by the date column
 * @method DocumentQuery groupByCategoryid() Group by the categoryId column
 * @method DocumentQuery groupByDescription() Group by the description column
 * @method DocumentQuery groupByDocumentDate() Group by the document_date column
 * @method DocumentQuery groupByPassword() Group by the password column
 * @method DocumentQuery groupByAuthor() Group by the author column
 * @method DocumentQuery groupByKeywords() Group by the keyWords column
 * @method DocumentQuery groupByNumber() Group by the number column
 * @method DocumentQuery groupBySize() Group by the size column
 * @method DocumentQuery groupByFulltextcontent() Group by the fullTextContent column
 *
 * @method DocumentQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method DocumentQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method DocumentQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method DocumentQuery leftJoinCategory($relationAlias = null) Adds a LEFT JOIN clause to the query using the Category relation
 * @method DocumentQuery rightJoinCategory($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Category relation
 * @method DocumentQuery innerJoinCategory($relationAlias = null) Adds a INNER JOIN clause to the query using the Category relation
 *
 * @method DocumentQuery leftJoinCampaignDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the CampaignDocument relation
 * @method DocumentQuery rightJoinCampaignDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the CampaignDocument relation
 * @method DocumentQuery innerJoinCampaignDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the CampaignDocument relation
 *
 * @method DocumentQuery leftJoinHeadlineDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the HeadlineDocument relation
 * @method DocumentQuery rightJoinHeadlineDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the HeadlineDocument relation
 * @method DocumentQuery innerJoinHeadlineDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the HeadlineDocument relation
 *
 * @method DocumentQuery leftJoinGuaranteeDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the GuaranteeDocument relation
 * @method DocumentQuery rightJoinGuaranteeDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the GuaranteeDocument relation
 * @method DocumentQuery innerJoinGuaranteeDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the GuaranteeDocument relation
 *
 * @method DocumentQuery leftJoinAdministrativeActDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the AdministrativeActDocument relation
 * @method DocumentQuery rightJoinAdministrativeActDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the AdministrativeActDocument relation
 * @method DocumentQuery innerJoinAdministrativeActDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the AdministrativeActDocument relation
 *
 * @method DocumentQuery leftJoinMissionDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the MissionDocument relation
 * @method DocumentQuery rightJoinMissionDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MissionDocument relation
 * @method DocumentQuery innerJoinMissionDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the MissionDocument relation
 *
 * @method DocumentQuery leftJoinReportSectionDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the ReportSectionDocument relation
 * @method DocumentQuery rightJoinReportSectionDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ReportSectionDocument relation
 * @method DocumentQuery innerJoinReportSectionDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the ReportSectionDocument relation
 *
 * @method DocumentQuery leftJoinPositionDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the PositionDocument relation
 * @method DocumentQuery rightJoinPositionDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PositionDocument relation
 * @method DocumentQuery innerJoinPositionDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the PositionDocument relation
 *
 * @method DocumentQuery leftJoinProjectDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectDocument relation
 * @method DocumentQuery rightJoinProjectDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectDocument relation
 * @method DocumentQuery innerJoinProjectDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectDocument relation
 *
 * @method DocumentQuery leftJoinActivityDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the ActivityDocument relation
 * @method DocumentQuery rightJoinActivityDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ActivityDocument relation
 * @method DocumentQuery innerJoinActivityDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the ActivityDocument relation
 *
 * @method Document findOne(PropelPDO $con = null) Return the first Document matching the query
 * @method Document findOneOrCreate(PropelPDO $con = null) Return the first Document matching the query, or a new Document object populated from the query conditions when no match is found
 *
 * @method Document findOneById(int $id) Return the first Document filtered by the id column
 * @method Document findOneByTitle(string $title) Return the first Document filtered by the title column
 * @method Document findOneByRealfilename(string $realFilename) Return the first Document filtered by the realFilename column
 * @method Document findOneByDate(string $date) Return the first Document filtered by the date column
 * @method Document findOneByCategoryid(int $categoryId) Return the first Document filtered by the categoryId column
 * @method Document findOneByDescription(string $description) Return the first Document filtered by the description column
 * @method Document findOneByDocumentDate(string $document_date) Return the first Document filtered by the document_date column
 * @method Document findOneByPassword(string $password) Return the first Document filtered by the password column
 * @method Document findOneByAuthor(string $author) Return the first Document filtered by the author column
 * @method Document findOneByKeywords(string $keyWords) Return the first Document filtered by the keyWords column
 * @method Document findOneByNumber(string $number) Return the first Document filtered by the number column
 * @method Document findOneBySize(int $size) Return the first Document filtered by the size column
 * @method Document findOneByFulltextcontent(string $fullTextContent) Return the first Document filtered by the fullTextContent column
 *
 * @method array findById(int $id) Return Document objects filtered by the id column
 * @method array findByTitle(string $title) Return Document objects filtered by the title column
 * @method array findByRealfilename(string $realFilename) Return Document objects filtered by the realFilename column
 * @method array findByDate(string $date) Return Document objects filtered by the date column
 * @method array findByCategoryid(int $categoryId) Return Document objects filtered by the categoryId column
 * @method array findByDescription(string $description) Return Document objects filtered by the description column
 * @method array findByDocumentDate(string $document_date) Return Document objects filtered by the document_date column
 * @method array findByPassword(string $password) Return Document objects filtered by the password column
 * @method array findByAuthor(string $author) Return Document objects filtered by the author column
 * @method array findByKeywords(string $keyWords) Return Document objects filtered by the keyWords column
 * @method array findByNumber(string $number) Return Document objects filtered by the number column
 * @method array findBySize(int $size) Return Document objects filtered by the size column
 * @method array findByFulltextcontent(string $fullTextContent) Return Document objects filtered by the fullTextContent column
 *
 * @package    propel.generator.documents.classes.om
 */
abstract class BaseDocumentQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseDocumentQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'Document', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new DocumentQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     DocumentQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return DocumentQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof DocumentQuery) {
            return $criteria;
        }
        $query = new DocumentQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   Document|Document[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = DocumentPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(DocumentPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   Document A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `TITLE`, `REALFILENAME`, `DATE`, `CATEGORYID`, `DESCRIPTION`, `DOCUMENT_DATE`, `PASSWORD`, `AUTHOR`, `KEYWORDS`, `NUMBER`, `SIZE`, `FULLTEXTCONTENT` FROM `documents_document` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new Document();
            $obj->hydrate($row);
            DocumentPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return Document|Document[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|Document[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(DocumentPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(DocumentPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(DocumentPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the title column
     *
     * Example usage:
     * <code>
     * $query->filterByTitle('fooValue');   // WHERE title = 'fooValue'
     * $query->filterByTitle('%fooValue%'); // WHERE title LIKE '%fooValue%'
     * </code>
     *
     * @param     string $title The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function filterByTitle($title = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($title)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $title)) {
                $title = str_replace('*', '%', $title);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(DocumentPeer::TITLE, $title, $comparison);
    }

    /**
     * Filter the query on the realFilename column
     *
     * Example usage:
     * <code>
     * $query->filterByRealfilename('fooValue');   // WHERE realFilename = 'fooValue'
     * $query->filterByRealfilename('%fooValue%'); // WHERE realFilename LIKE '%fooValue%'
     * </code>
     *
     * @param     string $realfilename The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function filterByRealfilename($realfilename = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($realfilename)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $realfilename)) {
                $realfilename = str_replace('*', '%', $realfilename);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(DocumentPeer::REALFILENAME, $realfilename, $comparison);
    }

    /**
     * Filter the query on the date column
     *
     * Example usage:
     * <code>
     * $query->filterByDate('2011-03-14'); // WHERE date = '2011-03-14'
     * $query->filterByDate('now'); // WHERE date = '2011-03-14'
     * $query->filterByDate(array('max' => 'yesterday')); // WHERE date > '2011-03-13'
     * </code>
     *
     * @param     mixed $date The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function filterByDate($date = null, $comparison = null)
    {
        if (is_array($date)) {
            $useMinMax = false;
            if (isset($date['min'])) {
                $this->addUsingAlias(DocumentPeer::DATE, $date['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($date['max'])) {
                $this->addUsingAlias(DocumentPeer::DATE, $date['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DocumentPeer::DATE, $date, $comparison);
    }

    /**
     * Filter the query on the categoryId column
     *
     * Example usage:
     * <code>
     * $query->filterByCategoryid(1234); // WHERE categoryId = 1234
     * $query->filterByCategoryid(array(12, 34)); // WHERE categoryId IN (12, 34)
     * $query->filterByCategoryid(array('min' => 12)); // WHERE categoryId > 12
     * </code>
     *
     * @see       filterByCategory()
     *
     * @param     mixed $categoryid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function filterByCategoryid($categoryid = null, $comparison = null)
    {
        if (is_array($categoryid)) {
            $useMinMax = false;
            if (isset($categoryid['min'])) {
                $this->addUsingAlias(DocumentPeer::CATEGORYID, $categoryid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($categoryid['max'])) {
                $this->addUsingAlias(DocumentPeer::CATEGORYID, $categoryid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DocumentPeer::CATEGORYID, $categoryid, $comparison);
    }

    /**
     * Filter the query on the description column
     *
     * Example usage:
     * <code>
     * $query->filterByDescription('fooValue');   // WHERE description = 'fooValue'
     * $query->filterByDescription('%fooValue%'); // WHERE description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $description The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function filterByDescription($description = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($description)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $description)) {
                $description = str_replace('*', '%', $description);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(DocumentPeer::DESCRIPTION, $description, $comparison);
    }

    /**
     * Filter the query on the document_date column
     *
     * Example usage:
     * <code>
     * $query->filterByDocumentDate('2011-03-14'); // WHERE document_date = '2011-03-14'
     * $query->filterByDocumentDate('now'); // WHERE document_date = '2011-03-14'
     * $query->filterByDocumentDate(array('max' => 'yesterday')); // WHERE document_date > '2011-03-13'
     * </code>
     *
     * @param     mixed $documentDate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function filterByDocumentDate($documentDate = null, $comparison = null)
    {
        if (is_array($documentDate)) {
            $useMinMax = false;
            if (isset($documentDate['min'])) {
                $this->addUsingAlias(DocumentPeer::DOCUMENT_DATE, $documentDate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($documentDate['max'])) {
                $this->addUsingAlias(DocumentPeer::DOCUMENT_DATE, $documentDate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DocumentPeer::DOCUMENT_DATE, $documentDate, $comparison);
    }

    /**
     * Filter the query on the password column
     *
     * Example usage:
     * <code>
     * $query->filterByPassword('fooValue');   // WHERE password = 'fooValue'
     * $query->filterByPassword('%fooValue%'); // WHERE password LIKE '%fooValue%'
     * </code>
     *
     * @param     string $password The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function filterByPassword($password = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($password)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $password)) {
                $password = str_replace('*', '%', $password);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(DocumentPeer::PASSWORD, $password, $comparison);
    }

    /**
     * Filter the query on the author column
     *
     * Example usage:
     * <code>
     * $query->filterByAuthor('fooValue');   // WHERE author = 'fooValue'
     * $query->filterByAuthor('%fooValue%'); // WHERE author LIKE '%fooValue%'
     * </code>
     *
     * @param     string $author The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function filterByAuthor($author = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($author)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $author)) {
                $author = str_replace('*', '%', $author);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(DocumentPeer::AUTHOR, $author, $comparison);
    }

    /**
     * Filter the query on the keyWords column
     *
     * Example usage:
     * <code>
     * $query->filterByKeywords('fooValue');   // WHERE keyWords = 'fooValue'
     * $query->filterByKeywords('%fooValue%'); // WHERE keyWords LIKE '%fooValue%'
     * </code>
     *
     * @param     string $keywords The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function filterByKeywords($keywords = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($keywords)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $keywords)) {
                $keywords = str_replace('*', '%', $keywords);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(DocumentPeer::KEYWORDS, $keywords, $comparison);
    }

    /**
     * Filter the query on the number column
     *
     * Example usage:
     * <code>
     * $query->filterByNumber('fooValue');   // WHERE number = 'fooValue'
     * $query->filterByNumber('%fooValue%'); // WHERE number LIKE '%fooValue%'
     * </code>
     *
     * @param     string $number The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function filterByNumber($number = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($number)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $number)) {
                $number = str_replace('*', '%', $number);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(DocumentPeer::NUMBER, $number, $comparison);
    }

    /**
     * Filter the query on the size column
     *
     * Example usage:
     * <code>
     * $query->filterBySize(1234); // WHERE size = 1234
     * $query->filterBySize(array(12, 34)); // WHERE size IN (12, 34)
     * $query->filterBySize(array('min' => 12)); // WHERE size > 12
     * </code>
     *
     * @param     mixed $size The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function filterBySize($size = null, $comparison = null)
    {
        if (is_array($size)) {
            $useMinMax = false;
            if (isset($size['min'])) {
                $this->addUsingAlias(DocumentPeer::SIZE, $size['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($size['max'])) {
                $this->addUsingAlias(DocumentPeer::SIZE, $size['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DocumentPeer::SIZE, $size, $comparison);
    }

    /**
     * Filter the query on the fullTextContent column
     *
     * Example usage:
     * <code>
     * $query->filterByFulltextcontent('fooValue');   // WHERE fullTextContent = 'fooValue'
     * $query->filterByFulltextcontent('%fooValue%'); // WHERE fullTextContent LIKE '%fooValue%'
     * </code>
     *
     * @param     string $fulltextcontent The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function filterByFulltextcontent($fulltextcontent = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($fulltextcontent)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $fulltextcontent)) {
                $fulltextcontent = str_replace('*', '%', $fulltextcontent);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(DocumentPeer::FULLTEXTCONTENT, $fulltextcontent, $comparison);
    }

    /**
     * Filter the query by a related Category object
     *
     * @param   Category|PropelObjectCollection $category The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   DocumentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByCategory($category, $comparison = null)
    {
        if ($category instanceof Category) {
            return $this
                ->addUsingAlias(DocumentPeer::CATEGORYID, $category->getId(), $comparison);
        } elseif ($category instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(DocumentPeer::CATEGORYID, $category->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByCategory() only accepts arguments of type Category or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Category relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function joinCategory($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Category');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Category');
        }

        return $this;
    }

    /**
     * Use the Category relation Category object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   CategoryQuery A secondary query class using the current class as primary query
     */
    public function useCategoryQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinCategory($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Category', 'CategoryQuery');
    }

    /**
     * Filter the query by a related CampaignDocument object
     *
     * @param   CampaignDocument|PropelObjectCollection $campaignDocument  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   DocumentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByCampaignDocument($campaignDocument, $comparison = null)
    {
        if ($campaignDocument instanceof CampaignDocument) {
            return $this
                ->addUsingAlias(DocumentPeer::ID, $campaignDocument->getDocumentid(), $comparison);
        } elseif ($campaignDocument instanceof PropelObjectCollection) {
            return $this
                ->useCampaignDocumentQuery()
                ->filterByPrimaryKeys($campaignDocument->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByCampaignDocument() only accepts arguments of type CampaignDocument or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the CampaignDocument relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function joinCampaignDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('CampaignDocument');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'CampaignDocument');
        }

        return $this;
    }

    /**
     * Use the CampaignDocument relation CampaignDocument object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   CampaignDocumentQuery A secondary query class using the current class as primary query
     */
    public function useCampaignDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCampaignDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'CampaignDocument', 'CampaignDocumentQuery');
    }

    /**
     * Filter the query by a related HeadlineDocument object
     *
     * @param   HeadlineDocument|PropelObjectCollection $headlineDocument  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   DocumentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByHeadlineDocument($headlineDocument, $comparison = null)
    {
        if ($headlineDocument instanceof HeadlineDocument) {
            return $this
                ->addUsingAlias(DocumentPeer::ID, $headlineDocument->getDocumentid(), $comparison);
        } elseif ($headlineDocument instanceof PropelObjectCollection) {
            return $this
                ->useHeadlineDocumentQuery()
                ->filterByPrimaryKeys($headlineDocument->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByHeadlineDocument() only accepts arguments of type HeadlineDocument or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the HeadlineDocument relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function joinHeadlineDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('HeadlineDocument');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'HeadlineDocument');
        }

        return $this;
    }

    /**
     * Use the HeadlineDocument relation HeadlineDocument object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   HeadlineDocumentQuery A secondary query class using the current class as primary query
     */
    public function useHeadlineDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinHeadlineDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'HeadlineDocument', 'HeadlineDocumentQuery');
    }

    /**
     * Filter the query by a related GuaranteeDocument object
     *
     * @param   GuaranteeDocument|PropelObjectCollection $guaranteeDocument  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   DocumentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByGuaranteeDocument($guaranteeDocument, $comparison = null)
    {
        if ($guaranteeDocument instanceof GuaranteeDocument) {
            return $this
                ->addUsingAlias(DocumentPeer::ID, $guaranteeDocument->getDocumentid(), $comparison);
        } elseif ($guaranteeDocument instanceof PropelObjectCollection) {
            return $this
                ->useGuaranteeDocumentQuery()
                ->filterByPrimaryKeys($guaranteeDocument->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByGuaranteeDocument() only accepts arguments of type GuaranteeDocument or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the GuaranteeDocument relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function joinGuaranteeDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('GuaranteeDocument');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'GuaranteeDocument');
        }

        return $this;
    }

    /**
     * Use the GuaranteeDocument relation GuaranteeDocument object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   GuaranteeDocumentQuery A secondary query class using the current class as primary query
     */
    public function useGuaranteeDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinGuaranteeDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'GuaranteeDocument', 'GuaranteeDocumentQuery');
    }

    /**
     * Filter the query by a related AdministrativeActDocument object
     *
     * @param   AdministrativeActDocument|PropelObjectCollection $administrativeActDocument  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   DocumentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByAdministrativeActDocument($administrativeActDocument, $comparison = null)
    {
        if ($administrativeActDocument instanceof AdministrativeActDocument) {
            return $this
                ->addUsingAlias(DocumentPeer::ID, $administrativeActDocument->getDocumentid(), $comparison);
        } elseif ($administrativeActDocument instanceof PropelObjectCollection) {
            return $this
                ->useAdministrativeActDocumentQuery()
                ->filterByPrimaryKeys($administrativeActDocument->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByAdministrativeActDocument() only accepts arguments of type AdministrativeActDocument or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the AdministrativeActDocument relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function joinAdministrativeActDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('AdministrativeActDocument');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'AdministrativeActDocument');
        }

        return $this;
    }

    /**
     * Use the AdministrativeActDocument relation AdministrativeActDocument object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   AdministrativeActDocumentQuery A secondary query class using the current class as primary query
     */
    public function useAdministrativeActDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinAdministrativeActDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'AdministrativeActDocument', 'AdministrativeActDocumentQuery');
    }

    /**
     * Filter the query by a related MissionDocument object
     *
     * @param   MissionDocument|PropelObjectCollection $missionDocument  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   DocumentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMissionDocument($missionDocument, $comparison = null)
    {
        if ($missionDocument instanceof MissionDocument) {
            return $this
                ->addUsingAlias(DocumentPeer::ID, $missionDocument->getDocumentid(), $comparison);
        } elseif ($missionDocument instanceof PropelObjectCollection) {
            return $this
                ->useMissionDocumentQuery()
                ->filterByPrimaryKeys($missionDocument->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByMissionDocument() only accepts arguments of type MissionDocument or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MissionDocument relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function joinMissionDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MissionDocument');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MissionDocument');
        }

        return $this;
    }

    /**
     * Use the MissionDocument relation MissionDocument object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MissionDocumentQuery A secondary query class using the current class as primary query
     */
    public function useMissionDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinMissionDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MissionDocument', 'MissionDocumentQuery');
    }

    /**
     * Filter the query by a related ReportSectionDocument object
     *
     * @param   ReportSectionDocument|PropelObjectCollection $reportSectionDocument  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   DocumentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByReportSectionDocument($reportSectionDocument, $comparison = null)
    {
        if ($reportSectionDocument instanceof ReportSectionDocument) {
            return $this
                ->addUsingAlias(DocumentPeer::ID, $reportSectionDocument->getDocumentid(), $comparison);
        } elseif ($reportSectionDocument instanceof PropelObjectCollection) {
            return $this
                ->useReportSectionDocumentQuery()
                ->filterByPrimaryKeys($reportSectionDocument->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByReportSectionDocument() only accepts arguments of type ReportSectionDocument or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ReportSectionDocument relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function joinReportSectionDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ReportSectionDocument');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ReportSectionDocument');
        }

        return $this;
    }

    /**
     * Use the ReportSectionDocument relation ReportSectionDocument object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ReportSectionDocumentQuery A secondary query class using the current class as primary query
     */
    public function useReportSectionDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinReportSectionDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ReportSectionDocument', 'ReportSectionDocumentQuery');
    }

    /**
     * Filter the query by a related PositionDocument object
     *
     * @param   PositionDocument|PropelObjectCollection $positionDocument  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   DocumentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPositionDocument($positionDocument, $comparison = null)
    {
        if ($positionDocument instanceof PositionDocument) {
            return $this
                ->addUsingAlias(DocumentPeer::ID, $positionDocument->getDocumentid(), $comparison);
        } elseif ($positionDocument instanceof PropelObjectCollection) {
            return $this
                ->usePositionDocumentQuery()
                ->filterByPrimaryKeys($positionDocument->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByPositionDocument() only accepts arguments of type PositionDocument or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PositionDocument relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function joinPositionDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PositionDocument');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PositionDocument');
        }

        return $this;
    }

    /**
     * Use the PositionDocument relation PositionDocument object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PositionDocumentQuery A secondary query class using the current class as primary query
     */
    public function usePositionDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPositionDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PositionDocument', 'PositionDocumentQuery');
    }

    /**
     * Filter the query by a related ProjectDocument object
     *
     * @param   ProjectDocument|PropelObjectCollection $projectDocument  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   DocumentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectDocument($projectDocument, $comparison = null)
    {
        if ($projectDocument instanceof ProjectDocument) {
            return $this
                ->addUsingAlias(DocumentPeer::ID, $projectDocument->getDocumentId(), $comparison);
        } elseif ($projectDocument instanceof PropelObjectCollection) {
            return $this
                ->useProjectDocumentQuery()
                ->filterByPrimaryKeys($projectDocument->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProjectDocument() only accepts arguments of type ProjectDocument or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectDocument relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function joinProjectDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectDocument');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectDocument');
        }

        return $this;
    }

    /**
     * Use the ProjectDocument relation ProjectDocument object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectDocumentQuery A secondary query class using the current class as primary query
     */
    public function useProjectDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProjectDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectDocument', 'ProjectDocumentQuery');
    }

    /**
     * Filter the query by a related ActivityDocument object
     *
     * @param   ActivityDocument|PropelObjectCollection $activityDocument  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   DocumentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByActivityDocument($activityDocument, $comparison = null)
    {
        if ($activityDocument instanceof ActivityDocument) {
            return $this
                ->addUsingAlias(DocumentPeer::ID, $activityDocument->getDocumentId(), $comparison);
        } elseif ($activityDocument instanceof PropelObjectCollection) {
            return $this
                ->useActivityDocumentQuery()
                ->filterByPrimaryKeys($activityDocument->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByActivityDocument() only accepts arguments of type ActivityDocument or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ActivityDocument relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function joinActivityDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ActivityDocument');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ActivityDocument');
        }

        return $this;
    }

    /**
     * Use the ActivityDocument relation ActivityDocument object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ActivityDocumentQuery A secondary query class using the current class as primary query
     */
    public function useActivityDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinActivityDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ActivityDocument', 'ActivityDocumentQuery');
    }

    /**
     * Filter the query by a related Campaign object
     * using the campaigns_campaignDocument table as cross reference
     *
     * @param   Campaign $campaign the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   DocumentQuery The current query, for fluid interface
     */
    public function filterByCampaign($campaign, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useCampaignDocumentQuery()
            ->filterByCampaign($campaign, $comparison)
            ->endUse();
    }

    /**
     * Filter the query by a related Headline object
     * using the headlines_headlineDocument table as cross reference
     *
     * @param   Headline $headline the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   DocumentQuery The current query, for fluid interface
     */
    public function filterByHeadline($headline, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useHeadlineDocumentQuery()
            ->filterByHeadline($headline, $comparison)
            ->endUse();
    }

    /**
     * Filter the query by a related Guarantee object
     * using the panel_guaranteeDocument table as cross reference
     *
     * @param   Guarantee $guarantee the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   DocumentQuery The current query, for fluid interface
     */
    public function filterByGuarantee($guarantee, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useGuaranteeDocumentQuery()
            ->filterByGuarantee($guarantee, $comparison)
            ->endUse();
    }

    /**
     * Filter the query by a related AdministrativeAct object
     * using the panel_administrativeActDocument table as cross reference
     *
     * @param   AdministrativeAct $administrativeAct the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   DocumentQuery The current query, for fluid interface
     */
    public function filterByAdministrativeAct($administrativeAct, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useAdministrativeActDocumentQuery()
            ->filterByAdministrativeAct($administrativeAct, $comparison)
            ->endUse();
    }

    /**
     * Filter the query by a related Mission object
     * using the panel_missionDocument table as cross reference
     *
     * @param   Mission $mission the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   DocumentQuery The current query, for fluid interface
     */
    public function filterByMission($mission, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useMissionDocumentQuery()
            ->filterByMission($mission, $comparison)
            ->endUse();
    }

    /**
     * Filter the query by a related ReportSection object
     * using the panel_reportDocument table as cross reference
     *
     * @param   ReportSection $reportSection the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   DocumentQuery The current query, for fluid interface
     */
    public function filterByReportSection($reportSection, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useReportSectionDocumentQuery()
            ->filterByReportSection($reportSection, $comparison)
            ->endUse();
    }

    /**
     * Filter the query by a related Position object
     * using the positions_document table as cross reference
     *
     * @param   Position $position the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   DocumentQuery The current query, for fluid interface
     */
    public function filterByPosition($position, $comparison = Criteria::EQUAL)
    {
        return $this
            ->usePositionDocumentQuery()
            ->filterByPosition($position, $comparison)
            ->endUse();
    }

    /**
     * Filter the query by a related Project object
     * using the projects_document table as cross reference
     *
     * @param   Project $project the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   DocumentQuery The current query, for fluid interface
     */
    public function filterByProject($project, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useProjectDocumentQuery()
            ->filterByProject($project, $comparison)
            ->endUse();
    }

    /**
     * Filter the query by a related ProjectActivity object
     * using the projects_activityDocument table as cross reference
     *
     * @param   ProjectActivity $projectActivity the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   DocumentQuery The current query, for fluid interface
     */
    public function filterByProjectActivity($projectActivity, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useActivityDocumentQuery()
            ->filterByProjectActivity($projectActivity, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   Document $document Object to remove from the list of results
     *
     * @return DocumentQuery The current query, for fluid interface
     */
    public function prune($document = null)
    {
        if ($document) {
            $this->addUsingAlias(DocumentPeer::ID, $document->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
