<?php



/**
 * This class defines the structure of the 'documents_document' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    propel.generator.documents.classes.map
 */
class DocumentTableMap extends TableMap
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'documents.classes.map.DocumentTableMap';

    /**
     * Initialize the table attributes, columns and validators
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('documents_document');
        $this->setPhpName('Document');
        $this->setClassname('Document');
        $this->setPackage('documents.classes');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('TITLE', 'Title', 'VARCHAR', false, 255, null);
        $this->addColumn('REALFILENAME', 'Realfilename', 'VARCHAR', false, 255, null);
        $this->addColumn('DATE', 'Date', 'DATE', false, null, null);
        $this->addForeignKey('CATEGORYID', 'Categoryid', 'INTEGER', 'categories_category', 'ID', false, null, null);
        $this->addColumn('DESCRIPTION', 'Description', 'VARCHAR', false, 255, null);
        $this->addColumn('DOCUMENT_DATE', 'DocumentDate', 'DATE', false, null, null);
        $this->addColumn('PASSWORD', 'Password', 'VARCHAR', false, 32, null);
        $this->addColumn('AUTHOR', 'Author', 'VARCHAR', false, 255, null);
        $this->addColumn('KEYWORDS', 'Keywords', 'VARCHAR', false, 255, null);
        $this->addColumn('NUMBER', 'Number', 'VARCHAR', false, 10, null);
        $this->addColumn('SIZE', 'Size', 'INTEGER', false, null, null);
        $this->addColumn('FULLTEXTCONTENT', 'Fulltextcontent', 'LONGVARCHAR', false, null, null);
        // validators
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Category', 'Category', RelationMap::MANY_TO_ONE, array('categoryId' => 'id', ), 'CASCADE', null);
        $this->addRelation('CampaignDocument', 'CampaignDocument', RelationMap::ONE_TO_MANY, array('id' => 'documentId', ), 'CASCADE', null, 'CampaignDocuments');
        $this->addRelation('HeadlineDocument', 'HeadlineDocument', RelationMap::ONE_TO_MANY, array('id' => 'documentId', ), 'CASCADE', null, 'HeadlineDocuments');
        $this->addRelation('GuaranteeDocument', 'GuaranteeDocument', RelationMap::ONE_TO_MANY, array('id' => 'documentId', ), 'CASCADE', null, 'GuaranteeDocuments');
        $this->addRelation('AdministrativeActDocument', 'AdministrativeActDocument', RelationMap::ONE_TO_MANY, array('id' => 'documentId', ), 'CASCADE', null, 'AdministrativeActDocuments');
        $this->addRelation('MissionDocument', 'MissionDocument', RelationMap::ONE_TO_MANY, array('id' => 'documentId', ), 'CASCADE', null, 'MissionDocuments');
        $this->addRelation('ReportSectionDocument', 'ReportSectionDocument', RelationMap::ONE_TO_MANY, array('id' => 'documentId', ), 'CASCADE', null, 'ReportSectionDocuments');
        $this->addRelation('PositionDocument', 'PositionDocument', RelationMap::ONE_TO_MANY, array('id' => 'documentId', ), 'CASCADE', null, 'PositionDocuments');
        $this->addRelation('ProjectDocument', 'ProjectDocument', RelationMap::ONE_TO_MANY, array('id' => 'document_id', ), 'CASCADE', null, 'ProjectDocuments');
        $this->addRelation('ActivityDocument', 'ActivityDocument', RelationMap::ONE_TO_MANY, array('id' => 'document_id', ), 'CASCADE', null, 'ActivityDocuments');
        $this->addRelation('Campaign', 'Campaign', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Campaigns');
        $this->addRelation('Headline', 'Headline', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Headlines');
        $this->addRelation('Guarantee', 'Guarantee', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Guarantees');
        $this->addRelation('AdministrativeAct', 'AdministrativeAct', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'AdministrativeActs');
        $this->addRelation('Mission', 'Mission', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Missions');
        $this->addRelation('ReportSection', 'ReportSection', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'ReportSections');
        $this->addRelation('Position', 'Position', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Positions');
        $this->addRelation('Project', 'Project', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Projects');
        $this->addRelation('ProjectActivity', 'ProjectActivity', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'ProjectActivitys');
    } // buildRelations()

} // DocumentTableMap
