<?php

class CommonDoEditPlanningYearsAction extends BaseAction {
	
	private $_errors;
	
	public function execute($mapping, $form, &$request, &$response) {
		
		parent::execute($mapping, $form, $request, $response);
		
		$plugInKey = 'SMARTY_PLUGIN';
		$smarty =& $this->actionServer->getPlugIn($plugInKey);
		if($smarty == NULL) {
			echo 'No PlugIn found matching key: '.$plugInKey."<br>\n";
		}
		
		if (isset($_POST['startingYear']))
			$this->setYear($_POST['startingYear'], 'startingYear');
		
		if (isset($_POST['endingYear']))
			$this->setYear($_POST['endingYear'], 'endingYear');
		
		$smarty->assign('errors', $this->_errors);
		
		$this->template->template = 'TemplatePlain.tpl';
		header('Content-Type: text/json; charset=UTF-8');
		return $mapping->findForwardConfig('success');
	}
	
	private function setYear($year, $type) {
		
		if ($parsedYear = intval($year))
			$_SESSION['planning'][$type] = $parsedYear;
		else
			$this->_errors[] = array('invalidYear', 'specified year is not valid');
	}
}
