<?php


/**
 * Base class that represents a row from the 'campaigns_campaign' table.
 *
 * Base de Campaigns
 *
 * @package    propel.generator.campaigns.classes.om
 */
abstract class BaseCampaign extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'CampaignPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        CampaignPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the type field.
     * @var        int
     */
    protected $type;

    /**
     * The value for the startdate field.
     * @var        string
     */
    protected $startdate;

    /**
     * The value for the finishdate field.
     * @var        string
     */
    protected $finishdate;

    /**
     * The value for the clientid field.
     * @var        int
     */
    protected $clientid;

    /**
     * The value for the description field.
     * @var        string
     */
    protected $description;

    /**
     * The value for the langcode field.
     * @var        string
     */
    protected $langcode;

    /**
     * The value for the defaultkeywords field.
     * @var        string
     */
    protected $defaultkeywords;

    /**
     * The value for the responsible field.
     * @var        string
     */
    protected $responsible;

    /**
     * The value for the sources field.
     * Note: this column has a database default value of: 1
     * @var        int
     */
    protected $sources;

    /**
     * The value for the searchqueries field.
     * @var        array
     */
    protected $searchqueries;

    /**
     * The unserialized $searchqueries value - i.e. the persisted object.
     * This is necessary to avoid repeated calls to unserialize() at runtime.
     * @var        object
     */
    protected $searchqueries_unserialized;

    /**
     * The value for the deleted_at field.
     * @var        string
     */
    protected $deleted_at;

    /**
     * @var        PropelObjectCollection|CampaignParticipant[] Collection to store aggregation of CampaignParticipant objects.
     */
    protected $collCampaignParticipants;
    protected $collCampaignParticipantsPartial;

    /**
     * @var        PropelObjectCollection|CampaignCommitment[] Collection to store aggregation of CampaignCommitment objects.
     */
    protected $collCampaignCommitments;
    protected $collCampaignCommitmentsPartial;

    /**
     * @var        PropelObjectCollection|CampaignDocument[] Collection to store aggregation of CampaignDocument objects.
     */
    protected $collCampaignDocuments;
    protected $collCampaignDocumentsPartial;

    /**
     * @var        PropelObjectCollection|Document[] Collection to store aggregation of Document objects.
     */
    protected $collDocuments;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $documentsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $campaignParticipantsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $campaignCommitmentsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $campaignDocumentsScheduledForDeletion = null;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see        __construct()
     */
    public function applyDefaultValues()
    {
        $this->sources = 1;
    }

    /**
     * Initializes internal state of BaseCampaign object.
     * @see        applyDefaults()
     */
    public function __construct()
    {
        parent::__construct();
        $this->applyDefaultValues();
    }

    /**
     * Get the [id] column value.
     * Identificacion de la Campaign
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     * Nombre de la Campaign
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [type] column value.
     * Tipo de Campaign
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Get the [optionally formatted] temporal [startdate] column value.
     * Fecha inicio de la campaign
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getStartdate($format = '%Y/%m/%d')
    {
        if ($this->startdate === null) {
            return null;
        }

        if ($this->startdate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->startdate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->startdate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [finishdate] column value.
     * Fecha final de la campaign
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getFinishdate($format = '%Y/%m/%d')
    {
        if ($this->finishdate === null) {
            return null;
        }

        if ($this->finishdate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->finishdate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->finishdate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [clientid] column value.
     * Cliente asociado
     * @return int
     */
    public function getClientid()
    {
        return $this->clientid;
    }

    /**
     * Get the [description] column value.
     * Descripcion de la Campaign
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Get the [langcode] column value.
     * Idioma de la campaign
     * @return string
     */
    public function getLangcode()
    {
        return $this->langcode;
    }

    /**
     * Get the [defaultkeywords] column value.
     * Palabras clave por defecto para prensa
     * @return string
     */
    public function getDefaultkeywords()
    {
        return $this->defaultkeywords;
    }

    /**
     * Get the [responsible] column value.
     * Persona Responsable de la campaign
     * @return string
     */
    public function getResponsible()
    {
        return $this->responsible;
    }

    /**
     * Get the [sources] column value.
     * Indica las fuentes de informacion
     * @return int
     */
    public function getSources()
    {
        return $this->sources;
    }

    /**
     * Get the [searchqueries] column value.
     * Busquedas
     * @return array
     */
    public function getSearchqueries()
    {
        if (null === $this->searchqueries_unserialized) {
            $this->searchqueries_unserialized = array();
        }
        if (!$this->searchqueries_unserialized && null !== $this->searchqueries) {
            $searchqueries_unserialized = substr($this->searchqueries, 2, -2);
            $this->searchqueries_unserialized = $searchqueries_unserialized ? explode(' | ', $searchqueries_unserialized) : array();
        }

        return $this->searchqueries_unserialized;
    }

    /**
     * Test the presence of a value in the [searchqueries] array column value.
     * @param mixed $value
     * Busquedas
     * @return boolean
     */
    public function hasSearchquerie($value)
    {
        return in_array($value, $this->getSearchqueries());
    } // hasSearchquerie()

    /**
     * Get the [optionally formatted] temporal [deleted_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDeletedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->deleted_at === null) {
            return null;
        }

        if ($this->deleted_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->deleted_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->deleted_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Set the value of [id] column.
     * Identificacion de la Campaign
     * @param int $v new value
     * @return Campaign The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = CampaignPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [name] column.
     * Nombre de la Campaign
     * @param string $v new value
     * @return Campaign The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = CampaignPeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [type] column.
     * Tipo de Campaign
     * @param int $v new value
     * @return Campaign The current object (for fluent API support)
     */
    public function setType($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->type !== $v) {
            $this->type = $v;
            $this->modifiedColumns[] = CampaignPeer::TYPE;
        }


        return $this;
    } // setType()

    /**
     * Sets the value of [startdate] column to a normalized version of the date/time value specified.
     * Fecha inicio de la campaign
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Campaign The current object (for fluent API support)
     */
    public function setStartdate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->startdate !== null || $dt !== null) {
            $currentDateAsString = ($this->startdate !== null && $tmpDt = new DateTime($this->startdate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->startdate = $newDateAsString;
                $this->modifiedColumns[] = CampaignPeer::STARTDATE;
            }
        } // if either are not null


        return $this;
    } // setStartdate()

    /**
     * Sets the value of [finishdate] column to a normalized version of the date/time value specified.
     * Fecha final de la campaign
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Campaign The current object (for fluent API support)
     */
    public function setFinishdate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->finishdate !== null || $dt !== null) {
            $currentDateAsString = ($this->finishdate !== null && $tmpDt = new DateTime($this->finishdate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->finishdate = $newDateAsString;
                $this->modifiedColumns[] = CampaignPeer::FINISHDATE;
            }
        } // if either are not null


        return $this;
    } // setFinishdate()

    /**
     * Set the value of [clientid] column.
     * Cliente asociado
     * @param int $v new value
     * @return Campaign The current object (for fluent API support)
     */
    public function setClientid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->clientid !== $v) {
            $this->clientid = $v;
            $this->modifiedColumns[] = CampaignPeer::CLIENTID;
        }


        return $this;
    } // setClientid()

    /**
     * Set the value of [description] column.
     * Descripcion de la Campaign
     * @param string $v new value
     * @return Campaign The current object (for fluent API support)
     */
    public function setDescription($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->description !== $v) {
            $this->description = $v;
            $this->modifiedColumns[] = CampaignPeer::DESCRIPTION;
        }


        return $this;
    } // setDescription()

    /**
     * Set the value of [langcode] column.
     * Idioma de la campaign
     * @param string $v new value
     * @return Campaign The current object (for fluent API support)
     */
    public function setLangcode($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->langcode !== $v) {
            $this->langcode = $v;
            $this->modifiedColumns[] = CampaignPeer::LANGCODE;
        }


        return $this;
    } // setLangcode()

    /**
     * Set the value of [defaultkeywords] column.
     * Palabras clave por defecto para prensa
     * @param string $v new value
     * @return Campaign The current object (for fluent API support)
     */
    public function setDefaultkeywords($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->defaultkeywords !== $v) {
            $this->defaultkeywords = $v;
            $this->modifiedColumns[] = CampaignPeer::DEFAULTKEYWORDS;
        }


        return $this;
    } // setDefaultkeywords()

    /**
     * Set the value of [responsible] column.
     * Persona Responsable de la campaign
     * @param string $v new value
     * @return Campaign The current object (for fluent API support)
     */
    public function setResponsible($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->responsible !== $v) {
            $this->responsible = $v;
            $this->modifiedColumns[] = CampaignPeer::RESPONSIBLE;
        }


        return $this;
    } // setResponsible()

    /**
     * Set the value of [sources] column.
     * Indica las fuentes de informacion
     * @param int $v new value
     * @return Campaign The current object (for fluent API support)
     */
    public function setSources($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->sources !== $v) {
            $this->sources = $v;
            $this->modifiedColumns[] = CampaignPeer::SOURCES;
        }


        return $this;
    } // setSources()

    /**
     * Set the value of [searchqueries] column.
     * Busquedas
     * @param array $v new value
     * @return Campaign The current object (for fluent API support)
     */
    public function setSearchqueries($v)
    {
        if ($this->searchqueries_unserialized !== $v) {
            $this->searchqueries_unserialized = $v;
            $this->searchqueries = '| ' . implode(' | ', $v) . ' |';
            $this->modifiedColumns[] = CampaignPeer::SEARCHQUERIES;
        }


        return $this;
    } // setSearchqueries()

    /**
     * Adds a value to the [searchqueries] array column value.
     * @param mixed $value
     * Busquedas
     * @return Campaign The current object (for fluent API support)
     */
    public function addSearchquerie($value)
    {
        $currentArray = $this->getSearchqueries();
        $currentArray []= $value;
        $this->setSearchqueries($currentArray);

        return $this;
    } // addSearchquerie()

    /**
     * Removes a value from the [searchqueries] array column value.
     * @param mixed $value
     * Busquedas
     * @return Campaign The current object (for fluent API support)
     */
    public function removeSearchquerie($value)
    {
        $targetArray = array();
        foreach ($this->getSearchqueries() as $element) {
            if ($element != $value) {
                $targetArray []= $element;
            }
        }
        $this->setSearchqueries($targetArray);

        return $this;
    } // removeSearchquerie()

    /**
     * Sets the value of [deleted_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Campaign The current object (for fluent API support)
     */
    public function setDeletedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->deleted_at !== null || $dt !== null) {
            $currentDateAsString = ($this->deleted_at !== null && $tmpDt = new DateTime($this->deleted_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->deleted_at = $newDateAsString;
                $this->modifiedColumns[] = CampaignPeer::DELETED_AT;
            }
        } // if either are not null


        return $this;
    } // setDeletedAt()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
            if ($this->sources !== 1) {
                return false;
            }

        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->type = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
            $this->startdate = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->finishdate = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->clientid = ($row[$startcol + 5] !== null) ? (int) $row[$startcol + 5] : null;
            $this->description = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->langcode = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
            $this->defaultkeywords = ($row[$startcol + 8] !== null) ? (string) $row[$startcol + 8] : null;
            $this->responsible = ($row[$startcol + 9] !== null) ? (string) $row[$startcol + 9] : null;
            $this->sources = ($row[$startcol + 10] !== null) ? (int) $row[$startcol + 10] : null;
            $this->searchqueries = $row[$startcol + 11];
            $this->searchqueries_unserialized = null;
            $this->deleted_at = ($row[$startcol + 12] !== null) ? (string) $row[$startcol + 12] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 13; // 13 = CampaignPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating Campaign object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(CampaignPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = CampaignPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->collCampaignParticipants = null;

            $this->collCampaignCommitments = null;

            $this->collCampaignDocuments = null;

            $this->collDocuments = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(CampaignPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = CampaignQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            // soft_delete behavior
            if (!empty($ret) && CampaignQuery::isSoftDeleteEnabled()) {
                $this->setDeletedAt(time());
                $this->save($con);
                $this->postDelete($con);
                $con->commit();
                CampaignPeer::removeInstanceFromPool($this);

                return;
            }

            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(CampaignPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                CampaignPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->documentsScheduledForDeletion !== null) {
                if (!$this->documentsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->documentsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    CampaignDocumentQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->documentsScheduledForDeletion = null;
                }

                foreach ($this->getDocuments() as $document) {
                    if ($document->isModified()) {
                        $document->save($con);
                    }
                }
            }

            if ($this->campaignParticipantsScheduledForDeletion !== null) {
                if (!$this->campaignParticipantsScheduledForDeletion->isEmpty()) {
                    CampaignParticipantQuery::create()
                        ->filterByPrimaryKeys($this->campaignParticipantsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->campaignParticipantsScheduledForDeletion = null;
                }
            }

            if ($this->collCampaignParticipants !== null) {
                foreach ($this->collCampaignParticipants as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->campaignCommitmentsScheduledForDeletion !== null) {
                if (!$this->campaignCommitmentsScheduledForDeletion->isEmpty()) {
                    foreach ($this->campaignCommitmentsScheduledForDeletion as $campaignCommitment) {
                        // need to save related object because we set the relation to null
                        $campaignCommitment->save($con);
                    }
                    $this->campaignCommitmentsScheduledForDeletion = null;
                }
            }

            if ($this->collCampaignCommitments !== null) {
                foreach ($this->collCampaignCommitments as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->campaignDocumentsScheduledForDeletion !== null) {
                if (!$this->campaignDocumentsScheduledForDeletion->isEmpty()) {
                    CampaignDocumentQuery::create()
                        ->filterByPrimaryKeys($this->campaignDocumentsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->campaignDocumentsScheduledForDeletion = null;
                }
            }

            if ($this->collCampaignDocuments !== null) {
                foreach ($this->collCampaignDocuments as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = CampaignPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . CampaignPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(CampaignPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(CampaignPeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(CampaignPeer::TYPE)) {
            $modifiedColumns[':p' . $index++]  = '`TYPE`';
        }
        if ($this->isColumnModified(CampaignPeer::STARTDATE)) {
            $modifiedColumns[':p' . $index++]  = '`STARTDATE`';
        }
        if ($this->isColumnModified(CampaignPeer::FINISHDATE)) {
            $modifiedColumns[':p' . $index++]  = '`FINISHDATE`';
        }
        if ($this->isColumnModified(CampaignPeer::CLIENTID)) {
            $modifiedColumns[':p' . $index++]  = '`CLIENTID`';
        }
        if ($this->isColumnModified(CampaignPeer::DESCRIPTION)) {
            $modifiedColumns[':p' . $index++]  = '`DESCRIPTION`';
        }
        if ($this->isColumnModified(CampaignPeer::LANGCODE)) {
            $modifiedColumns[':p' . $index++]  = '`LANGCODE`';
        }
        if ($this->isColumnModified(CampaignPeer::DEFAULTKEYWORDS)) {
            $modifiedColumns[':p' . $index++]  = '`DEFAULTKEYWORDS`';
        }
        if ($this->isColumnModified(CampaignPeer::RESPONSIBLE)) {
            $modifiedColumns[':p' . $index++]  = '`RESPONSIBLE`';
        }
        if ($this->isColumnModified(CampaignPeer::SOURCES)) {
            $modifiedColumns[':p' . $index++]  = '`SOURCES`';
        }
        if ($this->isColumnModified(CampaignPeer::SEARCHQUERIES)) {
            $modifiedColumns[':p' . $index++]  = '`SEARCHQUERIES`';
        }
        if ($this->isColumnModified(CampaignPeer::DELETED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`DELETED_AT`';
        }

        $sql = sprintf(
            'INSERT INTO `campaigns_campaign` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`TYPE`':
                        $stmt->bindValue($identifier, $this->type, PDO::PARAM_INT);
                        break;
                    case '`STARTDATE`':
                        $stmt->bindValue($identifier, $this->startdate, PDO::PARAM_STR);
                        break;
                    case '`FINISHDATE`':
                        $stmt->bindValue($identifier, $this->finishdate, PDO::PARAM_STR);
                        break;
                    case '`CLIENTID`':
                        $stmt->bindValue($identifier, $this->clientid, PDO::PARAM_INT);
                        break;
                    case '`DESCRIPTION`':
                        $stmt->bindValue($identifier, $this->description, PDO::PARAM_STR);
                        break;
                    case '`LANGCODE`':
                        $stmt->bindValue($identifier, $this->langcode, PDO::PARAM_STR);
                        break;
                    case '`DEFAULTKEYWORDS`':
                        $stmt->bindValue($identifier, $this->defaultkeywords, PDO::PARAM_STR);
                        break;
                    case '`RESPONSIBLE`':
                        $stmt->bindValue($identifier, $this->responsible, PDO::PARAM_STR);
                        break;
                    case '`SOURCES`':
                        $stmt->bindValue($identifier, $this->sources, PDO::PARAM_INT);
                        break;
                    case '`SEARCHQUERIES`':
                        $stmt->bindValue($identifier, $this->searchqueries, PDO::PARAM_STR);
                        break;
                    case '`DELETED_AT`':
                        $stmt->bindValue($identifier, $this->deleted_at, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            if (($retval = CampaignPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collCampaignParticipants !== null) {
                    foreach ($this->collCampaignParticipants as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collCampaignCommitments !== null) {
                    foreach ($this->collCampaignCommitments as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collCampaignDocuments !== null) {
                    foreach ($this->collCampaignDocuments as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = CampaignPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getName();
                break;
            case 2:
                return $this->getType();
                break;
            case 3:
                return $this->getStartdate();
                break;
            case 4:
                return $this->getFinishdate();
                break;
            case 5:
                return $this->getClientid();
                break;
            case 6:
                return $this->getDescription();
                break;
            case 7:
                return $this->getLangcode();
                break;
            case 8:
                return $this->getDefaultkeywords();
                break;
            case 9:
                return $this->getResponsible();
                break;
            case 10:
                return $this->getSources();
                break;
            case 11:
                return $this->getSearchqueries();
                break;
            case 12:
                return $this->getDeletedAt();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['Campaign'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Campaign'][$this->getPrimaryKey()] = true;
        $keys = CampaignPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
            $keys[2] => $this->getType(),
            $keys[3] => $this->getStartdate(),
            $keys[4] => $this->getFinishdate(),
            $keys[5] => $this->getClientid(),
            $keys[6] => $this->getDescription(),
            $keys[7] => $this->getLangcode(),
            $keys[8] => $this->getDefaultkeywords(),
            $keys[9] => $this->getResponsible(),
            $keys[10] => $this->getSources(),
            $keys[11] => $this->getSearchqueries(),
            $keys[12] => $this->getDeletedAt(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->collCampaignParticipants) {
                $result['CampaignParticipants'] = $this->collCampaignParticipants->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collCampaignCommitments) {
                $result['CampaignCommitments'] = $this->collCampaignCommitments->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collCampaignDocuments) {
                $result['CampaignDocuments'] = $this->collCampaignDocuments->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = CampaignPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
            case 2:
                $this->setType($value);
                break;
            case 3:
                $this->setStartdate($value);
                break;
            case 4:
                $this->setFinishdate($value);
                break;
            case 5:
                $this->setClientid($value);
                break;
            case 6:
                $this->setDescription($value);
                break;
            case 7:
                $this->setLangcode($value);
                break;
            case 8:
                $this->setDefaultkeywords($value);
                break;
            case 9:
                $this->setResponsible($value);
                break;
            case 10:
                $this->setSources($value);
                break;
            case 11:
                if (!is_array($value)) {
                    $v = trim(substr($value, 2, -2));
                    $value = $v ? explode(' | ', $v) : array();
                }
                $this->setSearchqueries($value);
                break;
            case 12:
                $this->setDeletedAt($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = CampaignPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setName($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setType($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setStartdate($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setFinishdate($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setClientid($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setDescription($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setLangcode($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setDefaultkeywords($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setResponsible($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setSources($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setSearchqueries($arr[$keys[11]]);
        if (array_key_exists($keys[12], $arr)) $this->setDeletedAt($arr[$keys[12]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(CampaignPeer::DATABASE_NAME);

        if ($this->isColumnModified(CampaignPeer::ID)) $criteria->add(CampaignPeer::ID, $this->id);
        if ($this->isColumnModified(CampaignPeer::NAME)) $criteria->add(CampaignPeer::NAME, $this->name);
        if ($this->isColumnModified(CampaignPeer::TYPE)) $criteria->add(CampaignPeer::TYPE, $this->type);
        if ($this->isColumnModified(CampaignPeer::STARTDATE)) $criteria->add(CampaignPeer::STARTDATE, $this->startdate);
        if ($this->isColumnModified(CampaignPeer::FINISHDATE)) $criteria->add(CampaignPeer::FINISHDATE, $this->finishdate);
        if ($this->isColumnModified(CampaignPeer::CLIENTID)) $criteria->add(CampaignPeer::CLIENTID, $this->clientid);
        if ($this->isColumnModified(CampaignPeer::DESCRIPTION)) $criteria->add(CampaignPeer::DESCRIPTION, $this->description);
        if ($this->isColumnModified(CampaignPeer::LANGCODE)) $criteria->add(CampaignPeer::LANGCODE, $this->langcode);
        if ($this->isColumnModified(CampaignPeer::DEFAULTKEYWORDS)) $criteria->add(CampaignPeer::DEFAULTKEYWORDS, $this->defaultkeywords);
        if ($this->isColumnModified(CampaignPeer::RESPONSIBLE)) $criteria->add(CampaignPeer::RESPONSIBLE, $this->responsible);
        if ($this->isColumnModified(CampaignPeer::SOURCES)) $criteria->add(CampaignPeer::SOURCES, $this->sources);
        if ($this->isColumnModified(CampaignPeer::SEARCHQUERIES)) $criteria->add(CampaignPeer::SEARCHQUERIES, $this->searchqueries);
        if ($this->isColumnModified(CampaignPeer::DELETED_AT)) $criteria->add(CampaignPeer::DELETED_AT, $this->deleted_at);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(CampaignPeer::DATABASE_NAME);
        $criteria->add(CampaignPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of Campaign (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setName($this->getName());
        $copyObj->setType($this->getType());
        $copyObj->setStartdate($this->getStartdate());
        $copyObj->setFinishdate($this->getFinishdate());
        $copyObj->setClientid($this->getClientid());
        $copyObj->setDescription($this->getDescription());
        $copyObj->setLangcode($this->getLangcode());
        $copyObj->setDefaultkeywords($this->getDefaultkeywords());
        $copyObj->setResponsible($this->getResponsible());
        $copyObj->setSources($this->getSources());
        $copyObj->setSearchqueries($this->getSearchqueries());
        $copyObj->setDeletedAt($this->getDeletedAt());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getCampaignParticipants() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addCampaignParticipant($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getCampaignCommitments() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addCampaignCommitment($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getCampaignDocuments() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addCampaignDocument($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return Campaign Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return CampaignPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new CampaignPeer();
        }

        return self::$peer;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('CampaignParticipant' == $relationName) {
            $this->initCampaignParticipants();
        }
        if ('CampaignCommitment' == $relationName) {
            $this->initCampaignCommitments();
        }
        if ('CampaignDocument' == $relationName) {
            $this->initCampaignDocuments();
        }
    }

    /**
     * Clears out the collCampaignParticipants collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addCampaignParticipants()
     */
    public function clearCampaignParticipants()
    {
        $this->collCampaignParticipants = null; // important to set this to null since that means it is uninitialized
        $this->collCampaignParticipantsPartial = null;
    }

    /**
     * reset is the collCampaignParticipants collection loaded partially
     *
     * @return void
     */
    public function resetPartialCampaignParticipants($v = true)
    {
        $this->collCampaignParticipantsPartial = $v;
    }

    /**
     * Initializes the collCampaignParticipants collection.
     *
     * By default this just sets the collCampaignParticipants collection to an empty array (like clearcollCampaignParticipants());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initCampaignParticipants($overrideExisting = true)
    {
        if (null !== $this->collCampaignParticipants && !$overrideExisting) {
            return;
        }
        $this->collCampaignParticipants = new PropelObjectCollection();
        $this->collCampaignParticipants->setModel('CampaignParticipant');
    }

    /**
     * Gets an array of CampaignParticipant objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Campaign is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|CampaignParticipant[] List of CampaignParticipant objects
     * @throws PropelException
     */
    public function getCampaignParticipants($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collCampaignParticipantsPartial && !$this->isNew();
        if (null === $this->collCampaignParticipants || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collCampaignParticipants) {
                // return empty collection
                $this->initCampaignParticipants();
            } else {
                $collCampaignParticipants = CampaignParticipantQuery::create(null, $criteria)
                    ->filterByCampaign($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collCampaignParticipantsPartial && count($collCampaignParticipants)) {
                      $this->initCampaignParticipants(false);

                      foreach($collCampaignParticipants as $obj) {
                        if (false == $this->collCampaignParticipants->contains($obj)) {
                          $this->collCampaignParticipants->append($obj);
                        }
                      }

                      $this->collCampaignParticipantsPartial = true;
                    }

                    return $collCampaignParticipants;
                }

                if($partial && $this->collCampaignParticipants) {
                    foreach($this->collCampaignParticipants as $obj) {
                        if($obj->isNew()) {
                            $collCampaignParticipants[] = $obj;
                        }
                    }
                }

                $this->collCampaignParticipants = $collCampaignParticipants;
                $this->collCampaignParticipantsPartial = false;
            }
        }

        return $this->collCampaignParticipants;
    }

    /**
     * Sets a collection of CampaignParticipant objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $campaignParticipants A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setCampaignParticipants(PropelCollection $campaignParticipants, PropelPDO $con = null)
    {
        $this->campaignParticipantsScheduledForDeletion = $this->getCampaignParticipants(new Criteria(), $con)->diff($campaignParticipants);

        foreach ($this->campaignParticipantsScheduledForDeletion as $campaignParticipantRemoved) {
            $campaignParticipantRemoved->setCampaign(null);
        }

        $this->collCampaignParticipants = null;
        foreach ($campaignParticipants as $campaignParticipant) {
            $this->addCampaignParticipant($campaignParticipant);
        }

        $this->collCampaignParticipants = $campaignParticipants;
        $this->collCampaignParticipantsPartial = false;
    }

    /**
     * Returns the number of related CampaignParticipant objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related CampaignParticipant objects.
     * @throws PropelException
     */
    public function countCampaignParticipants(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collCampaignParticipantsPartial && !$this->isNew();
        if (null === $this->collCampaignParticipants || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collCampaignParticipants) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getCampaignParticipants());
                }
                $query = CampaignParticipantQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByCampaign($this)
                    ->count($con);
            }
        } else {
            return count($this->collCampaignParticipants);
        }
    }

    /**
     * Method called to associate a CampaignParticipant object to this object
     * through the CampaignParticipant foreign key attribute.
     *
     * @param    CampaignParticipant $l CampaignParticipant
     * @return Campaign The current object (for fluent API support)
     */
    public function addCampaignParticipant(CampaignParticipant $l)
    {
        if ($this->collCampaignParticipants === null) {
            $this->initCampaignParticipants();
            $this->collCampaignParticipantsPartial = true;
        }
        if (!$this->collCampaignParticipants->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddCampaignParticipant($l);
        }

        return $this;
    }

    /**
     * @param	CampaignParticipant $campaignParticipant The campaignParticipant object to add.
     */
    protected function doAddCampaignParticipant($campaignParticipant)
    {
        $this->collCampaignParticipants[]= $campaignParticipant;
        $campaignParticipant->setCampaign($this);
    }

    /**
     * @param	CampaignParticipant $campaignParticipant The campaignParticipant object to remove.
     */
    public function removeCampaignParticipant($campaignParticipant)
    {
        if ($this->getCampaignParticipants()->contains($campaignParticipant)) {
            $this->collCampaignParticipants->remove($this->collCampaignParticipants->search($campaignParticipant));
            if (null === $this->campaignParticipantsScheduledForDeletion) {
                $this->campaignParticipantsScheduledForDeletion = clone $this->collCampaignParticipants;
                $this->campaignParticipantsScheduledForDeletion->clear();
            }
            $this->campaignParticipantsScheduledForDeletion[]= $campaignParticipant;
            $campaignParticipant->setCampaign(null);
        }
    }

    /**
     * Clears out the collCampaignCommitments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addCampaignCommitments()
     */
    public function clearCampaignCommitments()
    {
        $this->collCampaignCommitments = null; // important to set this to null since that means it is uninitialized
        $this->collCampaignCommitmentsPartial = null;
    }

    /**
     * reset is the collCampaignCommitments collection loaded partially
     *
     * @return void
     */
    public function resetPartialCampaignCommitments($v = true)
    {
        $this->collCampaignCommitmentsPartial = $v;
    }

    /**
     * Initializes the collCampaignCommitments collection.
     *
     * By default this just sets the collCampaignCommitments collection to an empty array (like clearcollCampaignCommitments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initCampaignCommitments($overrideExisting = true)
    {
        if (null !== $this->collCampaignCommitments && !$overrideExisting) {
            return;
        }
        $this->collCampaignCommitments = new PropelObjectCollection();
        $this->collCampaignCommitments->setModel('CampaignCommitment');
    }

    /**
     * Gets an array of CampaignCommitment objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Campaign is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|CampaignCommitment[] List of CampaignCommitment objects
     * @throws PropelException
     */
    public function getCampaignCommitments($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collCampaignCommitmentsPartial && !$this->isNew();
        if (null === $this->collCampaignCommitments || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collCampaignCommitments) {
                // return empty collection
                $this->initCampaignCommitments();
            } else {
                $collCampaignCommitments = CampaignCommitmentQuery::create(null, $criteria)
                    ->filterByCampaign($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collCampaignCommitmentsPartial && count($collCampaignCommitments)) {
                      $this->initCampaignCommitments(false);

                      foreach($collCampaignCommitments as $obj) {
                        if (false == $this->collCampaignCommitments->contains($obj)) {
                          $this->collCampaignCommitments->append($obj);
                        }
                      }

                      $this->collCampaignCommitmentsPartial = true;
                    }

                    return $collCampaignCommitments;
                }

                if($partial && $this->collCampaignCommitments) {
                    foreach($this->collCampaignCommitments as $obj) {
                        if($obj->isNew()) {
                            $collCampaignCommitments[] = $obj;
                        }
                    }
                }

                $this->collCampaignCommitments = $collCampaignCommitments;
                $this->collCampaignCommitmentsPartial = false;
            }
        }

        return $this->collCampaignCommitments;
    }

    /**
     * Sets a collection of CampaignCommitment objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $campaignCommitments A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setCampaignCommitments(PropelCollection $campaignCommitments, PropelPDO $con = null)
    {
        $this->campaignCommitmentsScheduledForDeletion = $this->getCampaignCommitments(new Criteria(), $con)->diff($campaignCommitments);

        foreach ($this->campaignCommitmentsScheduledForDeletion as $campaignCommitmentRemoved) {
            $campaignCommitmentRemoved->setCampaign(null);
        }

        $this->collCampaignCommitments = null;
        foreach ($campaignCommitments as $campaignCommitment) {
            $this->addCampaignCommitment($campaignCommitment);
        }

        $this->collCampaignCommitments = $campaignCommitments;
        $this->collCampaignCommitmentsPartial = false;
    }

    /**
     * Returns the number of related CampaignCommitment objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related CampaignCommitment objects.
     * @throws PropelException
     */
    public function countCampaignCommitments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collCampaignCommitmentsPartial && !$this->isNew();
        if (null === $this->collCampaignCommitments || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collCampaignCommitments) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getCampaignCommitments());
                }
                $query = CampaignCommitmentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByCampaign($this)
                    ->count($con);
            }
        } else {
            return count($this->collCampaignCommitments);
        }
    }

    /**
     * Method called to associate a CampaignCommitment object to this object
     * through the CampaignCommitment foreign key attribute.
     *
     * @param    CampaignCommitment $l CampaignCommitment
     * @return Campaign The current object (for fluent API support)
     */
    public function addCampaignCommitment(CampaignCommitment $l)
    {
        if ($this->collCampaignCommitments === null) {
            $this->initCampaignCommitments();
            $this->collCampaignCommitmentsPartial = true;
        }
        if (!$this->collCampaignCommitments->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddCampaignCommitment($l);
        }

        return $this;
    }

    /**
     * @param	CampaignCommitment $campaignCommitment The campaignCommitment object to add.
     */
    protected function doAddCampaignCommitment($campaignCommitment)
    {
        $this->collCampaignCommitments[]= $campaignCommitment;
        $campaignCommitment->setCampaign($this);
    }

    /**
     * @param	CampaignCommitment $campaignCommitment The campaignCommitment object to remove.
     */
    public function removeCampaignCommitment($campaignCommitment)
    {
        if ($this->getCampaignCommitments()->contains($campaignCommitment)) {
            $this->collCampaignCommitments->remove($this->collCampaignCommitments->search($campaignCommitment));
            if (null === $this->campaignCommitmentsScheduledForDeletion) {
                $this->campaignCommitmentsScheduledForDeletion = clone $this->collCampaignCommitments;
                $this->campaignCommitmentsScheduledForDeletion->clear();
            }
            $this->campaignCommitmentsScheduledForDeletion[]= $campaignCommitment;
            $campaignCommitment->setCampaign(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Campaign is new, it will return
     * an empty collection; or if this Campaign has previously
     * been saved, it will retrieve related CampaignCommitments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Campaign.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|CampaignCommitment[] List of CampaignCommitment objects
     */
    public function getCampaignCommitmentsJoinCampaignParticipant($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = CampaignCommitmentQuery::create(null, $criteria);
        $query->joinWith('CampaignParticipant', $join_behavior);

        return $this->getCampaignCommitments($query, $con);
    }

    /**
     * Clears out the collCampaignDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addCampaignDocuments()
     */
    public function clearCampaignDocuments()
    {
        $this->collCampaignDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collCampaignDocumentsPartial = null;
    }

    /**
     * reset is the collCampaignDocuments collection loaded partially
     *
     * @return void
     */
    public function resetPartialCampaignDocuments($v = true)
    {
        $this->collCampaignDocumentsPartial = $v;
    }

    /**
     * Initializes the collCampaignDocuments collection.
     *
     * By default this just sets the collCampaignDocuments collection to an empty array (like clearcollCampaignDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initCampaignDocuments($overrideExisting = true)
    {
        if (null !== $this->collCampaignDocuments && !$overrideExisting) {
            return;
        }
        $this->collCampaignDocuments = new PropelObjectCollection();
        $this->collCampaignDocuments->setModel('CampaignDocument');
    }

    /**
     * Gets an array of CampaignDocument objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Campaign is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|CampaignDocument[] List of CampaignDocument objects
     * @throws PropelException
     */
    public function getCampaignDocuments($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collCampaignDocumentsPartial && !$this->isNew();
        if (null === $this->collCampaignDocuments || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collCampaignDocuments) {
                // return empty collection
                $this->initCampaignDocuments();
            } else {
                $collCampaignDocuments = CampaignDocumentQuery::create(null, $criteria)
                    ->filterByCampaign($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collCampaignDocumentsPartial && count($collCampaignDocuments)) {
                      $this->initCampaignDocuments(false);

                      foreach($collCampaignDocuments as $obj) {
                        if (false == $this->collCampaignDocuments->contains($obj)) {
                          $this->collCampaignDocuments->append($obj);
                        }
                      }

                      $this->collCampaignDocumentsPartial = true;
                    }

                    return $collCampaignDocuments;
                }

                if($partial && $this->collCampaignDocuments) {
                    foreach($this->collCampaignDocuments as $obj) {
                        if($obj->isNew()) {
                            $collCampaignDocuments[] = $obj;
                        }
                    }
                }

                $this->collCampaignDocuments = $collCampaignDocuments;
                $this->collCampaignDocumentsPartial = false;
            }
        }

        return $this->collCampaignDocuments;
    }

    /**
     * Sets a collection of CampaignDocument objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $campaignDocuments A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setCampaignDocuments(PropelCollection $campaignDocuments, PropelPDO $con = null)
    {
        $this->campaignDocumentsScheduledForDeletion = $this->getCampaignDocuments(new Criteria(), $con)->diff($campaignDocuments);

        foreach ($this->campaignDocumentsScheduledForDeletion as $campaignDocumentRemoved) {
            $campaignDocumentRemoved->setCampaign(null);
        }

        $this->collCampaignDocuments = null;
        foreach ($campaignDocuments as $campaignDocument) {
            $this->addCampaignDocument($campaignDocument);
        }

        $this->collCampaignDocuments = $campaignDocuments;
        $this->collCampaignDocumentsPartial = false;
    }

    /**
     * Returns the number of related CampaignDocument objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related CampaignDocument objects.
     * @throws PropelException
     */
    public function countCampaignDocuments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collCampaignDocumentsPartial && !$this->isNew();
        if (null === $this->collCampaignDocuments || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collCampaignDocuments) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getCampaignDocuments());
                }
                $query = CampaignDocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByCampaign($this)
                    ->count($con);
            }
        } else {
            return count($this->collCampaignDocuments);
        }
    }

    /**
     * Method called to associate a CampaignDocument object to this object
     * through the CampaignDocument foreign key attribute.
     *
     * @param    CampaignDocument $l CampaignDocument
     * @return Campaign The current object (for fluent API support)
     */
    public function addCampaignDocument(CampaignDocument $l)
    {
        if ($this->collCampaignDocuments === null) {
            $this->initCampaignDocuments();
            $this->collCampaignDocumentsPartial = true;
        }
        if (!$this->collCampaignDocuments->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddCampaignDocument($l);
        }

        return $this;
    }

    /**
     * @param	CampaignDocument $campaignDocument The campaignDocument object to add.
     */
    protected function doAddCampaignDocument($campaignDocument)
    {
        $this->collCampaignDocuments[]= $campaignDocument;
        $campaignDocument->setCampaign($this);
    }

    /**
     * @param	CampaignDocument $campaignDocument The campaignDocument object to remove.
     */
    public function removeCampaignDocument($campaignDocument)
    {
        if ($this->getCampaignDocuments()->contains($campaignDocument)) {
            $this->collCampaignDocuments->remove($this->collCampaignDocuments->search($campaignDocument));
            if (null === $this->campaignDocumentsScheduledForDeletion) {
                $this->campaignDocumentsScheduledForDeletion = clone $this->collCampaignDocuments;
                $this->campaignDocumentsScheduledForDeletion->clear();
            }
            $this->campaignDocumentsScheduledForDeletion[]= $campaignDocument;
            $campaignDocument->setCampaign(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Campaign is new, it will return
     * an empty collection; or if this Campaign has previously
     * been saved, it will retrieve related CampaignDocuments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Campaign.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|CampaignDocument[] List of CampaignDocument objects
     */
    public function getCampaignDocumentsJoinDocument($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = CampaignDocumentQuery::create(null, $criteria);
        $query->joinWith('Document', $join_behavior);

        return $this->getCampaignDocuments($query, $con);
    }

    /**
     * Clears out the collDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addDocuments()
     */
    public function clearDocuments()
    {
        $this->collDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collDocumentsPartial = null;
    }

    /**
     * Initializes the collDocuments collection.
     *
     * By default this just sets the collDocuments collection to an empty collection (like clearDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initDocuments()
    {
        $this->collDocuments = new PropelObjectCollection();
        $this->collDocuments->setModel('Document');
    }

    /**
     * Gets a collection of Document objects related by a many-to-many relationship
     * to the current object by way of the campaigns_campaignDocument cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Campaign is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Document[] List of Document objects
     */
    public function getDocuments($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collDocuments || null !== $criteria) {
            if ($this->isNew() && null === $this->collDocuments) {
                // return empty collection
                $this->initDocuments();
            } else {
                $collDocuments = DocumentQuery::create(null, $criteria)
                    ->filterByCampaign($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collDocuments;
                }
                $this->collDocuments = $collDocuments;
            }
        }

        return $this->collDocuments;
    }

    /**
     * Sets a collection of Document objects related by a many-to-many relationship
     * to the current object by way of the campaigns_campaignDocument cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $documents A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setDocuments(PropelCollection $documents, PropelPDO $con = null)
    {
        $this->clearDocuments();
        $currentDocuments = $this->getDocuments();

        $this->documentsScheduledForDeletion = $currentDocuments->diff($documents);

        foreach ($documents as $document) {
            if (!$currentDocuments->contains($document)) {
                $this->doAddDocument($document);
            }
        }

        $this->collDocuments = $documents;
    }

    /**
     * Gets the number of Document objects related by a many-to-many relationship
     * to the current object by way of the campaigns_campaignDocument cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Document objects
     */
    public function countDocuments($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collDocuments || null !== $criteria) {
            if ($this->isNew() && null === $this->collDocuments) {
                return 0;
            } else {
                $query = DocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByCampaign($this)
                    ->count($con);
            }
        } else {
            return count($this->collDocuments);
        }
    }

    /**
     * Associate a Document object to this object
     * through the campaigns_campaignDocument cross reference table.
     *
     * @param  Document $document The CampaignDocument object to relate
     * @return void
     */
    public function addDocument(Document $document)
    {
        if ($this->collDocuments === null) {
            $this->initDocuments();
        }
        if (!$this->collDocuments->contains($document)) { // only add it if the **same** object is not already associated
            $this->doAddDocument($document);

            $this->collDocuments[]= $document;
        }
    }

    /**
     * @param	Document $document The document object to add.
     */
    protected function doAddDocument($document)
    {
        $campaignDocument = new CampaignDocument();
        $campaignDocument->setDocument($document);
        $this->addCampaignDocument($campaignDocument);
    }

    /**
     * Remove a Document object to this object
     * through the campaigns_campaignDocument cross reference table.
     *
     * @param Document $document The CampaignDocument object to relate
     * @return void
     */
    public function removeDocument(Document $document)
    {
        if ($this->getDocuments()->contains($document)) {
            $this->collDocuments->remove($this->collDocuments->search($document));
            if (null === $this->documentsScheduledForDeletion) {
                $this->documentsScheduledForDeletion = clone $this->collDocuments;
                $this->documentsScheduledForDeletion->clear();
            }
            $this->documentsScheduledForDeletion[]= $document;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->name = null;
        $this->type = null;
        $this->startdate = null;
        $this->finishdate = null;
        $this->clientid = null;
        $this->description = null;
        $this->langcode = null;
        $this->defaultkeywords = null;
        $this->responsible = null;
        $this->sources = null;
        $this->searchqueries = null;
        $this->searchqueries_unserialized = null;
        $this->deleted_at = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collCampaignParticipants) {
                foreach ($this->collCampaignParticipants as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collCampaignCommitments) {
                foreach ($this->collCampaignCommitments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collCampaignDocuments) {
                foreach ($this->collCampaignDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collDocuments) {
                foreach ($this->collDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collCampaignParticipants instanceof PropelCollection) {
            $this->collCampaignParticipants->clearIterator();
        }
        $this->collCampaignParticipants = null;
        if ($this->collCampaignCommitments instanceof PropelCollection) {
            $this->collCampaignCommitments->clearIterator();
        }
        $this->collCampaignCommitments = null;
        if ($this->collCampaignDocuments instanceof PropelCollection) {
            $this->collCampaignDocuments->clearIterator();
        }
        $this->collCampaignDocuments = null;
        if ($this->collDocuments instanceof PropelCollection) {
            $this->collDocuments->clearIterator();
        }
        $this->collDocuments = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string The value of the 'name' column
     */
    public function __toString()
    {
        return (string) $this->getName();
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

    // soft_delete behavior

    /**
     * Bypass the soft_delete behavior and force a hard delete of the current object
     */
    public function forceDelete(PropelPDO $con = null)
    {
        if ($isSoftDeleteEnabled = CampaignPeer::isSoftDeleteEnabled()) {
            CampaignPeer::disableSoftDelete();
        }
        $this->delete($con);
        if ($isSoftDeleteEnabled) {
            CampaignPeer::enableSoftDelete();
        }
    }

    /**
     * Undelete a row that was soft_deleted
     *
     * @return		 int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        $this->setDeletedAt(null);

        return $this->save($con);
    }

}
