<?php

/**
 * BackupCreateAction
 *
 * Crea un respaldo extendiendo el BaseAction
 *
 * @package backup
 */

class BackupCreateAction extends BaseAction {

	/**
	 * Acciones a ejecutar antes de generar el display
	 */
	protected function exec() {
		parent::exec();

		require_once('Backup.php');
		$backup = new Backup();
		
		$options = $_GET['options'];
		$content = $backup->createBackup($options);
		if (!$content) {
			Common::doLog('failure', 'Error creating backup');
			return false;
		}
		
		$filename = $backup->getFileName();
		Common::doLog('success', 'Backup created: ' . $filename);
		
		if ($options['toFile']) {
			header("Content-type: application/zip");
			header("Content-Disposition: attachment; filename=$filename");
			echo $content;
			die;
		}

	} // End exec

}
