<?php


/**
 * Base class that represents a query for the 'actors_profileForm' table.
 *
 * Base de Formularios de Perfiles
 *
 * @method ProfileFormQuery orderById($order = Criteria::ASC) Order by the id column
 * @method ProfileFormQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method ProfileFormQuery orderByRelationship($order = Criteria::ASC) Order by the relationship column
 * @method ProfileFormQuery orderByType($order = Criteria::ASC) Order by the type column
 * @method ProfileFormQuery orderByQuestion($order = Criteria::ASC) Order by the question column
 * @method ProfileFormQuery orderByQuestiontype($order = Criteria::ASC) Order by the questionType column
 * @method ProfileFormQuery orderByLabel($order = Criteria::ASC) Order by the label column
 * @method ProfileFormQuery orderByInanalysis($order = Criteria::ASC) Order by the inAnalysis column
 * @method ProfileFormQuery orderByTreeLeft($order = Criteria::ASC) Order by the tree_left column
 * @method ProfileFormQuery orderByTreeRight($order = Criteria::ASC) Order by the tree_right column
 * @method ProfileFormQuery orderByTreeLevel($order = Criteria::ASC) Order by the tree_level column
 * @method ProfileFormQuery orderByScope($order = Criteria::ASC) Order by the scope column
 *
 * @method ProfileFormQuery groupById() Group by the id column
 * @method ProfileFormQuery groupByName() Group by the name column
 * @method ProfileFormQuery groupByRelationship() Group by the relationship column
 * @method ProfileFormQuery groupByType() Group by the type column
 * @method ProfileFormQuery groupByQuestion() Group by the question column
 * @method ProfileFormQuery groupByQuestiontype() Group by the questionType column
 * @method ProfileFormQuery groupByLabel() Group by the label column
 * @method ProfileFormQuery groupByInanalysis() Group by the inAnalysis column
 * @method ProfileFormQuery groupByTreeLeft() Group by the tree_left column
 * @method ProfileFormQuery groupByTreeRight() Group by the tree_right column
 * @method ProfileFormQuery groupByTreeLevel() Group by the tree_level column
 * @method ProfileFormQuery groupByScope() Group by the scope column
 *
 * @method ProfileFormQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ProfileFormQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ProfileFormQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ProfileFormQuery leftJoinQuestionOption($relationAlias = null) Adds a LEFT JOIN clause to the query using the QuestionOption relation
 * @method ProfileFormQuery rightJoinQuestionOption($relationAlias = null) Adds a RIGHT JOIN clause to the query using the QuestionOption relation
 * @method ProfileFormQuery innerJoinQuestionOption($relationAlias = null) Adds a INNER JOIN clause to the query using the QuestionOption relation
 *
 * @method ProfileFormQuery leftJoinActorRelation($relationAlias = null) Adds a LEFT JOIN clause to the query using the ActorRelation relation
 * @method ProfileFormQuery rightJoinActorRelation($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ActorRelation relation
 * @method ProfileFormQuery innerJoinActorRelation($relationAlias = null) Adds a INNER JOIN clause to the query using the ActorRelation relation
 *
 * @method ProfileFormQuery leftJoinActorActiveQuestion($relationAlias = null) Adds a LEFT JOIN clause to the query using the ActorActiveQuestion relation
 * @method ProfileFormQuery rightJoinActorActiveQuestion($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ActorActiveQuestion relation
 * @method ProfileFormQuery innerJoinActorActiveQuestion($relationAlias = null) Adds a INNER JOIN clause to the query using the ActorActiveQuestion relation
 *
 * @method ProfileFormQuery leftJoinActorActiveRelationQuestion($relationAlias = null) Adds a LEFT JOIN clause to the query using the ActorActiveRelationQuestion relation
 * @method ProfileFormQuery rightJoinActorActiveRelationQuestion($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ActorActiveRelationQuestion relation
 * @method ProfileFormQuery innerJoinActorActiveRelationQuestion($relationAlias = null) Adds a INNER JOIN clause to the query using the ActorActiveRelationQuestion relation
 *
 * @method ProfileFormQuery leftJoinActorFormAnswer($relationAlias = null) Adds a LEFT JOIN clause to the query using the ActorFormAnswer relation
 * @method ProfileFormQuery rightJoinActorFormAnswer($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ActorFormAnswer relation
 * @method ProfileFormQuery innerJoinActorFormAnswer($relationAlias = null) Adds a INNER JOIN clause to the query using the ActorFormAnswer relation
 *
 * @method ProfileForm findOne(PropelPDO $con = null) Return the first ProfileForm matching the query
 * @method ProfileForm findOneOrCreate(PropelPDO $con = null) Return the first ProfileForm matching the query, or a new ProfileForm object populated from the query conditions when no match is found
 *
 * @method ProfileForm findOneById(int $id) Return the first ProfileForm filtered by the id column
 * @method ProfileForm findOneByName(string $name) Return the first ProfileForm filtered by the name column
 * @method ProfileForm findOneByRelationship(boolean $relationship) Return the first ProfileForm filtered by the relationship column
 * @method ProfileForm findOneByType(int $type) Return the first ProfileForm filtered by the type column
 * @method ProfileForm findOneByQuestion(string $question) Return the first ProfileForm filtered by the question column
 * @method ProfileForm findOneByQuestiontype(int $questionType) Return the first ProfileForm filtered by the questionType column
 * @method ProfileForm findOneByLabel(string $label) Return the first ProfileForm filtered by the label column
 * @method ProfileForm findOneByInanalysis(boolean $inAnalysis) Return the first ProfileForm filtered by the inAnalysis column
 * @method ProfileForm findOneByTreeLeft(int $tree_left) Return the first ProfileForm filtered by the tree_left column
 * @method ProfileForm findOneByTreeRight(int $tree_right) Return the first ProfileForm filtered by the tree_right column
 * @method ProfileForm findOneByTreeLevel(int $tree_level) Return the first ProfileForm filtered by the tree_level column
 * @method ProfileForm findOneByScope(int $scope) Return the first ProfileForm filtered by the scope column
 *
 * @method array findById(int $id) Return ProfileForm objects filtered by the id column
 * @method array findByName(string $name) Return ProfileForm objects filtered by the name column
 * @method array findByRelationship(boolean $relationship) Return ProfileForm objects filtered by the relationship column
 * @method array findByType(int $type) Return ProfileForm objects filtered by the type column
 * @method array findByQuestion(string $question) Return ProfileForm objects filtered by the question column
 * @method array findByQuestiontype(int $questionType) Return ProfileForm objects filtered by the questionType column
 * @method array findByLabel(string $label) Return ProfileForm objects filtered by the label column
 * @method array findByInanalysis(boolean $inAnalysis) Return ProfileForm objects filtered by the inAnalysis column
 * @method array findByTreeLeft(int $tree_left) Return ProfileForm objects filtered by the tree_left column
 * @method array findByTreeRight(int $tree_right) Return ProfileForm objects filtered by the tree_right column
 * @method array findByTreeLevel(int $tree_level) Return ProfileForm objects filtered by the tree_level column
 * @method array findByScope(int $scope) Return ProfileForm objects filtered by the scope column
 *
 * @package    propel.generator.actors.classes.om
 */
abstract class BaseProfileFormQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseProfileFormQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'ProfileForm', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ProfileFormQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ProfileFormQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ProfileFormQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ProfileFormQuery) {
            return $criteria;
        }
        $query = new ProfileFormQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   ProfileForm|ProfileForm[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ProfileFormPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ProfileFormPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   ProfileForm A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `NAME`, `RELATIONSHIP`, `TYPE`, `QUESTION`, `QUESTIONTYPE`, `LABEL`, `INANALYSIS`, `TREE_LEFT`, `TREE_RIGHT`, `TREE_LEVEL`, `SCOPE` FROM `actors_profileForm` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new ProfileForm();
            $obj->hydrate($row);
            ProfileFormPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return ProfileForm|ProfileForm[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|ProfileForm[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ProfileFormQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ProfileFormPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ProfileFormQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ProfileFormPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProfileFormQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ProfileFormPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProfileFormQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProfileFormPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the relationship column
     *
     * Example usage:
     * <code>
     * $query->filterByRelationship(true); // WHERE relationship = true
     * $query->filterByRelationship('yes'); // WHERE relationship = true
     * </code>
     *
     * @param     boolean|string $relationship The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProfileFormQuery The current query, for fluid interface
     */
    public function filterByRelationship($relationship = null, $comparison = null)
    {
        if (is_string($relationship)) {
            $relationship = in_array(strtolower($relationship), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProfileFormPeer::RELATIONSHIP, $relationship, $comparison);
    }

    /**
     * Filter the query on the type column
     *
     * Example usage:
     * <code>
     * $query->filterByType(1234); // WHERE type = 1234
     * $query->filterByType(array(12, 34)); // WHERE type IN (12, 34)
     * $query->filterByType(array('min' => 12)); // WHERE type > 12
     * </code>
     *
     * @param     mixed $type The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProfileFormQuery The current query, for fluid interface
     */
    public function filterByType($type = null, $comparison = null)
    {
        if (is_array($type)) {
            $useMinMax = false;
            if (isset($type['min'])) {
                $this->addUsingAlias(ProfileFormPeer::TYPE, $type['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($type['max'])) {
                $this->addUsingAlias(ProfileFormPeer::TYPE, $type['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProfileFormPeer::TYPE, $type, $comparison);
    }

    /**
     * Filter the query on the question column
     *
     * Example usage:
     * <code>
     * $query->filterByQuestion('fooValue');   // WHERE question = 'fooValue'
     * $query->filterByQuestion('%fooValue%'); // WHERE question LIKE '%fooValue%'
     * </code>
     *
     * @param     string $question The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProfileFormQuery The current query, for fluid interface
     */
    public function filterByQuestion($question = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($question)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $question)) {
                $question = str_replace('*', '%', $question);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProfileFormPeer::QUESTION, $question, $comparison);
    }

    /**
     * Filter the query on the questionType column
     *
     * Example usage:
     * <code>
     * $query->filterByQuestiontype(1234); // WHERE questionType = 1234
     * $query->filterByQuestiontype(array(12, 34)); // WHERE questionType IN (12, 34)
     * $query->filterByQuestiontype(array('min' => 12)); // WHERE questionType > 12
     * </code>
     *
     * @param     mixed $questiontype The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProfileFormQuery The current query, for fluid interface
     */
    public function filterByQuestiontype($questiontype = null, $comparison = null)
    {
        if (is_array($questiontype)) {
            $useMinMax = false;
            if (isset($questiontype['min'])) {
                $this->addUsingAlias(ProfileFormPeer::QUESTIONTYPE, $questiontype['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($questiontype['max'])) {
                $this->addUsingAlias(ProfileFormPeer::QUESTIONTYPE, $questiontype['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProfileFormPeer::QUESTIONTYPE, $questiontype, $comparison);
    }

    /**
     * Filter the query on the label column
     *
     * Example usage:
     * <code>
     * $query->filterByLabel('fooValue');   // WHERE label = 'fooValue'
     * $query->filterByLabel('%fooValue%'); // WHERE label LIKE '%fooValue%'
     * </code>
     *
     * @param     string $label The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProfileFormQuery The current query, for fluid interface
     */
    public function filterByLabel($label = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($label)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $label)) {
                $label = str_replace('*', '%', $label);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProfileFormPeer::LABEL, $label, $comparison);
    }

    /**
     * Filter the query on the inAnalysis column
     *
     * Example usage:
     * <code>
     * $query->filterByInanalysis(true); // WHERE inAnalysis = true
     * $query->filterByInanalysis('yes'); // WHERE inAnalysis = true
     * </code>
     *
     * @param     boolean|string $inanalysis The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProfileFormQuery The current query, for fluid interface
     */
    public function filterByInanalysis($inanalysis = null, $comparison = null)
    {
        if (is_string($inanalysis)) {
            $inAnalysis = in_array(strtolower($inanalysis), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProfileFormPeer::INANALYSIS, $inanalysis, $comparison);
    }

    /**
     * Filter the query on the tree_left column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeLeft(1234); // WHERE tree_left = 1234
     * $query->filterByTreeLeft(array(12, 34)); // WHERE tree_left IN (12, 34)
     * $query->filterByTreeLeft(array('min' => 12)); // WHERE tree_left > 12
     * </code>
     *
     * @param     mixed $treeLeft The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProfileFormQuery The current query, for fluid interface
     */
    public function filterByTreeLeft($treeLeft = null, $comparison = null)
    {
        if (is_array($treeLeft)) {
            $useMinMax = false;
            if (isset($treeLeft['min'])) {
                $this->addUsingAlias(ProfileFormPeer::TREE_LEFT, $treeLeft['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeLeft['max'])) {
                $this->addUsingAlias(ProfileFormPeer::TREE_LEFT, $treeLeft['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProfileFormPeer::TREE_LEFT, $treeLeft, $comparison);
    }

    /**
     * Filter the query on the tree_right column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeRight(1234); // WHERE tree_right = 1234
     * $query->filterByTreeRight(array(12, 34)); // WHERE tree_right IN (12, 34)
     * $query->filterByTreeRight(array('min' => 12)); // WHERE tree_right > 12
     * </code>
     *
     * @param     mixed $treeRight The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProfileFormQuery The current query, for fluid interface
     */
    public function filterByTreeRight($treeRight = null, $comparison = null)
    {
        if (is_array($treeRight)) {
            $useMinMax = false;
            if (isset($treeRight['min'])) {
                $this->addUsingAlias(ProfileFormPeer::TREE_RIGHT, $treeRight['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeRight['max'])) {
                $this->addUsingAlias(ProfileFormPeer::TREE_RIGHT, $treeRight['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProfileFormPeer::TREE_RIGHT, $treeRight, $comparison);
    }

    /**
     * Filter the query on the tree_level column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeLevel(1234); // WHERE tree_level = 1234
     * $query->filterByTreeLevel(array(12, 34)); // WHERE tree_level IN (12, 34)
     * $query->filterByTreeLevel(array('min' => 12)); // WHERE tree_level > 12
     * </code>
     *
     * @param     mixed $treeLevel The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProfileFormQuery The current query, for fluid interface
     */
    public function filterByTreeLevel($treeLevel = null, $comparison = null)
    {
        if (is_array($treeLevel)) {
            $useMinMax = false;
            if (isset($treeLevel['min'])) {
                $this->addUsingAlias(ProfileFormPeer::TREE_LEVEL, $treeLevel['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeLevel['max'])) {
                $this->addUsingAlias(ProfileFormPeer::TREE_LEVEL, $treeLevel['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProfileFormPeer::TREE_LEVEL, $treeLevel, $comparison);
    }

    /**
     * Filter the query on the scope column
     *
     * Example usage:
     * <code>
     * $query->filterByScope(1234); // WHERE scope = 1234
     * $query->filterByScope(array(12, 34)); // WHERE scope IN (12, 34)
     * $query->filterByScope(array('min' => 12)); // WHERE scope > 12
     * </code>
     *
     * @param     mixed $scope The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProfileFormQuery The current query, for fluid interface
     */
    public function filterByScope($scope = null, $comparison = null)
    {
        if (is_array($scope)) {
            $useMinMax = false;
            if (isset($scope['min'])) {
                $this->addUsingAlias(ProfileFormPeer::SCOPE, $scope['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($scope['max'])) {
                $this->addUsingAlias(ProfileFormPeer::SCOPE, $scope['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProfileFormPeer::SCOPE, $scope, $comparison);
    }

    /**
     * Filter the query by a related QuestionOption object
     *
     * @param   QuestionOption|PropelObjectCollection $questionOption  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProfileFormQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByQuestionOption($questionOption, $comparison = null)
    {
        if ($questionOption instanceof QuestionOption) {
            return $this
                ->addUsingAlias(ProfileFormPeer::ID, $questionOption->getFormid(), $comparison);
        } elseif ($questionOption instanceof PropelObjectCollection) {
            return $this
                ->useQuestionOptionQuery()
                ->filterByPrimaryKeys($questionOption->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByQuestionOption() only accepts arguments of type QuestionOption or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the QuestionOption relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProfileFormQuery The current query, for fluid interface
     */
    public function joinQuestionOption($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('QuestionOption');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'QuestionOption');
        }

        return $this;
    }

    /**
     * Use the QuestionOption relation QuestionOption object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   QuestionOptionQuery A secondary query class using the current class as primary query
     */
    public function useQuestionOptionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinQuestionOption($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'QuestionOption', 'QuestionOptionQuery');
    }

    /**
     * Filter the query by a related ActorRelation object
     *
     * @param   ActorRelation|PropelObjectCollection $actorRelation  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProfileFormQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByActorRelation($actorRelation, $comparison = null)
    {
        if ($actorRelation instanceof ActorRelation) {
            return $this
                ->addUsingAlias(ProfileFormPeer::ID, $actorRelation->getQuestionid(), $comparison);
        } elseif ($actorRelation instanceof PropelObjectCollection) {
            return $this
                ->useActorRelationQuery()
                ->filterByPrimaryKeys($actorRelation->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByActorRelation() only accepts arguments of type ActorRelation or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ActorRelation relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProfileFormQuery The current query, for fluid interface
     */
    public function joinActorRelation($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ActorRelation');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ActorRelation');
        }

        return $this;
    }

    /**
     * Use the ActorRelation relation ActorRelation object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ActorRelationQuery A secondary query class using the current class as primary query
     */
    public function useActorRelationQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinActorRelation($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ActorRelation', 'ActorRelationQuery');
    }

    /**
     * Filter the query by a related ActorActiveQuestion object
     *
     * @param   ActorActiveQuestion|PropelObjectCollection $actorActiveQuestion  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProfileFormQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByActorActiveQuestion($actorActiveQuestion, $comparison = null)
    {
        if ($actorActiveQuestion instanceof ActorActiveQuestion) {
            return $this
                ->addUsingAlias(ProfileFormPeer::ID, $actorActiveQuestion->getQuestionid(), $comparison);
        } elseif ($actorActiveQuestion instanceof PropelObjectCollection) {
            return $this
                ->useActorActiveQuestionQuery()
                ->filterByPrimaryKeys($actorActiveQuestion->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByActorActiveQuestion() only accepts arguments of type ActorActiveQuestion or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ActorActiveQuestion relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProfileFormQuery The current query, for fluid interface
     */
    public function joinActorActiveQuestion($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ActorActiveQuestion');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ActorActiveQuestion');
        }

        return $this;
    }

    /**
     * Use the ActorActiveQuestion relation ActorActiveQuestion object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ActorActiveQuestionQuery A secondary query class using the current class as primary query
     */
    public function useActorActiveQuestionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinActorActiveQuestion($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ActorActiveQuestion', 'ActorActiveQuestionQuery');
    }

    /**
     * Filter the query by a related ActorActiveRelationQuestion object
     *
     * @param   ActorActiveRelationQuestion|PropelObjectCollection $actorActiveRelationQuestion  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProfileFormQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByActorActiveRelationQuestion($actorActiveRelationQuestion, $comparison = null)
    {
        if ($actorActiveRelationQuestion instanceof ActorActiveRelationQuestion) {
            return $this
                ->addUsingAlias(ProfileFormPeer::ID, $actorActiveRelationQuestion->getQuestionid(), $comparison);
        } elseif ($actorActiveRelationQuestion instanceof PropelObjectCollection) {
            return $this
                ->useActorActiveRelationQuestionQuery()
                ->filterByPrimaryKeys($actorActiveRelationQuestion->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByActorActiveRelationQuestion() only accepts arguments of type ActorActiveRelationQuestion or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ActorActiveRelationQuestion relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProfileFormQuery The current query, for fluid interface
     */
    public function joinActorActiveRelationQuestion($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ActorActiveRelationQuestion');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ActorActiveRelationQuestion');
        }

        return $this;
    }

    /**
     * Use the ActorActiveRelationQuestion relation ActorActiveRelationQuestion object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ActorActiveRelationQuestionQuery A secondary query class using the current class as primary query
     */
    public function useActorActiveRelationQuestionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinActorActiveRelationQuestion($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ActorActiveRelationQuestion', 'ActorActiveRelationQuestionQuery');
    }

    /**
     * Filter the query by a related ActorFormAnswer object
     *
     * @param   ActorFormAnswer|PropelObjectCollection $actorFormAnswer  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProfileFormQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByActorFormAnswer($actorFormAnswer, $comparison = null)
    {
        if ($actorFormAnswer instanceof ActorFormAnswer) {
            return $this
                ->addUsingAlias(ProfileFormPeer::ID, $actorFormAnswer->getQuestionid(), $comparison);
        } elseif ($actorFormAnswer instanceof PropelObjectCollection) {
            return $this
                ->useActorFormAnswerQuery()
                ->filterByPrimaryKeys($actorFormAnswer->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByActorFormAnswer() only accepts arguments of type ActorFormAnswer or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ActorFormAnswer relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProfileFormQuery The current query, for fluid interface
     */
    public function joinActorFormAnswer($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ActorFormAnswer');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ActorFormAnswer');
        }

        return $this;
    }

    /**
     * Use the ActorFormAnswer relation ActorFormAnswer object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ActorFormAnswerQuery A secondary query class using the current class as primary query
     */
    public function useActorFormAnswerQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinActorFormAnswer($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ActorFormAnswer', 'ActorFormAnswerQuery');
    }

    /**
     * Filter the query by a related Actor object
     * using the actors_activeRelationQuestions table as cross reference
     *
     * @param   Actor $actor the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProfileFormQuery The current query, for fluid interface
     */
    public function filterByActor($actor, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useActorActiveRelationQuestionQuery()
            ->filterByActor($actor, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   ProfileForm $profileForm Object to remove from the list of results
     *
     * @return ProfileFormQuery The current query, for fluid interface
     */
    public function prune($profileForm = null)
    {
        if ($profileForm) {
            $this->addUsingAlias(ProfileFormPeer::ID, $profileForm->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    // nested_set behavior

    /**
     * Filter the query to restrict the result to root objects
     *
     * @return    ProfileFormQuery The current query, for fluid interface
     */
    public function treeRoots()
    {
        return $this->addUsingAlias(ProfileFormPeer::LEFT_COL, 1, Criteria::EQUAL);
    }

    /**
     * Returns the objects in a certain tree, from the tree scope
     *
     * @param     int $scope		Scope to determine which objects node to return
     *
     * @return    ProfileFormQuery The current query, for fluid interface
     */
    public function inTree($scope = null)
    {
        return $this->addUsingAlias(ProfileFormPeer::SCOPE_COL, $scope, Criteria::EQUAL);
    }

    /**
     * Filter the query to restrict the result to descendants of an object
     *
     * @param     ProfileForm $profileForm The object to use for descendant search
     *
     * @return    ProfileFormQuery The current query, for fluid interface
     */
    public function descendantsOf($profileForm)
    {
        return $this
            ->inTree($profileForm->getScopeValue())
            ->addUsingAlias(ProfileFormPeer::LEFT_COL, $profileForm->getLeftValue(), Criteria::GREATER_THAN)
            ->addUsingAlias(ProfileFormPeer::LEFT_COL, $profileForm->getRightValue(), Criteria::LESS_THAN);
    }

    /**
     * Filter the query to restrict the result to the branch of an object.
     * Same as descendantsOf(), except that it includes the object passed as parameter in the result
     *
     * @param     ProfileForm $profileForm The object to use for branch search
     *
     * @return    ProfileFormQuery The current query, for fluid interface
     */
    public function branchOf($profileForm)
    {
        return $this
            ->inTree($profileForm->getScopeValue())
            ->addUsingAlias(ProfileFormPeer::LEFT_COL, $profileForm->getLeftValue(), Criteria::GREATER_EQUAL)
            ->addUsingAlias(ProfileFormPeer::LEFT_COL, $profileForm->getRightValue(), Criteria::LESS_EQUAL);
    }

    /**
     * Filter the query to restrict the result to children of an object
     *
     * @param     ProfileForm $profileForm The object to use for child search
     *
     * @return    ProfileFormQuery The current query, for fluid interface
     */
    public function childrenOf($profileForm)
    {
        return $this
            ->descendantsOf($profileForm)
            ->addUsingAlias(ProfileFormPeer::LEVEL_COL, $profileForm->getLevel() + 1, Criteria::EQUAL);
    }

    /**
     * Filter the query to restrict the result to siblings of an object.
     * The result does not include the object passed as parameter.
     *
     * @param     ProfileForm $profileForm The object to use for sibling search
     * @param      PropelPDO $con Connection to use.
     *
     * @return    ProfileFormQuery The current query, for fluid interface
     */
    public function siblingsOf($profileForm, PropelPDO $con = null)
    {
        if ($profileForm->isRoot()) {
            return $this->
                add(ProfileFormPeer::LEVEL_COL, '1<>1', Criteria::CUSTOM);
        } else {
            return $this
                ->childrenOf($profileForm->getParent($con))
                ->prune($profileForm);
        }
    }

    /**
     * Filter the query to restrict the result to ancestors of an object
     *
     * @param     ProfileForm $profileForm The object to use for ancestors search
     *
     * @return    ProfileFormQuery The current query, for fluid interface
     */
    public function ancestorsOf($profileForm)
    {
        return $this
            ->inTree($profileForm->getScopeValue())
            ->addUsingAlias(ProfileFormPeer::LEFT_COL, $profileForm->getLeftValue(), Criteria::LESS_THAN)
            ->addUsingAlias(ProfileFormPeer::RIGHT_COL, $profileForm->getRightValue(), Criteria::GREATER_THAN);
    }

    /**
     * Filter the query to restrict the result to roots of an object.
     * Same as ancestorsOf(), except that it includes the object passed as parameter in the result
     *
     * @param     ProfileForm $profileForm The object to use for roots search
     *
     * @return    ProfileFormQuery The current query, for fluid interface
     */
    public function rootsOf($profileForm)
    {
        return $this
            ->inTree($profileForm->getScopeValue())
            ->addUsingAlias(ProfileFormPeer::LEFT_COL, $profileForm->getLeftValue(), Criteria::LESS_EQUAL)
            ->addUsingAlias(ProfileFormPeer::RIGHT_COL, $profileForm->getRightValue(), Criteria::GREATER_EQUAL);
    }

    /**
     * Order the result by branch, i.e. natural tree order
     *
     * @param     bool $reverse if true, reverses the order
     *
     * @return    ProfileFormQuery The current query, for fluid interface
     */
    public function orderByBranch($reverse = false)
    {
        if ($reverse) {
            return $this
                ->addDescendingOrderByColumn(ProfileFormPeer::LEFT_COL);
        } else {
            return $this
                ->addAscendingOrderByColumn(ProfileFormPeer::LEFT_COL);
        }
    }

    /**
     * Order the result by level, the closer to the root first
     *
     * @param     bool $reverse if true, reverses the order
     *
     * @return    ProfileFormQuery The current query, for fluid interface
     */
    public function orderByLevel($reverse = false)
    {
        if ($reverse) {
            return $this
                ->addAscendingOrderByColumn(ProfileFormPeer::RIGHT_COL);
        } else {
            return $this
                ->addDescendingOrderByColumn(ProfileFormPeer::RIGHT_COL);
        }
    }

    /**
     * Returns a root node for the tree
     *
     * @param      int $scope		Scope to determine which root node to return
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     ProfileForm The tree root object
     */
    public function findRoot($scope = null, $con = null)
    {
        return $this
            ->addUsingAlias(ProfileFormPeer::LEFT_COL, 1, Criteria::EQUAL)
            ->inTree($scope)
            ->findOne($con);
    }

    /**
     * Returns the root objects for all trees.
     *
     * @param      PropelPDO $con	Connection to use.
     *
     * @return    mixed the list of results, formatted by the current formatter
     */
    public function findRoots($con = null)
    {
        return $this
            ->treeRoots()
            ->find($con);
    }

    /**
     * Returns a tree of objects
     *
     * @param      int $scope		Scope to determine which tree node to return
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     mixed the list of results, formatted by the current formatter
     */
    public function findTree($scope = null, $con = null)
    {
        return $this
            ->inTree($scope)
            ->orderByBranch()
            ->find($con);
    }

}
