<?php

namespace Egytca\Statements;

class BinaryNonInvertingStatement extends BinaryStatement {

	private $operatorMap = [
		'<' => '>=',
		'<=' => '>',
		'>' => '<=',
		'>=' => '<'
	];

	function __construct($operator, Statement $operand1, Statement $operand2) {
		parent::__construct($operator, $this->operatorMap, $operand1, $operand2);
	}

	function invert() {
		$this->invertOperator();
		return $this;
	}
}
