<?php

namespace Egytca;

use Exception;

class RouteConfig {

	const URL_PREFIX = 'Main.php?do=';

	private static $config;

	static function init() {
		self::$config = require 'config/routes.php';
	}

	static function getDefaultPrefix($type) {
		preg_match("/^Egytca\\\Modules\\\(\w+)\\\(\w+)$/", $type, $matches);
		if ($matches) {
			return lcfirst($matches[1]) . ucfirst($matches[2]);
		} else {
			return lcfirst($type) . 's';
		}
	}

	static function getAction($entity, $action) {

		$type = is_object($entity) ? get_class($entity) : ucfirst($entity);

		if (array_key_exists($type, self::$config)) {
			$typeConfig = self::$config[$type];
			if ( array_key_exists('actions', $typeConfig) && array_key_exists($action, $typeConfig['actions']) ) { // rule exception exists
				return $typeConfig['actions'][$action];
			} else { // no rule exception
				if (array_key_exists('prefix', $typeConfig)) { // if prefix is defined, use it. otherwise fallback to default
					return $typeConfig['prefix'] . ucfirst($action);
				}
			}
		}

		return self::getDefaultPrefix($type) . ucfirst($action); // default
	}

	static function getRoute($entity, $action) {

		$route = self::URL_PREFIX . self::getAction($entity, $action);

		if (is_object($entity))
			$route .= '&id='. $entity->getId();

		return $route;
	}
}

RouteConfig::init();
