<?php

namespace Egytca;

use BooleanIndicatorQuery;
use NumericIndicatorQuery;
use Egytca\DateTime as EgytcaDateTime;
use Egytca\Modules\Panel\ActivityQuery;
use Egytca\Modules\Panel\ProjectQuery;
use ObjectiveQuery;

trait PositionRelatedObjects {

	private function getRelatedFiltered($filter, $params = []) {

		$related = [
			'objectives' => [],
			'numericIndicators' => [],
			'booleanIndicators' => [],
			'projects' => [],
			'activities' => []
		];

		$objectiveQuery = ObjectiveQuery::create();
		call_user_func_array([$objectiveQuery, $filter], $params);
		$objectiveQuery->filterByPosition($this);
		//codecept_debug($objectiveQuery->toString());
		$objectives = $objectiveQuery->find();

		$projectQuery = ProjectQuery::create();
		call_user_func_array([$projectQuery, $filter], $params);
		$projectQuery->useObjectiveQuery()
				->filterByPosition($this)
			->endUse();
		//codecept_debug($projectQuery->toString());
		$projects = $projectQuery->find();

		$activityQuery = ActivityQuery::create();
		call_user_func_array([$activityQuery, $filter], $params);
		$activityQuery->useProjectQuery()
				->useObjectiveQuery()
					->filterByPosition($this)
				->endUse()
			->endUse();
		//codecept_debug($activityQuery->toString());
		$activities = $activityQuery->find();

		$booleanIndicatorQuery = BooleanIndicatorQuery::create();
		call_user_func_array([$booleanIndicatorQuery, $filter], $params);
		$booleanIndicatorQuery->useObjectiveQuery()
				->filterByPosition($this)
			->endUse();
		//codecept_debug($booleanIndicatorQuery->toString());
		$booleanIndicators = $booleanIndicatorQuery->find();

		$numericIndicatorQuery = NumericIndicatorQuery::create();
		call_user_func_array([$numericIndicatorQuery, $filter], $params);
		$numericIndicatorQuery->useObjectiveQuery()
				->filterByPosition($this)
			->endUse();
		//codecept_debug($numericIndicatorQuery->toString());
		$numericIndicators = $numericIndicatorQuery->find();

		$related['objectives'] = array_map(function($objective) {
			return ['object' => $objective, 'triggetCause' => 'desc'];
		}, $objectives->getArrayCopy());

		$related['projects'] = array_map(function($project) {
			return ['object' => $project, 'triggetCause' => 'desc'];
		}, $projects->getArrayCopy());

		$related['activities'] = array_map(function($activity) {
			return ['object' => $activity, 'triggetCause' => 'self'];
		}, $activities->getArrayCopy());

		$related['booleanIndicators'] = array_map(function($booleanIndicator) {
			return ['object' => $booleanIndicator, 'triggetCause' => 'self'];
		}, $booleanIndicators->getArrayCopy());

		$related['numericIndicators'] = array_map(function($numericIndicator) {
			return ['object' => $numericIndicator, 'triggetCause' => 'self'];
		}, $numericIndicators->getArrayCopy());

		return $related;
	}

	function getRelatedWithStatusLate() {
		return $this->getRelatedFiltered('filterByStatus', ['late']);
	}

	function getRelatedByDueDate($dateModifier, $referenceDate = null) {

		if ($dateModifier === null)
			throw new Exception('$dateModifier required');

		if (!($referenceDate instanceof EgytcaDateTime))
			$referenceDate = new EgytcaDateTime($referenceDate);

		$modifiedDate = new EgytcaDateTime($referenceDate);
		$modifiedDate->modify($dateModifier);

		$minDate = min($referenceDate, $modifiedDate);
		$maxDate = max($referenceDate, $modifiedDate);

		$minMaxValues = [
			'min' => $minDate->format('Y-m-d'),
			'max' => $maxDate->format('Y-m-d')
		];

		return $this->getRelatedFiltered('filterByUnmetDueDate', [$minMaxValues]);
	}
}
