<?php

use Egytca\HTTPError;


/**
 * BaseSelectAction
 *
 * Meta clase de obtencion de un objeto de la base de datos
 *
 * @package phpMVC
 * @author Modulos Empresarios / Egytca
 * @copyright Copyright (c) 2015, Egytca
 */

class BaseSelectAction extends BaseAction {

	const FINISH = 'FINISH';

	private $entityClassName;
	protected $smarty;
	protected $entity;
	protected $ajaxTemplate;
	protected $filters;
	protected $forwardName = 'success';
	protected $forwardFailureName = 'failure';
	protected $notFoundErrorTemplate = 'errors/404.tpl';

	/**
	 * Constructor
	 *
	 * @param string $entityClassName Nombre de la clase que representa la entidad que se va a seleccionar
	 */
	function __construct($entityClassName) {
		if (empty($entityClassName))
			throw new Exception('$entityClassName must be set');
		if (!class_exists($entityClassName))
			throw new Exception('Class "' . $entityClassName .'" not found or unavailable');
		$this->entityClassName = $entityClassName;
		if (substr(get_class($this), -7, 1) != 'X')
			$this->ajaxTemplate = str_replace('Action', '', get_class($this)).'X.tpl';
		else
			$this->ajaxTemplate = str_replace('Action', '', get_class($this)) . '.tpl';
	}

	/**
	 * Execute
	 * @see BaseAction::execute()
	 */
	function execute($mapping, $form, &$request, &$response) {

		parent::execute($mapping, $form, $request, $response);

		// Acciones a ejecutar antes de obtener el objeto
		if ($this->preSelect() === false)
			return $mapping->findForwardConfig($this->forwardFailureName);

		$ret = $this->fetch($this->entity);
		if ($ret !== null) {
			return $this->finish($ret);
		}

		// Asigno al template el objeto obtenido
		$unnamespacedEntityClass = preg_replace('/^(\w+\\\)*/', '', get_class($this->entity));
		$this->smarty->assign(lcfirst($unnamespacedEntityClass), $this->entity);
		// Compatibilidad con Smarty hasta soportar namespaces, anunciado para 3.2
		$this->smarty->assign('entity', $this->entity);

		// Acciones a ejecutar despues de obtener el objeto
		$this->postSelect();

		// Elijo la vista basado en si es o no un pedido por AJAX
		if ($this->isAjax() && isset($this->ajaxTemplate))
			$this->smarty->display($this->ajaxTemplate);
		else
			return $mapping->findForwardConfig('success');

	}

	protected function createQuery() {
		return BaseQuery::create($this->entityClassName);
	}

	/**
	 * Acciones a ejecutar antes de obtener el objeto
	 */
	protected function preSelect() {

		// Procesar los valores del request asociados a filtros
		$this->prepareFilters();

	}

	/**
	 * Acciones a ejecutar despues de obtener el objeto
	 */
	protected function postSelect() {

		// Informacion para armar los links de paginador
		$this->assignFiltersToSmarty();

	}

	/**
	 * Busca el objeto y lo coloca en $entity.
	 * Devuelve:
	 *   - null: continua la ejecucion por defecto
	 *   - BaseAction::FINISH: pide el fin de la ejecución
	 *   - ForwardConfig: pide el fin de la ejecución continuando con un ForwardConfig
	 */
	protected function fetch(&$entity) {
		$id = $_GET['id'];
		if (isset($id)) {

			$entity = $this->createQuery()->findOneById($id);

			if (is_null($entity)) {
				$this->errors->add($this->entityClassName . ' with id "' . $id . '" not found');
				$this->smarty->assign('notValidId', 'true');
				//Elijo la vista basado en si es o no un pedido por AJAX
				if ($this->isAjax()) {
					return $this->forwardConfigEnd(
						'success',
						HTTPError::NOT_FOUND
					);
				} else {
					return $this->templateEnd(
						$this->notFoundErrorTemplate,
						HTTPError::NOT_FOUND
					);
				}
			}

		}
		else {
			$entityClassName = $this->entityClassName;
			$entity = new $entityClassName();
		}

	}

}
